/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pssc.common.utils.PsscContractUtil;

public class PsscMatchContractPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.createData();
    }

    private void createData() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object obj = formShowParameter.getCustomParam("handle_ids");
        if (null != obj && obj instanceof List) {
            List handleIds = (List)obj;
            Object[] handidsObj = new Object[handleIds.size()];
            for (int i = 0; i < handleIds.size(); ++i) {
                handidsObj[i] = handleIds.get(i);
            }
            DynamicObject[] taskObjs = BusinessDataServiceHelper.load((Object[])handidsObj, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"pssc_mytask").getDynamicObjectType());
            HashSet<String> excludeFields = new HashSet<String>(1);
            DynamicObjectCollection contractCols = this.getContractData(taskObjs);
            this.setEntryValue("entryentity", excludeFields, taskObjs, contractCols);
        }
    }

    private DynamicObjectCollection getContractData(DynamicObject[] billObjs) {
        QFilter conFilter = this.getContractFilter(billObjs);
        String selectFields = this.getSelectFields();
        String order = "validdate desc";
        DynamicObjectCollection contractCols = QueryServiceHelper.query((String)"conm_purcontract", (String)selectFields, (QFilter[])conFilter.toArray(), (String)order);
        return contractCols;
    }

    private String getSelectFields() {
        return "id,billno,settlecurrency,org,supplier,billentry.id entryid,billentry.material material,billentry.price price,billentry.priceandtax priceandtax,billentry.unit unit,billentry.taxrateid taxrateid,billentry.taxrate taxrate,billentry.qty qty,billentry.joinorderqty joinorderqty";
    }

    private QFilter getContractFilter(DynamicObject[] billObjs) {
        return PsscContractUtil.getContractFilterByTask((DynamicObject[])billObjs);
    }

    public void setEntryValue(String entryentity, Set<String> excFields, DynamicObject[] taskObjs, DynamicObjectCollection contractCols) {
        if (null == taskObjs) {
            return;
        }
        IFormView view = this.getView();
        AbstractFormDataModel model = (AbstractFormDataModel)view.getModel();
        model.beginInit();
        model.deleteEntryData(entryentity);
        EntryGrid entryGrid = (EntryGrid)view.getControl(entryentity);
        List properties = DynamicObjectUtil.getContainerProperties((Container)entryGrid);
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int rowCount = 0;
        for (int i = 0; i < taskObjs.length; ++i) {
            DynamicObject task = taskObjs[i];
            this.setEntryTaskData(task, properties, excFields, ts, rowCount);
            List<DynamicObject> contractList = this.matchContract(task, contractCols);
            if (contractList.size() > 0) {
                for (DynamicObject contract : contractList) {
                    ts.set("srcbillid", task.getPkValue(), rowCount);
                    this.setEntryContractData(contract, properties, ts, rowCount);
                    ++rowCount;
                }
                continue;
            }
            ++rowCount;
        }
        model.batchCreateNewEntryRow(entryentity, ts);
        model.endInit();
        view.updateView(entryentity);
    }

    private void setEntryTaskData(DynamicObject task, List<String> properties, Set<String> excFields, TableValueSetter ts, int rowCount) {
        for (String pro : properties) {
            if (excFields.contains(pro)) continue;
            try {
                if (pro.equals("srcbillid")) {
                    ts.set(pro, task.getPkValue(), rowCount);
                    continue;
                }
                if (pro.equals("srcentryid")) {
                    ts.set("srcentryid", task.getPkValue(), rowCount);
                    continue;
                }
                if (task.get(pro) instanceof DynamicObject) {
                    ts.set(pro, task.getDynamicObject(pro).getPkValue(), rowCount);
                    continue;
                }
                ts.set(pro, task.get(pro), rowCount);
            }
            catch (Exception e) {
                BizLog.log((String)e.getMessage());
            }
        }
    }

    private void setEntryContractData(DynamicObject contract, List<String> properties, TableValueSetter ts, int rowCount) {
        for (String pro : properties) {
            if (!pro.contains("conm_")) continue;
            try {
                String realPro = pro.replaceAll("conm_", "");
                ts.set(pro, contract.get(realPro), rowCount);
            }
            catch (Exception e) {
                BizLog.log((String)e.getMessage());
            }
        }
        BigDecimal conmQty = contract.getBigDecimal("qty");
        BigDecimal joinorderQty = contract.getBigDecimal("joinorderqty");
        ts.set("unexecuteqty", (Object)conmQty.subtract(joinorderQty), rowCount);
    }

    private List<DynamicObject> matchContract(DynamicObject task, DynamicObjectCollection contractCols) {
        Long materialId = task.getLong("material.id");
        Long purOrgId = task.getLong("processorg.id");
        StringBuilder taskMatchKey = new StringBuilder();
        taskMatchKey.append(materialId).append('_').append(purOrgId);
        ArrayList<DynamicObject> contractList = new ArrayList<DynamicObject>();
        for (DynamicObject col : contractCols) {
            Long contractMatId = col.getLong("material");
            Long contractPurOrgId = col.getLong("org");
            StringBuilder contractMatchKey = new StringBuilder();
            contractMatchKey.append(contractMatId).append('_').append(contractPurOrgId);
            if (!taskMatchKey.toString().equals(contractMatchKey.toString())) continue;
            contractList.add(col);
        }
        return contractList;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("pushorder".equals(formOperate.getOperateKey())) {
            this.pushOrder();
        } else if ("refresh".equals(formOperate.getOperateKey())) {
            this.createData();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f\u3002", (String)"PsscMatchContractPlugin_0", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
        } else if ("remove".equals(formOperate.getOperateKey())) {
            // empty if block
        }
    }

    private void pushOrder() {
        DynamicObjectCollection cols = this.getModel().getEntryEntity("entryentity");
        HashMap<Long, ArrayList<DynamicObject>> taskContractMap = new HashMap<Long, ArrayList<DynamicObject>>();
        HashMap<Long, DynamicObject> contractIdMap = new HashMap<Long, DynamicObject>(8);
        HashSet<Long> taskIdSet = new HashSet<Long>(8);
        for (DynamicObject col : cols) {
            Long taskId = col.getLong("srcbillid");
            taskIdSet.add(taskId);
            BigDecimal restofQty = col.getBigDecimal("restofqty");
            if (restofQty.compareTo(BigDecimal.ZERO) == 0) continue;
            contractIdMap.putIfAbsent(col.getLong("conm_entryid"), col);
            ArrayList<DynamicObject> contractList = (ArrayList<DynamicObject>)taskContractMap.get(taskId);
            if (null == contractList) {
                contractList = new ArrayList<DynamicObject>(8);
            }
            contractList.add(col);
            taskContractMap.put(taskId, contractList);
        }
        DynamicObject mytasK = BusinessDataServiceHelper.newDynamicObject((String)"pssc_mytask");
        DynamicObject[] objs = BusinessDataServiceHelper.load((Object[])taskIdSet.toArray(new Object[0]), (DynamicObjectType)mytasK.getDynamicObjectType());
        Date now = TimeServiceHelper.now();
        for (DynamicObject obj : objs) {
            Long taskId = obj.getLong("id");
            List contractList = (List)taskContractMap.get(taskId);
            if (null == contractList) continue;
            DynamicObjectCollection contractEntrys = obj.getDynamicObjectCollection("entryentity");
            contractEntrys.removeAll((Collection)contractEntrys);
            for (DynamicObject contract : contractList) {
                DynamicObject newEntry = contractEntrys.addNew();
                this.setContractEntry(newEntry, contract);
                newEntry.set("matchdate", (Object)now);
            }
        }
        SaveServiceHelper.save((DynamicObject[])objs);
        List<DynamicObject> targetObjects = this.pushOrder(objs);
        StringBuilder billnoStr = new StringBuilder();
        for (DynamicObject targetObj : targetObjects) {
            String billNo = targetObj.getString("billno");
            if (billnoStr.length() > 0) {
                billnoStr.append(',').append(billNo);
            } else {
                billnoStr.append(billNo);
            }
            DynamicObjectCollection billEntrys = targetObj.getDynamicObjectCollection("billentry");
            for (DynamicObject billEntry : billEntrys) {
                Long conEntryId = billEntry.getLong("conbillentryid");
                DynamicObject contract = (DynamicObject)contractIdMap.get(conEntryId);
                if (null == contract) continue;
                billEntry.set("conbillnumber", contract.get("conm_id.number"));
                billEntry.set("entrycomment", contract.get("remark"));
            }
        }
        OperationServiceHelper.executeOperate((String)"save", (String)"pssc_mytask", (DynamicObject[])targetObjects.toArray(new DynamicObject[0]), null);
        this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u4e0b\u5355\u6210\u529f,\u5355\u636e\u7f16\u53f7\uff1a%1$s", (String)"PsscMatchContractPlugin_1", (String)"scm-pssc-formplugin", (Object[])new Object[0]), billnoStr.toString()));
        IFormView parentView = this.getView().getView(this.getView().getFormShowParameter().getParentPageId());
        if (parentView != null) {
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(parentView);
            this.getView().close();
        }
    }

    private void setContractEntry(DynamicObject newEntry, DynamicObject contract) {
        newEntry.set("contractid", contract.get("conm_id.id"));
        newEntry.set("contractentryid", contract.get("conm_entryid"));
        newEntry.set("contractcurrency", contract.get("conm_settlecurrency.id"));
        newEntry.set("contractsup", contract.get("conm_supplier.id"));
        newEntry.set("contractqty", contract.get("restofqty"));
        newEntry.set("contractprice", contract.get("conm_price"));
        newEntry.set("contracttaxprice", contract.get("conm_priceandtax"));
        newEntry.set("contracttaxitem", contract.get("conm_taxrateid"));
    }

    private List<DynamicObject> pushOrder(DynamicObject[] objs) {
        StringBuilder logMsg;
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>(8);
        for (DynamicObject obj : objs) {
            DynamicObjectCollection contractEntrys = obj.getDynamicObjectCollection("entryentity");
            for (DynamicObject contract : contractEntrys) {
                ListSelectedRow row = new ListSelectedRow();
                row.setPrimaryKeyValue(obj.getPkValue());
                row.setEntryEntityKey("entryentity");
                row.setEntryPrimaryKeyValue(contract.getPkValue());
                selectedRowList.add(row);
            }
        }
        String srcEntityKey = "pssc_mytask";
        String targetEntityKey = "pm_purorderbill";
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(srcEntityKey);
        pushArgs.setTargetEntityNumber(targetEntityKey);
        pushArgs.setBuildConvReport(false);
        pushArgs.setSelectedRows(selectedRowList);
        pushArgs.setShowReport(true);
        pushArgs.setBuildConvReport(true);
        pushArgs.setRuleId("1756668819041950720");
        List targetObjects = Collections.emptyList();
        try {
            ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)targetEntityKey);
            if (result.isSuccess()) {
                targetObjects = result.loadTargetDataObjects((objects, iDataEntityType) -> BusinessDataServiceHelper.loadRefence((Object[])objects, (IDataEntityType)iDataEntityType), mainType);
            } else {
                logMsg = new StringBuilder();
                BizLog.log((String)logMsg.toString());
            }
        }
        catch (Exception e) {
            logMsg = new StringBuilder();
            logMsg.append(srcEntityKey).append(" push ").append(targetEntityKey).append(" fail reason:").append(e.getMessage());
            BizLog.log((String)logMsg.toString());
        }
        return targetObjects;
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        e.getRowIndexs();
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        e.getRowIndexs();
    }
}

