/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.formplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeBatchFillEntryArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pssc.business.helper.PsscPackageGroupHelper;
import kd.scm.pssc.common.PsscOperationContext;
import kd.scm.pssc.common.log.HandleLogEntity;
import kd.scm.pssc.common.log.PsscAllocateLog;
import kd.scm.pssc.common.log.PsscHandleLogHelper;
import kd.scm.pssc.common.log.PsscHandleLogService;
import kd.scm.pssc.common.utils.MultiBasedataUtils;
import kd.scm.pssc.common.utils.PsscCommonUtils;
import kd.scm.pssc.common.utils.PsscPackageGroupUtils;
import kd.scm.pssc.common.utils.PsscTaskPoolUtil;
import kd.scm.pssc.formplugin.PsscReqPoolHandleCorePlugin;

public final class PsscReqPoolAllocatePlugin
extends PsscReqPoolHandleCorePlugin {
    private PsscHandleLogService psscAllocateLog = new PsscAllocateLog();
    private static Log logger = LogFactory.getLog(PsscReqPoolAllocatePlugin.class);

    @Override
    protected void showWithoutPermMessage() {
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u4efb\u52a1\u7ba1\u7406\u201d\u7684\u201c\u5206\u914d\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PsscReqPoolAllocatePlugin_9", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
    }

    @Override
    protected boolean checkHasPermission() {
        return PermissionServiceHelper.checkPermission((Long)UserServiceHelper.getCurrentUserId(), (String)AppMetadataCache.getAppInfo((String)"pssc").getId(), (String)"pssc_taskmanage", (String)"3GRT/S/FIMNK");
    }

    @Override
    protected void bindData(List<DynamicObject> targetObjects, PsscOperationContext context) {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        Map groupEntryMap = DynamicObjectUtil.colsToMap((DynamicObjectCollection)entryentity, (String)"number");
        for (DynamicObject targetObject : targetObjects) {
            targetObject.set("biztype", (Object)context.getOperationKey());
            DynamicObjectCollection approveEntry = targetObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : approveEntry) {
                DynamicObject newRow = (DynamicObject)groupEntryMap.get(String.valueOf(entry.getString("tasknumber")));
                if (newRow == null) continue;
                entry.set("opinion", (Object)newRow.getString("opinion"));
                entry.set("newhandler_id", (Object)newRow.getLong("handler.id"));
                entry.set("newhandler", newRow.get("handler"));
                entry.set("newpurgroup_id", (Object)newRow.getLong("purgroup.id"));
                entry.set("newpurgroup", newRow.get("purgroup"));
                entry.set("newsourceorg_id", (Object)newRow.getLong("sourceorg.id"));
                entry.set("newsourceorg", newRow.get("sourceorg"));
                entry.set("approvetype", (Object)context.getOperationKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(PsscOperationContext context) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        DynamicObject[] rows = context.getRows();
        ArrayList<HandleLogEntity> logEntityList = new ArrayList<HandleLogEntity>(rows.length);
        DynamicObjectCollection entryRows = context.getView().getModel().getEntryEntity("entryentity");
        Map groupEntryMap = DynamicObjectUtil.colsToMap((DynamicObjectCollection)entryRows, (String)"srcbillid");
        HashMap packageGroupInfos = new HashMap(rows.length);
        for (DynamicObject row : rows) {
            DynamicObject newRow = (DynamicObject)groupEntryMap.get(String.valueOf(row.getPkValue()));
            if (null == newRow) continue;
            DynamicObject handler = newRow.getDynamicObject("handler");
            if (null != handler) {
                Long userId = handler.getLong("operatorid.id");
                row.set("handleuser", (Object)userId);
                DynamicObjectCollection partnerRows = row.getDynamicObjectCollection("partners");
                Set idSet = partnerRows.stream().map(e -> e.getLong("fbasedataid.id")).collect(Collectors.toSet());
                idSet.add(userId);
                MultiBasedataUtils.setMultiBasedataForBillObj((DynamicObject)row, idSet, (String)"partners");
            }
            row.set("handler", newRow.get("handler"));
            row.set("sourceorg", newRow.get("sourceorg"));
            DynamicObject groupObj = newRow.getDynamicObject("purgroup");
            if (null != groupObj) {
                row.set("purgroup", (Object)groupObj);
            }
            PsscTaskPoolUtil.setHandleStatus((DynamicObject)row, (Boolean)true);
            String opinion = newRow.getString("opinion");
            row.set("opinion", (Object)opinion);
            String remark = this.getRemark(handler, groupObj);
            String detail = this.psscAllocateLog.getDetail(row, newRow);
            HandleLogEntity logEntity = PsscHandleLogHelper.getLogInfo((String)remark, (String)detail);
            this.psscAllocateLog.updateLogInfo(logEntity, context.getView(), row);
            logEntityList.add(logEntity);
            PsscPackageGroupUtils.dealUnPackageData((DynamicObject)row, packageGroupInfos, (boolean)true);
            ++count;
        }
        PsscPackageGroupHelper.packageGroup(packageGroupInfos, (long)0L);
        for (DynamicObject row : rows) {
            PsscPackageGroupUtils.dealPackageGroupInfo((DynamicObject)row, packageGroupInfos, (String)"id");
        }
        boolean needSync = true;
        if (count > 0) {
            try (TXHandle tx = TX.required();){
                PsscCommonUtils.saveDynamicObjects((DynamicObject[])context.getRows());
                PsscHandleLogHelper.log(logEntityList);
                sb.append(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f\u3002", (String)"PsscReqPoolAllocatePlugin_2", (String)"scm-pssc-formplugin", (Object[])new Object[0])).append(System.lineSeparator());
            }
            if (needSync) {
                OperationServiceHelper.executeOperate((String)"syncdata", (String)"pssc_mytask", (DynamicObject[])context.getRows(), null);
                OperationServiceHelper.executeOperate((String)"sendmsg", (String)"pssc_mytask", (DynamicObject[])context.getRows(), null);
            }
        } else {
            sb.append(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u5206\u914d\u7684\u4efb\u52a1\u3002", (String)"PsscReqPoolAllocatePlugin_3", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
        }
        context.setMessage(sb);
    }

    private String getRemark(DynamicObject handler, DynamicObject handleGourp) {
        StringBuilder remarkSb = new StringBuilder();
        remarkSb.append(RequestContext.get().getUserName()).append(' ').append(ResManager.loadKDString((String)"\u5206\u914d\u7ed9 ", (String)"PsscReqPoolAllocatePlugin_4", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
        if (null != handler) {
            remarkSb.append(handler.getString("operatorname"));
        }
        return remarkSb.toString();
    }

    public void beforeBatchFillEntry(BeforeBatchFillEntryArgs e) {
        super.beforeBatchFillEntry(e);
        IDataModel model = this.getModel();
        e.setPredicate(e.getPredicate().and(rowItem -> {
            IDataEntityProperty selProp = rowItem.getSelProp();
            int row = rowItem.getRow();
            switch (selProp.getName()) {
                case "handler": {
                    DynamicObject sourceorg = (DynamicObject)model.getValue("sourceorg", row);
                    if (sourceorg == null) {
                        return false;
                    }
                    int currentRow = model.getEntryCurrentRowIndex("entryentity");
                    DynamicObject currentRowCompareValue = (DynamicObject)model.getValue("sourceorg", currentRow);
                    if (currentRowCompareValue == null) {
                        return false;
                    }
                    return sourceorg.getLong("id") == currentRowCompareValue.getLong("id");
                }
            }
            return true;
        }));
    }
}

