/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.formplugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pssc.common.PsscOperationContext;
import kd.scm.pssc.common.enums.HandleStatusEnums;
import kd.scm.pssc.common.log.HandleLogEntity;
import kd.scm.pssc.common.log.PsscHandleLogHelper;
import kd.scm.pssc.common.log.PsscHandleLogService;
import kd.scm.pssc.common.log.PsscSuspendLog;
import kd.scm.pssc.common.log.PsscUnsuspendLog;
import kd.scm.pssc.common.utils.PsscCommonUtils;
import kd.scm.pssc.formplugin.PsscReqPoolHandleCorePlugin;

public final class PsscReqPoolSuspendPlugin
extends PsscReqPoolHandleCorePlugin {
    private PsscHandleLogService psscHandleLogService = new PsscSuspendLog();
    private static Log logger = LogFactory.getLog(PsscReqPoolSuspendPlugin.class);

    @Override
    protected void showWithoutPermMessage() {
        String opKey = (String)this.getView().getFormShowParameter().getCustomParam("opkey");
        if (StringUtils.equals((CharSequence)opKey, (CharSequence)"suspend")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u91c7\u8d2d\u4efb\u52a1\u201d\u7684\u201c\u6682\u6302\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PsscReqPoolSuspendPlugin_0", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u91c7\u8d2d\u4efb\u52a1\u201d\u7684\u201c\u53d6\u6d88\u6682\u6302\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PsscReqPoolSuspendPlugin_1", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    protected boolean checkHasPermission() {
        String opKey = (String)this.getView().getFormShowParameter().getCustomParam("opkey");
        return PermissionServiceHelper.checkPermission((Long)UserServiceHelper.getCurrentUserId(), (String)AppMetadataCache.getAppInfo((String)"pssc").getId(), (String)"pssc_mytask", (String)(StringUtils.equals((CharSequence)opKey, (CharSequence)"suspend") ? "3GRWCHFHY0F1" : "3GRWULQP9LOA"));
    }

    @Override
    protected void bindData(List<DynamicObject> targetObjects, PsscOperationContext context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(PsscOperationContext context) {
        StringBuilder sb = new StringBuilder();
        String opKey = context.getOperationKey();
        int count = 0;
        List properties = PsscCommonUtils.getEntryProperties((PsscOperationContext)context);
        HashSet<String> excludedFields = new HashSet<String>(1);
        excludedFields.add("srcbillid");
        excludedFields.add("material");
        boolean isSuspend = StringUtils.equals((CharSequence)opKey, (CharSequence)"suspend");
        DynamicObjectCollection entryRows = context.getView().getModel().getEntryEntity("entryentity");
        Map gourpEntryMap = DynamicObjectUtil.colsToMap((DynamicObjectCollection)entryRows, (String)"srcbillid");
        QFilter filter = isSuspend ? null : new QFilter("billentry.id", "in", DynamicObjectUtil.getProVal2List((DynamicObject[])context.getRows(), (String)"srcentryid").stream().map(Long::parseLong).collect(Collectors.toList())).and(new QFilter("billentry.rowterminatestatus", "=", (Object)"B"));
        List teminateEntryIds = isSuspend ? null : DynamicObjectUtil.col2ListId((DynamicObjectCollection)QueryServiceHelper.query((String)"pm_purapplybill", (String)"billentry.id", (QFilter[])new QFilter[]{filter}), (String)"billentry.id");
        ArrayList<HandleLogEntity> logEntityList = new ArrayList<HandleLogEntity>(entryRows.size());
        for (DynamicObject row : context.getRows()) {
            DynamicObject newRow = (DynamicObject)gourpEntryMap.get(String.valueOf(row.getPkValue()));
            if (null == newRow) continue;
            PsscCommonUtils.copyDynamicObjectValue((DynamicObject)newRow, (DynamicObject)row, (List)properties, excludedFields, (int)-1);
            String opinion = newRow.getString("opinion");
            row.set("opinion", (Object)opinion);
            if (isSuspend) {
                if (!StringUtils.equals((CharSequence)HandleStatusEnums.SUSPEND.getValue(), (CharSequence)row.getString("handlestatus"))) {
                    row.set("statusbeforeend", (Object)row.getString("handlestatus"));
                }
                row.set("handlestatus", (Object)HandleStatusEnums.SUSPEND.getValue());
            } else {
                this.psscHandleLogService = new PsscUnsuspendLog();
                if (teminateEntryIds.contains(Long.parseLong(row.getString("srcentryid")))) {
                    row.set("handlestatus", (Object)HandleStatusEnums.TERMINATED.getValue());
                } else {
                    String newStatus = row.getString("statusbeforeend");
                    row.set("handlestatus", (Object)newStatus);
                }
            }
            HandleLogEntity logEntity = this.psscHandleLogService.getLogInfo(context.getView(), row, newRow);
            this.psscHandleLogService.updateLogInfo(logEntity, context.getView(), row);
            logEntityList.add(logEntity);
            ++count;
        }
        if (count > 0) {
            try (TXHandle tx = TX.requiresNew();){
                PsscCommonUtils.saveDynamicObjects((DynamicObject[])context.getRows());
                PsscHandleLogHelper.log(logEntityList);
                sb.append(StringUtils.equals((CharSequence)opKey, (CharSequence)"suspend") ? ResManager.loadKDString((String)"\u6682\u6302\u6210\u529f\u3002", (String)"PsscReqPoolSuspendPlugin_2", (String)"scm-pssc-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53d6\u6d88\u6682\u6302\u6210\u529f\u3002", (String)"PsscReqPoolSuspendPlugin_3", (String)"scm-pssc-formplugin", (Object[])new Object[0])).append(System.lineSeparator());
            }
        } else {
            sb.append(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u5904\u7406\u7684\u4efb\u52a1\u3002", (String)"PsscReqPoolTargetPlugin_4", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
        }
        context.setMessage(sb);
    }
}

