/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeBatchFillEntryArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pssc.common.PsscOperationContext;
import kd.scm.pssc.common.log.HandleLogEntity;
import kd.scm.pssc.common.log.PsscHandleLogHelper;
import kd.scm.pssc.common.log.PsscHandleLogService;
import kd.scm.pssc.common.log.PsscTargetLog;
import kd.scm.pssc.common.utils.PsscCommonUtils;
import kd.scm.pssc.common.utils.PsscDispatchServiceUtil;
import kd.scm.pssc.common.utils.PsscTaskPoolUtil;
import kd.scm.pssc.formplugin.PsscReqPoolHandleCorePlugin;

public final class PsscReqPoolTargetPlugin
extends PsscReqPoolHandleCorePlugin
implements BeforeF7SelectListener {
    private PsscHandleLogService psscTargetLogService = new PsscTargetLog();
    private static Log logger = LogFactory.getLog(PsscReqPoolTargetPlugin.class);

    @Override
    protected void showWithoutPermMessage() {
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u91c7\u8d2d\u4efb\u52a1\u201d\u7684\u201c\u786e\u8ba4\u6267\u884c\u65b9\u5f0f\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PsscReqPoolTargetPlugin_5", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
    }

    @Override
    protected boolean checkHasPermission() {
        return PermissionServiceHelper.checkPermission((Long)UserServiceHelper.getCurrentUserId(), (String)AppMetadataCache.getAppInfo((String)"pssc").getId(), (String)"pssc_mytask", (String)"3GRWQGYEW851");
    }

    @Override
    protected void bindData(List<DynamicObject> targetObjects, PsscOperationContext context) {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        Map groupEntryMap = DynamicObjectUtil.colsToMap((DynamicObjectCollection)entryentity, (String)"number");
        for (DynamicObject targetObject : targetObjects) {
            targetObject.set("biztype", (Object)context.getOperationKey());
            DynamicObjectCollection approveEntry = targetObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : approveEntry) {
                DynamicObject newRow = (DynamicObject)groupEntryMap.get(String.valueOf(entry.getString("tasknumber")));
                if (null == newRow) continue;
                entry.set("purmethod", (Object)newRow.getString("purmethod"));
                entry.set("sourcetype_id", (Object)newRow.getLong("sourcetype.id"));
                entry.set("sourcetype", newRow.get("sourcetype"));
                entry.set("srctype_id", (Object)newRow.getString("srctype.id"));
                entry.set("srctype", newRow.get("srctype"));
                entry.set("opinion", (Object)newRow.getString("opinion"));
                entry.set("approvetype", (Object)context.getOperationKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(PsscOperationContext context) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        List properties = PsscCommonUtils.getEntryProperties((PsscOperationContext)context);
        HashSet<String> excludedFields = new HashSet<String>(1);
        excludedFields.add("srcbillid");
        excludedFields.add("material");
        DynamicObjectCollection entryRows = context.getView().getModel().getEntryEntity("entryentity");
        Map gourpEntryMap = DynamicObjectUtil.colsToMap((DynamicObjectCollection)entryRows, (String)"srcbillid");
        ArrayList<HandleLogEntity> logEntityList = new ArrayList<HandleLogEntity>(entryRows.size());
        for (DynamicObject row : context.getRows()) {
            DynamicObject newRow = (DynamicObject)gourpEntryMap.get(String.valueOf(row.getPkValue()));
            if (null == newRow) continue;
            PsscCommonUtils.copyDynamicObjectValue((DynamicObject)newRow, (DynamicObject)row, (List)properties, excludedFields, (int)-1);
            HandleLogEntity logEntity = this.psscTargetLogService.getLogInfo(context.getView(), row, newRow);
            this.psscTargetLogService.updateLogInfo(logEntity, context.getView(), row);
            logEntityList.add(logEntity);
            ++count;
        }
        boolean needSync = true;
        if (count > 0) {
            try (TXHandle tx = TX.requiresNew();){
                PsscCommonUtils.saveDynamicObjects((DynamicObject[])context.getRows());
                PsscHandleLogHelper.log(logEntityList);
                sb.append(ResManager.loadKDString((String)"\u786e\u8ba4\u6267\u884c\u65b9\u5f0f\u6210\u529f\u3002", (String)"PsscReqPoolTargetPlugin_3", (String)"scm-pssc-formplugin", (Object[])new Object[0])).append(System.lineSeparator());
            }
            if (needSync) {
                OperationServiceHelper.executeOperate((String)"syncdata", (String)"pssc_mytask", (DynamicObject[])context.getRows(), null);
            }
        } else {
            sb.append(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u5904\u7406\u7684\u4efb\u52a1\u3002", (String)"PsscReqPoolTargetPlugin_4", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
        }
        context.setMessage(sb);
    }

    public void registerListener(EventObject e) {
        BasedataEdit srcorg;
        BasedataEdit srcType;
        super.registerListener(e);
        BasedataEdit sourceType = (BasedataEdit)this.getControl("sourcetype");
        if (sourceType != null) {
            sourceType.addBeforeF7SelectListener(this::beforeF7Select);
        }
        if ((srcType = (BasedataEdit)this.getControl("srctype")) != null) {
            srcType.addBeforeF7SelectListener(this::beforeF7Select);
        }
        if ((srcorg = (BasedataEdit)this.getControl("sourceorg")) != null) {
            srcorg.addBeforeF7SelectListener(this::beforeF7Select);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        String sourceMethod = beforeF7SelectEvent.getSourceMethod();
        String sourceMethodVal = "setItemByNumber";
        switch (name) {
            case "srctype": {
                DynamicObject sourceType = (DynamicObject)this.getModel().getValue("sourcetype", beforeF7SelectEvent.getRow());
                if (sourceType != null) {
                    QFilter sourceTypeFilter = new QFilter("sourcetype", "=", sourceType.getPkValue());
                    showParameter.getListFilterParameter().getQFilters().add(sourceTypeFilter);
                    break;
                }
                beforeF7SelectEvent.setCancel(true);
                if (!Objects.equals(sourceMethod, sourceMethodVal) && !"click".equals(sourceMethod)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5efa\u8bae\u5bfb\u6e90\u65b9\u5f0f\u3002", (String)"PsscReqPoolTargetPlugin_0", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    public void beforeBatchFillEntry(BeforeBatchFillEntryArgs e) {
        super.beforeBatchFillEntry(e);
        IDataModel model = this.getModel();
        e.setPredicate(e.getPredicate().and(rowItem -> {
            IDataEntityProperty selProp = rowItem.getSelProp();
            int row = rowItem.getRow();
            switch (selProp.getName()) {
                case "sourcetype": 
                case "srctype": {
                    String purmethod = (String)model.getValue("purmethod", row);
                    if ("sourc".equals(purmethod)) {
                        if ("srctype".equals(selProp.getName())) {
                            Long sourceId;
                            Object sourceType = model.getValue("sourcetype", row);
                            if (null == sourceType) {
                                return false;
                            }
                            Long origionSourceId = ((DynamicObject)sourceType).getLong("id");
                            return origionSourceId.compareTo(sourceId = Long.valueOf(((DynamicObject)rowItem.getValue()).getLong("sourcetype.id"))) == 0;
                        }
                        return true;
                    }
                    return false;
                }
            }
            return true;
        }));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String pro = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        IDataModel model = this.getModel();
        switch (pro) {
            case "sourcetype": {
                this.getModel().beginInit();
                for (ChangeData data : changeSet) {
                    model.setValue("srctype", null, data.getRowIndex());
                }
                this.getModel().endInit();
                this.getView().updateView("entryentity");
                break;
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opkey;
        super.afterDoOperation(args);
        switch (opkey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "autoprocess": {
                DynamicObject[] pssc_mytasks;
                DynamicObjectCollection cols = this.getModel().getEntryEntity("entryentity");
                ArrayList<String> billnoList = new ArrayList<String>();
                for (DynamicObject col : cols) {
                    billnoList.add(col.getString("number"));
                }
                QFilter filter = new QFilter("number", "in", billnoList);
                String selected = DynamicObjectUtil.getSelectfields((String)"pssc_mytask", (boolean)false);
                for (DynamicObject pssc_mytask : pssc_mytasks = BusinessDataServiceHelper.load((String)"pssc_mytask", (String)selected, (QFilter[])filter.toArray())) {
                    pssc_mytask.set("purmethod", (Object)"");
                }
                List<DynamicObject> tasklist = Arrays.asList(pssc_mytasks);
                boolean flag = PsscDispatchServiceUtil.isMcmServiceOn();
                if (flag) {
                    PsscTaskPoolUtil.setValByCategoryStrategy(tasklist, (boolean)true);
                }
                PsscTaskPoolUtil.setTargetValByPrice(tasklist, (boolean)true);
                this.getModel().beginInit();
                HashMap<String, DynamicObject> priceResMap = new HashMap<String, DynamicObject>();
                for (DynamicObject task : tasklist) {
                    priceResMap.put(task.getString("number"), task);
                }
                for (int i = 0; i < cols.size(); ++i) {
                    DynamicObject col = (DynamicObject)cols.get(i);
                    String number = col.getString("number");
                    DynamicObject taskobj = (DynamicObject)priceResMap.get(number);
                    Object proVal = taskobj.get("purmethod");
                    if (!(proVal instanceof String) || ((String)proVal).isEmpty()) continue;
                    this.getModel().setValue("purmethod", proVal, i);
                    if ("sourc".equals(this.getModel().getValue("purmethod", i))) continue;
                    this.getModel().setValue("sourcetype", null, i);
                    this.getModel().setValue("srctype", null, i);
                }
                this.getModel().endInit();
                this.getView().updateView("entryentity");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5904\u7406\u6210\u529f\u3002", (String)"PsscReqPoolTargetPlugin_1", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }
}

