/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.formplugin;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.IDataModelListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.pluginnew.GridCardPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.DateUtil;

public class PsscTaskPiePlugin
extends GridCardPlugin
implements ClickListener,
IDataModelListener {
    private static String[] colors = new String[]{"#098bff", "#00cccc", "#87db3b", "#ffd72b"};
    private static final Log logger = LogFactory.getLog(PsscTaskPiePlugin.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.drawPiechart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawPiechart() {
        PieChart pieChart = (PieChart)this.getControl("piechartap");
        pieChart.clearData();
        ArrayList<ItemValue> itemList = new ArrayList<ItemValue>(10);
        Map<Object, Object> allInfoMap = this.queryData();
        Integer count = (Integer)allInfoMap.get("count");
        HashMap dataMap = (HashMap)allInfoMap.get("datamap");
        this.cleatOldData();
        int i = 0;
        for (Map.Entry entry : dataMap.entrySet()) {
            String handlenodeName = (String)entry.getKey();
            String percent = BigDecimal.valueOf(((Integer)entry.getValue()).intValue()).multiply(BigDecimal.valueOf(100L)).divide(BigDecimal.valueOf(count.intValue()), 2, 4) + "%";
            ItemValue itemValue = new ItemValue(handlenodeName + "                " + entry.getValue() + "                  " + percent, (Number)entry.getValue(), colors[i]);
            itemList.add(itemValue);
            ++i;
        }
        ItemValue[] items = new ItemValue[itemList.size()];
        itemList.toArray(items);
        PieSeries series = pieChart.createPieSeries("");
        series.setData(items);
        HashMap<String, String> label = new HashMap<String, String>();
        try (Formatter formatter = new Formatter();){
            label.put("formatter", formatter.format("%d", count).toString());
        }
        label.put("position", "center");
        label.put("show", "true");
        label.put("fontSize", "20");
        label.put("color", "#212121");
        series.setPropValue("label", label);
        series.setRadius("65%", "80%");
        pieChart.setLegendVertical(true);
        series.setPropValue("center", (Object)new String[]{"20%", "50%"});
        HashMap<String, Object> legendMap = new HashMap<String, Object>(5);
        legendMap.put("padding", new Number[]{0, 50, 0, 0});
        legendMap.put("icon", "circle");
        legendMap.put("left", "45%");
        legendMap.put("top", "middle");
        legendMap.put("orient", "vertical");
        pieChart.addProperty("legend", legendMap);
        this.getView().updateView();
    }

    private void cleatOldData() {
        for (int i = 0; i < 3; ++i) {
            String oldcount = "count" + i;
            String oldpersentage = "percentage" + i;
            Label oldCountLabel = (Label)this.getView().getControl(oldcount);
            Label oldPersentlabel = (Label)this.getView().getControl(oldpersentage);
            oldCountLabel.setText("0");
            oldPersentlabel.setText("0%");
        }
    }

    private Map<Object, Object> queryData() {
        QFilter queryFilter = this.getqFilter();
        HashMap<Object, Object> dataMap = new HashMap<Object, Object>();
        HashMap<String, Integer> taskCategoryMap = new HashMap<String, Integer>();
        try (DataSet originDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pssc_mytask", (String)"id,handlenode.name", (QFilter[])queryFilter.toArray(), null);){
            DataSet copy = originDataSet.copy();
            int sumtaskCount = copy.count("id", false);
            dataMap.put("count", sumtaskCount);
            DataSet taskDataSet = originDataSet.groupBy(new String[]{"handlenode.name"}).count("id").finish();
            DataSet orderDataset = taskDataSet.orderBy(new String[]{"id"});
            for (Row row : orderDataset) {
                String handlenodeName = row.getString("handlenode.name");
                Integer count = row.getInteger("id");
                taskCategoryMap.put(handlenodeName, count);
            }
            dataMap.put("datamap", taskCategoryMap);
        }
        return dataMap;
    }

    private QFilter getqFilter() {
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter userFilter = new QFilter("handleuser", "=", (Object)currUserId);
        ArrayList<Long> handlenodeList = new ArrayList<Long>();
        handlenodeList.add(1673295762617913344L);
        handlenodeList.add(1673295983666123776L);
        QFilter statusFilter = new QFilter("handlenode", "in", handlenodeList);
        QFilter dateFilter = this.getDateFilter();
        QFilter filter = new QFilter("entryentity.operator", "=", (Object)RequestContext.get().getCurrUserId());
        filter.and("enable", "=", (Object)"1");
        filter.and("entryentity.invalid", "=", (Object)"0");
        filter.and("entryentity.operator", "=", (Object)currUserId);
        DynamicObjectCollection bd_operatorgroup = QueryServiceHelper.query((String)"bd_operatorgroup", (String)"id", (QFilter[])filter.toArray());
        ArrayList<Long> groupIdList = new ArrayList<Long>();
        for (DynamicObject operatorgroup : bd_operatorgroup) {
            groupIdList.add(operatorgroup.getLong("id"));
        }
        QFilter groupFilter = new QFilter("purgroup", "in", groupIdList);
        QFilter handlerFilter = new QFilter("handleuser", "=", (Object)0);
        return userFilter.and(statusFilter).and(dateFilter);
    }

    private QFilter getDateFilter() {
        Date toDate;
        String daterange = (String)this.getModel().getValue("daterange");
        Date fromDate = TimeServiceHelper.now();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(fromDate);
        switch (daterange) {
            case "1": {
                fromDate = PsscTaskPiePlugin.getDate(calendar);
                toDate = TimeServiceHelper.now();
                break;
            }
            case "2": {
                fromDate = this.getWeekStart();
                toDate = TimeServiceHelper.now();
                break;
            }
            case "3": {
                fromDate = PsscTaskPiePlugin.getMonthStart();
                toDate = TimeServiceHelper.now();
                break;
            }
            default: {
                fromDate = DateUtil.addMonth((Date)TimeServiceHelper.now(), (int)-3);
                toDate = TimeServiceHelper.now();
            }
        }
        QFilter formFilter = new QFilter("billdate", ">", (Object)fromDate);
        QFilter toFilter = new QFilter("billdate", "<=", (Object)toDate);
        return formFilter.and(toFilter);
    }

    public void click(EventObject e) {
        super.click(e);
        String clickKey = ((Control)e.getSource()).getKey();
        if (!StringUtils.isNotBlank((CharSequence)clickKey) || StringUtils.equals((CharSequence)"query", (CharSequence)clickKey)) {
            // empty if block
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        this.drawPiechart();
    }

    public Date getWeekStart() {
        Calendar cal = Calendar.getInstance();
        cal.add(4, 0);
        cal.set(7, 2);
        return PsscTaskPiePlugin.getDate(cal);
    }

    public static Date getMonthStart() {
        Calendar cal = Calendar.getInstance();
        cal.add(2, 0);
        cal.set(5, 1);
        return PsscTaskPiePlugin.getDate(cal);
    }

    private static Date getDate(Calendar cal) {
        Date date = cal.getTime();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = simpleDateFormat.format(date) + " 00:00:00";
        try {
            date = simpleDateFormat.parse(dateString);
        }
        catch (ParseException e) {
            logger.info("\u89e3\u6790\u65e5\u671f\u5b57\u7b26\u4e32\u5931\u8d25" + e.getMessage());
        }
        return date;
    }
}

