/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.formplugin;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.IDataModelListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.ChartType;
import kd.bos.form.chart.CustomChart;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.control.Control;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.pluginnew.GridCardPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.ExceptionUtil;

public class PsscTaskStatisticPlugin
extends GridCardPlugin
implements IDataModelListener {
    private static Log log = LogFactory.getLog(PsscTaskStatisticPlugin.class);
    public static final String DAYCHART = "daychart";
    public static final String MONTHCHART = "monthchart";
    public static final int MAX_MONTHSDURATION = 6;
    public static final int MAX_DAYSDURATION = 6;
    public static final int MIN_MONTHSDURATION = 6;
    public static final int DEFAULT_PART = 5;
    public static final String PERSONDATAS = "personDatas";
    public static final String AVGDATAS = "avgDatas";
    public static final String DAYQUERYFROM = "dayqueryfrom";
    public static final String MONTHQUERYFROM = "monthqueryfrom";
    public static final String XAXISDATA = "xAxisData";
    public static final String DAYQUERYTO = "dayqueryto";
    public static final String MONTHQUERYTO = "monthqueryto";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"query"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DateRangeEdit dateRangeEdit = (DateRangeEdit)this.getControl("querymonthrange");
        dateRangeEdit.setMaxDate(DateUtil.getFormatDateEndMaxDate((Date)TimeServiceHelper.now()));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDefaultDateRange();
        this.refreshData(this.getYearFirstDay(), TimeServiceHelper.now(), "month");
        this.refreshData((Date)this.getModel().getValue(DAYQUERYFROM), (Date)this.getModel().getValue(DAYQUERYTO), "day");
    }

    private Date getYearFirstDay() {
        Calendar currCal = Calendar.getInstance();
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, currCal.get(1));
        return calendar.getTime();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "dayqueryfrom": 
            case "dayqueryto": {
                this.refreshData((Date)this.getModel().getValue(DAYQUERYFROM), (Date)this.getModel().getValue(DAYQUERYTO), "day");
                break;
            }
            case "monthqueryfrom": 
            case "monthqueryto": {
                this.refreshData((Date)this.getModel().getValue(MONTHQUERYFROM), (Date)this.getModel().getValue(MONTHQUERYTO), "month");
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshData(Date fromDate, Date toDate, String type) {
        try {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u52a0\u8f7d\u4e2d", (String)"PsscTaskStatisticPlugin_0", (String)"scm-pssc-formplugin", (Object[])new Object[0])));
            Control dayormonthchart = "month".equals(type) ? this.getView().getControl(MONTHCHART) : this.getView().getControl(DAYCHART);
            if (dayormonthchart instanceof CustomChart) {
                CustomChart chart = (CustomChart)dayormonthchart;
                chart.clearData();
                Map<String, Object> xyAxisDataMap = this.getXYAxisDataMap(fromDate, toDate, type);
                chart.setShowTitle(false);
                String qtyString = ResManager.loadKDString((String)"\u4e2a\u4eba\u5b9e\u9645\u503c", (String)"PsscTaskStatisticPlugin_1", (String)"scm-pssc-formplugin", (Object[])new Object[0]);
                String avgString = ResManager.loadKDString((String)"\u5e73\u5747\u503c", (String)"PsscTaskStatisticPlugin_2", (String)"scm-pssc-formplugin", (Object[])new Object[0]);
                LineSeries lineSerial = chart.createLineSeries(qtyString);
                LineSeries avglineSerial = chart.createLineSeries(avgString);
                avglineSerial.setName(ResManager.loadKDString((String)"\u5e73\u5747\u503c", (String)"PsscTaskStatisticPlugin_2", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                lineSerial.setType(ChartType.line);
                avglineSerial.setType(ChartType.line);
                Axis axis = chart.createXAxis("", AxisType.category);
                String[] cat = (String[])xyAxisDataMap.get(XAXISDATA);
                Number[] personDatas = (Number[])xyAxisDataMap.get(PERSONDATAS);
                Number[] avgDatas = (Number[])xyAxisDataMap.get(AVGDATAS);
                axis.setCategorys(cat);
                String yaxisname = ResManager.loadKDString((String)"     \u6570\u91cf", (String)"PsscTaskStatisticPlugin_3", (String)"scm-pssc-formplugin", (Object[])new Object[0]);
                this.creatYAxis(chart, avgDatas, personDatas, yaxisname);
                lineSerial.setData(personDatas);
                avglineSerial.setData(avgDatas);
                HashMap<String, Boolean> param = new HashMap<String, Boolean>(4);
                param.put("containLabel", true);
                chart.addProperty("grid", param);
                chart.setShowTooltip(true);
                chart.bindData(null);
                chart.refresh();
                if ("month".equals(type)) {
                    this.getView().updateView(MONTHCHART);
                } else {
                    this.getView().updateView(DAYCHART);
                }
            }
        }
        catch (Exception e) {
            log.info(ExceptionUtil.getStackTrace((Throwable)e));
        }
        finally {
            this.getView().hideLoading();
        }
    }

    private void creatYAxis(CustomChart chart, Number[] datas, Number[] deptdatas, String name) {
        Number personMax = Stream.of(datas).max(Comparator.comparingInt(Number::intValue)).get();
        Number deptMax = Stream.of(deptdatas).max(Comparator.comparingInt(Number::intValue)).get();
        Number personMin = Stream.of(datas).min(Comparator.comparingInt(Number::intValue)).get();
        Number deptMin = Stream.of(deptdatas).min(Comparator.comparingInt(Number::intValue)).get();
        Number max = personMax.intValue() > deptMax.intValue() ? (Number)personMax : (Number)deptMax;
        Number min = personMin.intValue() < deptMin.intValue() ? (Number)personMin : (Number)deptMin;
        double interval = Math.ceil((max.doubleValue() - min.doubleValue()) / 5.0);
        if (max.equals(min)) {
            interval = max.doubleValue();
        }
        Axis amtYAxis = chart.createYAxis(name, AxisType.value);
        amtYAxis.setInterval((Number)interval);
        amtYAxis.setMax((Number)(interval * 5.0));
        amtYAxis.setMin((Number)0);
    }

    private Map<String, Object> getXYAxisDataMap(Date fromDate, Date toDate, String type) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        int dayormonths = PsscTaskStatisticPlugin.getDayorMonths(fromDate, toDate, type);
        String[] cat = new String[dayormonths];
        Number[] avgDatas = new Number[dayormonths];
        Number[] personnalDatas = new Number[dayormonths];
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>(12);
        for (int i = 0; i < dayormonths; ++i) {
            String s = "month".equals(type) ? DateUtils.formatDate((Date)DateUtil.addMonth((Date)fromDate, (int)i), (Object[])new Object[]{"yyyy-MM"}) : DateUtils.formatDate((Date)DateUtil.addDays((Date)fromDate, (int)i), (Object[])new Object[]{"yyyy-MM-dd"});
            cat[i] = s;
            avgDatas[i] = 0;
            personnalDatas[i] = 0;
            indexMap.put(s, i);
        }
        resultMap.put(XAXISDATA, cat);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(new QFilter("handlestatus", "=", (Object)"D"));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        toDate = simpleDateFormat.format(fromDate).equals(simpleDateFormat.format(toDate)) ? DateUtils.addDays((Date)fromDate, (int)1) : DateUtils.addDays((Date)toDate, (int)1);
        filterList.add(new QFilter("taskfinishtime", ">=", (Object)fromDate));
        filterList.add(new QFilter("taskfinishtime", "<=", (Object)toDate));
        if (!CollectionUtils.isEmpty(filterList)) {
            QFilter[] qFilters = filterList.toArray(new QFilter[0]);
            try (AlgoContext algoContext = Algo.newContext();
                 DataSet originDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pssc_mytask", (String)"id,handleuser,taskfinishtime", (QFilter[])qFilters, (String)"taskfinishtime");){
                DataSet copyData = originDataSet.copy();
                DataSet userCountDataset = originDataSet.copy();
                DataSet taskDataSet = this.getTaskDataset(originDataSet, type);
                DataSet personnalDataset = this.getPersonnalDataset(copyData, type);
                this.buildData(dayormonths, avgDatas, indexMap, taskDataSet);
                this.buildData(dayormonths, personnalDatas, indexMap, personnalDataset);
                copyData.close();
            }
        }
        resultMap.put(AVGDATAS, avgDatas);
        resultMap.put(PERSONDATAS, personnalDatas);
        return resultMap;
    }

    private DataSet getPersonnalDataset(DataSet copyData, final String type) {
        return copyData.map(new MapFunction(){

            public Object[] map(Row row) {
                String yearAndMonth = "";
                if (row.getDate("taskfinishtime") != null) {
                    yearAndMonth = "month".equals(type) ? DateUtils.formatDate((Date)row.getDate("taskfinishtime"), (Object[])new Object[]{"yyyy-MM"}) : DateUtils.formatDate((Date)row.getDate("taskfinishtime"), (Object[])new Object[]{"yyyy-MM-dd"});
                }
                return new Object[]{yearAndMonth, row.get("id"), row.getLong("handleuser")};
            }

            public RowMeta getResultRowMeta() {
                RowMeta sourceRowMeta = new RowMeta(new String[]{"yearandmonth", "id", "handleuser"}, new DataType[]{DataType.StringType, DateType.LongType, DateType.LongType});
                return sourceRowMeta;
            }
        }).filter(new FilterFunction(){

            public boolean test(Row row) {
                long currUserId = RequestContext.get().getCurrUserId();
                return currUserId == row.getLong("handleuser");
            }
        }).groupBy(new String[]{"yearandmonth", "handleuser"}).count("id").finish();
    }

    private DataSet getTaskDataset(DataSet originDataSet, final String type) {
        DataSet groupDataset = originDataSet.map(new MapFunction(){

            public Object[] map(Row row) {
                String yearAndMonth = "";
                if (row.getDate("taskfinishtime") != null) {
                    yearAndMonth = "month".equals(type) ? DateUtils.formatDate((Date)row.getDate("taskfinishtime"), (Object[])new Object[]{"yyyy-MM"}) : DateUtils.formatDate((Date)row.getDate("taskfinishtime"), (Object[])new Object[]{"yyyy-MM-dd"});
                }
                return new Object[]{yearAndMonth, row.get("id"), row.getLong("handleuser")};
            }

            public RowMeta getResultRowMeta() {
                RowMeta sourceRowMeta = new RowMeta(new String[]{"yearandmonth", "id", "handleuser"}, new DataType[]{DataType.StringType, DateType.LongType, DateType.LongType});
                return sourceRowMeta;
            }
        }).groupBy(new String[]{"yearandmonth", "handleuser"}).count("id").finish();
        return groupDataset.select(new String[]{"yearandmonth", "id"}).groupBy(new String[]{"yearandmonth"}).avg("id").finish();
    }

    private void buildData(int months, Number[] avgDatas, Map<String, Integer> indexMap, DataSet taskDataSet) {
        int i = 0;
        for (Row row : taskDataSet) {
            if (i >= months) break;
            Integer yearandmonth = indexMap.get(row.getString("yearandmonth"));
            if (yearandmonth != null && yearandmonth >= 0) {
                avgDatas[yearandmonth.intValue()] = row.getInteger("id");
            }
            ++i;
        }
    }

    private void setDefaultDateRange() {
        this.getModel().setValue(DAYQUERYTO, (Object)TimeServiceHelper.now());
        this.getModel().setValue(DAYQUERYFROM, (Object)DateUtil.addDays((Date)TimeServiceHelper.now(), (int)-6));
    }

    public static int getDayorMonths(Date firstDate, Date secDate, String type) {
        if ("month".equals(type)) {
            LocalDate localDate1 = firstDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            LocalDate localDate2 = secDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            return localDate2.isAfter(localDate1) ? (int)localDate1.until(localDate2, ChronoUnit.MONTHS) + 1 : (int)localDate2.until(localDate1, ChronoUnit.MONTHS) + 1;
        }
        return DateUtil.daysBetween((Date)firstDate, (Date)secDate) + 1;
    }
}

