/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.formplugin.edit;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportEntryEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.importentry.resolving.ImportEntryData;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pssc.common.helper.MaterialOperatorHelper;
import kd.scm.pssc.common.utils.PsscPackageGroupUtils;

public class PsscPackageGroupEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit handler = (BasedataEdit)this.getControl("handler");
        handler.addBeforeF7SelectListener(this::beforeF7Select);
        BasedataEdit material = (BasedataEdit)this.getControl("material");
        material.addBeforeF7SelectListener(this::beforeF7Select);
        BasedataEdit category = (BasedataEdit)this.getControl("category");
        category.addBeforeF7SelectListener(this::beforeF7Select);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject operator;
        QFilter qFilter = new QFilter("operatorid", "=", (Object)RequestContext.get().getCurrUserId());
        qFilter.and("invalid", "=", (Object)Boolean.FALSE);
        qFilter.and("opergrptype", "=", (Object)"CGZ");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bd_operator", (String)"operatorid,id,operatorgrpid,opergrpname", (QFilter[])new QFilter[]{qFilter}, (String)"opergrpname asc", (int)1);
        if (query.size() > 0 && (operator = (DynamicObject)query.get(0)) != null) {
            this.getModel().setValue("handler", (Object)operator.getLong("id"));
            this.getModel().setValue("purgroup", (Object)operator.getLong("operatorgrpid"));
            this.getModel().setValue("handleuser", (Object)RequestContext.get().getCurrUserId());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        String fieldKey = e.getProperty().getName();
        block10: for (ChangeData changeData : changeSet = e.getChangeSet()) {
            int rowIndex = changeData.getRowIndex();
            Object newValue = changeData.getNewValue();
            switch (fieldKey) {
                case "handler": {
                    this.changeHandler(newValue);
                    continue block10;
                }
                case "category": {
                    if (newValue == null) continue block10;
                    this.getModel().setValue("material", null, rowIndex);
                    continue block10;
                }
                case "material": {
                    if (newValue == null) continue block10;
                    this.getModel().setValue("category", null, rowIndex);
                    continue block10;
                }
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        Object handler = this.getModel().getDataEntity(true).get("handler");
        switch (name) {
            case "handler": {
                QFilter q1 = new QFilter("invalid", "=", (Object)Boolean.FALSE);
                QFilter q2 = new QFilter("operatorid", "=", (Object)RequestContext.get().getCurrUserId());
                List qFilters = showParameter.getListFilterParameter().getQFilters();
                if (qFilters == null) break;
                qFilters.add(q1);
                qFilters.add(q2);
                break;
            }
            case "material": 
            case "category": {
                if (handler == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u91c7\u8d2d\u5458", (String)"PsscPackageGroupEditPlugin_1", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                }
                Set ids = null;
                long handlerId = this.getModel().getDataEntity(true).getLong("handleuser_id");
                DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                HashSet<Long> unIncludes = new HashSet<Long>(entryEntity.size());
                for (DynamicObject row : entryEntity) {
                    long baseDataId = row.getLong(name + "_id");
                    unIncludes.add(baseDataId);
                }
                if (StringUtils.equals((CharSequence)"material", (CharSequence)name)) {
                    ids = MaterialOperatorHelper.getPurchasableDataInfoByOperator((long)handlerId, (String)"OPER_MATER");
                    showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)ids));
                }
                if (unIncludes.size() <= 0) break;
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", unIncludes));
                break;
            }
        }
    }

    private void changeHandler(Object newValue) {
        IDataModel model = this.getModel();
        if (newValue instanceof DynamicObject) {
            DynamicObject bizOperator = (DynamicObject)newValue;
            model.setValue("purgroup", bizOperator.get("operatorgrpid"));
        } else {
            model.setValue("purgroup", null);
        }
    }

    public void beforeImportEntry(BeforeImportEntryEventArgs e) {
        Map source = (Map)e.getSource();
        Map logMap = e.getEntryDataMap();
        List entryEntity = (List)logMap.get("entryentity");
        if (entryEntity == null) {
            return;
        }
        ImportLogger importLogger = (ImportLogger)entryEntity.get(0);
        HashMap materialMap = new HashMap();
        HashMap categoryMap = new HashMap();
        List entryDatas = (List)source.get("entryentity");
        Iterator iterator = entryDatas.iterator();
        while (iterator.hasNext()) {
            String materialNumber;
            JSONObject baseData;
            String categoryNumber;
            String msg;
            ImportEntryData entryData = (ImportEntryData)iterator.next();
            JSONObject data = entryData.getData();
            int rowIndex = data.getInteger("rowNum") + 1;
            StringBuilder sb = new StringBuilder();
            if (data.containsKey((Object)"category") && data.containsKey((Object)"material")) {
                sb.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u5bfc\u5165\u7269\u6599\u5206\u7c7b\u7f16\u7801\u3001\u7269\u6599\u7f16\u7801\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PsscPackageGroupEditPlugin_0", (String)"scm-pssc-formplugin", (Object[])new Object[0]), rowIndex));
            }
            if (data.containsKey((Object)"category") && StringUtils.isNotBlank((CharSequence)(msg = PsscPackageGroupUtils.validateBaseData((String)"category", materialMap, (int)rowIndex, (String)(categoryNumber = (baseData = data.getJSONObject("category")).getString("number")))))) {
                sb.append(msg);
            }
            if (data.containsKey((Object)"material") && StringUtils.isNotBlank((CharSequence)(msg = PsscPackageGroupUtils.validateBaseData((String)"material", categoryMap, (int)rowIndex, (String)(materialNumber = (baseData = data.getJSONObject("material")).getString("number")))))) {
                sb.append(msg);
            }
            if (!StringUtils.isNotBlank((CharSequence)sb.toString())) continue;
            importLogger.log(data.getInteger("rowNum"), sb.toString());
            importLogger.fail();
            importLogger.setTotal(importLogger.getTotal() + 1);
            iterator.remove();
        }
    }
}

