/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.formplugin.edit;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msbd.business.helper.OrgHelper;
import kd.mpscmm.msbd.common.enums.UnitConvertDirEnum;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.pssc.business.helper.BillQtyAndUnitHelper;
import kd.scm.pssc.business.helper.ReqApplyBillHelper;
import kd.scm.pssc.common.utils.PsscParamUtil;

public class PsscReqApplyMaterialEditPlugin
extends AbstractFormPlugin {
    public void initialize() {
        super.initialize();
        boolean supportUnMaterial = PsscParamUtil.isSupportUnMaterial();
        BasedataEdit materialmasterid = (BasedataEdit)this.getControl("materialmasterid");
        if (supportUnMaterial) {
            materialmasterid.setMustInput(false);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"advconbaritemap"});
        } else {
            materialmasterid.setMustInput(true);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconbaritemap"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        if (StringUtils.equals((CharSequence)"materialmasterid", (CharSequence)name)) {
            ChangeData[] changeSet;
            boolean supportUnMaterial = PsscParamUtil.isSupportUnMaterial();
            for (ChangeData changeData : changeSet = e.getChangeSet()) {
                this.setMaterialNameEnable(supportUnMaterial, changeData.getNewValue(), changeData.getRowIndex());
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        boolean supportUnMaterial = PsscParamUtil.isSupportUnMaterial();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection("billentry");
        for (int i = 0; i < rows.size(); ++i) {
            DynamicObject material = ((DynamicObject)rows.get(0)).getDynamicObject("materialmasterid");
            this.setMaterialNameEnable(supportUnMaterial, material, i);
        }
    }

    private void setMaterialNameEnable(boolean supportUnMaterial, Object material, int index) {
        if (supportUnMaterial || material instanceof DynamicObject) {
            if (material != null && !((DynamicObject)material).getBoolean("isdisposable")) {
                this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"materialname"});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), index, new String[]{"materialname"});
            }
        } else {
            this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"materialname"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("replacematerial".equals(operateKey) || "replacelog".equals(operateKey)) {
            DynamicObjectCollection billentry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("billentry");
            EntryGrid billentryGrid = (EntryGrid)this.getControl("billentry");
            int[] selectRows = billentryGrid.getSelectRows();
            if ("replacelog".equals(operateKey)) {
                if (selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u5f55\u884c\u3002", (String)"PsscReqApplyMaterialEditPlugin_6", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                } else if (selectRows.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u4e14\u53ea\u80fd\u9009\u62e9\u4e00\u884c\u5206\u5f55\u64cd\u4f5c\u3002", (String)"PsscReqApplyMaterialEditPlugin_7", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
                return;
            }
            HashSet<Long> entryIds = new HashSet<Long>();
            for (int selectRow : selectRows) {
                DynamicObject row;
                if (billentry.size() <= selectRow || (row = (DynamicObject)billentry.get(selectRow)) == null) continue;
                entryIds.add(row.getLong("id"));
            }
            DynamicObjectCollection billentryFromDb = QueryServiceHelper.query((String)"pm_requirapplybill", (String)"billentry.id id,billentry.linetype linetype_id,billentry.materialmasterid materialmasterid_id,billentry.rowclosestatus rowclosestatus,billentry.rowterminatestatus rowterminatestatus,billentry.unmaterialtag unmaterialtag", (QFilter[])new QFilter[]{new QFilter("billentry.id", "in", entryIds)}, null);
            String message = this.validate(billentryFromDb, entryIds);
            if (StringUtils.isNotBlank((CharSequence)message)) {
                this.getView().showTipNotification(message);
                args.setCancel(true);
            }
        }
    }

    private String validate(DynamicObjectCollection billentry, Set<Long> entryIds) {
        EntryGrid billentryGrid = (EntryGrid)this.getControl("billentry");
        int[] selectRows = billentryGrid.getSelectRows();
        StringBuilder messageBuilder = new StringBuilder();
        if (selectRows.length == 0) {
            messageBuilder.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u7f16\u7801\u4e3a\u7a7a\u6216\u9700\u8981\u91cd\u65b0\u66ff\u6362\u7684\u5206\u5f55\u884c\u6570\u636e\u3002", (String)"PsscReqApplyMaterialEditPlugin_0", (String)"scm-pssc-formplugin", (Object[])new Object[0])).append(System.lineSeparator());
        }
        HashSet<Long> lineTypeIds = new HashSet<Long>();
        for (DynamicObject row : billentry) {
            if (!entryIds.contains(row.getLong("id"))) continue;
            lineTypeIds.add(row.getLong("linetype_id"));
            long materialmasterid = row.getLong("materialmasterid_id");
            long unmaterialtag = row.getLong("unmaterialtag");
            String rowCloseStatus = row.getString("rowclosestatus");
            String rowTerminateStatus = row.getString("rowterminatestatus");
            if (!StringUtils.equals((CharSequence)rowCloseStatus, (CharSequence)"A")) {
                messageBuilder.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u5173\u95ed\u72b6\u6001\u4e3a\u6b63\u5e38\u7684\u6570\u636e\u3002", (String)"PsscReqApplyMaterialEditPlugin_1", (String)"scm-pssc-formplugin", (Object[])new Object[0])).append(System.lineSeparator());
                break;
            }
            if (!StringUtils.equals((CharSequence)rowTerminateStatus, (CharSequence)"A")) {
                messageBuilder.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u7ec8\u6b62\u72b6\u6001\u4e3a\u6b63\u5e38\u7684\u6570\u636e\u3002", (String)"PsscReqApplyMaterialEditPlugin_2", (String)"scm-pssc-formplugin", (Object[])new Object[0])).append(System.lineSeparator());
                break;
            }
            if (materialmasterid == 0L || unmaterialtag != 0L) continue;
            messageBuilder.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u7f16\u7801\u4e3a\u7a7a\u6216\u9700\u8981\u91cd\u65b0\u66ff\u6362\u7684\u5206\u5f55\u884c\u6570\u636e\u3002", (String)"PsscReqApplyMaterialEditPlugin_0", (String)"scm-pssc-formplugin", (Object[])new Object[0])).append(System.lineSeparator());
            break;
        }
        if (lineTypeIds.size() > 1) {
            messageBuilder.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u7c7b\u578b\u76f8\u540c\u7684\u6570\u636e\u8fdb\u884c\u7269\u6599\u66ff\u6362\u3002", (String)"PsscReqApplyMaterialEditPlugin_3", (String)"scm-pssc-formplugin", (Object[])new Object[0])).append(System.lineSeparator());
        }
        String message = messageBuilder.toString();
        return message;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("replacematerial".equals(operateKey) || "replacelog".equals(operateKey)) {
            boolean success = args.getOperationResult().isSuccess();
            if (!success) {
                return;
            }
            EntryGrid billentry = (EntryGrid)this.getControl("billentry");
            int[] selectRows = billentry.getSelectRows();
            long orgId = this.getModel().getDataEntity(true).getLong("org_id");
            HashSet<Long> entryIds = new HashSet<Long>();
            DynamicObjectCollection billentry1 = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("billentry");
            HashMap<String, Object> param = new HashMap<String, Object>(1);
            for (int selectRow : selectRows) {
                DynamicObject row;
                if (billentry1.size() <= selectRow || (row = (DynamicObject)billentry1.get(selectRow)) == null) continue;
                entryIds.add(row.getLong("id"));
                param.put("lineTypeId", row.getLong("linetype_id"));
            }
            param.put("entryId", SerializationUtils.toJsonString(entryIds));
            param.put("orgId", orgId);
            param.put("billTypeId", this.getModel().getDataEntity(true).getLong("billtype_id"));
            param.put("bizTypeId", this.getModel().getDataEntity(true).getLong("biztype_id"));
            param.put("formId", "pm_requirapplybill");
            if ("replacelog".equals(operateKey)) {
                OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)"pssc_replace_logdilog", (ShowType)ShowType.Modal, param, null);
                return;
            }
            OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)"pssc_replace_diglog", (ShowType)ShowType.Modal, param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "replaceMaterial"));
        } else if ("save".equals(operateKey)) {
            boolean supportUnMaterial = PsscParamUtil.isSupportUnMaterial();
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection("billentry");
            for (int i = 0; i < rows.size(); ++i) {
                DynamicObject material = ((DynamicObject)rows.get(0)).getDynamicObject("materialmasterid");
                this.setMaterialNameEnable(supportUnMaterial, material, i);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("replaceMaterial".equals(actionId) && (returnData = evt.getReturnData()) instanceof JSONObject) {
            List<Map<String, Object>> inParameterList;
            String entryId = ((JSONObject)returnData).getString("entryId");
            Long materialId = ((JSONObject)returnData).getLong("material");
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getDataEntity().getPkValue(), (String)"pm_requirapplybill");
            DynamicObject material = BusinessDataServiceHelper.loadSingleFromCache((Object)materialId, (String)"bd_material");
            Set entryIds = (Set)SerializationUtils.fromJsonString((String)entryId, Set.class);
            DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
            ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>();
            String message = this.validate(billentry, entryIds);
            if (StringUtils.isNotBlank((CharSequence)message)) {
                this.getView().showTipNotification(message);
                return;
            }
            boolean kindParameter = ReqApplyBillHelper.getKindParameter();
            Map ebPurOrgData = null;
            if (kindParameter && (inParameterList = this.collectParameter(bill, entryIds, materialId)) != null) {
                ebPurOrgData = ReqApplyBillHelper.getEBPurOrgData(inParameterList, (String)"pm_requirapplybill");
            }
            int failNum = 0;
            DynamicObject org = bill.getDynamicObject("org");
            StringBuilder errorMessage = new StringBuilder();
            for (DynamicObject row : billentry) {
                long id = row.getLong("id");
                if (!entryIds.contains(id)) continue;
                BigDecimal unionsumqty = row.getBigDecimal("unionsumqty");
                if (unionsumqty != null && unionsumqty.compareTo(BigDecimal.ZERO) > 0) {
                    ++failNum;
                    errorMessage.append(String.format(ResManager.loadKDString((String)"%1$s\u5df2\u5173\u8054\u4e0b\u6e38\u5355\u636e\uff0c\u66ff\u6362\u5931\u8d25\u3002", (String)"PsscReqApplyMaterialEditPlugin_4", (String)"scm-pssc-formplugin", (Object[])new Object[0]), row.getString("materialname"))).append(System.lineSeparator());
                    continue;
                }
                DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"pssc_replace_log");
                log.set("entryid", (Object)id);
                log.set("material", (Object)row.getDynamicObject("materialmasterid"));
                log.set("materialname", (Object)row.getString("materialname"));
                log.set("materialnew", (Object)material);
                log.set("materialnamenew", material.getLocaleString("name") != null ? material.getLocaleString("name").toString() : null);
                log.set("creator_id", (Object)RequestContext.get().getCurrUserId());
                log.set("optime", (Object)TimeServiceHelper.now());
                row.set("materialmasterid", (Object)material);
                row.set("materialname", material.getLocaleString("name") != null ? material.getLocaleString("name").toString() : null);
                logs.add(log);
                DynamicObject baseUnit = material.getDynamicObject("baseunit");
                if (baseUnit != null) {
                    row.set("baseunit", (Object)baseUnit);
                    row.set("unit", (Object)baseUnit);
                }
                if (material.getDynamicObject("auxptyunit") != null) {
                    row.set("auxunit", (Object)material.getDynamicObject("auxptyunit"));
                    String unitConvertDir = material.getString("unitconvertdir");
                    if (UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir)) {
                        BigDecimal auxQty = BillQtyAndUnitHelper.getDesQtyConv((Long)materialId, (DynamicObject)baseUnit, (BigDecimal)row.getBigDecimal("baseqty"), (DynamicObject)material.getDynamicObject("auxptyunit"));
                        row.set("auxqty", (Object)auxQty);
                    }
                } else {
                    row.set("auxunit", null);
                    row.set("auxqty", (Object)BigDecimal.ZERO);
                }
                DynamicObject ebPurOrg = ReqApplyBillHelper.getEBPurOrg((Map)ebPurOrgData, (Long)((Long)org.getPkValue()), (String)row.getString("reqkind"), (Long)material.getLong("id"), (DynamicObject)row);
                if (ebPurOrg != null) {
                    row.set("entrybizorg", (Object)ebPurOrg);
                    continue;
                }
                Object entryBizOrg = row.get("entrybizorg");
                if (org != null && entryBizOrg == null) {
                    row.set("entrybizorg", (Object)org);
                    continue;
                }
                if (entryBizOrg != null) continue;
                DynamicObject fromOrg = OrgHelper.getOrgForFormDefObjValue((Long)((Long)org.getPkValue()), (String)"", (String)"02", (String)"toorg");
                row.set("entrybizorg", (Object)fromOrg);
            }
            if (logs.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])logs.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
                this.getView().invokeOperation("refresh");
            }
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7269\u6599\u66ff\u6362\u6210\u529f%1$s\u6761\u3001\u5931\u8d25%2$s\u6761\u3002%3$s", (String)"PsscReqApplyMaterialEditPlugin_5", (String)"scm-pssc-formplugin", (Object[])new Object[0]), entryIds.size() - failNum, failNum, errorMessage.toString()));
        }
    }

    private List<Map<String, Object>> collectParameter(DynamicObject bill, Set<Long> entryIds, Long materialId) {
        ArrayList<Map<String, Object>> inParameterList = new ArrayList<Map<String, Object>>(16);
        DynamicObjectCollection entryList = bill.getDynamicObjectCollection("billentry");
        for (DynamicObject row : entryList) {
            long id;
            if (materialId == null || !entryIds.contains(id = row.getLong("id"))) continue;
            HashMap<String, Object> parameter = new HashMap<String, Object>(16);
            String reqKind = row.getString("reqkind");
            if (StringUtils.isBlank((CharSequence)reqKind)) continue;
            parameter.put("baseDataType", "2");
            parameter.put("orgId", bill.getLong("org_id"));
            parameter.put("baseDataId", materialId);
            if ("A".equals(reqKind)) {
                parameter.put("bizType", "2");
            } else if ("B".equals(reqKind)) {
                parameter.put("bizType", "3");
            }
            inParameterList.add(parameter);
        }
        return inParameterList;
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String name;
        EntryProp entryProp = e.getEntryProp();
        switch (name = entryProp.getName()) {
            case "billentry": {
                int insertRow = e.getInsertRow();
                boolean supportUnMaterial = PsscParamUtil.isSupportUnMaterial();
                Object value = this.getModel().getValue("materialmasterid", insertRow);
                this.setMaterialNameEnable(supportUnMaterial, value, insertRow);
                break;
            }
        }
    }
}

