/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.formplugin.edit;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeBindDataEvent;
import kd.bos.form.events.BeforeBindDataListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.pssc.common.utils.DateUtil;

public class PsscReqSumResultTodoEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
BeforeBindDataListener,
HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl("sumbilllistap");
        if (billList != null) {
            billList.addBeforeBindDataListener((BeforeBindDataListener)this);
            billList.addHyperClickListener((HyperLinkClickListener)this);
        }
        MulBasedataEdit sumrequireorg = (MulBasedataEdit)this.getControl("sumrequireorg");
        BasedataEdit sumquerymaterial = (BasedataEdit)this.getControl("sumquerymaterial");
        sumrequireorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        sumquerymaterial.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        QFilter qFilter = new QFilter("id", "=", (Object)0L);
        FilterParameter filterParameter = new FilterParameter();
        filterParameter.setFilter(qFilter);
        BillList billList = (BillList)this.getControl("sumbilllistap");
        LocalDateTime todayStart = LocalDateTime.of(LocalDate.now().minusMonths(1L), LocalTime.MIN);
        LocalDateTime todayEnd = LocalDateTime.of(LocalDate.now(), LocalTime.MIN);
        this.getView().getModel().setValue("sumapplydate_startdate", (Object)todayStart);
        this.getView().getModel().setValue("sumapplydate_enddate", (Object)todayEnd);
        billList.setFilterParameter(filterParameter);
        billList.refresh();
    }

    public void beforeBindData(BeforeBindDataEvent evt) {
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName;
        switch (fieldName = evt.getFieldName()) {
            case "billno": {
                Control control = (Control)evt.getSource();
                ListSelectedRow selectedRow = ((BillList)control).getCurrentSelectedRowInfo();
                Object id = selectedRow.getPrimaryKeyValue();
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setFormId("pm_requirapplybill");
                showParameter.setPkId(id);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setStatus(OperationStatus.VIEW);
                control.getView().showForm((FormShowParameter)showParameter);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name;
        IDataEntityProperty property = evt.getProperty();
        switch (name = property.getName()) {
            case "sumrequireorg": {
                List customQFilters = evt.getCustomQFilters();
                HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"15", (String)BizAppServiceHelp.getAppIdByAppNumber((String)"pssc"), (String)"pm_requirapplybill", (String)"47150e89000000ac");
                List orgIds = result.getHasPermOrgs();
                if (!result.hasAllOrgPerm() && orgIds != null && orgIds.size() > 0) {
                    customQFilters.add(new QFilter("id", "in", (Object)orgIds));
                    break;
                }
                if (result.hasAllOrgPerm()) break;
                customQFilters.add(QFilter.of((String)"1!=1", (Object[])new Object[0]));
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (opKey = operate.getOperateKey()) {
            case "submit": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": 
            case "delete": {
                ListSelectedRowCollection selectedRows = this.getSelectedRows("sumbilllistap");
                int size = selectedRows.getPrimaryKeyValues().length;
                if (size != 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PsscReqSumResultTodoEditPlugin_11", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "sumquery": {
                DynamicObjectCollection sumReQuireOrg = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("sumrequireorg");
                if (sumReQuireOrg.size() != 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u6c42\u7ec4\u7ec7\u3002", (String)"PsscReqSumResultTodoEditPlugin_10", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        this.doOperateOption(operateKey);
    }

    private String getOpName(String opKey) {
        String opName = null;
        switch (opKey) {
            case "delete": {
                opName = ResManager.loadKDString((String)"\u5220\u9664", (String)"PsscReqSumResultTodoEditPlugin_0", (String)"scm-pssc-formplugin", (Object[])new Object[0]);
                break;
            }
            case "submit": {
                opName = ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"PsscReqSumResultTodoEditPlugin_1", (String)"scm-pssc-formplugin", (Object[])new Object[0]);
                break;
            }
            case "unsubmit": {
                opName = ResManager.loadKDString((String)"\u64a4\u9500", (String)"PsscReqSumResultTodoEditPlugin_2", (String)"scm-pssc-formplugin", (Object[])new Object[0]);
                break;
            }
            case "audit": {
                opName = ResManager.loadKDString((String)"\u5ba1\u6838", (String)"PsscReqSumResultTodoEditPlugin_3", (String)"scm-pssc-formplugin", (Object[])new Object[0]);
                break;
            }
            case "unaudit": {
                opName = ResManager.loadKDString((String)"\u53cd\u5ba1\u6838", (String)"PsscReqSumResultTodoEditPlugin_4", (String)"scm-pssc-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        return opName;
    }

    private QFilter getViewQFilter() {
        List<Object> querymaterialIds;
        DynamicObject billtype;
        Date enddate;
        Date startdate;
        IDataModel model = this.getModel();
        QFilter qFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        List<Object> reqOrgList = this.getMulBaseDataIdList(this.getModel(), "sumrequireorg");
        if (reqOrgList.size() > 0) {
            qFilter.and(new QFilter("org", "in", reqOrgList));
        }
        if ((startdate = (Date)model.getValue("sumapplydate_startdate")) != null) {
            qFilter.and(new QFilter("biztime", ">=", (Object)startdate));
        }
        if ((enddate = (Date)model.getValue("sumapplydate_enddate")) != null) {
            Date endOfDay = DateUtil.getEndOfDay((Date)enddate);
            qFilter.and(new QFilter("biztime", "<=", (Object)endOfDay));
        }
        if ((billtype = (DynamicObject)model.getValue("sumbilltype")) != null) {
            qFilter.and(new QFilter("billtype", "=", billtype.getPkValue()));
        }
        if ((querymaterialIds = this.getMulBaseDataIdList(this.getModel(), "sumquerymaterial")).size() > 0) {
            QFilter qFilter1 = new QFilter("billentry.materialmasterid", "in", querymaterialIds);
            qFilter.and(qFilter1);
        }
        String sumbillstatus = this.getView().getModel().getDataEntity(true).getString("sumbillstatus");
        String sumtype = this.getView().getModel().getDataEntity(true).getString("sumtype");
        if (StringUtils.isNotBlank((CharSequence)sumbillstatus)) {
            qFilter.and(new QFilter("billstatus", "=", (Object)sumbillstatus));
        }
        if (StringUtils.isNotBlank((CharSequence)sumtype)) {
            qFilter.and(new QFilter("type", "=", (Object)sumtype));
        }
        return qFilter;
    }

    private List<Object> getMulBaseDataIdList(IDataModel model, String fieldKey) {
        DynamicObjectCollection baseDataCol = (DynamicObjectCollection)model.getValue(fieldKey);
        ArrayList<Object> idList = new ArrayList<Object>(16);
        for (DynamicObject row : baseDataCol) {
            DynamicObject baseData = row.getDynamicObject("fbasedataid");
            if (baseData == null) continue;
            idList.add(baseData.getPkValue());
        }
        return idList;
    }

    private boolean doOperateOption(String opKey) {
        ListSelectedRowCollection selectedRows = this.getSelectedRows("sumbilllistap");
        boolean needFresh = false;
        int total = selectedRows.getPrimaryKeyValues().length;
        switch (opKey) {
            case "submit": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": 
            case "delete": {
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)opKey, (String)"pm_requirapplybill", (Object[])selectedRows.getPrimaryKeyValues(), (OperateOption)OperateOption.create());
                if (operationResult.isSuccess()) {
                    this.getView().showSuccessNotification(this.buildSuccessTipInfo(opKey));
                    needFresh = true;
                } else {
                    List<String> errorMsg = this.getBillOperateErrorMsg(operationResult);
                    if (errorMsg.isEmpty()) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d1\u751f\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PsscReqSumResultTodoEditPlugin_5", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                    } else if (total == 1 && errorMsg.size() == 1) {
                        this.getView().showTipNotification(errorMsg.get(0));
                    } else {
                        int success = operationResult.getSuccessPkIds().size();
                        this.showErrorForm(total, success, operationResult.getBillNos(), this.getOpName(opKey), errorMsg);
                        boolean bl = needFresh = success > 0;
                    }
                }
                if (!needFresh) break;
                this.refreshList();
                break;
            }
            case "sumquery": {
                this.refreshList();
                break;
            }
        }
        return needFresh;
    }

    private ListSelectedRowCollection getSelectedRows(String listApKey) {
        BillList billList = (BillList)this.getControl(listApKey);
        if (billList != null) {
            return billList.getSelectedRows();
        }
        return new ListSelectedRowCollection();
    }

    private String buildSuccessTipInfo(String opKey) {
        String opName = this.getOpName(opKey);
        if (opName == null || StringUtils.isEmpty((CharSequence)opName)) {
            return ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"PsscReqSumResultTodoEditPlugin_6", (String)"scm-pssc-formplugin", (Object[])new Object[0]);
        }
        return opName.concat(ResManager.loadKDString((String)"\u6210\u529f\u3002", (String)"PsscReqSumResultTodoEditPlugin_7", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
    }

    private List<String> getBillOperateErrorMsg(OperationResult operateResult) {
        ArrayList<String> errorMsg = new ArrayList<String>(16);
        List allErrorOrValidateInfo = operateResult.getAllErrorOrValidateInfo();
        if (allErrorOrValidateInfo != null && !allErrorOrValidateInfo.isEmpty()) {
            for (IOperateInfo operateInfo : allErrorOrValidateInfo) {
                errorMsg.add(operateInfo.getMessage());
            }
        }
        if (errorMsg.isEmpty() && StringUtils.isNotEmpty((CharSequence)operateResult.getMessage())) {
            errorMsg.add(operateResult.getMessage());
        }
        return errorMsg;
    }

    private void showErrorForm(int total, int success, Map<Object, String> billNos, String opName, List<String> errorMsg) {
        String title = this.buildTitle(total, success, errorMsg.size(), billNos, opName);
        HashMap<String, Object> msgInfo = new HashMap<String, Object>(4);
        msgInfo.put("hasMore", false);
        msgInfo.put("title", title);
        msgInfo.put("errorMsg", errorMsg);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setShowTitle(false);
        showParameter.setAppId("im");
        showParameter.setFormId("bos_operationresult");
        showParameter.setCustomParams(msgInfo);
        this.getView().showForm(showParameter);
    }

    private String buildTitle(int total, int success, int errorInfoSize, Map<Object, String> billNos, String opName) {
        if (total == 1 && errorInfoSize > 1) {
            String billNo = billNos.values().stream().findFirst().get();
            return "\u201c" + billNo + "\u201d" + opName + ResManager.loadKDString((String)"\u5931\u8d25", (String)"PsscReqSumResultTodoEditPlugin_8", (String)"scm-pssc-formplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u5171{0}\u6761\u5355\u636e\uff0c{1}\u6210\u529f{2}\u6761\uff0c\u5931\u8d25{3}\u6761\u3002", (String)"PsscReqSumResultTodoEditPlugin_9", (String)"scm-pssc-formplugin", (Object[])new Object[]{total, opName, success, total - success});
    }

    private void refreshList() {
        FilterParameter filterParameter = new FilterParameter();
        filterParameter.setFilter(this.getViewQFilter());
        BillList billList = (BillList)this.getControl("sumbilllistap");
        billList.setFilterParameter(filterParameter);
        billList.refresh();
        billList.clearSelection();
    }
}

