/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.formplugin.edit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeBatchFillEntryArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.pssc.common.utils.PsscCommonUtils;
import kd.scm.pssc.common.utils.PsscDispatchServiceUtil;

public class PsscTaskApproveEdit
extends AbstractFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject entity = this.getModel().getDataEntity();
        Object biztype = entity.get("biztype");
        if (null == biztype) {
            return;
        }
        switch (biztype.toString()) {
            case "allocate": 
            case "transmit": {
                FieldEdit newsourceorg = (FieldEdit)this.getControl("newsourceorg");
                FieldEdit newhandler = (FieldEdit)this.getControl("newhandler");
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"newsourceorg"});
                newsourceorg.setMustInput(true);
                newhandler.setMustInput(true);
                break;
            }
            case "priority": {
                FieldEdit priority = (FieldEdit)this.getControl("priority");
                priority.setMustInput(true);
                this.setFieldInvisible();
                break;
            }
            case "target": {
                FieldEdit purmethod = (FieldEdit)this.getControl("purmethod");
                purmethod.setMustInput(true);
                this.setFieldInvisible();
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        this.setEntryStyle();
    }

    private void setEntryStyle() {
        int count = 0;
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        DataEntityPropertyCollection properties = entryentity.getDynamicObjectType().getProperties();
        for (int i = 0; i < entryentity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryentity.get(i);
            if (!"1".equals(dynamicObject.get("cancelstatus"))) continue;
            ++count;
            for (IDataEntityProperty property : properties) {
                if ("seq".equals(property.getName())) continue;
                CellStyle cs = new CellStyle();
                cs.setBackColor("#e5e5e5");
                cs.setFieldKey(property.getName());
                cs.setRow(i);
                cellStyles.add(cs);
            }
            CellStyle cs = new CellStyle();
            cs.setBackColor("#e5e5e5");
            cs.setFieldKey("model");
            cs.setRow(i);
            cellStyles.add(cs);
        }
        if (count > 0) {
            EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
            grid.setCellStyle(cellStyles);
        }
    }

    private void setFieldInvisible() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"newsourceorg"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"newhandler"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"newpurgroup"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid materialentry = (EntryGrid)this.getControl("entryentity");
        materialentry.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit newhandler = (BasedataEdit)this.getControl("newhandler");
        BasedataEdit newsourceorg = (BasedataEdit)this.getControl("newsourceorg");
        BasedataEdit srctype = (BasedataEdit)this.getControl("srctype");
        if (null != newhandler) {
            newhandler.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (null != newsourceorg) {
            newsourceorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (null != srctype) {
            srctype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        EntryGrid grid = (EntryGrid)e.getSource();
        String gridKey = grid.getKey();
        int index = e.getRowIndex();
        if ("entryentity".equals(gridKey)) {
            String srcbillid = (String)this.getModel().getValue("srcbillid", index);
            OpenFormUtil.openBillPage((IFormView)this.getView(), (String)"pssc_mytask", (Object)srcbillid, (BillOperationStatus)BillOperationStatus.VIEW, (ShowType)ShowType.MainNewTabPage, null, null);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (name) {
            case "newhandler": {
                ArrayList<Long> orgidList = new ArrayList<Long>();
                DynamicObject purorg = (DynamicObject)this.getModel().getValue("purorg", e.getRow());
                DynamicObject sourceorg = (DynamicObject)this.getModel().getValue("newsourceorg", e.getRow());
                if (purorg != null) {
                    orgidList.add((Long)purorg.getPkValue());
                }
                if (purorg != null) {
                    orgidList.add((Long)sourceorg.getPkValue());
                }
                QFilter q1 = new QFilter("operatorgrpid", "in", this.getOperatorGroupByOrg(orgidList));
                QFilter q2 = new QFilter("invalid", "=", (Object)Boolean.FALSE);
                showParameter.getListFilterParameter().getQFilters().add(q1.and(q2));
                break;
            }
            case "newsourceorg": {
                showParameter.setMultiSelect(false);
                DynamicObject row = this.getModel().getEntryRowEntity("entryentity", e.getRow());
                boolean flag = PsscDispatchServiceUtil.isMcmServiceOn();
                List qfilters = showParameter.getListFilterParameter().getQFilters();
                Object relationParam = showParameter.getCustomParams().get("orgRelation");
                if (flag) {
                    Long sourceOrgId;
                    Map<String, Object> relation;
                    ArrayList<Long> orgIds = new ArrayList<Long>(8);
                    if (relationParam != null && (relation = this.getRelationMap((HashMap)relationParam)) != null) {
                        orgIds.addAll((List)relation.get("orgId"));
                    }
                    if ((sourceOrgId = this.getPurOrgIdByCategory(row)) > 0L) {
                        orgIds.add(sourceOrgId);
                        if (orgIds.size() <= 1) break;
                        qfilters.add(new QFilter("id", "in", orgIds));
                        showParameter.getCustomParams().remove("orgRelation");
                        break;
                    }
                    if (orgIds.size() != 0) break;
                    showParameter.getCustomParams().remove("orgRelation");
                    break;
                }
                Map<String, Object> relationMap = this.getRelationMap((HashMap)relationParam);
                if (relationMap == null || relationMap.get("orgId") == null) {
                    showParameter.getCustomParams().remove("orgRelation");
                    return;
                }
                List orgIdList = (List)relationMap.get("orgId");
                if (!orgIdList.isEmpty()) break;
                showParameter.getCustomParams().remove("orgRelation");
                return;
            }
            case "srctype": {
                String sourceMethod = e.getSourceMethod();
                String sourceMethodVal = "setItemByNumber";
                DynamicObject sourceType = (DynamicObject)this.getModel().getValue("sourcetype", e.getRow());
                if (sourceType != null) {
                    QFilter sourceTypeFilter = new QFilter("sourcetype", "=", sourceType.getPkValue());
                    showParameter.getListFilterParameter().getQFilters().add(sourceTypeFilter);
                    break;
                }
                e.setCancel(true);
                if (!Objects.equals(sourceMethod, sourceMethodVal) && !"click".equals(sourceMethod)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5efa\u8bae\u5bfb\u6e90\u65b9\u5f0f\u3002", (String)"PsscReqPoolTargetPlugin_0", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private Map<String, Object> getRelationMap(HashMap<String, Object> relationParam) {
        HashMap<String, Object> orgRelation = relationParam;
        Long orgpkid = (Long)orgRelation.get("orgpkid");
        String fromtype = (String)orgRelation.get("fromtype");
        String totype = (String)orgRelation.get("totype");
        String directtype = (String)orgRelation.get("directtype");
        OrgRelationParam orgRelationParam = this.buildOrgRelationParam(orgpkid, fromtype, totype, directtype);
        return OrgUnitServiceHelper.getOrgRelation((OrgRelationParam)orgRelationParam);
    }

    private OrgRelationParam buildOrgRelationParam(Long orgId, String fromViewType, String toViewType, String getDirectOrgType) {
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgId(orgId.longValue());
        param.setFromViewType(fromViewType);
        param.setToViewType(toViewType);
        param.setDirectViewType(getDirectOrgType);
        return param;
    }

    private List<Long> getOperatorGroupByOrg(List<Long> orgIds) {
        QFilter q3;
        QFilter q2;
        ArrayList<Long> operatorGroupList = null;
        QFilter q1 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", orgIds, (boolean)true);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id,createorg,operatorgrouptype,enable", (QFilter[])new QFilter[]{q1, q2 = new QFilter("operatorgrouptype", "in", (Object)"CGZ"), q3 = new QFilter("enable", "in", (Object)"1")});
        if (map != null && map.size() > 0) {
            operatorGroupList = new ArrayList<Long>(map.size());
            for (DynamicObject dyn : map.values()) {
                if (dyn == null) continue;
                operatorGroupList.add((Long)dyn.getPkValue());
            }
        }
        return operatorGroupList;
    }

    private Long getPurOrgIdByCategory(DynamicObject row) {
        Long purOrgId = 0L;
        ArrayList<DynamicObject> rowList = new ArrayList<DynamicObject>(1);
        rowList.add(row);
        Map data = PsscCommonUtils.getPurOrgByCategory(rowList);
        if (null != data) {
            for (Map.Entry dataMapEntry : data.entrySet()) {
                Map valMap = (Map)dataMapEntry.getValue();
                if (null == valMap) continue;
                purOrgId = (Long)valMap.get("orgId");
            }
        }
        return purOrgId;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String operateKey = ((AbstractOperate)e.getSource()).getOperateKey();
        if ("submit".equals(operateKey) || "unsubmit".equals(operateKey) || "audit".equals(operateKey) || "save".equals(operateKey)) {
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            QFilter filter = new QFilter("id", "=", pkValue);
            DynamicObjectCollection pssc_task_approve = QueryServiceHelper.query((String)"pssc_task_approve", (String)"entryentity.cancelstatus cancelstatus, entryentity.seq seq", (QFilter[])filter.toArray());
            for (DynamicObject dynamicObject : pssc_task_approve) {
                String cancelstatus = dynamicObject.getString("cancelstatus");
                int seq = dynamicObject.getInt("seq");
                if (!"1".equals(cancelstatus)) continue;
                this.getModel().setValue("cancelstatus", (Object)"1", seq - 1);
                this.getModel().setValue("entryresult", (Object)"0", seq - 1);
            }
        }
        this.setEntryStyle();
    }

    public void beforeBatchFillEntry(BeforeBatchFillEntryArgs e) {
        super.beforeBatchFillEntry(e);
        IDataModel model = this.getModel();
        e.setPredicate(e.getPredicate().and(rowItem -> {
            IDataEntityProperty selProp = rowItem.getSelProp();
            int row = rowItem.getRow();
            switch (selProp.getName()) {
                case "newhandler": {
                    DynamicObject sourceorg = (DynamicObject)model.getValue("newsourceorg", row);
                    if (sourceorg == null) {
                        return false;
                    }
                    int currentRow = model.getEntryCurrentRowIndex("entryentity");
                    DynamicObject currentRowCompareValue = (DynamicObject)model.getValue("newsourceorg", currentRow);
                    if (currentRowCompareValue == null) {
                        return false;
                    }
                    return sourceorg.getLong("id") == currentRowCompareValue.getLong("id");
                }
                case "sourcetype": 
                case "srctype": {
                    String purmethod = (String)model.getValue("purmethod", row);
                    if ("sourc".equals(purmethod)) {
                        if ("srctype".equals(selProp.getName())) {
                            Long sourceId;
                            Object sourceType = model.getValue("sourcetype", row);
                            if (null == sourceType) {
                                return false;
                            }
                            Long origionSourceId = ((DynamicObject)sourceType).getLong("id");
                            return origionSourceId.compareTo(sourceId = Long.valueOf(((DynamicObject)rowItem.getValue()).getLong("sourcetype.id"))) == 0;
                        }
                        return true;
                    }
                    return false;
                }
            }
            return true;
        }));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String pro = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        IDataModel model = this.getModel();
        switch (pro) {
            case "newsourceorg": {
                model.beginInit();
                for (ChangeData data : changeSet) {
                    model.setValue("newhandler", null, data.getRowIndex());
                    model.setValue("newpurgroup", null, data.getRowIndex());
                }
                model.endInit();
                this.getView().updateView("entryentity");
                break;
            }
            case "sourcetype": {
                model.beginInit();
                for (ChangeData data : changeSet) {
                    model.setValue("srctype", null, data.getRowIndex());
                }
                model.endInit();
                this.getView().updateView("entryentity");
                break;
            }
            case "purmethod": {
                model.beginInit();
                for (ChangeData data : changeSet) {
                    model.setValue("sourcetype", null, data.getRowIndex());
                    model.setValue("srctype", null, data.getRowIndex());
                }
                model.endInit();
                this.getView().updateView("entryentity");
                break;
            }
        }
    }
}

