/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.formplugin.edit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.botp.Push;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.scm.pssc.business.helper.PsscMalHelper;
import kd.scm.pssc.business.pojo.ContactOrderWrapper;
import kd.scm.pssc.common.utils.PsscCommonUtils;
import kd.scm.pssc.common.utils.TaskBotpDispatchUtils;

public class PsscTaskPushEdit
extends AbstractFormPlugin {
    private static final String SRCDEMAND = "src_demand";
    private static final String PMPURORDER = "pm_purorderbill";
    private static final Log logger = LogFactory.getLog(PsscTaskPushEdit.class);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "contactorder": {
                HashSet<Long> taskIds = new HashSet<Long>(1);
                taskIds.add(this.getModel().getDataEntity(true).getLong("id"));
                ContactOrderWrapper wrapper = new ContactOrderWrapper();
                DataSet contactDataSet = wrapper.getContactDataSet(taskIds);
                int tasknumber = contactDataSet.count("tasknumber_repeat", true);
                if (tasknumber != 0) break;
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u6709\u6548\u5408\u540c\u3002", (String)"PsscTaskPushList_1", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                break;
            }
            case "malpurchase": {
                DynamicObject dataEntity = this.getModel().getDataEntity();
                long currUserId = RequestContext.get().getCurrUserId();
                StringBuilder stringBuilder = new StringBuilder();
                PsscCommonUtils.businessCheck((DynamicObject[])new DynamicObject[]{dataEntity}, new ArrayList(), (long)currUserId, (StringBuilder)stringBuilder);
                String srcbillid = dataEntity.getString("srcbillid");
                this.validateIfIsChanging(srcbillid, stringBuilder, dataEntity.getString("number"));
                if (stringBuilder.length() == 0) {
                    this.setCustomParam(args, dataEntity, srcbillid);
                    break;
                }
                args.setCancel(true);
                this.getView().showTipNotification(stringBuilder.toString());
            }
        }
    }

    private void setCustomParam(BeforeDoOperationEventArgs args, DynamicObject dataEntity, String srcbillid) {
        Object source = args.getSource();
        HashMap selectedIdMap = new HashMap(16);
        ArrayList<String> srcentryidList = new ArrayList<String>(16);
        srcentryidList.add(dataEntity.getString("srcentryid"));
        selectedIdMap.put(srcbillid, srcentryidList);
        if (source instanceof FormOperate) {
            ((FormOperate)source).getOption().setVariableValue("selectedRows", SerializationUtils.toJsonString(selectedIdMap));
        }
    }

    private void validateIfIsChanging(String srcbillid, StringBuilder stringBuilder, String taskNumber) {
        long applybillId;
        Map resultMap;
        Boolean isChanging;
        HashSet<Long> srcidSet = new HashSet<Long>(16);
        srcidSet.add(Long.parseLong(srcbillid));
        Object result = DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PurApplyService", (String)"getPurApplyChangeStatus", (Object[])new Object[]{srcidSet});
        if (result instanceof Map && (isChanging = (Boolean)(resultMap = (Map)result).get(applybillId = Long.parseLong(srcbillid))) != null && isChanging.booleanValue()) {
            stringBuilder.append(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u5173\u8054\u7684\u91c7\u8d2d\u7533\u8bf7\u6b63\u5728\u53d8\u66f4\u4e2d\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"PsscTaskPushEdit_6", (String)"scm-pssc-formplugin", (Object[])new Object[0]), taskNumber)).append(System.lineSeparator());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key;
        if (afterDoOperationEventArgs.getOperationResult() != null && !afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            PsscCommonUtils.dealOperationResult((OperationResult)afterDoOperationEventArgs.getOperationResult(), (boolean)true);
            return;
        }
        switch (key = ((AbstractOperate)afterDoOperationEventArgs.getSource()).getOperateKey()) {
            case "pushsrcdemand": {
                this.push(SRCDEMAND);
                break;
            }
            case "pushorder": {
                this.push(PMPURORDER);
                break;
            }
            case "pushsrcproject": {
                long id = this.getView().getModel().getDataEntity(true).getLong("id");
                Object[] ids = new Long[]{id};
                TaskBotpDispatchUtils.doPush((IFormView)this.getView(), (Object[])ids, (String)"pushsrcproject");
                break;
            }
            case "malpurchase": {
                this.showMalPurchase(afterDoOperationEventArgs);
                break;
            }
        }
    }

    private Map<String, Object> getRequestMap() {
        HashMap<String, Object> datamap = new HashMap<String, Object>(1);
        HashMap param = new HashMap(1);
        ArrayList<String> entryidandidList = new ArrayList<String>(1);
        entryidandidList.add(this.getModel().getDataEntity().getString("srcentryid") + "_" + this.getModel().getDataEntity().getString("srcbillid"));
        param.put("entryidandid", entryidandidList);
        datamap.put("data", param);
        return datamap;
    }

    private void showMalPurchase(AfterDoOperationEventArgs e) {
        FormShowParameter showParameter = PsscMalHelper.getMalPurchaseShowParameter((EventObject)e);
        if (showParameter != null) {
            this.getView().showForm(showParameter);
        }
    }

    private void push(String tarBill) {
        PushArgs args = this.getPushArgs(tarBill);
        ListSelectedRow selectedRow = new ListSelectedRow();
        selectedRow.setPrimaryKeyValue((Object)this.getModel().getDataEntity().getLong("srcbillid"));
        selectedRow.setEntryEntityKey("billentry");
        selectedRow.setEntryPrimaryKeyValue((Object)this.getModel().getDataEntity().getLong("srcentryid"));
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>();
        selectedRowList.add(selectedRow);
        args.setSelectedRows(selectedRowList);
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)args);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)tarBill);
        if (result.isSuccess() && result.getCachePageIds().size() + result.getTargetBillIds().size() != 0) {
            if (PMPURORDER.equals(tarBill)) {
                List targetObjects = result.loadTargetDataObjects(BusinessDataServiceHelper::loadRefence, mainType);
                PsscCommonUtils.saveRelation((List)targetObjects);
            }
            Push.showTargetBill((IFormView)this.getView(), (PushArgs)args, (ConvertOperationResult)result, (boolean)false);
        } else {
            Push.showReport((IFormView)this.getView(), (AbstractConvertServiceArgs)args, (ConvertOperationResult)result);
        }
    }

    private PushArgs getPushArgs(String tarBill) {
        PushArgs args = new PushArgs();
        args.setSourceEntityNumber("pm_purapplybill");
        args.setTargetEntityNumber(tarBill);
        args.setHasRight(false);
        args.addCustomParam("botp_requiredatamutex", String.valueOf(true));
        args.setAutoSave(false);
        args.setBuildConvReport(true);
        if (SRCDEMAND.equals(tarBill)) {
            args.setRuleId("1873292497963603968");
            args.getCustomParams().put("formId", "pssc_mytask");
        }
        HashMap<String, Long> propertyInfos = new HashMap<String, Long>();
        DynamicObject entity = this.getModel().getDataEntity();
        propertyInfos.put(entity.getString("srcentryid"), entity.getLong("id"));
        args.getCustomParams().put("data", SerializationUtils.toJsonString(propertyInfos));
        return args;
    }
}

