/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.botp;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.FieldMapItem;
import kd.bos.entity.botp.FieldSumType;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildGroupModeEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.pssc.business.helper.PurApplyBillHelper;
import org.apache.commons.lang3.StringUtils;

public class Requir2PurApplyConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log log = LogFactory.getLog(Requir2PurApplyConvertPlugin.class);
    private static final String BASEQTY = "baseqty";
    private static final String AUXQTY = "auxqty";

    public void beforeBuildGroupMode(BeforeBuildGroupModeEventArgs e) {
        String groupby;
        boolean containsVariable = this.getOption().containsVariable("summaryschema");
        if (containsVariable && StringUtils.isNotBlank((CharSequence)(groupby = this.getOption().getVariableValue("summaryschema")))) {
            e.setHeadGroupKey("@all");
            e.setEntryGroupKey(groupby);
            e.setSubEntryGroupKey("");
        }
    }

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        List fieldMaps = this.getRule().getFieldMapPolicy().getFieldMaps();
        for (FieldMapItem fieldMapItem : fieldMaps) {
            String targetFieldKey = fieldMapItem.getTargetFieldKey();
            if (!"srcbillentryid".equals(targetFieldKey)) continue;
            FieldSumType fieldSumType = fieldMapItem.getFieldSumType();
            if (FieldSumType.Max.equals((Object)fieldSumType)) break;
            e.setCustFilterExpression("false");
            e.setCustFilterDesc(ResManager.loadKDString((String)"\u9700\u6c42\u7533\u8bf7\u6c47\u603b\u7528\u5230\u7684\u3010\u9700\u6c42\u7533\u8bf7\u5355_\u91c7\u8d2d\u7533\u8bf7\u5355\u3011\u7684\u8f6c\u6362\u89c4\u5219\uff0c\u5b57\u6bb5\u6620\u5c04\u4e2d\u76ee\u6807\u5355\u5b57\u6bb5\u4e3a\u3010\u7269\u6599\u660e\u7ec6.\u6765\u6e90\u5355\u636e\u884cID\u3011\u7684\u5408\u5e76\u65b9\u5f0f\u5e94\u6539\u4e3a\u3010\u6700\u5927\u3011", (String)"Requir2PurApplyConvertPlugin_0", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
            break;
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        log.info("\u7cfb\u7edf\u65f6\u95f4:" + System.currentTimeMillis());
        log.info("\u4e0b\u63a8\u751f\u6210\u540e\uff0c\u83b7\u53d6\u76ee\u6807\u5355\u636e\uff0c\u8fdb\u884c\u91c7\u8d2d\u7533\u8bf7\u5355\u636e\u76f8\u7ba1\u903b\u8f91\u8bbe\u7f6e\u5f00\u59cb\uff01\uff01\uff01");
        boolean schemeExist = this.getOption().containsVariable("summaryschema");
        Map paramData = null;
        if (schemeExist) {
            String mapStr = this.getOption().getVariableValue("entryresult");
            paramData = (Map)SerializationUtils.fromJsonString((String)mapStr, Map.class);
        }
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(this.getTgtMainType().toString());
        List<DynamicObject> bills = new ArrayList(10);
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject bill = entity.getDataEntity();
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entrys) {
                if (paramData == null || paramData.isEmpty()) continue;
                this.initBaseAmnt(entry, paramData);
            }
            bills.add(bill);
        }
        bills = PurApplyBillHelper.batchSetPurApplyDefValue(bills);
        log.info("\u7cfb\u7edf\u65f6\u95f4:" + System.currentTimeMillis());
        log.info("\u4e0b\u63a8\u751f\u6210\u540e\uff0c\u83b7\u53d6\u76ee\u6807\u5355\u636e\uff0c\u8fdb\u884c\u91c7\u8d2d\u7533\u8bf7\u5355\u636e\u76f8\u7ba1\u903b\u8f91\u8bbe\u7f6e\u7ed3\u675f\uff01\uff01\uff01");
    }

    private void initBaseAmnt(DynamicObject row, Map<String, BigDecimal> paramMap) {
        String paramMapKeyStr = String.valueOf(row.get("srcbillentryid"));
        Map mapQty = (Map)((Object)paramMap.get(paramMapKeyStr));
        if (mapQty != null && !mapQty.isEmpty()) {
            row.set(BASEQTY, mapQty.get(BASEQTY));
            row.set(AUXQTY, mapQty.get(AUXQTY));
        }
    }
}

