/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.reqapply;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeBindDataEvent;
import kd.bos.form.events.BeforeBindDataListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.scm.pssc.business.helper.OrgHelper;
import kd.scm.pssc.business.helper.ReqApplyBillHelper;
import kd.scm.pssc.business.helper.ReqSumSchemeHelper;
import kd.scm.pssc.common.constant.PmReqforsumofneedsConst;
import kd.scm.pssc.common.utils.DateUtil;
import kd.scm.pssc.common.utils.PmFormUtil;

public class ReqApplyQueryPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
BeforeBindDataListener,
HyperLinkClickListener {
    private static final String BILLLISTAP = "billlistap";

    public void registerListener(EventObject e) {
        BillList billList;
        PmFormUtil.addF7Listener((BeforeF7SelectListener)this, (String[])PmReqforsumofneedsConst.AllF7FIELDS);
        Toolbar entryToolbar = (Toolbar)this.getView().getControl("toolbarap");
        if (entryToolbar != null) {
            entryToolbar.addItemClickListener((ItemClickListener)this);
        }
        if ((billList = (BillList)this.getControl(BILLLISTAP)) != null) {
            billList.addBeforeBindDataListener((BeforeBindDataListener)this);
            billList.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void initialize() {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        if (billList != null) {
            billList.getListUserOption().setMergeRow(false);
        }
    }

    public void afterCreateNewData(EventObject e) {
        long reqBillType;
        IDataModel model = this.getModel();
        LocalDateTime todayStart = LocalDateTime.of(LocalDate.now().minusMonths(1L), LocalTime.MIN);
        LocalDateTime todayEnd = LocalDateTime.of(LocalDate.now(), LocalTime.MIN);
        model.setValue("applydate_startdate", (Object)todayStart);
        model.setValue("applydate_enddate", (Object)todayEnd);
        Long defaultOrg = RequestContext.get().getOrgId();
        String formId = this.getView().getEntityId();
        List hasPermissionOrg = OrgHelper.getHasPermissionOrg((String)formId, (String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (IFormView)this.getView());
        if (hasPermissionOrg != null && hasPermissionOrg.contains(defaultOrg)) {
            model.setValue("org", (Object)defaultOrg);
        }
        this.setSumPath(defaultOrg);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String billTypeForm = (String)customParams.get("billTypeForm");
        if (billTypeForm != null && (reqBillType = ReqApplyBillHelper.getReqBillType((String)billTypeForm)) != 0L) {
            model.setValue("billtype", (Object)reqBillType);
        }
        QFilter qFilter = new QFilter("id", "=", (Object)0L);
        FilterParameter filterParameter = new FilterParameter();
        filterParameter.setFilter(qFilter);
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.setFilterParameter(filterParameter);
        billList.refresh();
    }

    private void setSumPath(Long defaultOrg) {
        List reqSumOrgList = ReqSumSchemeHelper.getReqSumPathList((Long)defaultOrg);
        IDataModel model = this.getModel();
        if (reqSumOrgList.size() == 1) {
            Long sumPathId = (Long)reqSumOrgList.get(0);
            model.setValue("reqpathsum", (Object)sumPathId);
            DynamicObject sumPath = BusinessDataServiceHelper.loadSingleFromCache((Object)sumPathId, (String)"pm_reqpathsettings");
            model.setValue("reqkind", (Object)sumPath.getString("reqkind"));
            model.setValue("sumdept", (Object)sumPath.getDynamicObject("sumdept"));
            model.setValue("requireorg", null);
            model.setValue("querymaterial", null);
        } else {
            model.setValue("reqpathsum", null);
            model.setValue("reqkind", null);
            model.setValue("requireorg", null);
            model.setValue("querymaterial", null);
            model.setValue("sumdept", null);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String stopChange = this.getPageCache().get("stopChange");
        if ("true".equals(stopChange)) {
            return;
        }
        IDataModel model = this.getModel();
        String propKey = e.getProperty().getName();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propKey) {
            case "org": {
                this.getPageCache().put("stopChange", "true");
                if (newValue == null) {
                    model.setValue("reqpathsum", null);
                    model.setValue("requireorg", null);
                    model.setValue("reqkind", null);
                    model.setValue("sumdept", null);
                } else if (oldValue == null || !oldValue.equals(newValue)) {
                    DynamicObject defaultOrg = (DynamicObject)newValue;
                    this.setSumPath((Long)defaultOrg.getPkValue());
                }
                this.getPageCache().remove("stopChange");
                break;
            }
            case "reqpathsum": {
                if (newValue != null) {
                    DynamicObject reqpathsumObj = (DynamicObject)newValue;
                    model.setValue("sumdept", (Object)reqpathsumObj.getDynamicObject("sumdept"));
                    model.setValue("reqkind", (Object)reqpathsumObj.getString("reqkind"));
                    model.setValue("querymaterial", null);
                    model.setValue("querydept", null);
                    model.setValue("requireorg", null);
                    break;
                }
                model.setValue("reqkind", null);
                model.setValue("requireorg", null);
                model.setValue("sumdept", null);
                model.setValue("querydept", null);
                model.setValue("querymaterial", null);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey = event.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        DynamicObject reqPathSum = (DynamicObject)this.getModel().getValue("reqpathsum");
        switch (fieldKey) {
            case "org": {
                String formId = this.getView().getEntityId();
                QFilter hasPermissionOrgFilter = OrgHelper.getHasPermissionOrgFilter((String)formId, (String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (IFormView)this.getView());
                if (hasPermissionOrgFilter == null) break;
                showParameter.getListFilterParameter().setFilter(hasPermissionOrgFilter);
                break;
            }
            case "reqpathsum": {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6c47\u603b\u7ec4\u7ec7\u3002", (String)"ReqApplyQueryPlugin_0", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                    event.setCancel(true);
                    return;
                }
                List reqSumOrgList = ReqSumSchemeHelper.getReqSumPathList((Long)((Long)org.getPkValue()));
                QFilter sumOrgFilter = new QFilter("id", "in", (Object)reqSumOrgList);
                showParameter.getListFilterParameter().setFilter(sumOrgFilter);
                break;
            }
            case "requireorg": {
                if (reqPathSum == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u6c42\u6c47\u603b\u8def\u5f84\u3002", (String)"ReqApplyQueryPlugin_1", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                    event.setCancel(true);
                    return;
                }
                DynamicObject sumOrg = reqPathSum.getDynamicObject("org");
                Set reqSumOrgSet = ReqSumSchemeHelper.getReqSumOrgSet((Long)((Long)sumOrg.getPkValue()), (Long)((Long)reqPathSum.getPkValue()));
                QFilter reqSumOrgSetFilter = new QFilter("id", "in", (Object)reqSumOrgSet);
                showParameter.getListFilterParameter().setFilter(reqSumOrgSetFilter);
                break;
            }
            case "querydept": {
                ReqApplyQueryPlugin.setF7FilterIfMethodByDept(reqPathSum, showParameter);
                break;
            }
            case "querymaterial": {
                Set<Long> usefulMaterial;
                if (reqPathSum == null || (usefulMaterial = this.getUsefulMaterial(reqPathSum)).size() <= 0) break;
                QFilter filter = new QFilter("id", "in", usefulMaterial);
                showParameter.getListFilterParameter().setFilter(filter);
                break;
            }
            case "billtype": {
                String reqsumapplyap = this.getView().getPageCache().get("reqsumapplyap");
                if ("1".equals(reqsumapplyap)) break;
                ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
                List qFilters = listFilterParameter.getQFilters();
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                Object billTypeForm = customParams.get("billTypeForm");
                ReqApplyBillHelper.addBillTypeFilter((String)String.valueOf(billTypeForm), (List)qFilters);
                break;
            }
        }
    }

    private static void setF7FilterIfMethodByDept(DynamicObject reqPathSum, ListShowParameter showParameter) {
        String summaryMethod;
        if (reqPathSum != null && "B".equals(summaryMethod = reqPathSum.getString("summarymethod"))) {
            Long sumDeptId = reqPathSum.getLong("sumdept.id");
            Set reqSumDeptSet = ReqSumSchemeHelper.getReqSumDeptSet((Long)((Long)reqPathSum.getPkValue()), (Long)sumDeptId);
            QFilter reqSumDeptFilter = new QFilter("id", "in", (Object)reqSumDeptSet);
            showParameter.getListFilterParameter().setFilter(reqSumDeptFilter);
        }
    }

    private Set<Long> getUsefulMaterial(DynamicObject reqPath) {
        HashSet<Long> materialSet = new HashSet<Long>(16);
        HashSet<String> materialGroupSet = new HashSet<String>(16);
        DynamicObjectCollection rowList = reqPath.getDynamicObjectCollection("entry");
        for (Object row : rowList) {
            DynamicObject materialGroup;
            String kind = row.getString("kind");
            if ("A".equals(kind)) {
                DynamicObject material = row.getDynamicObject("material");
                if (material == null) continue;
                materialSet.add((Long)material.getPkValue());
                continue;
            }
            if (!"B".equals(kind) || (materialGroup = row.getDynamicObject("materialgroup")) == null) continue;
            materialGroupSet.add(materialGroup.getString("longnumber"));
        }
        if (materialGroupSet.size() > 0) {
            QFilter materialGroupFilter = null;
            for (String longNumber : materialGroupSet) {
                if (materialGroupFilter == null) {
                    materialGroupFilter = new QFilter("longnumber", "like", (Object)longNumber.concat("%"));
                    continue;
                }
                materialGroupFilter.or(new QFilter("longnumber", "like", (Object)longNumber.concat("%")));
            }
            if (materialGroupFilter != null) {
                Map materialGroup = BusinessDataServiceHelper.loadFromCache((String)"bd_materialgroup", (String)"id", (QFilter[])materialGroupFilter.toArray());
                Set materialGroupIdSet = materialGroup.values().stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
                QFilter filter = new QFilter("group", "in", materialGroupIdSet);
                Map materialGroupDetail = BusinessDataServiceHelper.loadFromCache((String)"bd_materialgroupdetail", (String)"material", (QFilter[])filter.toArray());
                Collection values = materialGroupDetail.values();
                for (DynamicObject row : values) {
                    DynamicObject material = row.getDynamicObject("material");
                    if (material == null) continue;
                    Long materialId = material.getLong("id");
                    materialSet.add(materialId);
                }
            }
        }
        return materialSet;
    }

    private void refreshList() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject sumDept = (DynamicObject)this.getModel().getValue("sumdept");
        if (org != null) {
            String orgId = String.valueOf(org.getPkValue());
            this.getView().getPageCache().put("org", orgId);
        }
        if (sumDept != null) {
            String sumDeptId = String.valueOf(sumDept.getPkValue());
            this.getView().getPageCache().put("sumdept", sumDeptId);
        }
        FilterParameter filterParameter = new FilterParameter();
        filterParameter.setFilter(this.getViewQFilter());
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.setFilterParameter(filterParameter);
        billList.refresh();
        billList.clearSelection();
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        String operateKey = event.getOperateKey();
        IFormView view = this.getView();
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        switch (operateKey) {
            case "query": {
                Boolean enable;
                DynamicObject reqPath = (DynamicObject)this.getModel().getValue("reqpathsum");
                if (reqPath != null && (enable = Boolean.valueOf(reqPath.getBoolean("enable"))) == Boolean.FALSE) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9700\u6c42\u6c47\u603b\u8def\u5f84\u4e0d\u662f\u53ef\u7528\u72b6\u6001\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ReqApplyQueryPlugin_2", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.refreshList();
                break;
            }
            case "sum": {
                ListSelectedRowCollection selectedRow = billList.getSelectedRows();
                if (selectedRow.size() <= 0) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u8fdb\u884c\u6c47\u603b\u7684\u6570\u636e\u884c\u3002", (String)"ReqApplyQueryPlugin_3", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                    return;
                }
                Long defaultReqSumScheme = ReqSumSchemeHelper.getDefaultReqSumScheme();
                boolean existBotpRule = ReqSumSchemeHelper.judgeReqToReqBotpRule();
                if (!existBotpRule && defaultReqSumScheme == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u9700\u6c42\u6c47\u603b\u65b9\u6848\u3001\u8f6c\u6362\u89c4\u5219\u3002", (String)"ReqApplyQueryPlugin_4", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!existBotpRule) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u9700\u6c42\u7533\u8bf7\u5355\u751f\u6210\u9700\u6c42\u7533\u8bf7\u5355\u7684\u8f6c\u6362\u89c4\u5219\u3002", (String)"ReqApplyQueryPlugin_5", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (defaultReqSumScheme == null || defaultReqSumScheme == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u9700\u6c42\u6c47\u603b\u65b9\u6848\u3002", (String)"ReqApplyQueryPlugin_6", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashSet<Long> primaryIdList = new HashSet<Long>(selectedRow.size());
                ArrayList<Long> entryPrimaryIdList = new ArrayList<Long>(selectedRow.size());
                HashMap<Long, Long> pushParameter = new HashMap<Long, Long>(16);
                for (ListSelectedRow listSelectedRow : selectedRow) {
                    Long primaryId = (Long)listSelectedRow.getPrimaryKeyValue();
                    primaryIdList.add(primaryId);
                    Long entryPrimaryId = (Long)listSelectedRow.getEntryPrimaryKeyValue();
                    if (entryPrimaryId == null) continue;
                    entryPrimaryIdList.add(entryPrimaryId);
                    pushParameter.put(entryPrimaryId, primaryId);
                }
                if (entryPrimaryIdList.size() <= 0) {
                    this.getPurReqEntryIdId(primaryIdList, pushParameter);
                    Set entryIdSet = pushParameter.keySet();
                    entryPrimaryIdList.addAll(entryIdSet);
                }
                QFilter filter = new QFilter("billentry.id", "in", entryPrimaryIdList);
                HashSet<Long> materialIdSet = new HashSet<Long>(16);
                HashMap<Long, String> materialIdName = new HashMap<Long, String>(16);
                try (DataSet rowList = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_requirapplybill", (String)"id,billentry.materialmasterid.id,billentry.materialmasterid.name", (QFilter[])filter.toArray(), null);){
                    for (Row row : rowList) {
                        Long id = row.getLong("billentry.materialmasterid.id");
                        if (id == null) continue;
                        String name = row.getString("billentry.materialmasterid.name");
                        materialIdSet.add(id);
                        materialIdName.put(id, name);
                    }
                }
                QFilter masterIdqFilter = new QFilter("id", "in", materialIdSet);
                DynamicObject sumOrg = (DynamicObject)this.getModel().getValue("org");
                Long defaultOrg = (Long)sumOrg.getPkValue();
                QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)defaultOrg);
                QFilter endqFilter = masterIdqFilter.and(baseDataFilter);
                DataSet rowList = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_material", (String)"id", (QFilter[])endqFilter.toArray(), null);
                Object object = null;
                try {
                    for (Row row : rowList) {
                        Long id = row.getLong("id");
                        materialIdSet.remove(id);
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (rowList != null) {
                        if (object != null) {
                            try {
                                rowList.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            rowList.close();
                        }
                    }
                }
                if (materialIdSet.size() > 0) {
                    StringJoiner tipMsg = new StringJoiner(",");
                    for (Long id : materialIdSet) {
                        String tip = (String)materialIdName.get(id);
                        tipMsg.add(tip);
                    }
                    String formatTipMsg = String.format(ResManager.loadKDString((String)"\u6c47\u603b\u7ec4\u7ec7\u6ca1\u6709\u7269\u6599\u3010%s\u3011\u7684\u6743\u9650\uff0c\u65e0\u6cd5\u6c47\u603b\u3002", (String)"ReqApplyQueryPlugin_7", (String)"scm-pssc-formplugin", (Object[])new Object[0]), tipMsg);
                    this.getView().showTipNotification(formatTipMsg);
                    break;
                }
                this.showResultView(primaryIdList, entryPrimaryIdList, pushParameter);
                break;
            }
        }
    }

    private void getPurReqEntryIdId(Set<Long> reqIdList, Map<Long, Long> purReqEntryIdId) {
        QFilter filter = new QFilter("id", "in", reqIdList);
        filter.and(new QFilter("billentry.rowclosestatus", "=", (Object)"A"));
        filter.and(new QFilter("billentry.rowterminatestatus", "=", (Object)"A"));
        filter.and(new QFilter("billentry.baseqty", ">", (Object)"billentry.unionsumbaseqty", true));
        filter.and(new QFilter("billentry.applybaseqty", "=", (Object)BigDecimal.ZERO));
        filter.and(new QFilter("billentry.balancestatus", "=", (Object)"C"));
        try (DataSet bizList = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_requirapplybill", (String)"id,billentry.id", (QFilter[])filter.toArray(), null);){
            for (Row row : bizList) {
                Long entryId = row.getLong("billentry.id");
                Long id = row.getLong("id");
                if (entryId == null || id == null) continue;
                purReqEntryIdId.put(entryId, id);
            }
        }
    }

    private void showResultView(Set<Long> primaryIdList, List<Long> entryPrimaryIdList, Map<Long, Long> pushParameter) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pm_reqsumresult");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("selectline", primaryIdList);
        showParameter.setCustomParam("selectentryline", entryPrimaryIdList);
        showParameter.setCustomParam("selectentryidid", pushParameter);
        DynamicObject reqPath = (DynamicObject)this.getModel().getValue("reqpathsum");
        if (reqPath != null) {
            DynamicObject sumScheme = reqPath.getDynamicObject("sumscheme");
            if (sumScheme != null && (sumScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)sumScheme.getPkValue(), (String)"pm_reqsumscheme")).getBoolean("enable")) {
                Long sumSchemeId = (Long)sumScheme.getPkValue();
                showParameter.setCustomParam("sumSchemeId", (Object)sumSchemeId);
            }
            if ("B".equals(reqPath.getString("summarymethod"))) {
                String sumDeptId = this.getView().getPageCache().get("sumdept");
                showParameter.setCustomParam("sumdept", (Object)sumDeptId);
            }
        }
        String orgId = this.getView().getPageCache().get("org");
        showParameter.setCustomParam("org", (Object)orgId);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        showParameter.getCustomParams().put("billTypeForm", customParams.get("billTypeForm"));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "creation"));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals("creation")) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String reqsumapplyap = this.getView().getPageCache().get("reqsumapplyap");
            this.refreshList();
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData instanceof List) {
                if ("1".equals(reqsumapplyap)) {
                    OperateOption operateOption = OperateOption.create();
                    this.getView().invokeOperation("next", operateOption);
                } else {
                    this.showReqListView((List)returnData);
                }
            }
        }
    }

    private void showReqListView(List<Object> reqIdList) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("pm_sumreqapplybill");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String billTypeForm = (String)customParams.get("billTypeForm");
        showParameter.getCustomParams().put("billTypeForm", billTypeForm);
        if (billTypeForm != null) {
            switch (billTypeForm) {
                case "pssc_requirapplymonthbill": {
                    showParameter.setCaption(ResManager.loadKDString((String)"\u6c47\u603b\u6708\u5ea6\u9700\u6c42\u8ba1\u5212", (String)"ReqApplyToReqApplyPlugin_16", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "pssc_requirapplyyearbill": {
                    showParameter.setCaption(ResManager.loadKDString((String)"\u6c47\u603b\u5e74\u5ea6\u9700\u6c42\u8ba1\u5212", (String)"ReqApplyToReqApplyPlugin_17", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "pssc_requirapplyotherbill": {
                    showParameter.setCaption(ResManager.loadKDString((String)"\u6c47\u603b\u5176\u4ed6\u9700\u6c42\u8ba1\u5212", (String)"ReqApplyToReqApplyPlugin_18", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                    break;
                }
            }
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ListFilterParameter filterParameter = new ListFilterParameter();
        filterParameter.setFilter(new QFilter("id", "in", reqIdList));
        showParameter.setListFilterParameter(filterParameter);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    protected QFilter getViewQFilter() {
        String classType;
        String reqKind;
        Set<Long> usefulMaterial;
        List<Object> querymaterialIds;
        DynamicObject billtype;
        Date enddate;
        IDataModel model = this.getModel();
        QFilter qFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        List<Object> reqOrgList = this.getMulBaseDataIdList(this.getModel(), "requireorg");
        DynamicObject reqPath = (DynamicObject)model.getValue("reqpathsum");
        if (reqOrgList.size() > 0) {
            qFilter.and(new QFilter("org", "in", reqOrgList));
        } else {
            DynamicObject sumOrg = (DynamicObject)model.getValue("org");
            if (reqPath != null) {
                Set reqSumOrgSet = ReqSumSchemeHelper.getReqSumOrgSet((Long)((Long)sumOrg.getPkValue()), (Long)((Long)reqPath.getPkValue()));
                qFilter.and(new QFilter("org", "in", (Object)reqSumOrgSet));
            } else if (sumOrg != null) {
                qFilter.and(new QFilter("org", "=", sumOrg.getPkValue()));
            }
        }
        List<Object> deptList = this.getMulBaseDataIdList(this.getModel(), "querydept");
        if (!deptList.isEmpty()) {
            qFilter.and(new QFilter("dept", "in", deptList));
        } else if (reqPath != null && "B".equals(reqPath.getString("summarymethod"))) {
            Set sumDeptSet = ReqSumSchemeHelper.getReqSumDeptSet((Long)((Long)reqPath.getPkValue()), (Long)reqPath.getLong("sumdept.id"));
            qFilter.and(new QFilter("dept", "in", (Object)sumDeptSet));
        }
        Date startdate = (Date)model.getValue("applydate_startdate");
        if (startdate != null) {
            qFilter.and(new QFilter("biztime", ">=", (Object)startdate));
        }
        if ((enddate = (Date)model.getValue("applydate_enddate")) != null) {
            Date endOfDay = DateUtil.getEndOfDay((Date)enddate);
            qFilter.and(new QFilter("biztime", "<=", (Object)endOfDay));
        }
        if ((billtype = (DynamicObject)model.getValue("billtype")) != null) {
            qFilter.and(new QFilter("billtype", "=", billtype.getPkValue()));
        } else {
            qFilter = new QFilter("billtype", "in", null);
        }
        DynamicObject bizuser = (DynamicObject)model.getValue("querybizuser");
        if (bizuser != null) {
            qFilter.and(new QFilter("bizuser", "in", bizuser.getPkValue()));
        }
        if ((querymaterialIds = this.getMulBaseDataIdList(this.getModel(), "querymaterial")).size() > 0) {
            QFilter qFilter1 = new QFilter("billentry.materialmasterid", "in", querymaterialIds);
            qFilter1.or("billentry.materialmasterid", "=", (Object)0L);
            qFilter.and(qFilter1);
        } else if (reqPath != null && (usefulMaterial = this.getUsefulMaterial(reqPath)).size() > 0) {
            QFilter qFilter1 = new QFilter("billentry.materialmasterid", "in", usefulMaterial);
            qFilter1.or("billentry.materialmasterid", "=", (Object)0L);
            qFilter.and(qFilter1);
        }
        List<Object> projectItemIds = this.getMulBaseDataIdList(this.getModel(), "projectitem");
        if (projectItemIds.size() > 0) {
            qFilter.and(new QFilter("billentry.project", "in", projectItemIds));
        }
        if (StringUtils.isNotBlank((CharSequence)(reqKind = (String)model.getValue("reqkind")))) {
            if ("C".equals(reqKind)) {
                ArrayList<String> reqKindList = new ArrayList<String>(16);
                reqKindList.add("A");
                reqKindList.add("B");
                qFilter.and(new QFilter("billentry.reqkind", "in", reqKindList));
            } else {
                qFilter.and(new QFilter("billentry.reqkind", "=", (Object)reqKind));
            }
        }
        if (StringUtils.isBlank((CharSequence)(classType = (String)model.getValue("classtype")))) {
            ArrayList<String> classTypeList = new ArrayList<String>(16);
            classTypeList.add("1");
            classTypeList.add("2");
            classTypeList.add(" ");
            qFilter.and(new QFilter("billentry.classtype", "in", classTypeList));
        } else {
            qFilter.and(new QFilter("billentry.classtype", "=", (Object)classType));
        }
        qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        qFilter.and(new QFilter("closestatus", "=", (Object)"A"));
        qFilter.and(new QFilter("billentry.rowclosestatus", "=", (Object)"A"));
        qFilter.and(new QFilter("billentry.rowterminatestatus", "=", (Object)"A"));
        qFilter.and(new QFilter("billentry.baseqty", ">", (Object)"billentry.unionsumbaseqty", true));
        qFilter.and(new QFilter("billentry.applybaseqty", "=", (Object)BigDecimal.ZERO));
        qFilter.and(new QFilter("billentry.balancestatus", "=", (Object)"C"));
        qFilter.and(new QFilter("billentry.auditoption", "!=", (Object)"2"));
        return qFilter;
    }

    public void beforeBindData(BeforeBindDataEvent e) {
        FilterParameter filterParameter = new FilterParameter();
        filterParameter.setFilter(this.getViewQFilter());
        BillList parameter = (BillList)e.getSource();
        parameter.setFilterParameter(filterParameter);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        Object focusRowPkId = ((BillList)hyperLinkClickEvent.getSource()).getFocusRowPkId();
        if (focusRowPkId != null) {
            BillShowParameter fsp = new BillShowParameter();
            fsp.setFormId("pm_requirapplybill");
            fsp.setStatus(OperationStatus.EDIT);
            fsp.setPkId(focusRowPkId);
            fsp.getCustomParams().put("billTypeForm", this.getView().getFormShowParameter().getCustomParam("billTypeForm"));
            fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)fsp);
        }
    }

    private List<Object> getMulBaseDataIdList(IDataModel model, String fieldKey) {
        DynamicObjectCollection baseDataCol = (DynamicObjectCollection)model.getValue(fieldKey);
        ArrayList<Object> idList = new ArrayList<Object>(16);
        for (DynamicObject row : baseDataCol) {
            DynamicObject baseData = row.getDynamicObject("fbasedataid");
            if (baseData == null) continue;
            idList.add(baseData.getPkValue());
        }
        return idList;
    }
}

