/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.reqapply;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.mpscmm.msbd.business.helper.BizTypeHelper;
import kd.mpscmm.msbd.common.enums.StatusEnum;
import kd.scm.pssc.business.helper.BillImportHelper;
import kd.scm.pssc.business.helper.BillQtyAndUnitHelper;
import kd.scm.pssc.business.helper.OrgHelper;

public class RequirApplyBillImportPlugin
extends AbstractFormPlugin {
    private final BigDecimal ZERO = BigDecimal.ZERO;
    private Map<String, Object> tempCache = new HashMap<String, Object>();

    public void initImportData(InitImportDataEventArgs e) {
        List sourceDataList = e.getSourceDataList();
        if (sourceDataList.isEmpty()) {
            return;
        }
        IPageCache pageCache = this.getPageCache();
        BillImportHelper.billCreTypeFlag((IPageCache)pageCache, (List)sourceDataList);
        IDataModel model = (IDataModel)e.getSource();
        List hasPermissionOrg = (List)this.tempCache.get("hasPermissionOrg");
        if (hasPermissionOrg == null) {
            hasPermissionOrg = OrgHelper.getHasPermissionOrg((String)model.getDataEntityType().getName(), (String)"15", (IFormView)this.getView());
            this.tempCache.put("hasPermissionOrg", hasPermissionOrg);
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        String billcretype = this.getPageCache().get("billcretype");
        if (BillImportHelper.isSkip((String)billcretype)) {
            return;
        }
        DynamicObject org = this.getBaseDataFromCache(e.getSourceData(), "org", "bos_org", null);
        if (org == null) {
            return;
        }
        List hasPermissionOrg = (List)this.tempCache.get("hasPermissionOrg");
        if (hasPermissionOrg == null || !hasPermissionOrg.contains(org.getPkValue())) {
            Map propMap = BillImportHelper.format4ImportAndApi(e.getSourceData().get("org"));
            e.setCancel(true);
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u9700\u6c42\u7ec4\u7ec7\u3010%1$s\u3011\u4e0d\u5728\u7528\u6237\u6743\u9650\u8303\u56f4\u5185", (String)"RequirApplyBillImportPlugin_0", (String)"scm-pssc-formplugin", (Object[])new Object[0]), propMap.get(propMap.get("importprop"))));
            e.setFireAfterImportData(false);
            return;
        }
        DynamicObject billtype = this.getBaseDataFromCache(e.getSourceData(), "billtype", "bos_billtype", "billformid");
        if (billtype == null) {
            return;
        }
        String formId = this.getView().getFormShowParameter().getFormId();
        if (!billtype.getDynamicObject("billformid").getPkValue().equals(formId)) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4e0d\u7b26\u65e0\u6cd5\u5bfc\u5165", (String)"RequirApplyBillImportPlugin_1", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
            e.setFireAfterImportData(false);
        }
        Map billtypeMap = BillImportHelper.format4ImportAndApi(e.getSourceData().get("billtype"));
        DynamicObject billtypeparameter = (DynamicObject)this.tempCache.get("billtypeparameter" + billtypeMap.get(billtypeMap.get("importprop")));
        if (billtype != null && billtypeparameter == null) {
            billtypeparameter = (DynamicObject)SystemParamServiceHelper.getBillTypeParameter((String)"pm_requirapplybill", (String)"pm_billtypeparameter", (long)((Long)billtype.getPkValue()));
            this.tempCache.put("billtypeparameter" + billtypeMap.get(billtypeMap.get("importprop")), billtypeparameter);
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        Long lineTypeId;
        String billcretype = this.getPageCache().get("billcretype");
        if (BillImportHelper.isSkip((String)billcretype)) {
            return;
        }
        IDataModel model = this.getModel();
        model.setValue("billcretype", (Object)"1");
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            return;
        }
        DynamicObject billType = (DynamicObject)model.getValue("billtype");
        DynamicObject bizType = (DynamicObject)model.getValue("biztype");
        model.setValue("billstatus", (Object)StatusEnum.SAVE.getValue());
        if (billType != null && bizType == null) {
            Long bizTypeId = (Long)this.tempCache.get(billType.getPkValue() + "-biztype");
            if (bizTypeId == null && (bizTypeId = BizTypeHelper.getDefaultBizType((String)"pm_requirapplybill", (Long)((Long)billType.getPkValue()), (String)"pm_billtypeparameter")) != null) {
                this.tempCache.put(billType.getPkValue() + "-biztype", bizTypeId);
            }
            if (bizTypeId != null) {
                model.setValue("biztype", (Object)bizTypeId);
            }
        }
        DynamicObject defaultLineType = null;
        bizType = (DynamicObject)model.getValue("biztype");
        if (bizType != null && (lineTypeId = BizTypeHelper.getDefaultLineType((Long)((Long)bizType.getPkValue()))) != null) {
            defaultLineType = BusinessDataServiceHelper.loadSingleFromCache((Object)lineTypeId, (String)"bd_linetype");
        }
        Date biztime = (Date)model.getValue("biztime");
        Calendar instance = Calendar.getInstance();
        instance.set(11, 0);
        instance.set(12, 0);
        instance.set(13, 0);
        instance.set(14, 0);
        Date time = instance.getTime();
        DynamicObjectCollection billentrys = (DynamicObjectCollection)model.getValue("billentry");
        if (billentrys != null) {
            for (DynamicObject billentry : billentrys) {
                billentry.set("entryorg", model.getValue("org"));
                DynamicObject material = billentry.getDynamicObject("materialmasterid");
                if (material == null) break;
                DynamicObject lineType = billentry.getDynamicObject("linetype");
                if (lineType == null && defaultLineType != null) {
                    billentry.set("linetype", (Object)defaultLineType);
                }
                boolean isdisposable = material.getBoolean("isdisposable");
                if (StringUtils.isBlank((CharSequence)billentry.getString("materialname")) || !isdisposable) {
                    billentry.set("materialname", (Object)material.getLocaleString("name").toString());
                }
                billentry.set("baseunit", (Object)material.getDynamicObject("baseunit"));
                billentry.set("auxunit", (Object)material.getDynamicObject("auxptyunit"));
                Date deliverdate = (Date)billentry.get("reqdate");
                if (deliverdate.compareTo(time) == 0) {
                    billentry.set("reqdate", (Object)biztime);
                }
                DynamicObject unit = billentry.getDynamicObject("unit");
                DynamicObject baseunit = billentry.getDynamicObject("baseunit");
                if (unit == null) {
                    unit = material.getDynamicObject("baseunit");
                    billentry.set("unit", (Object)unit);
                }
                if (unit == null || baseunit == null) continue;
                if (unit.getPkValue().equals(baseunit.getPkValue())) {
                    billentry.set("baseqty", (Object)billentry.getBigDecimal("qty"));
                    continue;
                }
                billentry.set("baseqty", (Object)BillQtyAndUnitHelper.getDesQtyConv((Long)((Long)material.getPkValue()), (DynamicObject)unit, (BigDecimal)billentry.getBigDecimal("qty"), (DynamicObject)baseunit));
            }
        }
    }

    private DynamicObject getBaseDataFromCache(Map<String, Object> sourceData, String propName, String propEntityName, String select) {
        if (sourceData == null) {
            return null;
        }
        Map propMap = BillImportHelper.format4ImportAndApi((Object)sourceData.get(propName));
        String importProp = null;
        if (propMap != null) {
            importProp = (String)propMap.get("importprop");
            DynamicObject value = (DynamicObject)this.tempCache.get(propName + "_" + propMap.get(importProp));
            if (value == null && !"id".equals(importProp)) {
                if (select == null) {
                    select = "id";
                }
                value = BusinessDataServiceHelper.loadSingleFromCache((String)propEntityName, (String)select, (QFilter[])new QFilter(importProp, "=", propMap.get(importProp)).toArray());
            }
            return value;
        }
        return null;
    }
}

