/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.reqapply;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.business.helper.BizTypeHelper;
import kd.mpscmm.msbd.common.enums.BizCloseStatusEnum;
import kd.mpscmm.msbd.common.enums.UnitConvertDirEnum;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scm.pssc.business.helper.BillImportHelper;
import kd.scm.pssc.business.helper.BillQtyAndUnitHelper;
import kd.scm.pssc.business.helper.MaterialHelper;
import kd.scm.pssc.business.helper.OrgHelper;
import kd.scm.pssc.business.helper.SupplierHelper;
import kd.scm.pssc.common.utils.PsscParamUtil;

public class RequirApplyBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private final BigDecimal ZERO = BigDecimal.ZERO;
    private static final String CONFIRM_BIZTYPE = "confirm_biztype";
    private static final String CACHE_BIZTYPE = "cache_biztype";
    private static final String CONFIRM_LINETYPE = "confirm_linetype";
    private static final String CACHE_LINETYPE = "cache_linetype";

    public void registerListener(EventObject e) {
        BasedataEdit dept;
        BasedataEdit entryBizType;
        BasedataEdit supplier;
        BasedataEdit materialversion;
        BasedataEdit unit;
        BasedataEdit materialMasterEdit;
        BasedataEdit bizTypeEdit;
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getView().getControl("tbmainentry");
        if (toolbar != null) {
            toolbar.addItemClickListener((ItemClickListener)this);
        }
        if ((bizTypeEdit = (BasedataEdit)this.getView().getControl("biztype")) != null) {
            bizTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((materialMasterEdit = (BasedataEdit)this.getView().getControl("materialmasterid")) != null) {
            materialMasterEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            materialMasterEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
        }
        if ((unit = (BasedataEdit)this.getView().getControl("unit")) != null) {
            unit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((materialversion = (BasedataEdit)this.getView().getControl("materialversion")) != null) {
            materialversion.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((supplier = (BasedataEdit)this.getView().getControl("supplier")) != null) {
            supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entryBizType = (BasedataEdit)this.getView().getControl("linetype")) != null) {
            entryBizType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((dept = (BasedataEdit)this.getView().getControl("dept")) != null) {
            dept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        String formId;
        String billcretype = this.getPageCache().get("billcretype");
        if (BillImportHelper.isSkip((String)billcretype)) {
            return;
        }
        if (BillImportHelper.isImport((String)billcretype)) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            return;
        }
        Long orgId = (Long)org.getPkValue();
        this.setDefaultBillType();
        DynamicObject billType = (DynamicObject)model.getValue("billtype");
        Long bizTypeId = null;
        if (billType != null && (bizTypeId = BizTypeHelper.getDefaultBizType((String)(formId = this.getView().getEntityId()), (Long)((Long)billType.getPkValue()), (String)"pm_billtypeparameter")) != null) {
            model.beginInit();
            this.getModel().setValue("biztype", (Object)bizTypeId);
            model.endInit();
        }
        int entryRowCount = model.getEntryRowCount("billentry");
        Long lineType = null;
        if (bizTypeId != null) {
            lineType = BizTypeHelper.getDefaultLineType(bizTypeId);
        }
        for (int i = 0; i < entryRowCount; ++i) {
            model.setValue("entryorg", (Object)orgId, i);
            if (lineType == null) continue;
            model.setValue("linetype", (Object)lineType, i);
        }
        DynamicObject bizUser = (DynamicObject)model.getValue("bizuser");
        if (!CommonUtils.isNull((Object)bizUser)) {
            long userId = (Long)bizUser.getPkValue();
            Long deptId = UserServiceHelper.getUserMainOrgId((long)userId);
            model.setValue("dept", (Object)deptId);
        }
    }

    private void setDefaultBillType() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String entityId = (String)customParams.get("billTypeForm");
        if (entityId != null) {
            switch (entityId) {
                case "pssc_requirapplyyearbill": {
                    this.getView().getModel().setValue("billtype", (Object)1868906308766414848L);
                    break;
                }
                case "pssc_requirapplymonthbill": {
                    this.getView().getModel().setValue("billtype", (Object)1868906708617803776L);
                    break;
                }
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            return;
        }
        Long orgId = (Long)org.getPkValue();
        String entryName = e.getEntryProp().getName();
        if ("billentry".equals(entryName)) {
            RowDataEntity[] rowDataEntities;
            Long entryBizType = null;
            DynamicObject bizType = (DynamicObject)model.getValue("biztype");
            if (bizType != null) {
                entryBizType = BizTypeHelper.getDefaultLineType((Long)((Long)bizType.getPkValue()));
            }
            for (RowDataEntity rowDataEntity : rowDataEntities = e.getRowDataEntities()) {
                int rowIndex = rowDataEntity.getRowIndex();
                model.setValue("entryorg", (Object)orgId, rowIndex);
                if (entryBizType == null) continue;
                this.getPageCache().put("stopChange", "true");
                model.setValue("linetype", (Object)entryBizType, rowIndex);
                this.getPageCache().put("stopChange", "false");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String stopChange = this.getPageCache().get("stopChange");
        if ("true".equals(stopChange)) {
            return;
        }
        String billcretype = this.getPageCache().get("billcretype");
        if (BillImportHelper.isSkip((String)billcretype)) {
            return;
        }
        if (BillImportHelper.isImport((String)billcretype)) {
            return;
        }
        String fieldName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        block20: for (int i = 0; i < changeSet.length; ++i) {
            ChangeData changeData = changeSet[i];
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            int rowIndex = changeData.getRowIndex();
            if (newValue == null && oldValue == null) {
                return;
            }
            if (newValue != null && newValue.equals(oldValue)) {
                return;
            }
            if (oldValue instanceof DynamicObject && newValue instanceof DynamicObject && ((DynamicObject)oldValue).getPkValue().equals(((DynamicObject)newValue).getPkValue())) {
                return;
            }
            if (oldValue instanceof BigDecimal && newValue instanceof BigDecimal && ((BigDecimal)oldValue).compareTo((BigDecimal)newValue) == 0) {
                return;
            }
            switch (fieldName) {
                case "biztype": {
                    this.changeBizType(oldValue, newValue);
                    continue block20;
                }
                case "linetype": {
                    this.changeLineType(oldValue, newValue, rowIndex);
                    continue block20;
                }
                case "materialmasterid": {
                    this.changeMaterial(oldValue, newValue, rowIndex);
                    continue block20;
                }
                case "materialname": {
                    boolean isdisposable;
                    Object value = this.getModel().getValue("materialmasterid", rowIndex);
                    if (!(value instanceof DynamicObject) || (isdisposable = ((DynamicObject)value).getBoolean("isdisposable"))) continue block20;
                    ILocaleString name = ((DynamicObject)value).getLocaleString("name");
                    this.getModel().setValue("materialname", name == null ? newValue : name.getLocaleValue(), rowIndex);
                    continue block20;
                }
                case "auxqty": {
                    this.changeAuxQty(newValue, rowIndex);
                    continue block20;
                }
                case "qty": {
                    this.changeQty(newValue, rowIndex);
                    continue block20;
                }
                case "unit": {
                    this.changeUnit(newValue, rowIndex);
                    continue block20;
                }
                case "bizuser": {
                    this.changeBizuser(newValue);
                }
            }
        }
    }

    private void changeLineType(Object oldValue, Object newValue, int rowIndex) {
        if (oldValue != null && newValue == null) {
            this.getPageCache().put("stopChange", "true");
            this.getModel().setValue("linetype", ((DynamicObject)oldValue).getPkValue(), rowIndex);
            this.getPageCache().put("stopChange", "false");
            return;
        }
        Long srcBillId = (Long)this.getModel().getValue("srcbillid", rowIndex);
        Long srcBillEntryId = (Long)this.getModel().getValue("srcbillentryid", rowIndex);
        if (srcBillId != null && !srcBillId.equals(0L) || srcBillEntryId != null && !srcBillEntryId.equals(0L)) {
            return;
        }
        ConfirmCallBackListener callBack = new ConfirmCallBackListener(CONFIRM_LINETYPE, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u201c\u884c\u7c7b\u578b\u201d\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5f53\u524d\u5206\u5f55\u7269\u6599\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"RequirApplyBillPlugin_0", (String)"scm-pssc-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, callBack, null, String.valueOf(rowIndex));
        this.getView().getPageCache().put(CACHE_LINETYPE, oldValue == null ? null : ((DynamicObject)oldValue).getPkValue().toString());
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        String key = e.getProperty().getName();
        DynamicObject billType = (DynamicObject)model.getValue("billtype");
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        String formId = this.getView().getEntityId();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
        DynamicObject materialMaster = (DynamicObject)model.getValue("materialmasterid", rowIndex);
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        if (!"org".equals(key)) {
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u6c42\u7ec4\u7ec7", (String)"RequirApplyBillPlugin_1", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            if (billType == null && !"billtype".equals(key)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5355\u636e\u7c7b\u578b\u3002", (String)"RequirApplyBillPlugin_2", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
        switch (key) {
            case "biztype": {
                List bizTypeIds;
                if (billType == null || (bizTypeIds = BizTypeHelper.getAllBizTypes((String)formId, (Long)((Long)billType.getPkValue()), (String)"pm_billtypeparameter")) == null) break;
                QFilter q1 = new QFilter("id", "in", (Object)bizTypeIds);
                showParameter.getListFilterParameter().getQFilters().add(q1);
                break;
            }
            case "linetype": {
                if (bizType == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"RequirApplyBillPlugin_3", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                List allLineTypes = BizTypeHelper.getAllLineTypes((Long)((Long)bizType.getPkValue()));
                if (allLineTypes == null) break;
                QFilter fitler = new QFilter("id", "in", (Object)allLineTypes);
                showParameter.getListFilterParameter().getQFilters().add(fitler);
                break;
            }
            case "materialmasterid": {
                List masterMaterialQFilter;
                DynamicObject lineType = (DynamicObject)this.getModel().getValue("linetype", rowIndex);
                if (lineType == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u884c\u7c7b\u578b\u3002", (String)"RequirApplyBillPlugin_4", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                if (billType == null || (masterMaterialQFilter = MaterialHelper.getQFilterByLineType((Long)((Long)billType.getPkValue()), (Long)(bizType == null ? null : (Long)bizType.getPkValue()), (Long)((Long)lineType.getPkValue()), (String)formId, (boolean)false)) == null) break;
                showParameter.getListFilterParameter().getQFilters().addAll(masterMaterialQFilter);
                break;
            }
            case "unit": {
                if (materialMaster == null) {
                    if (PsscParamUtil.isSupportUnMaterial()) break;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u4fe1\u606f", (String)"RequirApplyBillPlugin_5", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", rowIndex);
                long srcmuId = baseUnit == null ? 0L : (Long)baseUnit.getPkValue();
                Long materialMasterId = (Long)materialMaster.getPkValue();
                List unitIds = BaseDataServiceHelper.getAssistMUListResult((Long)materialMasterId, (Long)srcmuId, (String)"1");
                QFilter qFilter = new QFilter("id", "in", (Object)unitIds);
                showParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
            case "materialversion": {
                if (materialMaster == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u4fe1\u606f", (String)"RequirApplyBillPlugin_5", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                Long materialMasterId = (Long)materialMaster.getPkValue();
                QFilter qFilter = new QFilter("material", "=", (Object)materialMasterId);
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
            case "supplier": {
                if (bizType == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"RequirApplyBillPlugin_3", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                showParameter.getListFilterParameter().getQFilters().add(SupplierHelper.getPurchaseFilter());
                break;
            }
            case "dept": {
                Long orgId = (Long)org.getPkValue();
                List deptIDs = OrgHelper.getAllToOrg((String)"15", (String)"01", (Long)orgId, (boolean)true);
                DynamicObject user = (DynamicObject)model.getValue("bizuser");
                if (user != null) {
                    Long userID = (Long)user.getPkValue();
                    Long deptID = UserServiceHelper.getUserMainOrgId((long)userID);
                    deptIDs.add(deptID);
                }
                QFilter q6 = new QFilter("id", "in", (Object)deptIDs);
                showParameter.getListFilterParameter().getQFilters().add(q6);
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IDataModel model = this.getModel();
        DynamicObjectCollection billEntry = model.getDataEntity(true).getDynamicObjectCollection("billentry");
        if (billEntry != null && !billEntry.isEmpty()) {
            model.beginInit();
            DataEntityPropertyCollection properties = ((DynamicObject)billEntry.get(0)).getDynamicObjectType().getProperties();
            DynamicProperty materialProp = (DynamicProperty)properties.get((Object)"materialmasterid");
            DynamicProperty materialNameProp = (DynamicProperty)properties.get((Object)"materialname");
            for (DynamicObject entry : billEntry) {
                DynamicObject masterid = (DynamicObject)materialProp.getValueFast((Object)entry);
                String materialName = (String)materialNameProp.getValueFast((Object)entry);
                if (masterid == null || !StringUtils.isBlank((CharSequence)materialName) || masterid == null) continue;
                materialName = masterid.getLocaleString("name").toString();
                materialNameProp.setValueFast((Object)entry, (Object)materialName);
            }
            model.endInit();
        }
    }

    public void afterBindData(EventObject e) {
        this.setEnableByCloseStatus();
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey = e.getOperateKey();
        if ("bizclose".equals(operateKey) || "bizunclose".equals(operateKey)) {
            this.setEnableByCloseStatus();
        }
    }

    private void changeBizType(Object oldValue, Object newValue) {
        DynamicObject bizType_old = (DynamicObject)oldValue;
        String msg = ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u7c7b\u578b\u201d\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5f53\u524d\u5355\u636e\u4f9b\u5e94\u5546\u53ca\u7269\u6599\u660e\u7ec6\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"RequirApplyBillPlugin_6", (String)"scm-pssc-formplugin", (Object[])new Object[0]);
        MessageBoxOptions options = MessageBoxOptions.YesNo;
        ConfirmCallBackListener callBack = new ConfirmCallBackListener(CONFIRM_BIZTYPE, (IFormPlugin)this);
        this.getView().showConfirm(msg, options, ConfirmTypes.Default, callBack);
        this.getView().getPageCache().put(CACHE_BIZTYPE, bizType_old == null ? null : bizType_old.getPkValue().toString());
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)CONFIRM_BIZTYPE, (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.getModel().deleteEntryData("billentry");
                EntryProp entryProp = (EntryProp)this.getModel().getDataEntityType().findProperty("billentry");
                int defaultRows = entryProp.getDefaultRows();
                this.getModel().batchCreateNewEntryRow("billentry", defaultRows);
            } else {
                String bizTypeId = this.getView().getPageCache().get(CACHE_BIZTYPE);
                this.getModel().beginInit();
                this.getModel().setValue("biztype", bizTypeId == null ? null : Long.valueOf(Long.parseLong(bizTypeId)));
                this.getModel().endInit();
                this.getView().updateView("biztype");
            }
        } else if (StringUtils.equals((CharSequence)CONFIRM_LINETYPE, (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            String customVaule = messageBoxClosedEvent.getCustomVaule();
            if (StringUtils.isBlank((CharSequence)customVaule)) {
                return;
            }
            int rowIndex = Integer.parseInt(customVaule);
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.getModel().setValue("materialmasterid", null, rowIndex);
                this.clearEntryInfo(rowIndex);
            } else {
                String lineTypeId = this.getView().getPageCache().get(CACHE_LINETYPE);
                this.getModel().beginInit();
                this.getModel().setValue("linetype", (Object)(lineTypeId == null ? null : Long.valueOf(Long.parseLong(lineTypeId))), rowIndex);
                this.getModel().endInit();
                this.getView().updateView("linetype", rowIndex);
            }
        }
    }

    private void changeMaterial(Object oldValue, Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        model.beginInit();
        this.clearEntryInfo(rowIndex);
        if (newValue instanceof DynamicObject) {
            DynamicObject materialMaster = (DynamicObject)newValue;
            model.setValue("materialname", materialMaster.getLocaleString("name") != null ? materialMaster.getLocaleString("name").toString() : null, rowIndex);
            if (materialMaster.getDynamicObject("auxptyunit") != null) {
                model.setValue("auxunit", materialMaster.getDynamicObject("auxptyunit").getPkValue(), rowIndex);
            } else {
                model.setValue("auxunit", null, rowIndex);
            }
            DynamicObject baseUnit = materialMaster.getDynamicObject("baseunit");
            if (baseUnit != null) {
                Long baseUnitId = (Long)baseUnit.getPkValue();
                model.setValue("baseunit", (Object)baseUnitId, rowIndex);
                model.setValue("unit", (Object)baseUnitId, rowIndex);
            }
        }
        model.endInit();
        IFormView view = this.getView();
        view.updateView("materialname", rowIndex);
        view.updateView("materialversion", rowIndex);
        view.updateView("auxpty", rowIndex);
        view.updateView("unit", rowIndex);
        view.updateView("auxunit", rowIndex);
        view.updateView("baseunit", rowIndex);
        view.updateView("qty", rowIndex);
        view.updateView("auxqty", rowIndex);
        view.updateView("baseqty", rowIndex);
    }

    private void clearEntryInfo(int rowIndex) {
        IDataModel model = this.getModel();
        model.setValue("materialname", null, rowIndex);
        model.setValue("materialversion", null, rowIndex);
        model.setValue("auxpty", null, rowIndex);
        model.setValue("unit", null, rowIndex);
        model.setValue("auxunit", null, rowIndex);
        model.setValue("baseunit", null, rowIndex);
        model.setValue("qty", (Object)this.ZERO, rowIndex);
        model.setValue("auxqty", (Object)this.ZERO, rowIndex);
        model.setValue("baseqty", (Object)this.ZERO, rowIndex);
    }

    private void changeQty(Object newValue, int rowIndex) {
        if (newValue instanceof BigDecimal) {
            IDataModel model = this.getModel();
            BigDecimal qty = (BigDecimal)newValue;
            DynamicObject materialMaster = (DynamicObject)model.getValue("materialmasterid", rowIndex);
            DynamicObject unit = (DynamicObject)model.getValue("unit", rowIndex);
            model.beginInit();
            if (materialMaster == null && unit == null) {
                return;
            }
            if (materialMaster == null && unit != null) {
                model.setValue("baseunit", unit.getPkValue(), rowIndex);
                model.setValue("auxunit", unit.getPkValue(), rowIndex);
            }
            DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", rowIndex);
            DynamicObject auxUnit = (DynamicObject)model.getValue("auxunit", rowIndex);
            if (baseUnit == null) {
                if (materialMaster != null) {
                    baseUnit = materialMaster.getDynamicObject("baseunit");
                }
                if (baseUnit != null) {
                    model.setValue("baseunit", baseUnit.getPkValue(), rowIndex);
                }
            }
            if (baseUnit != null) {
                Long materialMasterId = 0L;
                if (materialMaster != null) {
                    materialMasterId = (Long)materialMaster.getPkValue();
                }
                BigDecimal baseQty = BillQtyAndUnitHelper.getDesQtyConv((Long)materialMasterId, (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit);
                model.setValue("baseqty", (Object)baseQty, rowIndex);
                if (auxUnit != null && materialMaster != null) {
                    String unitConvertDir = materialMaster.getString("unitconvertdir");
                    if (UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir)) {
                        BigDecimal auxQty = BillQtyAndUnitHelper.getDesQtyConv((Long)materialMasterId, (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)auxUnit);
                        model.setValue("auxqty", (Object)auxQty, rowIndex);
                    }
                }
            }
            model.endInit();
        }
        IFormView view = this.getView();
        view.updateView("baseunit", rowIndex);
        view.updateView("baseqty", rowIndex);
        view.updateView("auxqty", rowIndex);
    }

    private void changeUnit(Object newValue, int rowIndex) {
        if (newValue instanceof DynamicObject) {
            DynamicObject unit = (DynamicObject)newValue;
            IDataModel model = this.getModel();
            DynamicObject materialMaster = (DynamicObject)model.getValue("materialmasterid", rowIndex);
            BigDecimal qty = (BigDecimal)model.getValue("qty", rowIndex);
            int precision = BillQtyAndUnitHelper.getPrecision((DynamicObject)unit);
            int precisionaccount = BillQtyAndUnitHelper.getPrecisionType((DynamicObject)unit);
            qty = qty.setScale(precision, precisionaccount);
            model.beginInit();
            model.setValue("qty", (Object)qty, rowIndex);
            if (materialMaster == null && unit != null) {
                model.setValue("baseqty", (Object)qty, rowIndex);
                model.setValue("auxqty", (Object)qty, rowIndex);
                model.setValue("baseunit", unit.getPkValue(), rowIndex);
                model.setValue("auxunit", unit.getPkValue(), rowIndex);
            }
            model.endInit();
            if (materialMaster != null && qty != null && qty.compareTo(this.ZERO) != 0) {
                DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", rowIndex);
                DynamicObject auxUnit = (DynamicObject)model.getValue("auxunit", rowIndex);
                model.beginInit();
                if (baseUnit == null && (baseUnit = materialMaster.getDynamicObject("baseunit")) != null) {
                    model.setValue("baseunit", baseUnit.getPkValue(), rowIndex);
                }
                if (baseUnit != null) {
                    Long masterId = (Long)materialMaster.getPkValue();
                    BigDecimal baseQty = BillQtyAndUnitHelper.getDesQtyConv((Long)masterId, (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit);
                    model.setValue("baseqty", (Object)baseQty, rowIndex);
                    if (auxUnit != null) {
                        String unitConvertDir = materialMaster.getString("unitconvertdir");
                        if (UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir)) {
                            BigDecimal auxQty = BillQtyAndUnitHelper.getDesQtyConv((Long)masterId, (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)auxUnit);
                            model.setValue("auxqty", (Object)auxQty, rowIndex);
                        }
                    }
                }
                model.endInit();
            }
        }
        this.getView().updateView("auxunit", rowIndex);
        this.getView().updateView("baseunit", rowIndex);
        this.getView().updateView("baseqty", rowIndex);
        this.getView().updateView("auxqty", rowIndex);
        this.getView().updateView("qty", rowIndex);
    }

    private void changeAuxQty(Object newValue, int rowIndex) {
        if (newValue instanceof BigDecimal) {
            IDataModel model = this.getModel();
            BigDecimal auxQty = (BigDecimal)newValue;
            DynamicObject materialMaster = (DynamicObject)model.getValue("materialmasterid", rowIndex);
            DynamicObject auxUnit = (DynamicObject)model.getValue("auxunit", rowIndex);
            if (materialMaster == null || auxUnit == null) {
                return;
            }
            DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", rowIndex);
            DynamicObject unit = (DynamicObject)model.getValue("unit", rowIndex);
            String unitConvertDir = materialMaster.getString("unitconvertdir");
            if (baseUnit == null && (baseUnit = materialMaster.getDynamicObject("baseunit")) != null) {
                model.setValue("baseunit", baseUnit.getPkValue(), rowIndex);
            }
            if (baseUnit != null && unit != null) {
                Long materialMasterId = (Long)materialMaster.getPkValue();
                if (UnitConvertDirEnum.U2ND_UINV.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir)) {
                    BigDecimal baseQty = BillQtyAndUnitHelper.getDesQtyConv((Long)materialMasterId, (DynamicObject)auxUnit, (BigDecimal)auxQty, (DynamicObject)baseUnit);
                    BigDecimal qty = BillQtyAndUnitHelper.getDesQtyConv((Long)materialMasterId, (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)unit);
                    model.beginInit();
                    model.setValue("baseqty", (Object)baseQty, rowIndex);
                    model.setValue("qty", (Object)qty, rowIndex);
                    model.endInit();
                    IFormView view = this.getView();
                    view.updateView("baseunit", rowIndex);
                    view.updateView("baseqty", rowIndex);
                    view.updateView("qty", rowIndex);
                }
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        if ("materialmasterid".equals(key)) {
            Long lineTypeID;
            int currentRowIndex = e.getCurrentRowIndex();
            ListSelectedRowCollection listSelectedRowCollection = e.getListSelectedRowCollection();
            DynamicObject lineType = (DynamicObject)this.getModel().getValue("linetype", currentRowIndex);
            Long l = lineTypeID = lineType == null ? null : (Long)lineType.getPkValue();
            if (listSelectedRowCollection.size() > 1) {
                for (int i = 1; i < listSelectedRowCollection.size(); ++i) {
                    this.getPageCache().put("stopChange", "true");
                    this.getModel().setValue("linetype", (Object)lineTypeID, i + currentRowIndex);
                    this.getPageCache().put("stopChange", "false");
                }
            }
        }
    }

    private void setEnableByCloseStatus() {
        IDataModel model = this.getView().getModel();
        String closeStatus = (String)model.getValue("closestatus");
        if (BizCloseStatusEnum.CLOSE.getValue().equals(closeStatus)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_bizclose"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"bar_bizunclose"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"bar_bizclose"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_bizunclose"});
        }
    }

    private void changeBizuser(Object newValue) {
        DynamicObject bizuser;
        Long userID;
        Long deptID = null;
        this.getModel().beginInit();
        if (newValue instanceof DynamicObject && (userID = (Long)(bizuser = (DynamicObject)newValue).getPkValue()) != null) {
            deptID = UserServiceHelper.getUserMainOrgId((long)userID);
        }
        this.getModel().endInit();
        this.getView().updateView("bizuser");
        this.getModel().setValue("dept", deptID);
    }
}

