/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.reqapply;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.QtyProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.scm.pssc.business.helper.BillQtyAndUnitHelper;
import kd.scm.pssc.business.helper.BotpHepler;
import kd.scm.pssc.business.helper.ReqSumSchemeHelper;
import kd.scm.pssc.business.pojo.ReturnResultInfo;
import kd.scm.pssc.business.pojo.SummarySchemaDTO;

public class RequireApplyGeneratePurApplyPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(RequireApplyGeneratePurApplyPlugin.class);
    private static final String ENTITY_SRCBILL = "pm_requirapplybill";
    private static final String ENTITY_TARGETBILL = "pm_purapplybill";
    private static final String KEY_BOTPRULE = "botprule";
    private static final String KEY_SUMSCHEME = "requirsumscheme";
    private static final String KEY_ENTRYENTITY = "resultentryentity";
    private static final String BASEQTY = "baseqty";
    private static final String AUXQTY = "auxqty";
    private static final String REQ_APPLY_ENTRY_ID_TO_ENTRY_ID_MAP = "reqApplyEntryIdTOEntryIdMap";

    public void afterCreateNewData(EventObject e) {
        boolean initBotpRuleControl = this.initBotpRuleControl();
        if (!initBotpRuleControl) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u9700\u6c42\u7533\u8bf7\u5355\u751f\u6210\u91c7\u8d2d\u7533\u8bf7\u5355\u7684\u8f6c\u6362\u89c4\u5219\u3002", (String)"RequireApplyGeneratePurApplyPlugin_0", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
            return;
        }
        Long defaultRequireSumScheme = ReqSumSchemeHelper.getDefaultRequireSumScheme();
        if (defaultRequireSumScheme == null || defaultRequireSumScheme == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u9700\u6c42\u6c47\u603b\u65b9\u6848\u3002", (String)"RequireApplyGeneratePurApplyPlugin_1", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue(KEY_SUMSCHEME, (Object)defaultRequireSumScheme);
        this.loadBillList(defaultRequireSumScheme);
        this.updateEntryEntity();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData;
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        IDataModel model = this.getModel();
        block6: for (int i = 0; i < changeSet.length; ++i) {
            changeData = changeSet[i];
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            DynamicObject dataEntity = changeData.getDataEntity();
            int rowIndex = changeData.getRowIndex();
            if (newValue == null && oldValue == null) {
                return;
            }
            if (newValue != null && newValue.equals(oldValue)) {
                return;
            }
            if (oldValue instanceof DynamicObject && newValue instanceof DynamicObject && ((DynamicObject)oldValue).getPkValue().equals(((DynamicObject)newValue).getPkValue())) {
                return;
            }
            if (oldValue instanceof BigDecimal && newValue instanceof BigDecimal && ((BigDecimal)oldValue).compareTo((BigDecimal)newValue) == 0) {
                return;
            }
            switch (fieldKey) {
                case "checkneedsnum": {
                    BigDecimal checkneedsnum = (BigDecimal)dataEntity.get("checkneedsnum");
                    if (checkneedsnum == null) {
                        model.setValue("checkneedsnum", (Object)new BigDecimal(0));
                    }
                    this.controlSelectRow();
                    Long materialmasterid = (Long)dataEntity.getDynamicObject("materialmasterid").getPkValue();
                    DynamicObject baseUnit = dataEntity.getDynamicObject("baseunit");
                    DynamicObject purChaseUnit = dataEntity.getDynamicObject("purchaseunit");
                    BigDecimal purChaseUnitQty = (BigDecimal)newValue;
                    BigDecimal surplusbasenum = (BigDecimal)model.getValue("surplusbasenum", rowIndex);
                    if (purChaseUnitQty != null && surplusbasenum != null && purChaseUnitQty.compareTo(surplusbasenum) > 0) {
                        purChaseUnitQty = surplusbasenum;
                    }
                    BigDecimal baseUnitQty = BillQtyAndUnitHelper.getDesQtyConv((Long)materialmasterid, (DynamicObject)purChaseUnit, (BigDecimal)purChaseUnitQty, (DynamicObject)baseUnit);
                    model.setValue(BASEQTY, (Object)baseUnitQty, rowIndex);
                    continue block6;
                }
            }
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)KEY_SUMSCHEME)) {
            this.getModel().deleteEntryData(KEY_ENTRYENTITY);
            ChangeData[] changeSet1 = e.getChangeSet();
            if (changeSet1.length > 0) {
                changeData = changeSet1[0];
                if (changeData == null) {
                    return;
                }
                if (changeData.getNewValue() instanceof DynamicObject) {
                    Long defaultRequireSumScheme = (Long)((DynamicObject)changeData.getNewValue()).getPkValue();
                    this.loadBillList(defaultRequireSumScheme);
                }
                this.updateEntryEntity();
            }
        }
    }

    public void afterBindData(EventObject e) {
        this.initSelectRow();
    }

    private void initSelectRow() {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        ArrayList<Integer> setSelectRow = new ArrayList<Integer>(dynamicObjects.size());
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            BigDecimal checkneedsnum = ((DynamicObject)dynamicObjects.get(i)).getBigDecimal("checkneedsnum");
            if (checkneedsnum.compareTo(BigDecimal.ZERO) == 0) continue;
            setSelectRow.add(i);
        }
        int[] selectRow = setSelectRow.stream().mapToInt(Integer::intValue).toArray();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        entryGrid.selectRows(selectRow, -1);
    }

    private void controlSelectRow() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        int[] beforeSelectRows = entryGrid.getSelectRows();
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        ArrayList<Integer> afterSelectRow = new ArrayList<Integer>(dynamicObjects.size());
        for (int row : beforeSelectRows) {
            BigDecimal checkneedsnum = ((DynamicObject)dynamicObjects.get(row)).getBigDecimal("checkneedsnum");
            if (checkneedsnum == null || checkneedsnum.compareTo(BigDecimal.ZERO) == 0) continue;
            afterSelectRow.add(row);
        }
        int[] selectRow = afterSelectRow.stream().mapToInt(Integer::intValue).toArray();
        entryGrid.selectRows(selectRow, -1);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operatekey;
        super.afterDoOperation(e);
        switch (operatekey = e.getOperateKey()) {
            case "generateneeds": {
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                Map billIDMap = (Map)formShowParameter.getCustomParam("selectline");
                if (billIDMap == null || billIDMap.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"RequireApplyGeneratePurApplyPlugin_2", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                    return;
                }
                String ruleId = (String)this.getModel().getValue(KEY_BOTPRULE);
                boolean exists = QueryServiceHelper.exists((String)"botp_crlist", (Object)ruleId);
                if (!exists) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f6c\u6362\u89c4\u5219\u88ab\u5220\u9664\uff0c\u8bf7\u9000\u51fa\u91cd\u65b0\u6c47\u603b\u3002", (String)"RequireApplyGeneratePurApplyPlugin_3", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject sumScheme = (DynamicObject)this.getModel().getValue(KEY_SUMSCHEME);
                if (sumScheme == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9700\u6c42\u6c47\u603b\u65b9\u6848\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RequireApplyGeneratePurApplyPlugin_4", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                    return;
                }
                Map<String, String> param = this.getBotpParam((Long)sumScheme.getPkValue());
                Set<String> entryIdSet = this.getSelectEntryIdSet();
                if (entryIdSet == null || entryIdSet.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761 \u201c\u786e\u8ba4\u9700\u6c42\u6570\u91cf\u201d \u4e0d\u4e3a0\u7684\u6570\u636e\u884c\u3002", (String)"ReqApplyToReqApplyPlugin_12", (String)"scm-pssc-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashMap<Long, Long> sourceIdMap = new HashMap<Long, Long>(billIDMap.size());
                for (Map.Entry map : billIDMap.entrySet()) {
                    String key = (String)map.getKey();
                    List values = (List)map.getValue();
                    for (Long value : values) {
                        if (!entryIdSet.contains(value.toString())) continue;
                        sourceIdMap.put(value, Long.valueOf(key));
                    }
                }
                ReturnResultInfo result = BotpHepler.botpGenerateTargetBill(sourceIdMap, (String)ruleId, (String)ENTITY_SRCBILL, (String)"billentry", (String)ENTITY_TARGETBILL, (String)"billentry", (String)"save", param, (boolean)true);
                if (result.isSuccess()) {
                    this.getView().returnDataToParent((Object)result.getSuccessList());
                    this.getView().close();
                }
                if (result.isSuccess()) break;
                this.getView().showTipNotification(result.getMessage());
                return;
            }
        }
    }

    private Set<String> getSelectEntryIdSet() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            return null;
        }
        String cacheString = this.getPageCache().get(REQ_APPLY_ENTRY_ID_TO_ENTRY_ID_MAP);
        if (StringUtils.isEmpty((CharSequence)cacheString)) {
            return null;
        }
        Map reqApplyEntryIdTOEntryIdMap = (Map)JSON.parseObject((String)cacheString, Map.class);
        if (reqApplyEntryIdTOEntryIdMap == null || reqApplyEntryIdTOEntryIdMap.isEmpty()) {
            return null;
        }
        DynamicObjectCollection entity = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        HashSet<String> entryIdSet = new HashSet<String>();
        for (int selectRow : selectRows) {
            String reqapplyentryid;
            String entryIdsStr;
            DynamicObject dynamicObject = (DynamicObject)entity.get(selectRow);
            BigDecimal checkneedsnum = dynamicObject.getBigDecimal("checkneedsnum");
            if (checkneedsnum.compareTo(BigDecimal.ZERO) == 0 || StringUtils.isEmpty((CharSequence)(entryIdsStr = (String)reqApplyEntryIdTOEntryIdMap.get(reqapplyentryid = dynamicObject.getString("reqapplyentryid"))))) continue;
            List entryIds = Stream.of(entryIdsStr.split(",")).filter(s -> !s.isEmpty()).collect(Collectors.toList());
            entryIdSet.addAll(entryIds);
        }
        return entryIdSet;
    }

    private Map<String, String> getBotpParam(Long requireSumSchemeID) {
        HashMap<String, String> param = new HashMap<String, String>(6);
        ArrayList<String> paramKeyField = new ArrayList<String>(16);
        Map<String, Map> initSummary = this.initSummaryParameter(paramKeyField);
        String entryData = SerializationUtils.toJsonString(initSummary);
        StringBuilder schemaField = new StringBuilder();
        Set<String> fields = this.getFields(requireSumSchemeID);
        HashSet<String> copyFields = new HashSet<String>(fields.size());
        for (String field : fields) {
            if (field.contains("billentry.") && !field.contains("billentry.id")) {
                copyFields.add(field.replace("billentry.", ""));
                continue;
            }
            copyFields.add(field);
        }
        schemaField.append(String.join((CharSequence)",", copyFields));
        param.put("entryresult", entryData);
        param.put("summaryschema", schemaField.toString());
        return param;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBillList(Long requireSumSchemeID) {
        String tips = "";
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map billIDMap = (Map)formShowParameter.getCustomParam("selectline");
        List rowEntryIDList = (List)formShowParameter.getCustomParam("selectentryline");
        if (billIDMap != null && !billIDMap.isEmpty()) {
            DataSet initSummarySchema = this.initDynamicSummarySchema(requireSumSchemeID, rowEntryIDList);
            DataSet copy = initSummarySchema.copy();
            int numSize = copy.count("billentry.materialmasterid", false);
            try {
                copy.close();
            }
            finally {
                copy.close();
            }
            tips = this.getLabelapValue(billIDMap, numSize);
            this.getModel().beginInit();
            this.initDefaultResultEntry(initSummarySchema);
            this.getModel().endInit();
            try {
                initSummarySchema.close();
            }
            finally {
                initSummarySchema.close();
            }
        }
        tips = ResManager.loadKDString((String)"\u6309\u7167\u9700\u6c42\u6c47\u603b\u65b9\u6848\u8ba1\u7b97\uff0c0\u5f20\uff08\u51710\u884c\uff09\u9700\u6c42\u7533\u8bf7\u5355\u88ab\u6c47\u603b\u4e3a0\u884c", (String)"RequireApplyGeneratePurApplyPlugin_5", (String)"scm-pssc-formplugin", (Object[])new Object[0]);
        Label labelAp = (Label)this.getView().getControl("sumlab");
        labelAp.setText(tips);
    }

    private void updateEntryEntity() {
        this.getView().updateView(KEY_ENTRYENTITY);
    }

    private boolean initBotpRuleControl() {
        List ruleElements = ConvertMetaServiceHelper.loadRules((String)ENTITY_SRCBILL, (String)ENTITY_TARGETBILL);
        if (ruleElements == null || ruleElements.isEmpty()) {
            return false;
        }
        int size = ruleElements.size();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(size);
        String defRuleId = "";
        for (int i = 0; i < size; ++i) {
            ConvertRuleElement ruleElement = (ConvertRuleElement)ruleElements.get(i);
            boolean enabled = ruleElement.isEnabled();
            boolean visibled = ruleElement.isVisibled();
            if (!enabled || !visibled) continue;
            boolean defRule = ruleElement.isDefRule();
            LocaleString caption = ruleElement.getName();
            String value = ruleElement.getId();
            ComboItem item = new ComboItem(caption, value);
            comboItems.add(item);
            if (!defRule && i != 0) continue;
            defRuleId = value;
        }
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(KEY_BOTPRULE);
        comboEdit.setComboItems(comboItems);
        this.getModel().setValue(KEY_BOTPRULE, (Object)defRuleId);
        return comboItems.size() != 0;
    }

    /*
     * WARNING - void declaration
     */
    private DataSet initDynamicSummarySchema(Long requireSumSchemeID, List<Long> selectEntryLine) {
        void var11_21;
        QFilter q1 = new QFilter("billentry.id", "in", selectEntryLine);
        QFilter q2 = new QFilter("billentry.baseqty", "!=", (Object)0);
        HashSet<String> queryFieldSet = new HashSet<String>(Arrays.asList("billentry.id", "billentry.baseqty", "billentry.applybaseqty", "billentry.auxqty", "org", "dept", "bizorg", "billentry.reqdate", "billentry.supplier", "billentry.materialmasterid", "billentry.project"));
        Set<String> fields = this.getFields(requireSumSchemeID);
        for (String field : fields) {
            queryFieldSet.add(field);
        }
        StringBuilder queryFieldSql = new StringBuilder();
        boolean isFirst = true;
        for (String string : queryFieldSet) {
            if (isFirst) {
                queryFieldSql.append(string);
                isFirst = false;
                continue;
            }
            queryFieldSql.append(',').append(string);
        }
        HashSet<String> groupByFieldSet = new HashSet<String>(16);
        for (String string : fields) {
            groupByFieldSet.add(string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        isFirst = true;
        for (String groupByField : groupByFieldSet) {
            if (isFirst) {
                stringBuilder.append(groupByField);
                isFirst = false;
                continue;
            }
            stringBuilder.append(',').append(groupByField);
        }
        Object var11_16 = null;
        String querySql = queryFieldSql.toString();
        String groupBySql = stringBuilder.toString();
        if (fields.contains("billentry.reqdate")) {
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)ENTITY_SRCBILL, (String)querySql, (QFilter[])new QFilter[]{q1, q2}, (String)"billentry.reqdate desc");
            GroupbyDataSet groupDataSet = dataSet.groupBy(this.convertStrToArray(groupBySql)).groupConcat("billentry.id", "billentryids").max("billentry.id").sum("billentry.baseqty").sum("billentry.applybaseqty").sum("( billentry.baseqty - billentry.applybaseqty ) * billentry.auxqty / billentry.baseqty", "billentry.auxqty");
            DataSet dataSet2 = groupDataSet.finish();
        } else {
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)ENTITY_SRCBILL, (String)querySql, (QFilter[])new QFilter[]{q1, q2}, (String)"billentry.reqdate desc");
            GroupbyDataSet groupDataSet = dataSet.groupBy(this.convertStrToArray(groupBySql)).groupConcat("billentry.id", "billentryids").min("billentry.reqdate").max("billentry.id").sum("billentry.baseqty").sum("billentry.applybaseqty").sum("( billentry.baseqty - billentry.applybaseqty ) * billentry.auxqty / billentry.baseqty", "billentry.auxqty");
            DataSet dataSet3 = groupDataSet.finish();
        }
        return var11_21;
    }

    private String getLabelapValue(Map<String, List<Long>> selectLine, int numSize) {
        int num = 0;
        for (Map.Entry<String, List<Long>> item : selectLine.entrySet()) {
            List<Long> value = item.getValue();
            num += value.size();
        }
        String result = String.format(ResManager.loadKDString((String)"\u6309\u7167\u9700\u6c42\u6c47\u603b\u65b9\u6848\u8ba1\u7b97\uff0c%1$s\u5f20\uff08\u5171%2$s\u884c\uff09\u9700\u6c42\u7533\u8bf7\u5355\u88ab\u6c47\u603b\u4e3a%3$s\u884c", (String)"RequireApplyGeneratePurApplyPlugin_6", (String)"scm-pssc-formplugin", (Object[])new Object[0]), selectLine.size(), num, numSize);
        return result;
    }

    private void initDefaultResultEntry(DataSet rows) {
        IDataModel model = this.getModel();
        DataSet dataSetCopy = rows.copy();
        Map<Long, SummarySchemaDTO> initMaterialBaseUnitAndPurUnit = this.initMaterialBaseUnitAndPurUnitAndAuxunit(dataSetCopy);
        dataSetCopy.close();
        QtyProp baseQtyProperty = (QtyProp)this.getModel().getDataEntityType().findProperty(BASEQTY);
        BigDecimal baseQtyMax = baseQtyProperty.getMax();
        BigDecimal baseQtyMin = baseQtyProperty.getMin();
        QtyProp surauxQtyProperty = (QtyProp)this.getModel().getDataEntityType().findProperty(AUXQTY);
        BigDecimal surauxQtyPropertyMax = surauxQtyProperty.getMax();
        BigDecimal surauxQtyPropertyMin = surauxQtyProperty.getMin();
        QtyProp surplusbasenumProperty = (QtyProp)this.getModel().getDataEntityType().findProperty("surplusbasenum");
        BigDecimal surplusbasenumMax = surplusbasenumProperty.getMax();
        BigDecimal surplusbasenumMin = surplusbasenumProperty.getMin();
        QtyProp checkneedsnumProperty = (QtyProp)this.getModel().getDataEntityType().findProperty("checkneedsnum");
        BigDecimal checkneedsnumMax = checkneedsnumProperty.getMax();
        BigDecimal checkneedsnumMin = checkneedsnumProperty.getMin();
        List<Field> rowFields = Arrays.asList(rows.getRowMeta().getFields());
        if (rowFields == null || rowFields.isEmpty()) {
            return;
        }
        List rowFieldName = rowFields.stream().map(Field::getName).collect(Collectors.toList());
        HashMap<String, String> reqApplyEntryIdTOEntryIdMap = new HashMap<String, String>();
        for (Row row : rows) {
            reqApplyEntryIdTOEntryIdMap.put(row.getString("billentry.id"), row.getString("billentryids"));
            int rowId = model.createNewEntryRow(KEY_ENTRYENTITY);
            model.setValue("reqdateid", row.get("billentry.reqdate"), rowId);
            model.setValue("reqapplyentryid", row.get("billentry.id"), rowId);
            Long materialmasterid = null;
            if (rowFieldName.contains("billentry.materialmasterid")) {
                materialmasterid = row.getLong("billentry.materialmasterid");
            }
            if (rowFieldName.contains("bizorg")) {
                model.setValue("purorg", row.get("bizorg"), rowId);
            }
            if (rowFieldName.contains("org")) {
                model.setValue("orgid", row.get("org"), rowId);
            }
            if (rowFieldName.contains("billentry.project")) {
                model.setValue("project", row.get("billentry.project"), rowId);
            }
            if (rowFieldName.contains("dept")) {
                model.setValue("deptid", row.get("dept"), rowId);
            }
            if (rowFieldName.contains("billentry.supplier")) {
                model.setValue("supplierid", row.get("billentry.supplier"), rowId);
            }
            SummarySchemaDTO sumSchema = initMaterialBaseUnitAndPurUnit.get(materialmasterid);
            DynamicObject baseUnit = sumSchema.getBaseUnit();
            DynamicObject purChaseUnit = sumSchema.getPurChaseUnit();
            DynamicObject auxunit = sumSchema.getAuxunit();
            model.setValue("materialmasterid", (Object)materialmasterid, rowId);
            model.setValue("purchaseunit", (Object)purChaseUnit, rowId);
            model.setValue("baseunit", (Object)baseUnit, rowId);
            model.setValue("auxunit", (Object)auxunit, rowId);
            BigDecimal baseqty = row.getBigDecimal("billentry.baseqty");
            BigDecimal applybaseqty = row.getBigDecimal("billentry.applybaseqty");
            BigDecimal surauxqty = row.getBigDecimal("billentry.auxqty");
            BigDecimal auxqty = surauxqty.setScale(BillQtyAndUnitHelper.getPrecision((DynamicObject)auxunit), BillQtyAndUnitHelper.getPrecisionType((DynamicObject)auxunit));
            BigDecimal surplusbaseqty = baseqty.subtract(applybaseqty);
            BigDecimal surplusqty = BillQtyAndUnitHelper.getDesQtyConv((Long)materialmasterid, (DynamicObject)baseUnit, (BigDecimal)surplusbaseqty, (DynamicObject)purChaseUnit);
            if (baseqty.compareTo(baseQtyMax) > 0 || baseqty.compareTo(baseQtyMin) < 0) {
                model.setValue(BASEQTY, (Object)BigDecimal.ZERO, rowId);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9700\u6c42\u6c47\u603b\u7b2c%1$s\u884c\u57fa\u672c\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u5b57\u6bb5\u8bbe\u5b9a\u6570\u636e\u8303\u56f4", (String)"RequireApplyGeneratePurApplyPlugin_7", (String)"scm-pssc-formplugin", (Object[])new Object[0]), rowId + 1));
            } else {
                model.setValue(BASEQTY, (Object)surplusbaseqty, rowId);
            }
            if (auxqty.compareTo(surauxQtyPropertyMax) > 0 || auxqty.compareTo(surauxQtyPropertyMin) < 0) {
                model.setValue(AUXQTY, (Object)BigDecimal.ZERO, rowId);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9700\u6c42\u6c47\u603b\u7b2c%1$s\u884c\u8f85\u52a9\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u5b57\u6bb5\u8bbe\u5b9a\u6570\u636e\u8303\u56f4", (String)"RequireApplyGeneratePurApplyPlugin_8", (String)"scm-pssc-formplugin", (Object[])new Object[0]), rowId + 1));
            } else {
                model.setValue(AUXQTY, (Object)auxqty, rowId);
            }
            if (surplusqty.compareTo(surplusbasenumMax) > 0 || surplusqty.compareTo(surplusbasenumMin) < 0) {
                model.setValue("surplusbasenum", (Object)BigDecimal.ZERO, rowId);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9700\u6c42\u6c47\u603b\u7b2c%1$s\u884c\u5269\u4f59\u57fa\u672c\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u5b57\u6bb5\u8bbe\u5b9a\u6570\u636e\u8303\u56f4", (String)"RequireApplyGeneratePurApplyPlugin_9", (String)"scm-pssc-formplugin", (Object[])new Object[0]), rowId + 1));
            } else {
                model.setValue("surplusbasenum", (Object)surplusqty, rowId);
            }
            if (surplusqty.compareTo(checkneedsnumMax) > 0 || surplusqty.compareTo(checkneedsnumMin) < 0) {
                model.setValue("checkneedsnum", (Object)BigDecimal.ZERO, rowId);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9700\u6c42\u6c47\u603b\u7b2c%1$s\u884c\u786e\u8ba4\u9700\u6c42\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u5b57\u6bb5\u8bbe\u5b9a\u6570\u636e\u8303\u56f4", (String)"RequireApplyGeneratePurApplyPlugin_10", (String)"scm-pssc-formplugin", (Object[])new Object[0]), rowId + 1));
                continue;
            }
            model.setValue("checkneedsnum", (Object)surplusqty, rowId);
        }
        this.getView().getPageCache().put(REQ_APPLY_ENTRY_ID_TO_ENTRY_ID_MAP, SerializationUtils.toJsonString(reqApplyEntryIdTOEntryIdMap));
    }

    private Map<Long, SummarySchemaDTO> initMaterialBaseUnitAndPurUnitAndAuxunit(DataSet dataSetCopy) {
        int count = dataSetCopy.count("billentry.materialmasterid", true);
        ArrayList<Long> materialList = new ArrayList<Long>(count);
        for (Row row : dataSetCopy) {
            Long materialId = row.getLong("billentry.materialmasterid");
            materialList.add(materialId);
        }
        QFilter qFilter = new QFilter("masterid.id", "in", materialList);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bd_materialpurchaseinfo", (String)"masterid.id,masterid.baseunit,masterid.auxptyunit,purchaseunit", (QFilter[])qFilter.toArray());
        HashMap<Long, SummarySchemaDTO> mapDTO = new HashMap<Long, SummarySchemaDTO>(load.length);
        for (DynamicObject dynamic : load) {
            Long pkvalue = dynamic.getLong("masterid.id");
            DynamicObject baseUnit = dynamic.getDynamicObject("masterid.baseunit");
            DynamicObject auxunit = dynamic.getDynamicObject("masterid.auxptyunit");
            DynamicObject purChaseUnit = dynamic.getDynamicObject("purchaseunit");
            mapDTO.put(pkvalue, SummarySchemaDTO.initBaseUnitAndAuxunit((DynamicObject)baseUnit, (DynamicObject)purChaseUnit, (DynamicObject)auxunit));
        }
        return mapDTO;
    }

    private Map<String, Map> initSummaryParameter(List<String> paramKeyField) {
        IDataModel model = this.getModel();
        DynamicObject bill = model.getDataEntity(true);
        DynamicObjectCollection entry = bill.getDynamicObjectCollection(KEY_ENTRYENTITY);
        HashMap<String, Map> mapCollection = new HashMap<String, Map>(entry.size());
        for (DynamicObject row : entry) {
            BigDecimal surplusbasenum = row.getBigDecimal(BASEQTY);
            BigDecimal auxqtysum = row.getBigDecimal(AUXQTY);
            String paramMapKeyStr = String.valueOf(row.get("reqapplyentryid"));
            HashMap<String, BigDecimal> mapsum = new HashMap<String, BigDecimal>();
            mapsum.put(BASEQTY, surplusbasenum);
            mapsum.put(AUXQTY, auxqtysum);
            mapCollection.put(paramMapKeyStr, mapsum);
        }
        return mapCollection;
    }

    private String[] convertStrToArray(String str) {
        String[] strArray = null;
        if (str != null && !"".equals(str)) {
            strArray = str.split(",");
        }
        return strArray;
    }

    private Set<String> getFields(Long schemeID) {
        HashSet<String> fields = new HashSet<String>(16);
        DynamicObject requireSumScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)schemeID, (String)"pm_reqsumscheme", (String)"id,entryentity.sumcode");
        if (requireSumScheme != null) {
            DynamicObjectCollection entrys = requireSumScheme.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                fields.add(entry.getString("sumcode"));
            }
        }
        return fields;
    }
}

