/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.scm.pssc.business.helper.OrgHelper;
import kd.scm.pssc.common.utils.DateUtil;
import kd.scm.pssc.report.PurRptHelper;

public class PurReqBillRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit project;
        BasedataEdit material;
        BasedataEdit reqDept;
        super.registerListener(e);
        IReportView view = this.getView();
        BasedataEdit org = (BasedataEdit)view.getControl("orgfield");
        if (org != null) {
            org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((reqDept = (BasedataEdit)view.getControl("reqdeptfield")) != null) {
            reqDept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((material = (BasedataEdit)view.getControl("materialfield")) != null) {
            material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((project = (BasedataEdit)view.getControl("projectfield")) != null) {
            project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("orgfield");
        if (org == null) {
            long orgId = RequestContext.get().getOrgId();
            List hasPermissionOrgList = OrgHelper.getHasPermissionOrg((String)this.getView().getFormShowParameter().getFormId(), (String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (IFormView)this.getView());
            Long defaultOrg = PurRptHelper.getDefaultOrg(hasPermissionOrgList, orgId);
            if (defaultOrg != null) {
                this.getModel().setValue("orgfield", (Object)defaultOrg);
            }
        }
        Date now = new Date();
        if (model.getValue("startdatefield") == null) {
            model.setValue("startdatefield", (Object)DateUtil.getStartOfDay((Date)now));
        }
        if (model.getValue("enddatefield") == null) {
            model.setValue("enddatefield", (Object)now);
        }
    }

    public void beforeBindData(EventObject e) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String filed = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        switch (filed) {
            case "orgfield": {
                if (newValue != null && newValue.equals(oldValue)) {
                    return;
                }
                if (model.getValue("reqdeptfield") != null) {
                    model.setValue("reqdeptfield", null);
                }
                if (model.getValue("materialfield") != null) {
                    model.setValue("materialfield", null);
                }
                if (model.getValue("projectfield") == null) break;
                model.setValue("projectfield", null);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        DynamicObject org = (DynamicObject)this.getModel().getValue("orgfield");
        switch (fieldKey) {
            case "orgfield": {
                List orgList = OrgHelper.getHasPermissionOrg((String)this.getView().getFormShowParameter().getFormId(), (String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (IFormView)this.getView());
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)orgList));
                break;
            }
            case "reqdeptfield": {
                if (org != null) break;
                this.showOrgTipNotification(beforeF7SelectEvent);
                return;
            }
            case "materialfield": 
            case "projectfield": {
                if (org == null) {
                    this.showOrgTipNotification(beforeF7SelectEvent);
                    return;
                }
                showParameter.setShowApproved(false);
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        DynamicObject org = filter.getDynamicObject("orgfield");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u6c42\u7ec4\u7ec7\u3002", (String)"PurReqBillRptPlugin_0", (String)"scmc-pm-report", (Object[])new Object[0]));
            return false;
        }
        Date startDate = filter.getDate("startdatefield");
        Date endDate = filter.getDate("enddatefield");
        if (startDate == null || endDate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u3002", (String)"PurReqBillRptPlugin_1", (String)"scmc-pm-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void showOrgTipNotification(BeforeF7SelectEvent beforeF7SelectEvent) {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u6c42\u7ec4\u7ec7\u3002", (String)"PurReqBillRptPlugin_0", (String)"scmc-pm-report", (Object[])new Object[0]));
        beforeF7SelectEvent.setCancel(true);
    }
}

