/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.pssc.business.pojo.ReturnResultInfo;
import kd.scm.pssc.common.utils.PsscTaskPoolUtil;

public class BotpHepler {
    private static final Log log = LogFactory.getLog(BotpHepler.class);

    public static ReturnResultInfo botpGenerateTargetBill(List<DynamicObject> sourceBills, String sourceEntity, String sourceEntryEntity, String targetEntity, String targetEntryEntity, String status, Map<String, String> param) {
        ReturnResultInfo returnResultInfo = new ReturnResultInfo();
        if (sourceBills != null && sourceBills.size() > 0) {
            PushArgs pushArgs = new PushArgs();
            pushArgs.setSourceEntityNumber(sourceEntity);
            pushArgs.setTargetEntityNumber(targetEntity);
            pushArgs.setBuildConvReport(true);
            if (param != null) {
                for (Map.Entry<String, String> entry : param.entrySet()) {
                    pushArgs.addCustomParam(entry.getKey(), entry.getValue());
                }
            }
            String ruleId = null;
            List loadRules = ConvertMetaServiceHelper.loadRules((String)sourceEntity, (String)targetEntity);
            if (loadRules != null && loadRules.size() > 0) {
                for (int i = 0; i < loadRules.size(); ++i) {
                    ConvertRuleElement loadRule = (ConvertRuleElement)loadRules.get(i);
                    boolean enabled = loadRule.isEnabled();
                    if (!enabled) continue;
                    if (loadRule.isDefRule()) {
                        ruleId = loadRule.getId();
                        break;
                    }
                    if (!StringUtils.isBlank(ruleId)) continue;
                    ruleId = loadRule.getId();
                }
            }
            pushArgs.setRuleId(ruleId);
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)targetEntity);
            IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

                public void fillReferenceData(Object[] dataEntitys, IDataEntityType dataType) {
                    BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dataType);
                }
            };
            ArrayList<Object> targetBills = new ArrayList<Object>();
            ArrayList<ListSelectedRow> sourceEntryRows = new ArrayList<ListSelectedRow>();
            for (int i = 0; i < sourceBills.size(); ++i) {
                DynamicObject sourceBill = sourceBills.get(i);
                DynamicObjectCollection cols = sourceBill.getDynamicObjectCollection(sourceEntryEntity);
                for (DynamicObject col : cols) {
                    ListSelectedRow row = new ListSelectedRow();
                    row.setPrimaryKeyValue(sourceBill.getPkValue());
                    row.setEntryEntityKey(targetEntryEntity);
                    row.setEntryPrimaryKeyValue(col.getPkValue());
                    sourceEntryRows.add(row);
                }
                pushArgs.setSelectedRows(sourceEntryRows);
            }
            ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
            if (result.isSuccess()) {
                List targetData = result.loadTargetDataObjects(refDataProvider, mainType);
                if (targetData != null && targetData.size() > 0) {
                    targetBills.addAll(targetData);
                }
            } else {
                log.info("\u6e90\u5355\u5355\u636e(" + sourceEntity + ")\u4e0b\u63a8\u76ee\u6807\u5355\u636e(" + targetEntity + ")\u5931\u8d25\uff1a" + result.getMessage());
                returnResultInfo.setSuccess(false);
                returnResultInfo.setMessage(result.getMessage());
                return returnResultInfo;
            }
            log.info("\u6e90\u5355\u5355\u636e(" + sourceEntity + ")\u4e0b\u63a8\u76ee\u6807\u5355\u636e(" + targetEntity + ")\u6210\u529f");
            if (targetBills != null && targetBills.size() > 0) {
                if (!("save".equals(status) || "submit".equals(status) || "audit".equals(status))) {
                    log.info("\u76ee\u6807\u5355\u636e(" + targetEntity + ")\u4e0b\u63a8\u6210\u529f\uff1a" + targetBills);
                    returnResultInfo.setSuccess(true);
                    returnResultInfo.setSuccessList(targetBills);
                    return returnResultInfo;
                }
                OperateOption option = OperateOption.create();
                option.setVariableValue("isStrict", String.valueOf(Boolean.FALSE));
                option.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
                option.setVariableValue("WF", String.valueOf(false));
                OperationResult saveResult = SaveServiceHelper.saveOperate((String)targetEntity, (DynamicObject[])targetBills.toArray(new DynamicObject[0]), (OperateOption)option);
                if (saveResult.isSuccess() && saveResult.getSuccessPkIds().size() > 0) {
                    List saveSuccessPkIds = saveResult.getSuccessPkIds();
                    if (!"submit".equals(status) && !"audit".equals(status)) {
                        log.info("\u76ee\u6807\u5355\u636e(" + targetEntity + ")\u4fdd\u5b58\u6210\u529f\uff1a" + saveSuccessPkIds);
                        returnResultInfo.setSuccess(true);
                        returnResultInfo.setSuccessList(saveSuccessPkIds);
                        return returnResultInfo;
                    }
                    OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)targetEntity, (Object[])saveSuccessPkIds.toArray(new Object[0]), (OperateOption)option);
                    if (submitResult.isSuccess() && submitResult.getSuccessPkIds().size() > 0) {
                        List submitSuccessPkIds = submitResult.getSuccessPkIds();
                        if (!"audit".equals(status)) {
                            log.info("\u76ee\u6807\u5355\u636e(" + targetEntity + ")\u63d0\u4ea4\u6210\u529f\uff1a" + submitSuccessPkIds);
                            returnResultInfo.setSuccess(true);
                            returnResultInfo.setSuccessList(submitSuccessPkIds);
                            return returnResultInfo;
                        }
                        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)targetEntity, (Object[])submitSuccessPkIds.toArray(new Object[0]), (OperateOption)option);
                        if (auditResult.isSuccess() && auditResult.getSuccessPkIds().size() > 0) {
                            List auditSuccessPkIds = auditResult.getSuccessPkIds();
                            log.info("\u76ee\u6807\u5355\u636e(" + targetEntity + ")\u5ba1\u6838\u6210\u529f\uff1a" + auditSuccessPkIds);
                            returnResultInfo.setSuccess(true);
                            returnResultInfo.setSuccessList(auditSuccessPkIds);
                            return returnResultInfo;
                        }
                        log.error("\u76ee\u6807\u5355\u636e(" + targetEntity + ")\u5ba1\u6838\u5f02\u5e38\uff1a" + BotpHepler.buildErrorInfoMessage(auditResult));
                        returnResultInfo.setSuccess(false);
                        returnResultInfo.setMessage(auditResult.getMessage());
                        return returnResultInfo;
                    }
                    log.error("\u76ee\u6807\u5355\u636e(" + targetEntity + ")\u63d0\u4ea4\u5f02\u5e38\uff1a" + BotpHepler.buildErrorInfoMessage(submitResult));
                    returnResultInfo.setSuccess(false);
                    returnResultInfo.setMessage(submitResult.getMessage());
                    return returnResultInfo;
                }
                log.error("\u76ee\u6807\u5355\u636e(" + targetEntity + ")\u4fdd\u5b58\u5f02\u5e38\uff1a" + BotpHepler.buildErrorInfoMessage(saveResult));
                returnResultInfo.setSuccess(false);
                returnResultInfo.setMessage(saveResult.getMessage());
                return returnResultInfo;
            }
        }
        returnResultInfo.setSuccess(false);
        return returnResultInfo;
    }

    public static ReturnResultInfo botpGenerateTargetBillByBillIds(Object[] billIds, String sourceEntity, String targetEntity, String status, Map<String, String> param) {
        ReturnResultInfo returnResultInfo = new ReturnResultInfo();
        if (billIds != null && billIds.length > 0) {
            PushArgs pushArgs = new PushArgs();
            pushArgs.setSourceEntityNumber(sourceEntity);
            pushArgs.setTargetEntityNumber(targetEntity);
            pushArgs.setBuildConvReport(true);
            if (param != null) {
                for (Map.Entry<String, String> entry : param.entrySet()) {
                    pushArgs.addCustomParam(entry.getKey(), entry.getValue());
                }
            }
            String ruleId = null;
            List loadRules = ConvertMetaServiceHelper.loadRules((String)sourceEntity, (String)targetEntity);
            if (loadRules != null && loadRules.size() > 0) {
                for (int i = 0; i < loadRules.size(); ++i) {
                    ConvertRuleElement loadRule = (ConvertRuleElement)loadRules.get(i);
                    boolean enabled = loadRule.isEnabled();
                    if (!enabled) continue;
                    if (loadRule.isDefRule()) {
                        ruleId = loadRule.getId();
                        break;
                    }
                    if (!StringUtils.isBlank(ruleId)) continue;
                    ruleId = loadRule.getId();
                }
            }
            pushArgs.setRuleId(ruleId);
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)targetEntity);
            IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

                public void fillReferenceData(Object[] dataEntitys, IDataEntityType dataType) {
                    BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dataType);
                }
            };
            ArrayList<DynamicObject> targetBills = new ArrayList<DynamicObject>(16);
            ArrayList<ListSelectedRow> sourceEntryRows = new ArrayList<ListSelectedRow>(16);
            for (Object billId : billIds) {
                ListSelectedRow row = new ListSelectedRow();
                row.setPrimaryKeyValue(billId);
                sourceEntryRows.add(row);
            }
            pushArgs.setSelectedRows(sourceEntryRows);
            ConvertOperationResult result = null;
            result = "save".equals(status) || "submit".equals(status) || "audit".equals(status) ? ConvertServiceHelper.pushAndSave((PushArgs)pushArgs) : ConvertServiceHelper.push((PushArgs)pushArgs);
            if (result.isSuccess() && result.getTargetBillIds().size() == 0) {
                List targetData = result.loadTargetDataObjects(refDataProvider, mainType);
                if (targetData != null && targetData.size() > 0) {
                    targetBills.addAll(targetData);
                }
                log.info("\u6e90\u5355\u5355\u636e(" + sourceEntity + ")\u4e0b\u63a8\u76ee\u6807\u5355\u636e(" + targetEntity + ")\u6210\u529f");
            } else if (result.isSuccess() && result.getTargetBillIds().size() > 0) {
                returnResultInfo.setSuccessList(Arrays.asList(result.getTargetBillIds().toArray()));
                returnResultInfo.setSuccess(result.isSuccess());
            } else {
                log.info("\u6e90\u5355\u5355\u636e(" + sourceEntity + ")\u4e0b\u63a8\u76ee\u6807\u5355\u636e(" + targetEntity + ")\u5931\u8d25\uff1a" + result.getMessage());
                returnResultInfo.setSuccess(false);
                List billReports = result.getBillReports();
                StringBuilder sb = new StringBuilder();
                for (SourceBillReport billReport : billReports) {
                    sb.append(billReport.getFailMessage());
                }
                returnResultInfo.setMessage(sb.toString());
                return returnResultInfo;
            }
            BotpHepler.dealReturnResultInfo(returnResultInfo, targetBills, status, targetEntity, true);
        }
        return returnResultInfo;
    }

    public static ReturnResultInfo botpGenerateTargetBillByBillId(Object billId, String sourceEntity, String targetEntity, String status, Map<String, String> param) {
        if (billId != null) {
            return BotpHepler.botpGenerateTargetBillByBillIds(new Object[]{billId}, sourceEntity, targetEntity, status, param);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static ReturnResultInfo botpGenerateTargetBill(Map<Long, Long> sourceIdMap, String ruleId, String sourceEntity, String sourceEntryEntity, String targetEntity, String targetEntryEntity, String status, Map<String, String> param, boolean ignoreFail) {
        ReturnResultInfo returnResultInfo = new ReturnResultInfo();
        returnResultInfo.setSuccess(false);
        if (sourceIdMap != null && sourceIdMap.size() > 0) {
            void var12_17;
            PushArgs pushArgs = new PushArgs();
            pushArgs.setSourceEntityNumber(sourceEntity);
            pushArgs.setTargetEntityNumber(targetEntity);
            pushArgs.setBuildConvReport(true);
            if (param != null) {
                for (Map.Entry<String, String> entry : param.entrySet()) {
                    pushArgs.addCustomParam(entry.getKey(), entry.getValue());
                }
            }
            pushArgs.setRuleId(ruleId);
            ArrayList<ListSelectedRow> sourceEntryRows = new ArrayList<ListSelectedRow>(sourceIdMap.size());
            for (Map.Entry<Long, Long> entry : sourceIdMap.entrySet()) {
                ListSelectedRow row = new ListSelectedRow();
                row.setPrimaryKeyValue((Object)entry.getValue());
                row.setEntryPrimaryKeyValue((Object)entry.getKey());
                row.setEntryEntityKey(targetEntryEntity);
                sourceEntryRows.add(row);
            }
            pushArgs.setSelectedRows(sourceEntryRows);
            Object var12_14 = null;
            if (StringUtils.equals((CharSequence)"save", (CharSequence)status)) {
                ConvertOperationResult convertOperationResult = ConvertServiceHelper.pushAndSave((PushArgs)pushArgs);
            } else {
                ConvertOperationResult convertOperationResult = ConvertServiceHelper.push((PushArgs)pushArgs);
            }
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)targetEntity);
            IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

                public void fillReferenceData(Object[] dataEntitys, IDataEntityType dataType) {
                    BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dataType);
                }
            };
            List targetBills = null;
            if (var12_17.isSuccess() && var12_17.getTargetBillIds().size() == 0) {
                targetBills = var12_17.loadTargetDataObjects(refDataProvider, mainEntityType);
                log.info("\u6e90\u5355\u5355\u636e(" + sourceEntity + ")\u4e0b\u63a8\u76ee\u6807\u5355\u636e(" + targetEntity + ")\u6210\u529f");
            } else if (var12_17.isSuccess() && var12_17.getTargetBillIds().size() > 0) {
                returnResultInfo.setSuccessList(Arrays.asList(var12_17.getTargetBillIds().toArray()));
                returnResultInfo.setSuccess(var12_17.isSuccess());
            } else {
                log.info("\u6e90\u5355\u5355\u636e(" + sourceEntity + ")\u4e0b\u63a8\u76ee\u6807\u5355\u636e(" + targetEntity + ")\u5931\u8d25\uff1a" + var12_17.getMessage());
                returnResultInfo.setSuccess(false);
                List billReports = var12_17.getBillReports();
                StringBuilder sb = new StringBuilder();
                for (SourceBillReport billReport : billReports) {
                    sb.append(billReport.getFailMessage());
                }
                returnResultInfo.setMessage(sb.toString());
                return returnResultInfo;
            }
            BotpHepler.dealReturnResultInfo(returnResultInfo, targetBills, status, targetEntity, ignoreFail);
        }
        return returnResultInfo;
    }

    private static void dealReturnResultInfo(ReturnResultInfo returnResultInfo, List<DynamicObject> targetBills, String status, String targetEntity, boolean ignoreFail) {
        if (targetBills != null && targetBills.size() > 0 && returnResultInfo != null) {
            if (!("save".equals(status) || "submit".equals(status) || "audit".equals(status))) {
                log.info("\u76ee\u6807\u5355\u636e(" + targetEntity + ")\u4e0b\u63a8\u6210\u529f\uff1a" + targetBills);
                returnResultInfo.setSuccess(true);
                returnResultInfo.setSuccessList(targetBills);
                return;
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("isStrict", String.valueOf(Boolean.FALSE));
            option.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
            option.setVariableValue("WF", String.valueOf(false));
            option.setVariableValue("vmioperate", Boolean.TRUE.toString());
            if (targetBills != null && targetBills.size() > 0) {
                OperationResult saveResult = SaveServiceHelper.saveOperate((String)targetEntity, (DynamicObject[])targetBills.toArray(new DynamicObject[0]), (OperateOption)option);
                if (saveResult != null && saveResult.getSuccessPkIds().size() > 0 && (ignoreFail || saveResult.isSuccess())) {
                    returnResultInfo.setSuccessList(saveResult.getSuccessPkIds());
                    returnResultInfo.setSuccess(saveResult.isSuccess());
                } else {
                    if (saveResult != null) {
                        log.error("\u76ee\u6807\u5355\u636e(" + targetEntity + ")\u4fdd\u5b58\u5f02\u5e38\uff1a" + BotpHepler.buildErrorInfoMessage(saveResult));
                        returnResultInfo.setSuccess(false);
                        returnResultInfo.setMessage(saveResult.getMessage());
                        return;
                    }
                    returnResultInfo.setSuccess(false);
                    return;
                }
            }
            if (returnResultInfo.getSuccessList() != null && returnResultInfo.getSuccessList().size() > 0 && (ignoreFail || returnResultInfo.isSuccess())) {
                List<Object> saveSuccessPkIds = returnResultInfo.getSuccessList();
                if (!"submit".equals(status) && !"audit".equals(status)) {
                    log.info("\u76ee\u6807\u5355\u636e(" + targetEntity + ")\u4fdd\u5b58\u6210\u529f\uff1a" + saveSuccessPkIds);
                    returnResultInfo.setSuccess(true);
                    returnResultInfo.setSuccessList(saveSuccessPkIds);
                    return;
                }
                OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)targetEntity, (Object[])saveSuccessPkIds.toArray(new Object[0]), (OperateOption)option);
                if (submitResult != null && submitResult.getSuccessPkIds().size() > 0 && (ignoreFail || submitResult.isSuccess())) {
                    List submitSuccessPkIds = submitResult.getSuccessPkIds();
                    if (!"audit".equals(status)) {
                        log.info("\u76ee\u6807\u5355\u636e(" + targetEntity + ")\u63d0\u4ea4\u6210\u529f\uff1a" + submitSuccessPkIds);
                        returnResultInfo.setSuccess(true);
                        returnResultInfo.setSuccessList(submitSuccessPkIds);
                        return;
                    }
                    OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)targetEntity, (Object[])submitSuccessPkIds.toArray(new Object[0]), (OperateOption)option);
                    if (auditResult != null && auditResult.getSuccessPkIds().size() > 0 && (ignoreFail || auditResult.isSuccess())) {
                        log.info("\u76ee\u6807\u5355\u636e(" + targetEntity + ")\u5ba1\u6838\u6210\u529f\uff1a" + auditResult.getSuccessPkIds());
                        returnResultInfo.setSuccess(true);
                        returnResultInfo.setSuccessList(auditResult.getSuccessPkIds());
                        return;
                    }
                    if (auditResult != null) {
                        log.error("\u76ee\u6807\u5355\u636e(" + targetEntity + ")\u5ba1\u6838\u5f02\u5e38\uff1a" + BotpHepler.buildErrorInfoMessage(auditResult));
                        returnResultInfo.setSuccess(false);
                        returnResultInfo.setMessage(auditResult.getMessage());
                        return;
                    }
                } else if (submitResult != null) {
                    log.error("\u76ee\u6807\u5355\u636e(" + targetEntity + ")\u63d0\u4ea4\u5f02\u5e38\uff1a" + BotpHepler.buildErrorInfoMessage(submitResult));
                    returnResultInfo.setSuccess(false);
                    returnResultInfo.setMessage(submitResult.getMessage());
                    return;
                }
            }
        }
    }

    private static String buildErrorInfoMessage(OperationResult opResult) {
        List allErrorInfos = opResult.getAllErrorInfo();
        StringBuilder sb = new StringBuilder();
        if (allErrorInfos != null) {
            for (OperateErrorInfo errorInfo : allErrorInfos) {
                String message = errorInfo.getMessage();
                sb.append(message);
            }
        }
        return sb.toString();
    }

    public static void showFormByOpResult(ReturnResultInfo op, IFormView view, String targetEntity, Map<String, Object> paramMap) {
        if (op != null) {
            if (op.isSuccess()) {
                List<Object> successPkIds = op.getSuccessList();
                if (successPkIds != null && successPkIds.size() == 1) {
                    OpenFormUtil.openBillPage((IFormView)view, (String)targetEntity, (Object)successPkIds.get(0), (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.MainNewTabPage, paramMap, null);
                } else {
                    OpenFormUtil.openListPage((IFormView)view, (String)targetEntity, (ShowType)ShowType.MainNewTabPage, paramMap, (QFilter)new QFilter("id", "in", successPkIds), null);
                }
            } else {
                view.showErrorNotification(op.getMessage());
            }
        }
    }

    public static void dealResult(List<ConvertOperationResult> successResult, List<ConvertOperationResult> errorResults, PushArgs args, IFormView view) {
        PsscTaskPoolUtil.dealResult(successResult, errorResults, (PushArgs)args, (IFormView)view);
    }
}

