/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.business.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.form.IFormView;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class OrgHelper {
    public static List<Long> getAllToOrg(String fromOrgType, String toOrgType, Long fromOrgId, boolean isIncludeFromOrgSelf) {
        List toOrgIds = OrgUnitServiceHelper.getAllToOrg((String)fromOrgType, (String)toOrgType, (Long)fromOrgId, (boolean)isIncludeFromOrgSelf);
        return toOrgIds;
    }

    public static List<Long> getHasPermissionOrg(String entityName, String orgViewType) {
        List hasPermissionOrgs = OrgViewServiceHelper.getAllPermissionOrgs((String)entityName, (String)orgViewType);
        if (CommonUtils.isNull((Object)hasPermissionOrgs)) {
            return null;
        }
        ArrayList<Long> orgs = new ArrayList<Long>(hasPermissionOrgs.size());
        for (Map tempOrg : hasPermissionOrgs) {
            Long tempOrgId = Long.valueOf((String)tempOrg.get("id"));
            orgs.add(tempOrgId);
        }
        return orgs;
    }

    public static List<Long> getHasPermissionOrg(String entityName, String orgViewType, IFormView view) {
        HasPermOrgResult allPermOrgs;
        String appId = null;
        if (view != null) {
            appId = view.getFormShowParameter().getAppId();
        }
        if ((allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)orgViewType, (String)appId, (String)entityName, (String)"47150e89000000ac", (boolean)true)) != null) {
            return allPermOrgs.getHasPermOrgs();
        }
        return null;
    }

    public static QFilter getHasPermissionOrgFilter(String entityName, String orgViewType, IFormView view) {
        HasPermOrgResult allPermOrgs;
        String appId = null;
        if (view != null) {
            appId = view.getFormShowParameter().getAppId();
        }
        if ((allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)orgViewType, (String)appId, (String)entityName, (String)"47150e89000000ac", (boolean)false)) != null) {
            if (allPermOrgs.hasAllOrgPerm()) {
                return null;
            }
            return new QFilter("id", "in", (Object)allPermOrgs.getHasPermOrgs());
        }
        return new QFilter("1", "!=", (Object)"1");
    }

    public static Long getDefaultOrg(String entityName, String orgViewType) {
        return OrgHelper.getDefaultOrg(entityName, orgViewType, null);
    }

    public static Long getDefaultOrg(String entityName, String orgViewType, IFormView view) {
        long orgId = RequestContext.get().getOrgId();
        List<Long> orgs = OrgHelper.getHasPermissionOrg(entityName, orgViewType, view);
        if (orgs == null || orgs.size() == 0) {
            return null;
        }
        if (orgs.contains(orgId)) {
            return orgId;
        }
        return orgs.get(0);
    }

    public static OrgRelationParam buildOrgRelationParam(Long orgId, String fromViewType, String toViewType, String getDirectOrgType) {
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgId(orgId.longValue());
        param.setFromViewType(fromViewType);
        param.setToViewType(toViewType);
        param.setDirectViewType(getDirectOrgType);
        return param;
    }
}

