/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class PsscMalHelper {
    private static final Log log = LogFactory.getLog(PsscMalHelper.class);
    public static final String MAL_PLAN_ID_KEY = "malPlanIds";
    public static final String SELECTED_ROWS_KEY = "selectedRows";

    public static Map<String, Object> malPurchase(OperateOption option, ExtendedDataEntity[] dataEntities) {
        HashMap<String, List<Map<String, Object>>> param = new HashMap<String, List<Map<String, Object>>>(dataEntities.length << 1);
        ArrayList<Long> srcentryidList = new ArrayList<Long>();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject task = dataEntity.getDataEntity();
            String srcentryid = task.getString("srcentryid");
            srcentryidList.add(Long.parseLong(srcentryid));
        }
        QFilter filter = new QFilter("billentry.id", "in", srcentryidList);
        DynamicObjectCollection pm_purapplybills = QueryServiceHelper.query((String)"pm_purapplybill", (String)"id, billentry.id entryid, billentry.joinqty joinqty", (QFilter[])filter.toArray());
        PsscMalHelper.buildMalPlanParam(param, pm_purapplybills);
        if (param.isEmpty()) {
            return null;
        }
        Map<String, Object> serviceResult = PsscMalHelper.pushMalPlan(param);
        if (serviceResult == null) {
            return null;
        }
        Boolean success = (Boolean)serviceResult.get("success");
        if (success == null || !success.booleanValue()) {
            return serviceResult;
        }
        List result = (List)serviceResult.get("result");
        if (result == null || result.isEmpty()) {
            return null;
        }
        option.setVariableValue(MAL_PLAN_ID_KEY, PsscMalHelper.longCollection2Str(result));
        return serviceResult;
    }

    public static FormShowParameter getMalPurchaseShowParameter(EventObject e) {
        String malPlanIdStr = PsscMalHelper.getCustomParam(e, MAL_PLAN_ID_KEY);
        if (malPlanIdStr == null) {
            return null;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCustomParam(MAL_PLAN_ID_KEY, PsscMalHelper.string2LongList(malPlanIdStr));
        showParameter.setFormId("mal_purchase");
        Map<String, List<String>> selectedEntryIdMap = PsscMalHelper.getSelectedEntryIdMap(e);
        if (selectedEntryIdMap != null && !selectedEntryIdMap.isEmpty()) {
            HashSet<String> srcEntryIds = new HashSet<String>(16);
            for (List<String> value : selectedEntryIdMap.values()) {
                srcEntryIds.addAll(value);
            }
            showParameter.setCustomParam("srcentryids", srcEntryIds);
        }
        showParameter.getOpenStyle().setShowType(ShowType.NewWindow);
        return showParameter;
    }

    public static String getCustomParam(EventObject eventObject, String key) {
        Object source = eventObject.getSource();
        if (source instanceof FormOperate) {
            return PsscMalHelper.getCustomParam(((FormOperate)source).getOption(), key);
        }
        return null;
    }

    private static void buildMalPlanParam(Map<String, List<Map<String, Object>>> param, DynamicObjectCollection dynamicObjectCollection) {
        for (DynamicObject row : dynamicObjectCollection) {
            List<Map<String, Object>> paramlist = param.get(row.getString("id"));
            if (paramlist == null) {
                ArrayList infoList = new ArrayList();
                HashMap<String, Object> entryinfoMap = new HashMap<String, Object>();
                entryinfoMap.put("entryid", row.get("entryid"));
                entryinfoMap.put("joinqty", row.get("joinqty"));
                infoList.add(entryinfoMap);
                param.put(row.getString("id"), infoList);
                continue;
            }
            HashMap<String, Object> entryinfoMap = new HashMap<String, Object>();
            entryinfoMap.put("entryid", row.get("entryid"));
            entryinfoMap.put("joinqty", row.get("joinqty"));
            paramlist.add(entryinfoMap);
        }
    }

    private static Map<String, Object> pushMalPlan(Map<String, List<Map<String, Object>>> param) {
        log.info("\u91c7\u8d2d\u7533\u8bf7\u5355\u8c03\u7528\u5546\u57ce\u91c7\u8d2d\u8ba1\u5212\u5fae\u670d\u52a1 \u53c2\u6570\uff1a" + param);
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"mal", (String)"MalPushPlanService", (String)"pushMalPlan", (Object[])new Object[]{param});
        log.info("\u91c7\u8d2d\u7533\u8bf7\u5355\u8c03\u7528\u5546\u57ce\u91c7\u8d2d\u8ba1\u5212\u5fae\u670d\u52a1 \u8fd4\u56de\u503c\uff1a" + result);
        return result;
    }

    private static String longCollection2Str(Collection<Long> collection) {
        return collection.stream().map(Object::toString).collect(Collectors.joining(","));
    }

    private static List<Long> string2LongList(String str) {
        return Arrays.stream(str.split(",")).map(Long::parseLong).collect(Collectors.toList());
    }

    private static Map<String, List<String>> getSelectedEntryIdMap(EventObject e) {
        String param = PsscMalHelper.getCustomParam(e, SELECTED_ROWS_KEY);
        if (param == null) {
            return new HashMap<String, List<String>>(2);
        }
        return (Map)SerializationUtils.fromJsonString((String)param, Map.class);
    }

    private static String getCustomParam(OperateOption option, String key) {
        return option.getVariableValue(key, null);
    }
}

