/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.business.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.MaterialGroupStandardUtils;
import kd.scm.pssc.business.pojo.PsscPackageGroupRuleInfo;
import kd.sdk.scm.pssc.packagegroup.IPsscPackageGroupPrepareExecutor;
import kd.sdk.scm.pssc.packagegroup.pojo.PsscMaterialGroupInfo;
import kd.sdk.scm.pssc.packagegroup.pojo.PsscPackageGroupContext;
import kd.sdk.scm.pssc.packagegroup.pojo.PsscTagGroupRuleOrderInfo;

public final class PsscPackageGroupDefaultExecutor
implements IPsscPackageGroupPrepareExecutor {
    public void prepareData(PsscPackageGroupContext context) {
        Map rules = context.getRules();
        Set entries = rules.entrySet();
        Iterator iterator = entries.iterator();
        HashSet<Long> categoryIds = new HashSet<Long>(16);
        HashSet<Long> materialIds = new HashSet<Long>(16);
        HashMap<String, String> materialToTag = new HashMap<String, String>(16);
        HashMap<String, String> categoryToTag = new HashMap<String, String>(16);
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            TreeSet values = (TreeSet)next.getValue();
            Long key = (Long)next.getKey();
            for (PsscTagGroupRuleOrderInfo value : values) {
                if (!(value instanceof PsscPackageGroupRuleInfo)) continue;
                List<DynamicObject> specialRule = ((PsscPackageGroupRuleInfo)value).getSpecialRule();
                for (DynamicObject info : specialRule) {
                    long materialId;
                    long categoryId = info.getLong("category_id");
                    if (categoryId != 0L) {
                        categoryToTag.put(categoryId + "-" + key, info.getString("packagegroup"));
                        categoryIds.add(categoryId);
                    }
                    if ((materialId = info.getLong("material_id")) == 0L) continue;
                    materialToTag.put(materialId + "-" + key, info.getString("packagegroup"));
                    materialIds.add(materialId);
                }
            }
        }
        context.setMaterialHanderTag(materialToTag);
        context.setCategoryToTag(categoryToTag);
        Map unDealTask = context.getUnDealTask();
        for (Map.Entry next : unDealTask.entrySet()) {
            JSONObject value = (JSONObject)next.getValue();
            Long material = value.getLong("material");
            materialIds.add(material);
        }
        Long standardId = MaterialGroupStandardUtils.getMaterialGroupType((String)context.getFormId());
        if (materialIds.size() > 0) {
            QFilter qFilter = new QFilter("standard.id", "=", (Object)standardId);
            qFilter.and("material.id", "in", materialIds);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_materialgroupdetail", (String)"group.number groupnumber,group.parent.id groupparentid ,group.longnumber longnumber,group.name groupname,group.id groupid,material.id materialid", (QFilter[])new QFilter[]{qFilter}, null);
            HashMap<Long, PsscMaterialGroupInfo> materialGroupInfoMap = new HashMap<Long, PsscMaterialGroupInfo>(16);
            for (Row row : dataSet) {
                categoryIds.add(row.getLong("groupid"));
                materialGroupInfoMap.put(row.getLong("materialid"), new PsscMaterialGroupInfo(row.getLong("groupid"), row.getLong("groupparentid"), row.getString("groupname")));
            }
            context.setMaterialGroupInfoMap(materialGroupInfoMap);
        }
        if (categoryIds.size() > 0) {
            Map<Long, LinkedList<PsscMaterialGroupInfo>> longNumMapByCategory = this.getLongNumMapByCategory(categoryIds, standardId);
            context.setLongNumMapByCategory(longNumMapByCategory);
        }
    }

    private Map<Long, LinkedList<PsscMaterialGroupInfo>> getLongNumMapByCategory(Set<Long> categoryIds, Long standardId) {
        HashMap<Long, LinkedList<PsscMaterialGroupInfo>> resultList = new HashMap<Long, LinkedList<PsscMaterialGroupInfo>>();
        HashMap longNumbers = new HashMap();
        HashSet<String> numbers = new HashSet<String>();
        QFilter qFilter = new QFilter("id", "in", categoryIds);
        qFilter.and("standard", "=", (Object)standardId);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PsscCommonUtils_number", (String)"bd_materialgroup", (String)"id,number,longnumber", (QFilter[])new QFilter[]{qFilter}, null);){
            for (Object row : dataSet) {
                LinkedList<String> number = (LinkedList<String>)longNumbers.get(row.getLong("id"));
                if (number == null) {
                    number = new LinkedList<String>();
                    longNumbers.put(row.getLong("id"), number);
                }
                if (!StringUtils.isNotBlank((CharSequence)row.getString("longnumber"))) continue;
                String[] longnumbers = row.getString("longnumber").split("!");
                for (int i = 0; i < longnumbers.length; ++i) {
                    number.add(longnumbers[i]);
                    numbers.add(longnumbers[i]);
                }
            }
        }
        if (numbers.size() > 0) {
            HashMap<String, PsscMaterialGroupInfo> categoryNumber = new HashMap<String, PsscMaterialGroupInfo>();
            qFilter = new QFilter("number", "in", numbers);
            qFilter.and("standard", "=", (Object)standardId);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PsscCommonUtils_group", (String)"bd_materialgroup", (String)"id,parent,name,number", (QFilter[])new QFilter[]{qFilter}, null);
            Object object = null;
            try {
                for (Row row : dataSet) {
                    categoryNumber.put(row.getString("number"), new PsscMaterialGroupInfo(row.getLong("id"), row.getLong("parent"), row.getString("name")));
                }
            }
            catch (Throwable row) {
                object = row;
                throw row;
            }
            finally {
                if (dataSet != null) {
                    if (object != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable row) {
                            ((Throwable)object).addSuppressed(row);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
            for (Map.Entry next : longNumbers.entrySet()) {
                Long key = (Long)next.getKey();
                LinkedList<PsscMaterialGroupInfo> longs = (LinkedList<PsscMaterialGroupInfo>)resultList.get(key);
                if (longs == null) {
                    longs = new LinkedList<PsscMaterialGroupInfo>();
                    resultList.put(key, longs);
                }
                LinkedList value = (LinkedList)next.getValue();
                for (String s : value) {
                    PsscMaterialGroupInfo aLong = (PsscMaterialGroupInfo)categoryNumber.get(s);
                    if (aLong == null) continue;
                    longs.add(aLong);
                }
            }
        }
        return resultList;
    }
}

