/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.CustomAggFunction;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;

public class ReqSumPathHelper {
    private static final Log logger = LogFactory.getLog(ReqSumPathHelper.class);

    /*
     * WARNING - void declaration
     */
    public static List<OutParameter> queryReqGatherPath(List<InParameter> parameterList) {
        Object queryRows;
        Set kindSet = parameterList.stream().map(InParameter::getKind).collect(Collectors.toSet());
        kindSet.add("C");
        Set orgSet = parameterList.stream().map(InParameter::getOrg).collect(Collectors.toSet());
        QFilter filter = new QFilter("reqkind", "in", kindSet);
        filter.and("enable", "=", (Object)"1");
        HashSet<Long> materialGroupSet = new HashSet<Long>(16);
        ArrayList<TransformDataInfo> transformDataInfoList = new ArrayList<TransformDataInfo>(16);
        try (DataSet rows = QueryServiceHelper.queryDataSet((String)"ReqSumPathHelper_01", (String)"pm_reqpathsettings", (String)"id,org,entry.material material,entry.materialgroup materialgroup", (QFilter[])filter.toArray(), null);){
            GroupbyDataSet groupbyDataSet = rows.groupBy(new String[]{"id", "org"});
            queryRows = ReqSumPathHelper.aggDataSet(groupbyDataSet).finish();
            Iterator iterator = queryRows.iterator();
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                String materialGroup = row.getString("materialgroup");
                transformDataInfoList.add(new TransformDataInfo(row.getLong("id"), row.getLong("org"), row.getString("material"), materialGroup));
                materialGroupSet.addAll(ReqSumPathHelper.getStrList(materialGroup));
            }
        }
        QFilter bdOrgFilter = new QFilter("enable", "=", (Object)"1");
        bdOrgFilter.and("reqkind", "in", kindSet);
        bdOrgFilter.and("entryentity.bdorg", "in", orgSet);
        ArrayList<TransformDataInfo> converterInfoList = new ArrayList<TransformDataInfo>(16);
        DataSet rows = QueryServiceHelper.queryDataSet((String)"ReqSumPathHelper_02", (String)"pm_reqpathsettings", (String)"id,reqkind,entry.material material,entry.materialgroup materialgroup,entryentity.bdorg bdorg", (QFilter[])bdOrgFilter.toArray(), null);
        queryRows = null;
        try {
            GroupbyDataSet groupbyDataSet = rows.groupBy(new String[]{"id", "reqkind"});
            groupbyDataSet = ReqSumPathHelper.aggGroupbyDataSet(groupbyDataSet);
            DataSet queryRows2 = ReqSumPathHelper.aggDataSet(groupbyDataSet).finish();
            for (Row row : queryRows2) {
                String materialGroup = row.getString("materialgroup");
                converterInfoList.add(new TransformDataInfo(row.getLong("id"), row.getString("reqkind"), row.getString("material"), materialGroup, row.getString("bdorg")));
                materialGroupSet.addAll(ReqSumPathHelper.getStrList(materialGroup));
            }
        }
        catch (Throwable groupbyDataSet) {
            queryRows = groupbyDataSet;
            throw groupbyDataSet;
        }
        finally {
            if (rows != null) {
                if (queryRows != null) {
                    try {
                        rows.close();
                    }
                    catch (Throwable groupbyDataSet) {
                        ((Throwable)queryRows).addSuppressed(groupbyDataSet);
                    }
                } else {
                    rows.close();
                }
            }
        }
        MaterialGroupInfo materialGroupInfo = ReqSumPathHelper.getMaterialGroupMultiValue(materialGroupSet);
        MultiValuedMap<Long, Long> materialGroupMultiValue = materialGroupInfo.getValue();
        MultiValuedMap<Long, Long> groupLevelValue = materialGroupInfo.getGroupLevel();
        ArrayList<OutParameter> outParameterList = new ArrayList<OutParameter>(16);
        for (InParameter inParameter : parameterList) {
            List<Long> materialIdList;
            List<Long> materialGroupList;
            Long material = inParameter.getMaterial();
            String kind = inParameter.getKind();
            String uniqueKey = inParameter.getUniqueKey();
            String classType = inParameter.getClassType();
            boolean material_control_01 = false;
            boolean material_control_02 = false;
            if (!StringUtils.equals((CharSequence)classType, (CharSequence)"2")) {
                for (TransformDataInfo row : transformDataInfoList) {
                    String materialStr = row.getMaterialStr();
                    List<Long> list = ReqSumPathHelper.getStrList(materialStr);
                    String materialGroupStr = row.getMaterialGroupStr();
                    materialGroupList = ReqSumPathHelper.getStrList(materialGroupStr);
                    if (list.size() <= 0 && materialGroupList.size() <= 0) {
                        material_control_01 = true;
                        break;
                    }
                    List<Long> materialIdList2 = ReqSumPathHelper.getMaterialList(materialGroupList, materialGroupMultiValue, groupLevelValue);
                    materialIdList2.addAll(list);
                    if (!materialIdList2.contains(material)) continue;
                    material_control_02 = true;
                    break;
                }
            }
            if (!material_control_01 && !material_control_02) {
                outParameterList.add(new OutParameter(uniqueKey, "true"));
                continue;
            }
            Long org = inParameter.getOrg();
            boolean flag = false;
            for (TransformDataInfo transformDataInfo : transformDataInfoList) {
                List<Long> materialList = ReqSumPathHelper.getStrList(transformDataInfo.getMaterialStr());
                materialGroupList = ReqSumPathHelper.getStrList(transformDataInfo.getMaterialGroupStr());
                Long queryOrg = transformDataInfo.getOrg();
                if (materialList.size() <= 0 && materialGroupList.size() <= 0 && org.equals(queryOrg)) {
                    flag = true;
                    break;
                }
                materialIdList = ReqSumPathHelper.getMaterialList(materialGroupList, materialGroupMultiValue, groupLevelValue);
                materialIdList.addAll(materialList);
                if (!materialIdList.contains(material) || !org.equals(queryOrg)) continue;
                flag = true;
                break;
            }
            List<TransformDataInfo> bdTransformDataInfo = ReqSumPathHelper.getTransformDataInfo(org, kind, converterInfoList);
            if (flag) {
                if (bdTransformDataInfo.size() > 0) {
                    for (TransformDataInfo info : bdTransformDataInfo) {
                        List<Long> materialList = ReqSumPathHelper.getStrList(info.getMaterialStr());
                        List<Long> materialGroupList2 = ReqSumPathHelper.getStrList(info.getMaterialGroupStr());
                        if (materialList.size() <= 0 && materialGroupList2.size() <= 0) {
                            flag = false;
                        } else {
                            materialIdList = ReqSumPathHelper.getMaterialList(materialGroupList2, materialGroupMultiValue, groupLevelValue);
                            materialIdList.addAll(materialList);
                            if (!materialIdList.contains(material)) continue;
                            flag = false;
                        }
                        break;
                    }
                }
            } else if (bdTransformDataInfo.size() > 0) {
                void var23_39;
                boolean bl = false;
                for (TransformDataInfo info : bdTransformDataInfo) {
                    List<Long> materialList = ReqSumPathHelper.getStrList(info.getMaterialStr());
                    List<Long> materialGroupList3 = ReqSumPathHelper.getStrList(info.getMaterialGroupStr());
                    if (materialList.size() > 0 || materialGroupList3.size() > 0) {
                        List<Long> materialIdList3 = ReqSumPathHelper.getMaterialList(materialGroupList3, materialGroupMultiValue, groupLevelValue);
                        materialIdList3.addAll(materialList);
                        if (!materialIdList3.contains(material)) continue;
                        flag = false;
                        boolean bl2 = true;
                        break;
                    }
                    flag = false;
                    boolean bl3 = true;
                    break;
                }
                if (var23_39 == false) {
                    flag = true;
                }
            } else {
                flag = true;
            }
            if (flag) {
                outParameterList.add(new OutParameter(uniqueKey, "true"));
                continue;
            }
            outParameterList.add(new OutParameter(uniqueKey, "false"));
        }
        transformDataInfoList.clear();
        transformDataInfoList = null;
        converterInfoList.clear();
        converterInfoList = null;
        materialGroupMultiValue.clear();
        materialGroupMultiValue = null;
        groupLevelValue.clear();
        groupLevelValue = null;
        return outParameterList;
    }

    private static List<TransformDataInfo> getTransformDataInfo(Long bdOrg, String reqKind, List<TransformDataInfo> converterInfoList) {
        return converterInfoList.stream().filter(info -> (info.getReqKind().equals(reqKind) || info.getReqKind().equals("C")) && ReqSumPathHelper.getStrList(info.getBdOrgStr()).contains(bdOrg)).collect(Collectors.toList());
    }

    private static List<Long> getStrList(String originStr) {
        List<String> materialList = Arrays.asList(originStr.split(","));
        List<Long> transferList = materialList.stream().map(row -> Long.valueOf(row)).collect(Collectors.toList());
        transferList.remove(0L);
        return transferList;
    }

    public static MaterialGroupInfo getMaterialGroupMultiValue(Set<Long> materialGroupList) {
        ArrayListValuedHashMap value = new ArrayListValuedHashMap(16);
        ArrayListValuedHashMap groupLevel = new ArrayListValuedHashMap(16);
        if (materialGroupList.size() > 0) {
            QFilter tempFilter = new QFilter("id", "in", materialGroupList);
            Map materialGroup = BusinessDataServiceHelper.loadFromCache((String)"bd_materialgroup", (String)"id,longnumber", (QFilter[])tempFilter.toArray());
            HashMap<Long, String> idLongNumberMap = new HashMap<Long, String>(16);
            HashSet<String> longNumberList = new HashSet<String>(16);
            for (Object row : materialGroup.values()) {
                Long id = (Long)row.getPkValue();
                String longNumber = row.getString("longnumber");
                if (longNumber == null || id == null) continue;
                idLongNumberMap.put(id, longNumber);
                longNumberList.add(longNumber);
            }
            QFilter materialGroupFilter = null;
            for (String longNumber : longNumberList) {
                if (materialGroupFilter == null) {
                    materialGroupFilter = new QFilter("longnumber", "like", (Object)longNumber.concat("%"));
                    continue;
                }
                materialGroupFilter.or(new QFilter("longnumber", "like", (Object)longNumber.concat("%")));
            }
            if (materialGroupFilter != null) {
                Map allMaterialGroup = BusinessDataServiceHelper.loadFromCache((String)"bd_materialgroup", (String)"id,longnumber", (QFilter[])materialGroupFilter.toArray());
                Collection allMaterialGroupValue = allMaterialGroup.values();
                for (Map.Entry entry : idLongNumberMap.entrySet()) {
                    Long key = (Long)entry.getKey();
                    String val = (String)entry.getValue();
                    for (Object obj : allMaterialGroupValue) {
                        String longNumber = obj.getString("longnumber");
                        Long id = (Long)obj.getPkValue();
                        if (longNumber == null || id == null || longNumber.equals(val) || !longNumber.contains(val)) continue;
                        groupLevel.put((Object)key, (Object)id);
                    }
                }
                Set materialGroupIdSet = allMaterialGroupValue.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
                logger.info("ReqSumPathHelper materialgroup number is:{}", (Object)materialGroupIdSet.size());
                QFilter qFilter = new QFilter("group", "in", materialGroupIdSet);
                int materialCount = ORM.create().count("alog_reqsumpathhelper_08", "bd_materialgroupdetail", qFilter.toArray());
                logger.info("ReqSumPathHelper material number is:{}", (Object)materialCount);
                int materialMaxNum = 500000;
                if (materialCount > materialMaxNum) {
                    Object obj;
                    DataSet rows = QueryServiceHelper.queryDataSet((String)"alog_reqsumpathhelper_09", (String)"bd_materialgroupdetail", (String)"material,group", (QFilter[])qFilter.toArray(), null);
                    obj = null;
                    try {
                        for (DynamicObject row : rows) {
                            Long groupId = row.getLong("group");
                            Long materialId = row.getLong("material");
                            if (groupId == null || materialId == null) continue;
                            value.put((Object)groupId, (Object)materialId);
                        }
                    }
                    catch (Throwable throwable) {
                        obj = throwable;
                        throw throwable;
                    }
                    finally {
                        if (rows != null) {
                            if (obj != null) {
                                try {
                                    rows.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)obj).addSuppressed(throwable);
                                }
                            } else {
                                rows.close();
                            }
                        }
                    }
                } else {
                    Map materialGroupDetail = BusinessDataServiceHelper.loadFromCache((String)"bd_materialgroupdetail", (String)"material,group", (QFilter[])qFilter.toArray());
                    Collection values = materialGroupDetail.values();
                    for (DynamicObject row : values) {
                        DynamicObject group = row.getDynamicObject("group");
                        DynamicObject material = row.getDynamicObject("material");
                        if (group == null || material == null) continue;
                        Long groupId = group.getLong("id");
                        Long materialId = material.getLong("id");
                        value.put((Object)groupId, (Object)materialId);
                    }
                }
            }
        }
        MaterialGroupInfo materialGroupInfo = new MaterialGroupInfo((MultiValuedMap<Long, Long>)value, (MultiValuedMap<Long, Long>)groupLevel);
        return materialGroupInfo;
    }

    public static List<Long> getMaterialList(List<Long> materialGroupList, MultiValuedMap<Long, Long> materialGroupMultiValue, MultiValuedMap<Long, Long> groupLevelValue) {
        ArrayList<Long> materialList = new ArrayList<Long>(16);
        if (materialGroupList.size() > 0 && materialGroupMultiValue.size() > 0) {
            for (Long groupId : materialGroupList) {
                Collection lowerGroupLevel;
                Collection multiValue = materialGroupMultiValue.get((Object)groupId);
                if (multiValue != null && multiValue.size() > 0) {
                    materialList.addAll(multiValue);
                }
                if ((lowerGroupLevel = groupLevelValue.get((Object)groupId)) == null || lowerGroupLevel.size() <= 0) continue;
                for (Long lowerGroupId : lowerGroupLevel) {
                    Collection lowerGroupLevelValue = materialGroupMultiValue.get((Object)lowerGroupId);
                    if (lowerGroupLevelValue == null || lowerGroupLevelValue.size() <= 0) continue;
                    materialList.addAll(lowerGroupLevelValue);
                }
            }
        }
        return materialList;
    }

    private static GroupbyDataSet aggGroupbyDataSet(GroupbyDataSet groupDataSet) {
        GroupbyDataSet aggDataSetBdOrg = groupDataSet.agg((CustomAggFunction)new CustomAggFunction<StringBuilder>("bdorg", (DataType)DataType.LongType){

            public StringBuilder newAggValue() {
                return new StringBuilder();
            }

            public StringBuilder addValue(StringBuilder aggValue, Object value) {
                aggValue.append(value).append(',');
                return aggValue;
            }

            public StringBuilder combineAggValue(StringBuilder aggValue, StringBuilder aggValue2) {
                aggValue.append((CharSequence)aggValue2);
                return aggValue;
            }

            public Object getResult(StringBuilder aggValue) {
                return aggValue.toString();
            }
        }, "bdorg", "bdorg");
        return aggDataSetBdOrg;
    }

    private static GroupbyDataSet aggDataSet(GroupbyDataSet groupDataSet) {
        GroupbyDataSet aggDataSetMaterial = groupDataSet.agg((CustomAggFunction)new CustomAggFunction<StringBuilder>("material", (DataType)DataType.LongType){

            public StringBuilder newAggValue() {
                return new StringBuilder();
            }

            public StringBuilder addValue(StringBuilder aggValue, Object value) {
                aggValue.append(value).append(',');
                return aggValue;
            }

            public StringBuilder combineAggValue(StringBuilder aggValue, StringBuilder aggValue2) {
                aggValue.append((CharSequence)aggValue2);
                return aggValue;
            }

            public Object getResult(StringBuilder aggValue) {
                return aggValue.toString();
            }
        }, "material", "material");
        GroupbyDataSet dataSetMaterialGroup = aggDataSetMaterial.agg((CustomAggFunction)new CustomAggFunction<StringBuilder>("materialgroup", (DataType)DataType.LongType){

            public StringBuilder newAggValue() {
                return new StringBuilder();
            }

            public StringBuilder addValue(StringBuilder aggValue, Object value) {
                aggValue.append(value).append(',');
                return aggValue;
            }

            public StringBuilder combineAggValue(StringBuilder aggValue, StringBuilder aggValue2) {
                aggValue.append((CharSequence)aggValue2);
                return aggValue;
            }

            public Object getResult(StringBuilder aggValue) {
                return aggValue.toString();
            }
        }, "materialgroup", "materialgroup");
        return dataSetMaterialGroup;
    }

    public static class MaterialGroupInfo {
        private MultiValuedMap<Long, Long> value;
        private MultiValuedMap<Long, Long> groupLevel;

        public MaterialGroupInfo(MultiValuedMap<Long, Long> value, MultiValuedMap<Long, Long> groupLevel) {
            this.value = value;
            this.groupLevel = groupLevel;
        }

        public MultiValuedMap<Long, Long> getValue() {
            return this.value;
        }

        public MultiValuedMap<Long, Long> getGroupLevel() {
            return this.groupLevel;
        }
    }

    public static class OutParameter {
        public String uniqueKey;
        public String value;

        public OutParameter() {
        }

        public OutParameter(String uniqueKey, String value) {
            this.uniqueKey = uniqueKey;
            this.value = value;
        }

        public String getUniqueKey() {
            return this.uniqueKey;
        }

        public void setUniqueKey(String uniqueKey) {
            this.uniqueKey = uniqueKey;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            return "OutParameter{uniqueKey='" + this.uniqueKey + '\'' + ", value='" + this.value + '\'' + '}';
        }
    }

    public static class InParameter {
        public Long org;
        public String kind;
        public Long material;
        public String uniqueKey;
        public String classType;

        public InParameter() {
        }

        public InParameter(Long org, String kind, Long material, String uniqueKey) {
            this.org = org;
            this.kind = kind;
            this.material = material;
            this.uniqueKey = uniqueKey;
        }

        public InParameter(Long org, String kind, Long material, String uniqueKey, String classType) {
            this.org = org;
            this.kind = kind;
            this.material = material;
            this.uniqueKey = uniqueKey;
            this.classType = classType;
        }

        public Long getOrg() {
            return this.org;
        }

        public void setOrg(Long org) {
            this.org = org;
        }

        public String getKind() {
            return this.kind;
        }

        public void setKind(String kind) {
            this.kind = kind;
        }

        public Long getMaterial() {
            return this.material;
        }

        public void setMaterial(Long material) {
            this.material = material;
        }

        public String getUniqueKey() {
            return this.uniqueKey;
        }

        public void setUniqueKey(String uniqueKey) {
            this.uniqueKey = uniqueKey;
        }

        public String getClassType() {
            return this.classType;
        }

        public void setClassType(String classType) {
            this.classType = classType;
        }

        public String toString() {
            return "InParameter{org='" + this.org + '\'' + ", kind='" + this.kind + '\'' + ", material='" + this.material + '\'' + ", uniqueKey='" + this.uniqueKey + '\'' + ", classType='" + this.classType + '\'' + '}';
        }
    }

    public static class TransformDataInfo {
        private Long id;
        private Long org;
        private String materialStr;
        private String materialGroupStr;
        private String bdOrgStr;
        private Long bdOrg;
        private String reqKind;

        public TransformDataInfo(Long id, Long org, String materialStr, String materialGroupStr) {
            this.id = id;
            this.org = org;
            this.materialStr = materialStr;
            this.materialGroupStr = materialGroupStr;
        }

        public TransformDataInfo(Long id, String reqKind, String materialStr, String materialGroupStr, String bdOrgStr) {
            this.id = id;
            this.reqKind = reqKind;
            this.materialStr = materialStr;
            this.materialGroupStr = materialGroupStr;
            this.bdOrgStr = bdOrgStr;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public Long getOrg() {
            return this.org;
        }

        public void setOrg(Long org) {
            this.org = org;
        }

        public String getMaterialStr() {
            return this.materialStr;
        }

        public void setMaterialStr(String materialStr) {
            this.materialStr = materialStr;
        }

        public String getMaterialGroupStr() {
            return this.materialGroupStr;
        }

        public void setMaterialGroupStr(String materialGroupStr) {
            this.materialGroupStr = materialGroupStr;
        }

        public String getBdOrgStr() {
            return this.bdOrgStr;
        }

        public void setBdOrgStr(String bdOrgStr) {
            this.bdOrgStr = bdOrgStr;
        }

        public Long getBdOrg() {
            return this.bdOrg;
        }

        public void setBdOrg(Long bdOrg) {
            this.bdOrg = bdOrg;
        }

        public String getReqKind() {
            return this.reqKind;
        }

        public void setReqKind(String reqKind) {
            this.reqKind = reqKind;
        }

        public String toString() {
            return "TransformDataInfo{id=" + this.id + ", org=" + this.org + ", materialStr='" + this.materialStr + '\'' + ", materialGroupStr='" + this.materialGroupStr + '\'' + ", bdOrgStr='" + this.bdOrgStr + '\'' + '}';
        }
    }
}

