/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.business.helper;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.org.OrgViewSchemeProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scm.pssc.business.pojo.BillTypeOrgPair;
import kd.scm.pssc.business.pojo.TimeSettingBillTypeInfo;
import kd.scm.pssc.business.pojo.TimeSettingOrgInfo;
import kd.scm.pssc.business.pojo.TimeSettingParam;
import kd.scm.pssc.common.utils.DateUtil;
import org.apache.commons.lang3.StringUtils;

public class ReqTimeSettingHelper {
    public static Map<BillTypeOrgPair, TimeSettingBillTypeInfo> matchNoticeInfo(TimeSettingParam param) {
        if (param == null || param.getBillTypeOrgInfoSet() == null) {
            return new HashMap<BillTypeOrgPair, TimeSettingBillTypeInfo>(1);
        }
        Set<BillTypeOrgPair> billTypeOrgInfoSet = param.getBillTypeOrgInfoSet();
        long matchTime = param.getTimeStamp();
        param.setTimeStamp(0L);
        Map<Long, TimeSettingOrgInfo> orgTimeSettingMap = ReqTimeSettingHelper.buildTimeSettingOrgTree(param);
        HashMap<BillTypeOrgPair, TimeSettingBillTypeInfo> billTypeOrgPairMap = new HashMap<BillTypeOrgPair, TimeSettingBillTypeInfo>(1024);
        for (BillTypeOrgPair pair : billTypeOrgInfoSet) {
            ReqTimeSettingHelper.matchCircleNotice(orgTimeSettingMap, billTypeOrgPairMap, pair.getOrgId(), pair, matchTime);
        }
        return billTypeOrgPairMap;
    }

    public static Map<BillTypeOrgPair, TimeSettingBillTypeInfo> matchUnSubmitReqBill(TimeSettingParam paramInfo) {
        Set<BillTypeOrgPair> billTypeOrgInfoSet = paramInfo.getBillTypeOrgInfoSet();
        Map<Long, TimeSettingOrgInfo> result = ReqTimeSettingHelper.buildTimeSettingOrgTree(paramInfo);
        HashMap<BillTypeOrgPair, TimeSettingBillTypeInfo> finalResult = new HashMap<BillTypeOrgPair, TimeSettingBillTypeInfo>(1024);
        HashSet<Long> orgIds = new HashSet<Long>(billTypeOrgInfoSet.size());
        for (BillTypeOrgPair pair : billTypeOrgInfoSet) {
            long orgId = pair.getOrgId();
            orgIds.add(orgId);
            ReqTimeSettingHelper.matchCircleNoBillType(result, finalResult, orgId, orgId, paramInfo.getTimeStamp());
        }
        ArrayList params = new ArrayList();
        finalResult.forEach((typeAndOrg, info) -> {
            Object[] param = new Object[6];
            param[0] = typeAndOrg.getOrgId();
            param[1] = info.getNotice();
            Set ranges = info.getRangeSet().asRanges();
            for (Range range : ranges) {
                param[2] = range.lowerEndpoint();
                param[3] = range.upperEndpoint();
            }
            param[4] = typeAndOrg.getBillTypeId();
            param[5] = info.getTimeSettingId();
            params.add(param);
        });
        if (params.size() > 0) {
            Algo algo = Algo.create((String)"ReqTimeSettingServiceImpl_Setting");
            DataSet timeSettingDataSet = algo.createDataSet(params, new RowMeta(new Field[]{new Field("orgid", (DataType)DataType.LongType), new Field("notice", (DataType)DataType.StringType), new Field("begin", (DataType)DataType.LongType), new Field("end", (DataType)DataType.LongType), new Field("billtypeid", (DataType)DataType.LongType), new Field("timesettingid", (DataType)DataType.LongType)}));
            QFilter qFilter = new QFilter("billstatus", "in", (Object)new String[]{"C", "B"});
            qFilter.and("org", "in", orgIds);
            qFilter.and("lastupdatetime", ">=", (Object)DateUtil.getCurrYearFirst());
            DataSet dataSet1 = QueryServiceHelper.queryDataSet((String)"ReqTimeSettingServiceImpl", (String)"pm_requirapplybill", (String)"id,org,billstatus,billtype,lastupdatetime", (QFilter[])new QFilter[]{qFilter}, null);
            DataSet finish = timeSettingDataSet.leftJoin(dataSet1).on("orgid", "org").on("billtypeid", "billtype").select(new String[]{"orgid", "notice", "begin", "end", "billtypeid"}, new String[]{"id", "lastupdatetime"}).finish();
            DataSet where = finish.where(new FilterFunction(){

                public boolean test(Row row) {
                    Date lastUpdateTime = row.getDate("lastupdatetime");
                    if (lastUpdateTime != null) {
                        long end = row.getLong("end");
                        long begin = row.getLong("begin");
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(lastUpdateTime);
                        calendar.set(1, 0);
                        long timeInMillis1 = calendar.getTimeInMillis();
                        if (timeInMillis1 > begin && timeInMillis1 < end) {
                            return true;
                        }
                    }
                    return false;
                }
            });
            for (Row row : where) {
                finalResult.remove(new BillTypeOrgPair(row.getLong("billtypeid"), row.getLong("orgid")));
            }
        }
        return finalResult;
    }

    private static Map<Long, TimeSettingOrgInfo> buildTimeSettingOrgTree(TimeSettingParam param) {
        String formId = param.getFormId();
        HashSet<Long> billTypes = new HashSet<Long>(1024);
        HashSet<Long> orgIds = new HashSet<Long>(1024);
        Set<BillTypeOrgPair> billTypeOrgInfoSet = param.getBillTypeOrgInfoSet();
        for (BillTypeOrgPair unionKey : billTypeOrgInfoSet) {
            if (unionKey == null) continue;
            orgIds.add(unionKey.getOrgId());
            if (unionKey.getBillTypeId() == 0L) continue;
            billTypes.add(unionKey.getBillTypeId());
        }
        String viewType = ReqTimeSettingHelper.getViewType(formId);
        HashMap<Long, TimeSettingOrgInfo> result = new HashMap<Long, TimeSettingOrgInfo>(1024);
        Set<Long> allOrgIds = ReqTimeSettingHelper.buildOrgTree(viewType, orgIds, result);
        QFilter qFilter = new QFilter("billformid.number", "=", (Object)formId);
        if (billTypes.size() > 0) {
            qFilter.and("billtype.id", "in", billTypes);
        }
        if (allOrgIds.size() > 0) {
            QFilter orgFilter = new QFilter("entryentity.controlorgid", "in", allOrgIds);
            qFilter.and(orgFilter);
        }
        if (param.getTimeStamp() != 0L) {
            qFilter.and("timeentity.starttimestamp", "<=", (Object)param.getTimeStamp());
            qFilter.and("timeentity.endtimestamp", ">=", (Object)param.getTimeStamp());
        }
        qFilter.and("enable", "=", (Object)"1");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ReqTimeSettingHelper.buildTimeSettingOrgTree", (String)"pssc_plantime_setting", (String)"id,noticetip,billtype.name billtypename,billtype.id billtype,entryentity.controlorgid controlorgid,entryentity.control control,modifytime,timeentity.starttimestamp starttimestamp,timeentity.endtimestamp endtimestamp", (QFilter[])new QFilter[]{qFilter}, (String)"modifytime desc");
        for (Row row : dataSet) {
            TimeSettingBillTypeInfo billTypeInfo;
            TimeSettingOrgInfo timeSettingOrgInfo;
            Long billtype = row.getLong("billtype");
            Long controlorgid = row.getLong("controlorgid");
            if (controlorgid == null || controlorgid == 0L || (timeSettingOrgInfo = (TimeSettingOrgInfo)result.get(controlorgid)) == null) continue;
            Map<Long, TimeSettingBillTypeInfo> billTypeInfoMap = timeSettingOrgInfo.getBillTypeInfoMap();
            if (billTypeInfoMap == null) {
                billTypeInfoMap = new HashMap<Long, TimeSettingBillTypeInfo>();
                billTypeInfo = ReqTimeSettingHelper.buildBillTypeInfo(row, param);
                ReqTimeSettingHelper.setBillTypeInfoRangSet(billTypeInfo, row);
                billTypeInfoMap.put(billtype, billTypeInfo);
                continue;
            }
            billTypeInfo = billTypeInfoMap.get(billtype);
            if (billTypeInfo == null) {
                billTypeInfo = ReqTimeSettingHelper.buildBillTypeInfo(row, param);
            }
            billTypeInfoMap.put(billtype, billTypeInfo);
        }
        return result;
    }

    private static TimeSettingBillTypeInfo buildBillTypeInfo(Row row, TimeSettingParam param) {
        TimeSettingBillTypeInfo billTypeInfo = new TimeSettingBillTypeInfo();
        boolean subController = row.getBoolean("control");
        Long timeSettingId = row.getLong("id");
        billTypeInfo.setSubController(subController);
        billTypeInfo.setTimeSettingId(timeSettingId);
        if (param.isIncludeDetail()) {
            String notice = row.getString("noticetip");
            String billTypeName = row.getString("billtypename");
            billTypeInfo.setNotice(notice);
            billTypeInfo.setBillTypeName(billTypeName);
            ReqTimeSettingHelper.setBillTypeInfoRangSet(billTypeInfo, row);
        }
        return billTypeInfo;
    }

    private static void setBillTypeInfoRangSet(TimeSettingBillTypeInfo billTypeInfo, Row row) {
        Long startTimestamp = row.getLong("starttimestamp");
        Long endTimestamp = row.getLong("endtimestamp");
        if (startTimestamp != null && endTimestamp != null) {
            if (endTimestamp == 0L || startTimestamp == 0L) {
                return;
            }
            billTypeInfo.getRangeSet().add(Range.closed((Comparable)startTimestamp, (Comparable)endTimestamp));
        }
    }

    private static void matchCircleNotice(Map<Long, TimeSettingOrgInfo> orgTimeSettingMap, Map<BillTypeOrgPair, TimeSettingBillTypeInfo> billTypeOrgPairMap, long parentOrgId, BillTypeOrgPair billTypeOrgPair, long timeInMillis) {
        Map<Long, TimeSettingBillTypeInfo> billTypeInfoMap;
        TimeSettingOrgInfo timeSettingOrgInfo = orgTimeSettingMap.get(parentOrgId);
        if (timeSettingOrgInfo != null && (billTypeInfoMap = timeSettingOrgInfo.getBillTypeInfoMap()) != null) {
            TimeSettingBillTypeInfo billTypeInfo = billTypeInfoMap.get(billTypeOrgPair.getBillTypeId());
            if (billTypeInfo != null) {
                if (parentOrgId != billTypeOrgPair.getOrgId()) {
                    if (billTypeInfo.getSubController() && (timeInMillis == 0L || !billTypeInfo.getRangeSet().contains((Comparable)Long.valueOf(timeInMillis)))) {
                        billTypeOrgPairMap.put(billTypeOrgPair, billTypeInfo);
                    } else {
                        parentOrgId = timeSettingOrgInfo.getParentOrgId();
                        if (parentOrgId == -1L) {
                            return;
                        }
                        ReqTimeSettingHelper.matchCircleNotice(orgTimeSettingMap, billTypeOrgPairMap, parentOrgId, billTypeOrgPair, timeInMillis);
                    }
                } else if (timeInMillis == 0L || !billTypeInfo.getRangeSet().contains((Comparable)Long.valueOf(timeInMillis))) {
                    billTypeOrgPairMap.put(billTypeOrgPair, billTypeInfo);
                    return;
                }
            } else {
                parentOrgId = timeSettingOrgInfo.getParentOrgId();
                if (parentOrgId == -1L) {
                    return;
                }
                ReqTimeSettingHelper.matchCircleNotice(orgTimeSettingMap, billTypeOrgPairMap, parentOrgId, billTypeOrgPair, timeInMillis);
            }
        }
    }

    private static void matchCircleNoBillType(Map<Long, TimeSettingOrgInfo> timeSettingResult, Map<BillTypeOrgPair, TimeSettingBillTypeInfo> finalResult, long orgId, long originOrgId, long timeInMillis) {
        TimeSettingOrgInfo timeSettingOrgInfo = timeSettingResult.get(orgId);
        if (timeSettingOrgInfo != null) {
            Map<Long, TimeSettingBillTypeInfo> billTypeInfoMap = timeSettingOrgInfo.getBillTypeInfoMap();
            if (billTypeInfoMap != null && billTypeInfoMap.size() > 0) {
                Set<Map.Entry<Long, TimeSettingBillTypeInfo>> entries = billTypeInfoMap.entrySet();
                for (Map.Entry<Long, TimeSettingBillTypeInfo> next : entries) {
                    long parentOrgId;
                    TimeSettingBillTypeInfo info = finalResult.get(new BillTypeOrgPair(next.getKey(), originOrgId));
                    if (info == null) {
                        if ((orgId == originOrgId || orgId != originOrgId && next.getValue().getSubController()) && StringUtils.isNotBlank((CharSequence)next.getValue().getNotice())) {
                            finalResult.put(new BillTypeOrgPair(next.getKey(), originOrgId), next.getValue());
                            continue;
                        }
                        parentOrgId = timeSettingOrgInfo.getParentOrgId();
                        if (parentOrgId == -1L) continue;
                        ReqTimeSettingHelper.matchCircleNoBillType(timeSettingResult, finalResult, timeSettingOrgInfo.getParentOrgId(), originOrgId, timeInMillis);
                        continue;
                    }
                    parentOrgId = timeSettingOrgInfo.getParentOrgId();
                    if (parentOrgId != -1L) continue;
                }
            } else {
                long parentOrgId = timeSettingOrgInfo.getParentOrgId();
                if (parentOrgId == -1L) {
                    return;
                }
                ReqTimeSettingHelper.matchCircleNoBillType(timeSettingResult, finalResult, parentOrgId, originOrgId, timeInMillis);
            }
        }
    }

    private static Set<Long> buildOrgTree(String viewType, Set<Long> useOrgs, Map<Long, TimeSettingOrgInfo> result) {
        HashSet<Object> numberSets = new HashSet<Object>();
        HashMap<String, String> orgNumberTree = new HashMap<String, String>(1024);
        if (viewType != null) {
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)ReqTimeSettingHelper.class.getName(), (String)"bos_org_structure", (String)"longnumber,org", (QFilter[])new QFilter[]{new QFilter("org", "in", useOrgs), new QFilter("view.number", "=", (Object)viewType)}, null);){
                for (Row d : ds) {
                    String longnumber = d.getString("longnumber");
                    String[] numbers = longnumber.split(OrgUnitServiceHelper.getOrgSeparation().getLongNumberSep());
                    for (int i = numbers.length - 1; i >= 0; --i) {
                        if (i - 1 >= 0) {
                            ReqTimeSettingHelper.buildOrgNumberTree(orgNumberTree, numbers[i], numbers[i - 1]);
                            continue;
                        }
                        ReqTimeSettingHelper.buildOrgNumberTree(orgNumberTree, numbers[i], null);
                    }
                    numberSets.addAll(Arrays.asList((Object[])numbers.clone()));
                }
            }
        }
        HashMap<String, Long> numberLongMap = new HashMap<String, Long>();
        HashSet<Long> orgIds = new HashSet<Long>();
        if (numberSets.size() > 0) {
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)ReqTimeSettingHelper.class.getName(), (String)"bos_org", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "in", numberSets)}, null);){
                for (Row d : ds) {
                    String number = d.getString("number");
                    numberLongMap.put(number, d.getLong("id"));
                    orgIds.add(d.getLong("id"));
                }
            }
        }
        ReqTimeSettingHelper.preBuildTimeSettingOrgTree(orgNumberTree, numberLongMap, result);
        return orgIds;
    }

    private static void preBuildTimeSettingOrgTree(Map<String, String> orgNumberTree, Map<String, Long> numberLongMap, Map<Long, TimeSettingOrgInfo> result) {
        Set<Map.Entry<String, Long>> entries = numberLongMap.entrySet();
        for (Map.Entry<String, Long> next : entries) {
            Long value = next.getValue();
            TimeSettingOrgInfo timeSettingOrgInfo = result.get(value);
            if (timeSettingOrgInfo != null) continue;
            String parentNumber = orgNumberTree.get(next.getKey());
            Long parentId = numberLongMap.get(parentNumber);
            timeSettingOrgInfo = new TimeSettingOrgInfo();
            if (parentId == null) {
                timeSettingOrgInfo.setParentOrgId(-1L);
            } else {
                timeSettingOrgInfo.setParentOrgId(parentId);
            }
            result.put(value, timeSettingOrgInfo);
        }
    }

    private static void buildOrgNumberTree(Map<String, String> orgNumberTree, String number, String parentNumber) {
        String nextNumber = orgNumberTree.get(number);
        if (nextNumber == null) {
            orgNumberTree.put(number, parentNumber);
        }
    }

    public static String getNoticeByBillTypeAndOrgId(Map<BillTypeOrgPair, TimeSettingBillTypeInfo> result, long billTypeId, long orgId) {
        TimeSettingBillTypeInfo billTypeInfo;
        if (result != null && (billTypeInfo = result.get(new BillTypeOrgPair(billTypeId, orgId))) != null) {
            return billTypeInfo.getNotice();
        }
        return null;
    }

    public static String getViewType(String formId) {
        OrgViewSchemeProp orgViewScheme;
        DynamicProperty mainOrgPro;
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)formId);
        String mainOrg = dataEntityType.getMainOrg();
        String viewType = "15";
        if (StringUtils.isNotBlank((CharSequence)mainOrg) && (mainOrgPro = dataEntityType.getProperty(mainOrg)) instanceof OrgProp && (orgViewScheme = ((OrgProp)mainOrgPro).getOrgViewScheme()) != null) {
            viewType = orgViewScheme.getNumber();
        }
        return viewType;
    }
}

