/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.business.helper.taskapprove;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.scm.pssc.business.helper.taskapprove.IPsscTaskApproveHandler;
import kd.scm.pssc.common.log.HandleLogEntity;
import kd.scm.pssc.common.log.PsscHandleLogService;
import kd.scm.pssc.common.log.PsscPriorityLog;

public class PsscPriorityHandler
implements IPsscTaskApproveHandler {
    private PsscHandleLogService priorityLog = new PsscPriorityLog();
    private PsscHandleLogService logservice = new PsscHandleLogService();

    @Override
    public void handler(ArrayList<DynamicObject> needSyncDataTasks, ArrayList<DynamicObject> needSendMsgTasks, List<HandleLogEntity> logEntityList, DynamicObject task, DynamicObject approveInfo) {
        String originPriority = task.getString("priority");
        task.set("priority", (Object)approveInfo.getString("priority"));
        task.set("opinion", (Object)approveInfo.getString("opinion"));
        this.dealPriorityLog(logEntityList, task, originPriority);
    }

    private void dealPriorityLog(List<HandleLogEntity> logEntityList, DynamicObject dynamicObject, String originPriority) {
        String priorityDetail = this.priorityLog.getDetail(originPriority, dynamicObject);
        String priorityRemark = this.getPriorityRemark();
        HandleLogEntity priorityLogentity = this.priorityLog.getLogInfo(priorityRemark, priorityDetail, dynamicObject, "priority");
        this.logservice.updateLogInfo(priorityLogentity, "priority", dynamicObject, "pssc_taskmanage");
        logEntityList.add(priorityLogentity);
    }

    private String getPriorityRemark() {
        return String.format(ResManager.loadKDString((String)"%1$s \u8c03\u6574\u4f18\u5148\u7ea7", (String)"PsscPriorityHandler_0", (String)"scm-pssc-business", (Object[])new Object[0]), RequestContext.get().getUserName());
    }
}

