/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.business.pojo;

import com.alibaba.fastjson.JSONObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sdk.scm.pssc.packagegroup.pojo.PsscMaterialGroupInfo;
import kd.sdk.scm.pssc.packagegroup.pojo.PsscPackageGroupContext;
import kd.sdk.scm.pssc.packagegroup.pojo.PsscTagGroupRuleOrderInfo;

public final class PsscPackageGroupRuleInfo
extends PsscTagGroupRuleOrderInfo {
    private String commonRule;
    private int level;
    private List<DynamicObject> specialRule;

    public String getCommonRule() {
        return this.commonRule;
    }

    public void setCommonRule(String commonRule) {
        this.commonRule = commonRule;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public List<DynamicObject> getSpecialRule() {
        return this.specialRule;
    }

    public void setSpecialRule(List<DynamicObject> specialRule) {
        this.specialRule = specialRule;
    }

    public void init(DynamicObject schema) {
        if (schema == null) {
            return;
        }
        int priority = schema.getInt("priority");
        int packagelevel = schema.getInt("packagelevel");
        String commonrule = schema.getString("commonrule");
        this.setSpecialRule((List<DynamicObject>)schema.getDynamicObjectCollection("entryentity"));
        this.setPriority(priority);
        this.setLevel(packagelevel);
        this.setCommonRule(commonrule);
    }

    public void doMatch(PsscPackageGroupContext context, Map.Entry<Long, JSONObject> next) {
        Map categoryToTag = context.getCategoryToTag();
        Map materialGroupInfoMap = context.getMaterialGroupInfoMap();
        Map longNumMapByCategory = context.getLongNumMapByCategory();
        Map materialHanderTag = context.getMaterialHanderTag();
        JSONObject value = next.getValue();
        Long material = value.getLong("material");
        Long hander = value.getLong("hander");
        String tag = (String)materialHanderTag.get(material + "-" + hander);
        if (StringUtils.isNotBlank((CharSequence)tag)) {
            this.setTag(value, tag);
            context.getDealTask().put(next.getKey(), value);
            return;
        }
        PsscMaterialGroupInfo psscMaterialGroupInfo = (PsscMaterialGroupInfo)materialGroupInfoMap.get(material);
        if (psscMaterialGroupInfo != null) {
            Long groupId = psscMaterialGroupInfo.getGroupId();
            tag = (String)categoryToTag.get(groupId + "-" + hander);
            if (StringUtils.isNotBlank((CharSequence)tag)) {
                this.setTag(value, tag);
                context.getDealTask().put(next.getKey(), value);
            } else {
                LinkedList groupIds = (LinkedList)longNumMapByCategory.get(groupId);
                for (PsscMaterialGroupInfo groupInfo : groupIds) {
                    Long groupId1 = groupInfo.getGroupId();
                    tag = (String)categoryToTag.get(groupId1 + "-" + hander);
                    if (!StringUtils.isNotBlank((CharSequence)tag)) continue;
                    this.setTag(value, tag);
                    context.getDealTask().put(next.getKey(), value);
                    return;
                }
                String commonRule = this.getCommonRule();
                if (StringUtils.equals((CharSequence)commonRule, (CharSequence)"B")) {
                    Map materialNameCache = context.getMaterialNameCache();
                    if (materialNameCache != null) {
                        tag = (String)materialNameCache.get(material);
                        if (tag == null) {
                            DynamicObject materialInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)material, (String)"bd_material");
                            tag = materialInfo != null ? materialInfo.getString("name") : "";
                            materialNameCache.put(material, tag);
                        }
                        if (StringUtils.isNotBlank((CharSequence)tag)) {
                            this.setTag(value, tag);
                            context.getDealTask().put(next.getKey(), value);
                            return;
                        }
                    }
                } else if (StringUtils.equals((CharSequence)commonRule, (CharSequence)"A")) {
                    if (groupIds.size() >= this.level && this.level >= 1) {
                        PsscMaterialGroupInfo psscMaterialGroupInfo1 = (PsscMaterialGroupInfo)groupIds.get(this.level - 1);
                        tag = psscMaterialGroupInfo1.getGroupName();
                    } else {
                        tag = psscMaterialGroupInfo.getGroupName();
                    }
                    this.setTag(value, tag);
                    context.getDealTask().put(next.getKey(), value);
                    return;
                }
            }
        }
    }

    private void setTag(JSONObject value, String tag) {
        if (value != null) {
            String tag1 = value.getString("tag");
            if (StringUtils.isBlank((CharSequence)tag1)) {
                value.put("tag", (Object)tag);
            } else {
                value.put("tag", (Object)(tag1 + this.getTagSplit() + tag));
            }
        }
    }
}

