/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.business.task;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.scm.pssc.business.helper.ReqTimeSettingHelper;
import kd.scm.pssc.business.pojo.BillTypeOrgPair;
import kd.scm.pssc.business.pojo.TimeSettingBillTypeInfo;
import kd.scm.pssc.business.pojo.TimeSettingParam;
import kd.scm.pssc.common.enums.PsscPlanReminderEnums;

public class PlanReminderTask
extends AbstractTask {
    private static int PAGE_SIZE = 5000;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        QFilter qFilter = new QFilter("enable", "=", (Object)Character.valueOf(PsscPlanReminderEnums.ENABLE.getCode()));
        qFilter.and("entryentity.loseefficacy", "=", (Object)Character.valueOf(PsscPlanReminderEnums.LOSE_EFFICACY_OFF.getCode()));
        ArrayList<Long> idList = new ArrayList<Long>(PAGE_SIZE);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)PlanReminderTask.class.getName(), (String)"pssc_planreminder", (String)"id", (QFilter[])new QFilter[]{qFilter}, null);){
            for (Row row : dataSet) {
                idList.add(row.getLong("id"));
            }
            int count = idList.size();
            int totalPages = count / PAGE_SIZE;
            if (count % PAGE_SIZE != 0) {
                ++totalPages;
            }
            for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
                List<Long> subIdList = (pageIndex + 1) * PAGE_SIZE > idList.size() ? idList.subList(pageIndex * PAGE_SIZE, idList.size()) : idList.subList(pageIndex * PAGE_SIZE, (pageIndex + 1) * PAGE_SIZE);
                if (subIdList == null || subIdList.isEmpty()) continue;
                this.sendNotice(subIdList);
            }
        }
    }

    private void sendNotice(List<Long> subIdList) {
        HashMap orgMapToReminder = new HashMap(1024);
        Calendar instance = Calendar.getInstance();
        instance.setTime(TimeServiceHelper.now());
        instance.set(1, 0);
        long timeInMillis = instance.getTimeInMillis();
        TimeSettingParam param = new TimeSettingParam("pm_requirapplybill", timeInMillis);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)PlanReminderTask.class.getName(), (String)"pssc_planreminder", (String)"createorg,entryentity.reminder reminder", (QFilter[])new QFilter[]{new QFilter("id", "in", subIdList)}, null);){
            for (Row row : dataSet) {
                Long createOrg = row.getLong("createorg");
                HashSet<Long> reminders = (HashSet<Long>)orgMapToReminder.get(createOrg);
                if (reminders == null) {
                    reminders = new HashSet<Long>(1);
                    orgMapToReminder.put(createOrg, reminders);
                }
                Long reminder = row.getLong("reminder");
                reminders.add(reminder);
                param.getBillTypeOrgInfoSet().add(new BillTypeOrgPair(0L, createOrg));
            }
        }
        if (orgMapToReminder.size() == 0) {
            return;
        }
        Set orgIds = orgMapToReminder.keySet();
        Map<BillTypeOrgPair, TimeSettingBillTypeInfo> result = ReqTimeSettingHelper.matchUnSubmitReqBill(param);
        if (result == null || result.isEmpty()) {
            return;
        }
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", orgIds)});
        HashMap<Long, DynamicObject> orgMap = new HashMap<Long, DynamicObject>(orgs.size());
        for (DynamicObject org : orgs) {
            orgMap.put(org.getLong("id"), org);
        }
        if (orgMap.size() == 0) {
            return;
        }
        Set<Map.Entry<BillTypeOrgPair, TimeSettingBillTypeInfo>> entries1 = result.entrySet();
        Iterator<Map.Entry<BillTypeOrgPair, TimeSettingBillTypeInfo>> iterator1 = entries1.iterator();
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>(1024);
        while (iterator1.hasNext()) {
            TimeSettingBillTypeInfo billTypeInfo;
            String orgName;
            MessageInfo msg;
            Map.Entry<BillTypeOrgPair, TimeSettingBillTypeInfo> next = iterator1.next();
            BillTypeOrgPair pair = next.getKey();
            long orgId1 = pair.getOrgId();
            Set reminders = (Set)orgMapToReminder.get(orgId1);
            DynamicObject orgInfo = (DynamicObject)orgMap.get(orgId1);
            if (reminders == null || orgInfo == null || (msg = this.wrapMessageInfo(orgName = orgInfo.getString("name"), reminders, billTypeInfo = next.getValue())) == null) continue;
            messageInfos.add(msg);
        }
        if (messageInfos.size() > 0) {
            MessageCenterServiceHelper.batchSendMessages(messageInfos);
        }
    }

    private MessageInfo wrapMessageInfo(String orgName, Set<Long> reminders, TimeSettingBillTypeInfo billTypeInfo) {
        if (billTypeInfo == null || reminders == null || reminders.size() == 0) {
            return null;
        }
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setSenderName("adminstrator");
        messageInfo.setMessageTitle((ILocaleString)new LocaleString(String.format(ResManager.loadKDString((String)"\u9700\u6c42\u8ba1\u5212\u63d0\u62a5\u63d0\u9192", (String)"PlanReminderTask_0", (String)"scm-pssc-common", (Object[])new Object[0]), new Object[0])));
        messageInfo.setMessageContent((ILocaleString)new LocaleString(orgName + "," + billTypeInfo.getBillTypeName() + ":" + billTypeInfo.getNotice()));
        messageInfo.setUserIds(reminders.stream().collect(Collectors.toList()));
        messageInfo.setType("message");
        messageInfo.setEntityNumber("pm_requirapplybill");
        messageInfo.setMessageTag((ILocaleString)new LocaleString(String.format(ResManager.loadKDString((String)"\u5b9a\u65f6\u4efb\u52a1", (String)"PlanReminderTask_1", (String)"scm-pssc-common", (Object[])new Object[0]), new Object[0])));
        messageInfo.setBizDataId(Long.valueOf(1L));
        messageInfo.setSignleEmail(true);
        return messageInfo;
    }
}

