/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.mservice.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pssc.mservice.PsscBillServiceImpl;

public class PsscApplyBillChangeEvent
implements IEventServicePlugin {
    private static final Log logger = LogFactory.getLog(PsscApplyBillChangeEvent.class);

    public Object handleEvent(KDBizEvent e) {
        if (e instanceof EntityEvent) {
            EntityEvent event = (EntityEvent)e;
            String entityNumber = event.getEntityNumber();
            String operation = event.getOperation();
            List businesskeys = event.getBusinesskeys();
            if (StringUtils.isBlank((CharSequence)entityNumber) || StringUtils.isBlank((CharSequence)operation) || businesskeys == null || businesskeys.size() == 0) {
                logger.info("\u4e8b\u4ef6\u8ba2\u9605\u7684\u53c2\u6570\u4e3a\u7a7a");
                return e.getEventId();
            }
            List ids = businesskeys.stream().map(Long::parseLong).collect(Collectors.toList());
            if ("pm_xpurapplybill".equals(entityNumber) && "bizvalid".equals(operation)) {
                QFilter idFilter = new QFilter("id", "in", ids);
                DynamicObjectCollection pm_xpurapplybill = QueryServiceHelper.query((String)"pm_xpurapplybill", (String)"id, sourcebillid", (QFilter[])idFilter.toArray());
                if (CollectionUtils.isEmpty((Collection)pm_xpurapplybill)) {
                    logger.info("\u67e5\u8be2\u7533\u8bf7\u53d8\u66f4\u5355\u5931\u8d25\uff0c\u53d8\u66f4\u5355ID\uff1a" + ids);
                    return e.getEventId();
                }
                HashSet<String> reqBillIds = new HashSet<String>();
                for (DynamicObject dynamicObject : pm_xpurapplybill) {
                    reqBillIds.add(dynamicObject.getString("sourcebillid"));
                }
                PsscBillServiceImpl service = new PsscBillServiceImpl();
                service.updateTaskByReqChangeIds(reqBillIds);
            } else if ("pm_batxpurapplybill".equals(entityNumber) && "bizvalid".equals(operation)) {
                QFilter idFilter = new QFilter("id", "in", ids);
                DynamicObjectCollection pm_batxpurapplybill = QueryServiceHelper.query((String)"pm_batxpurapplybill", (String)"id, entryentity.xsbillid xsbillid, entryentity.xsbillentryid xsbillentryid", (QFilter[])idFilter.toArray());
                if (CollectionUtils.isEmpty((Collection)pm_batxpurapplybill)) {
                    logger.info("\u67e5\u8be2\u6279\u91cf\u7533\u8bf7\u53d8\u66f4\u5355\u5931\u8d25\uff0c\u53d8\u66f4\u5355ID\uff1a" + ids);
                    return e.getEventId();
                }
                ArrayList<Long> srcEntryIds = new ArrayList<Long>();
                for (DynamicObject bill : pm_batxpurapplybill) {
                    long srcentryid = bill.getLong("xsbillentryid");
                    if (srcentryid == 0L) continue;
                    srcEntryIds.add(srcentryid);
                }
                PsscBillServiceImpl service = new PsscBillServiceImpl();
                service.updateTaskByReqBatchChangeIds(srcEntryIds);
            }
        } else {
            logger.info("\u4e8b\u4ef6\u8ba2\u9605\u7ed1\u5b9a\u7684\u4e8b\u4ef6\u5b9a\u4e49\u4e0d\u662f\u64cd\u4f5c\u4e8b\u4ef6");
        }
        return e.getEventId();
    }
}

