/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pssc.mservice.event;

import java.util.List;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.pssc.common.helper.status.PsscMalOrderStatusConvertService;
import kd.scm.pssc.common.helper.status.PsscPurOrderStatusConvertService;
import kd.scm.pssc.common.helper.status.PsscSrcDemandStatusConvertService;
import kd.scm.pssc.common.helper.status.PsscSrcProjectStatusConvertService;

public class PsscStatusConvertEvent
implements IEventServicePlugin {
    private static final Log logger = LogFactory.getLog(PsscStatusConvertEvent.class);

    public Object handleEvent(KDBizEvent e) {
        if (e instanceof EntityEvent) {
            EntityEvent event = (EntityEvent)e;
            String entityNumber = event.getEntityNumber();
            String operation = event.getOperation();
            List businesskeys = event.getBusinesskeys();
            if (StringUtils.isBlank((CharSequence)entityNumber) || StringUtils.isBlank((CharSequence)operation) || businesskeys == null || businesskeys.size() == 0) {
                logger.info("\u4e8b\u4ef6\u8ba2\u9605\u7684\u53c2\u6570\u4e3a\u7a7a");
                return e.getEventId();
            }
            if ("src_demand".equals(entityNumber)) {
                PsscSrcDemandStatusConvertService statusConvertService = new PsscSrcDemandStatusConvertService();
                statusConvertService.statusConvert(businesskeys, operation, e.getVariables());
            } else if ("pm_purorderbill".equals(entityNumber)) {
                PsscPurOrderStatusConvertService purService = new PsscPurOrderStatusConvertService();
                purService.statusConvert(businesskeys, operation, e.getVariables());
            } else if ("mal_order".equals(entityNumber)) {
                PsscMalOrderStatusConvertService malService = new PsscMalOrderStatusConvertService();
                malService.statusConvert(businesskeys, operation, e.getVariables());
            } else if ("src_project".equals(entityNumber)) {
                PsscSrcProjectStatusConvertService srcStatusConvert = new PsscSrcProjectStatusConvertService();
                srcStatusConvert.statusConvert(businesskeys, operation, e.getVariables());
            }
        } else {
            logger.info("\u4e8b\u4ef6\u8ba2\u9605\u7ed1\u5b9a\u7684\u4e8b\u4ef6\u5b9a\u4e49\u4e0d\u662f\u64cd\u4f5c\u4e8b\u4ef6");
        }
        return e.getEventId();
    }
}

