/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.common.blueprintshare.support;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.entity.MainEntityType;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.FileNameUtils;

public class PurBluePrintAttachmentSupport {
    private static final Log log = LogFactory.getLog(PurBluePrintAttachmentSupport.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUrlFile2AttachmentAndBind(String entity, Object pk, String fileUrl, String fileName, String fileSize, String attachKey) throws Exception {
        ArrayList attachments = new ArrayList();
        HashMap<String, Object> attachItem = new HashMap<String, Object>();
        attachItem.put("name", fileName);
        InputStream inputStream = null;
        URLConnection conn = null;
        String tempUrl = null;
        try {
            URL url = new URL(fileUrl);
            conn = url.openConnection();
            if (conn instanceof HttpURLConnection) {
                HttpURLConnection httpConn = (HttpURLConnection)conn;
                httpConn.setConnectTimeout(3000);
                httpConn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
                inputStream = httpConn.getInputStream();
            } else {
                inputStream = url.openStream();
            }
            attachItem.put("size", fileSize);
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            tempUrl = conn instanceof HttpURLConnection ? cache.saveAsFullUrl((String)attachItem.get("name"), inputStream, 600) : cache.saveAsUrl((String)attachItem.get("name"), inputStream, 600);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                log.error("\u6587\u4ef6\u6d41\u5173\u95ed\u5931\u8d25" + e.getMessage());
            }
        }
        log.info("\u5c06\u6587\u4ef6\u6d41\u5b58\u5165\u4e34\u65f6\u6587\u4ef6\u7f13\u5b58\u6210\u529f\u3002");
        attachItem.put("lastModified", System.currentTimeMillis());
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entity);
        String appId = dataEntityType.getAppId();
        String actUrl = AttachmentServiceHelper.saveTempToFileService((String)tempUrl, (String)appId, (String)entity, (Object)pk, (String)((String)attachItem.get("name")));
        log.info("\u9644\u4ef6\u4e0a\u4f20\u6587\u4ef6\u670d\u52a1\u5668\u6210\u529f\u3002");
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        InputStream in = cache.getInputStream(tempUrl);
        FileService service = FileServiceFactory.getAttachmentFileService();
        RequestContext requestContext = RequestContext.get();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        String pathParam = FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (Object)uuid, (String)fileName);
        FileItem fileItem = new FileItem(fileName, pathParam, in);
        String downUrl = service.upload(fileItem);
        attachItem.put("url", actUrl);
        attachments.add(attachItem);
        AttachmentServiceHelper.upload((String)entity, (Object)pk, (String)attachKey, attachments);
        log.info("\u5355\u636e\u7ed1\u5b9a\u9644\u4ef6\u6210\u529f\u3002");
    }

    public String saveInputStreamToTempFile(InputStream inputStream, String fileName) throws Exception {
        File tempFile = File.createTempFile(fileName, null);
        try (FileOutputStream out = new FileOutputStream(tempFile);){
            int bytesRead;
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
        }
        return tempFile.toURI().toURL().toString();
    }

    public InputStream getFileInputStreamFormLocal(String id) throws Exception {
        Path tempDir = Files.createTempDirectory("test_files", new FileAttribute[0]);
        Path tempFile = Paths.get(tempDir.toString(), "test_file.txt");
        String fileContent = "This is a test file";
        Files.write(tempFile, fileContent.getBytes(), new OpenOption[0]);
        return Files.newInputStream(tempFile, new OpenOption[0]);
    }
}

