/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.common.blueprintshare.support;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.pur.common.blueprintshare.po.BluePrintDTO;
import org.apache.commons.lang.StringUtils;

public class PurGetBlueprintSupport {
    private static final Log log = LogFactory.getLog(PurGetBlueprintSupport.class);
    private static final IAppCache cache = AppCache.get((String)"scm");

    public Map<String, List<BluePrintDTO>> getBluePrintMapXkPlm(Set<String> materielNumbers) throws Exception {
        String bluePrintsJsonString = this.queryBluePrintFromXkPlm(materielNumbers);
        if (StringUtils.isBlank((String)bluePrintsJsonString)) {
            log.info("\u8c03\u7528\u661f\u7a7a\u63a5\u53e3\u83b7\u53d6\u56fe\u7eb8\uff0c\u63a5\u53e3\u8fd4\u56de\u503c\u4e3a\u7a7a\u3002");
            return Collections.emptyMap();
        }
        log.info("\u5f00\u59cb\u89e3\u6790\u56fe\u7eb8json\u4fe1\u606f\uff1a" + bluePrintsJsonString);
        ObjectMapper mapper = new ObjectMapper();
        Map bluePrintMap = (Map)mapper.readValue(mapper.readTree(bluePrintsJsonString).get("data").toString(), (TypeReference)new TypeReference<Map<String, List<BluePrintDTO>>>(){});
        log.info("\u89e3\u6790\u56fe\u7eb8json\u4fe1\u606f\u7ed3\u675f\uff1a" + bluePrintMap);
        if (bluePrintMap == null || bluePrintMap.isEmpty()) {
            log.error("\u9009\u62e9\u7684\u7269\u6599\u7f16\u7801\u5728\u661f\u7a7aplm\u4e2d\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u56fe\u7eb8\u3002");
            return Collections.emptyMap();
        }
        this.putBluePrintDTOsToCache(bluePrintMap);
        log.info("\u5b58\u5165\u7f13\u5b58\u6210\u529f\uff1a");
        return bluePrintMap;
    }

    private void putBluePrintDTOsToCache(Map<String, List<BluePrintDTO>> bluePrintMap) throws Exception {
        String materielNumberToDtoMapString;
        Map bluePrintMapCache = null;
        long currentUserId = UserServiceHelper.getCurrentUserId();
        String cacheString = (String)cache.get("BLUEPRINT_MAP_CACHE_KEY_" + currentUserId, String.class);
        if (StringUtils.isNotBlank((String)cacheString)) {
            ObjectMapper mapper = new ObjectMapper();
            bluePrintMapCache = (Map)mapper.readValue(cacheString, (TypeReference)new TypeReference<Map<String, List<BluePrintDTO>>>(){});
        }
        if (bluePrintMapCache != null && !bluePrintMapCache.isEmpty()) {
            bluePrintMapCache.putAll(bluePrintMap);
            materielNumberToDtoMapString = JSON.toJSONString((Object)bluePrintMapCache);
        } else {
            materielNumberToDtoMapString = JSON.toJSONString(bluePrintMap);
        }
        log.info("\u63d2\u5165\u7f13\u5b58\uff0c\u7269\u6599\u7f16\u7801\u4e0e\u5bf9\u5e94\u7684\u56fe\u7eb8\u4fe1\u606f\u5217\u8868\uff1a" + materielNumberToDtoMapString);
        cache.put("BLUEPRINT_MAP_CACHE_KEY_" + currentUserId, (Object)materielNumberToDtoMapString);
        log.info("\u63d2\u5165\u7f13\u5b58\u7ed3\u675f\uff0c\u7269\u6599\u7f16\u7801\u4e0e\u5bf9\u5e94\u7684\u56fe\u7eb8\u4fe1\u606f\u5217\u8868\uff1a" + materielNumberToDtoMapString);
    }

    private String queryBluePrintFromXkPlm(Set<String> materielNumbers) throws Exception {
        log.info("\u5f00\u59cb\u8c03\u7528\u661f\u7a7a\u63a5\u53e3\u67e5\u8be2\u56fe\u7eb8\uff0c\u7269\u6599\u7f16\u7801\uff1a" + materielNumbers);
        String jsonString = "";
        log.info("\u8c03\u7528\u661f\u7a7a\u63a5\u53e3\u67e5\u8be2\u56fe\u7eb8\u7ed3\u675f\uff0c\u8fd4\u56de\u503c\uff1a" + jsonString);
        return jsonString;
    }
}

