/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.common.ecinvoice.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.ecapi.entity.EmalStatus;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.enums.PurEcInvoiceEnum;
import kd.scm.common.helper.apiconnector.api.ApiAccessor;
import kd.scm.common.helper.apiconnector.api.ApiResult;
import kd.scm.pur.common.ecinvoice.beans.EcConfirmInfo;
import kd.scm.pur.common.ecinvoice.beans.EcConfirmRecParam;
import kd.scm.pur.common.ecinvoice.beans.EcInvSubmitParam;
import kd.scm.pur.common.ecinvoice.beans.EcInvSubmitResult;
import kd.scm.pur.common.ecinvoice.beans.EcInvoiceInfo;
import kd.scm.pur.common.ecinvoice.beans.EcInvoiceSkuDetail;
import kd.scm.pur.common.ecinvoice.service.impl.GenericEcInvoiceService;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class SnEcInvoiceService
extends GenericEcInvoiceService {
    private static final Log log = LogFactory.getLog((String)SnEcInvoiceService.class.getName());
    private static final String ORDERITEM = "2";

    @Override
    public EcInvSubmitParam packageEcSubmitParam(IDataModel model, DynamicObjectCollection reportDyoCol) {
        EcInvSubmitParam ecInvSubmitParam = super.packageEcSubmitParam(model, reportDyoCol);
        DynamicObject reportDyo = (DynamicObject)reportDyoCol.get(0);
        ecInvSubmitParam.setCompanyName(reportDyo.getString("invoiceorg.ffirmname.zh_CN").trim());
        ecInvSubmitParam.setMarkId(ecInvSubmitParam.getMarkId().substring(0, 15));
        log.info("@@packageEcSubmitParam:" + ecInvSubmitParam);
        return ecInvSubmitParam;
    }

    @Override
    protected EcInvSubmitResult parseResult(EcInvSubmitParam ecInvSubmitParam, Map<String, Map<String, Object>> res) {
        EcInvSubmitResult ecInvSubmitResult = super.parseResult(ecInvSubmitParam, res);
        Map<String, Object> resultMap = res.get(EcPlatformEnum.ECPLATFORM_SUNING.getVal());
        ecInvSubmitResult.setSuccess((Boolean)resultMap.get("success"));
        if (ecInvSubmitResult.isSuccess()) {
            ecInvSubmitResult.setInvoiceState(PurEcInvoiceEnum.PREOUTINVOICE.getVal());
        } else {
            ecInvSubmitResult.setInvoiceState(PurEcInvoiceEnum.INVOICEFAILED.getVal());
            ArrayList<String> errorInfos = new ArrayList<String>();
            errorInfos.add(this.now() + ":" + resultMap.get("resultMessage"));
            ecInvSubmitResult.setErrorInfo(errorInfos);
        }
        ecInvSubmitResult.setPlatform(EcPlatformEnum.ECPLATFORM_SUNING.getVal());
        return ecInvSubmitResult;
    }

    @Override
    public Map<String, Object> prepareQueryParam(DynamicObject ecOrder) {
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        String orderid = ecOrder.getString("orderid");
        HashMap<String, String> platformParam = new HashMap<String, String>(16);
        platformParam.put("type", ORDERITEM);
        platformParam.put("field", orderid);
        param.put(EcPlatformEnum.ECPLATFORM_SUNING.getVal(), platformParam);
        return param;
    }

    @Override
    public EcInvoiceInfo packageEcInvoiceInfo(EcInvoiceInfo ecInvoiceInfo, JSONObject invoiceJo, Map<String, EmalStatus> emalStatusMap) {
        ecInvoiceInfo = super.packageEcInvoiceInfo(ecInvoiceInfo, invoiceJo, emalStatusMap);
        String ecInvState = invoiceJo.getString("invoiceState");
        ecInvoiceInfo.setResultCode(ecInvState);
        EmalStatus emalStatus = emalStatusMap.get(ecInvState);
        if (emalStatus != null) {
            ecInvoiceInfo.setInvoiceState(emalStatus.getNumber());
        } else {
            ecInvoiceInfo.setInvoiceState(PurEcInvoiceEnum.PREOUTINVOICE.getVal());
        }
        ecInvoiceInfo.setEcInvoiceSkuDetails(this.queryEcInvoiceDetail(invoiceJo));
        return ecInvoiceInfo;
    }

    protected List<EcInvoiceSkuDetail> queryEcInvoiceDetail(JSONObject invoiceJo) {
        Object invoiceDetailObj = invoiceJo.get("orderDetail");
        if (invoiceDetailObj == null) {
            return new ArrayList<EcInvoiceSkuDetail>();
        }
        JSONArray invoiceDetailJa = JSONArray.fromObject((Object)invoiceDetailObj);
        ArrayList<EcInvoiceSkuDetail> ecInvoiceSkuDetails = new ArrayList<EcInvoiceSkuDetail>(invoiceDetailJa.size());
        for (int i = 0; i < invoiceDetailJa.size(); ++i) {
            JSONObject invoiceDetailJo = invoiceDetailJa.getJSONObject(i);
            EcInvoiceSkuDetail ecInvoiceSkuDetail = new EcInvoiceSkuDetail();
            ecInvoiceSkuDetail.setNum(this.converStr2BigDecimal(invoiceDetailJo.getString("num")));
            ecInvoiceSkuDetail.setEcOrderId(invoiceDetailJo.getString("orderItemid"));
            ecInvoiceSkuDetail.setPrice(this.converStr2BigDecimal(invoiceDetailJo.getString("price")));
            ecInvoiceSkuDetail.setSkuName(invoiceDetailJo.getString("productName"));
            ecInvoiceSkuDetail.setTaxRate(this.converStr2BigDecimal(invoiceDetailJo.getString("invoiceTaxRate")));
            ecInvoiceSkuDetail.setSkuId(invoiceDetailJo.getString("sku"));
            ecInvoiceSkuDetails.add(ecInvoiceSkuDetail);
        }
        return ecInvoiceSkuDetails;
    }

    @Override
    protected EcConfirmRecParam prepareEcConfirmRecParam(IFormView view) {
        EcConfirmRecParam ecConfirmRecParam = new EcConfirmRecParam();
        DynamicObjectCollection reportDynCol = this.getSelectedDyObject(view);
        HashSet<String> ecChildOrderIdSet = new HashSet<String>();
        HashSet<String> poNo = new HashSet<String>();
        for (DynamicObject reportDyn : reportDynCol) {
            ecChildOrderIdSet.add(reportDyn.getString("jdchildorderid"));
            poNo.add(reportDyn.getString("purno"));
        }
        if (poNo.size() > 1) {
            view.showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u540c\u91c7\u8d2d\u8ba2\u5355\u53f7\u7684\u82cf\u5b81\u5b50\u8ba2\u5355\u8fdb\u884c\u66f4\u65b0\u3002", (String)"SnEcInvoiceService_4", (String)"scm-pur-common", (Object[])new Object[0]));
            return ecConfirmRecParam;
        }
        DynamicObjectCollection ecOrders = this.queryEcOrders(ecChildOrderIdSet);
        for (DynamicObject ecOrder : ecOrders) {
            if (StringUtils.isEmpty((CharSequence)ecConfirmRecParam.getEcOrderId())) {
                ecConfirmRecParam.setEcOrderId(ecOrder.getString("porderid"));
            }
            ecConfirmRecParam.getSkus().add(ecOrder.getString("entryentity.goods.number"));
        }
        ecConfirmRecParam.setConfirmDate(TimeServiceHelper.now());
        return ecConfirmRecParam;
    }

    @Override
    public String getEcOrderEntityKey() {
        return "pbd_order_sn";
    }

    @Override
    protected ApiResult<List<EcConfirmInfo>> doConfirmRec(EcConfirmRecParam ecConfirmRecParam) {
        if (StringUtils.isEmpty((CharSequence)ecConfirmRecParam.getEcOrderId()) || ecConfirmRecParam.getSkus().isEmpty()) {
            ApiResult apiResult = new ApiResult();
            apiResult.setSuccess(false);
            return apiResult;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orderId", ecConfirmRecParam.getEcOrderId());
        String confrimTime = this.now();
        Set<String> skus = ecConfirmRecParam.getSkus();
        HashMap<String, String> skuConfirmMap = new HashMap<String, String>(skus.size());
        for (String sku : skus) {
            skuConfirmMap.put(sku, confrimTime);
        }
        params.put("skuConfirmMap", skuConfirmMap);
        Map result = (Map)ApiAccessor.invoke((String)"SRM_SN_ORDER_confirmFacProduct", params);
        ApiResult apiResult = new ApiResult(result);
        apiResult.setResult(this.getBody(result));
        return apiResult;
    }

    @Override
    public String getPlatform() {
        return EcPlatformEnum.ECPLATFORM_SUNING.getVal();
    }
}

