/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.common.enums;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;

public enum ExtSystemEnum {
    EAS("EAS", 1),
    PIAOZONE(ExtSystemEnum.getPiaozoneName(), 2),
    KUAIDI100(ExtSystemEnum.getKuaidi100Name(), 3),
    UNKNOW(ExtSystemEnum.getUnknowName(), 0);

    private String name;
    private int val;
    private String localeid;

    private ExtSystemEnum(String name, int val) {
        this.name = name;
        this.val = val;
    }

    private ExtSystemEnum(String name, int val, String localeid) {
        this.name = name;
        this.val = val;
        this.localeid = localeid;
    }

    private static String getPiaozoneName() {
        return ResManager.loadKDString((String)"\u7968\u65e0\u5fe7", (String)"ExtSystemEnum_0", (String)"scm-pur-common", (Object[])new Object[0]);
    }

    private static String getKuaidi100Name() {
        return ResManager.loadKDString((String)"\u5feb\u9012100", (String)"ExtSystemEnum_1", (String)"scm-pur-common", (Object[])new Object[0]);
    }

    private static String getUnknowName() {
        return ResManager.loadKDString((String)"\u672a\u77e5", (String)"ExtSystemEnum_2", (String)"scm-pur-common", (Object[])new Object[0]);
    }

    private String getEnumName(int value) {
        String name = "";
        switch (value) {
            case 0: {
                name = ExtSystemEnum.getUnknowName();
                break;
            }
            case 1: {
                name = "EAS";
                break;
            }
            case 2: {
                name = ExtSystemEnum.getPiaozoneName();
                break;
            }
            case 3: {
                name = ExtSystemEnum.getKuaidi100Name();
            }
        }
        return name;
    }

    public String getName() {
        if (RequestContext.get().getLang().name().equals(this.localeid)) {
            return this.name;
        }
        return this.getEnumName(this.val);
    }

    public int getVal() {
        return this.val;
    }

    public String toString() {
        return this.name + ":" + this.val;
    }

    public ExtSystemEnum fromVal(String val) {
        for (ExtSystemEnum status : ExtSystemEnum.values()) {
            if (!val.equals(String.valueOf(status.getVal()))) continue;
            return status;
        }
        return UNKNOW;
    }
}

