/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.common.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.LogisticsStatusEnum;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.ExceptionUtil;

public class PurOrderAutoUrgeTask
extends AbstractTask {
    private static Log log = LogFactory.getLog(PurOrderAutoUrgeTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        log.info("@@@@@kd.scm.pur.common.task.PurOrderAutoUrgeTask start execute");
        Date now = DateUtil.addDays((Date)TimeServiceHelper.now(), (int)-3);
        QFilter qFilter = new QFilter("auditdate", "<", (Object)now);
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal()).or(new QFilter("billstatus", "=", (Object)BillStatusEnum.CHANGED.getVal())));
        qFilter.and(new QFilter("materialentry.rowlogstatus", "=", (Object)"").or(new QFilter("materialentry.rowlogstatus", "=", (Object)LogisticsStatusEnum.CONFIRM)).or(new QFilter("materialentry.rowlogstatus", "=", (Object)LogisticsStatusEnum.PARTOUTSTOCK)));
        qFilter.and(new QFilter("logstatus", "=", (Object)" ").or(new QFilter("logstatus", "=", (Object)LogisticsStatusEnum.CONFIRM)).or(new QFilter("logstatus", "=", (Object)LogisticsStatusEnum.PARTOUTSTOCK)));
        String selectProperties = "id,billno,supplier,auditdate,billstatus,logstatus,cfmstatus,materialentry,materialentry.id,materialentry.executeschedule,materialentry.rowlogstatus";
        DynamicObject[] pur_orders = BusinessDataServiceHelper.load((String)"pur_order", (String)selectProperties, (QFilter[])new QFilter[]{qFilter});
        ArrayList<DynamicObject> urgePurOrder = this.getUrgePurOrder(pur_orders);
        log.info("@@@@@kd.scm.pur.common.task.PurOrderAutoUrgeTask,pur_order_length:" + SerializationUtils.toJsonString((Object)pur_orders.length));
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"urge", (String)"pur_order", (DynamicObject[])urgePurOrder.toArray(new DynamicObject[urgePurOrder.size()]), (OperateOption)OperateOption.create());
        if (!operationResult.isSuccess()) {
            log.info("@@@@@kd.scm.pur.common.task.PurOrderAutoUrgeTask failed," + ExceptionUtil.getErrorInfoDetails((List)operationResult.getAllErrorOrValidateInfo()));
        }
    }

    private ArrayList<DynamicObject> getUrgePurOrder(DynamicObject[] pur_orders) {
        ArrayList<DynamicObject> urgePurOrder = new ArrayList<DynamicObject>(pur_orders.length * 2);
        for (DynamicObject pur_order : pur_orders) {
            DynamicObjectCollection materialEntry = pur_order.getDynamicObjectCollection("materialentry");
            boolean save = true;
            for (DynamicObject material : materialEntry) {
                if (material.getDynamicObject("executeschedule") == null) continue;
                save = false;
            }
            if (!save || pur_order.getDynamicObject("supplier") == null) continue;
            urgePurOrder.add(pur_order);
        }
        return urgePurOrder;
    }
}

