/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.common.upgrade;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.util.DateUtil;

public class LineTypeBussiTypeUpgradePluginUtils {
    private static final Log LOG = LogFactory.getLog(LineTypeBussiTypeUpgradePluginUtils.class);
    private static final int PAGE_SIZE = 500;
    private static final String DEFAULTVALUE = "0";
    private static final String FENTRYID = "fentryid";

    private static String getTotalNumTips() {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u603b\u6570\u636e\u91cf", (String)"LineTypeBussiTypeUpgradePluginUtils_1", (String)"scm-pur-common", (Object[])new Object[0]);
    }

    public static boolean upgradePurReturnData(StringBuilder pProcessInfo, String dbKey) {
        DBRoute dbRoute = new DBRoute(dbKey);
        Calendar calendar = Calendar.getInstance();
        Date date = DateUtil.getPreviousSomeMonth((Date)calendar.getTime(), (int)6);
        Object[] params = new Object[]{date};
        String sqlAll = "select tp.fentryid from T_PUR_RETURN t,T_PUR_RETURNENTRY tp,T_PUR_RETURNENTRY_A tpa where t.fid =tp.fid and tp.fid =tpa.fid and tp.fentryid =tpa.fentryid and (tp.flinetypeid =0 or tp.flinetypeid is null or t.fbusinesstypeid=0 or t.fbusinesstypeid is null) and (tpa.FSumCheckQty=0 or t.fbilldate>=?) order by tp.fentryid  desc";
        try (DataSet dataSet1 = DB.queryDataSet((String)"LineTypeBussiTypeUpgradePluginUtils.upgradePurReturnData", (DBRoute)dbRoute, (String)sqlAll, (Object[])params);){
            ArrayList<Object> idList = new ArrayList<Object>();
            dataSet1.forEach(row -> idList.add(row.getLong(FENTRYID)));
            pProcessInfo.append(LineTypeBussiTypeUpgradePluginUtils.getTotalNumTips()).append(idList.size()).append("\n");
            int totalPages = LineTypeBussiTypeUpgradePluginUtils.getTotalPage(idList);
            for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
                List<Object> subIdList = LineTypeBussiTypeUpgradePluginUtils.getSubIdList(idList, pageIndex);
                if (subIdList.isEmpty()) continue;
                ArrayList<Object[]> biztypeParms = new ArrayList<Object[]>(500);
                ArrayList<Object[]> linetypeParms = new ArrayList<Object[]>(500);
                HashMap<Long, Long> subIdMap = new HashMap<Long, Long>(500);
                HashMap<Long, Long> subEntryIdMap = new HashMap<Long, Long>(500);
                LineTypeBussiTypeUpgradePluginUtils.setSrcEntryIdMapping(dbRoute, subIdList, subIdMap, subEntryIdMap, "T_PUR_RETURNENTRY_A");
                LineTypeBussiTypeUpgradePluginUtils.buildBizTypeLineTypeByScmc(biztypeParms, linetypeParms, subIdMap, subEntryIdMap, "T_IM_PURINBILL", "T_IM_PURINBILLENTRY");
                if (!linetypeParms.isEmpty()) {
                    LineTypeBussiTypeUpgradePluginUtils.updateLineTypeData(dbRoute, linetypeParms, "T_PUR_RETURNENTRY");
                }
                if (biztypeParms.isEmpty()) continue;
                LineTypeBussiTypeUpgradePluginUtils.updateBussinessTypeData(dbRoute, biztypeParms, "T_PUR_RETURN");
            }
        }
        return true;
    }

    public static boolean upgradeInstockData(StringBuilder pProcessInfo, String dbKey) {
        DBRoute dbRoute = new DBRoute(dbKey);
        Calendar calendar = Calendar.getInstance();
        Date date = DateUtil.getPreviousSomeMonth((Date)calendar.getTime(), (int)6);
        Object[] params = new Object[]{date};
        String sqlAll = "select tp.fentryid from T_PUR_INSTOCK t,T_PUR_INSTOCKENTRY tp,T_PUR_INSTOCKENTRY_A tpa where t.fid =tp.fid and tp.fid =tpa.fid and tp.fentryid =tpa.fentryid and (tp.flinetypeid =0 or tp.flinetypeid is null or t.fbusinesstypeid=0 or t.fbusinesstypeid is null) and (tpa.FSumCheckQty=0 or t.fbilldate>=?) order by tp.fentryid  desc";
        try (DataSet dataSet1 = DB.queryDataSet((String)"LineTypeBussiTypeUpgradePluginUtils.upgradeInstockData", (DBRoute)dbRoute, (String)sqlAll, (Object[])params);){
            ArrayList<Object> idList = new ArrayList<Object>();
            dataSet1.forEach(row -> idList.add(row.getLong(FENTRYID)));
            pProcessInfo.append(LineTypeBussiTypeUpgradePluginUtils.getTotalNumTips()).append(idList.size()).append("\n");
            int totalPages = LineTypeBussiTypeUpgradePluginUtils.getTotalPage(idList);
            for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
                List<Object> subIdList = LineTypeBussiTypeUpgradePluginUtils.getSubIdList(idList, pageIndex);
                if (subIdList.isEmpty()) continue;
                ArrayList<Object[]> biztypeParms = new ArrayList<Object[]>(500);
                ArrayList<Object[]> linetypeParms = new ArrayList<Object[]>(500);
                HashMap<Long, Long> subIdMap = new HashMap<Long, Long>(500);
                HashMap<Long, Long> subEntryIdMap = new HashMap<Long, Long>(500);
                LineTypeBussiTypeUpgradePluginUtils.setSrcEntryIdMapping(dbRoute, subIdList, subIdMap, subEntryIdMap, "T_PUR_INSTOCKENTRY_A");
                LineTypeBussiTypeUpgradePluginUtils.buildBizTypeLineTypeByScmc(biztypeParms, linetypeParms, subIdMap, subEntryIdMap, "T_IM_PURINBILL", "T_IM_PURINBILLENTRY");
                if (!linetypeParms.isEmpty()) {
                    LineTypeBussiTypeUpgradePluginUtils.updateLineTypeData(dbRoute, linetypeParms, "T_PUR_INSTOCKENTRY");
                }
                if (biztypeParms.isEmpty()) continue;
                LineTypeBussiTypeUpgradePluginUtils.updateBussinessTypeData(dbRoute, biztypeParms, "T_PUR_INSTOCK");
            }
        }
        return true;
    }

    public static boolean upgradeInvioceData(StringBuilder pProcessInfo, String dbKey) {
        DBRoute dbRoute = new DBRoute(dbKey);
        String sqlAll = "select tp.fentryid from T_PUR_INVOICENTRY2 tp,T_PUR_INVOICENTRY2_A tpa where tp.fid =tpa.fid and tp.fentryid =tpa.fentryid and (tp.flinetypeid =0 or tp.flinetypeid is null) and tpa.fisentrypay!='1' order by tp.fentryid  desc";
        try (DataSet dataSet1 = DB.queryDataSet((String)"LineTypeBussiTypeUpgradePluginUtils.upgradeInvioceData", (DBRoute)dbRoute, (String)sqlAll, null);){
            ArrayList<Object> idList = new ArrayList<Object>();
            dataSet1.forEach(row -> idList.add(row.getLong(FENTRYID)));
            pProcessInfo.append(LineTypeBussiTypeUpgradePluginUtils.getTotalNumTips()).append(idList.size()).append("\n");
            int totalPages = LineTypeBussiTypeUpgradePluginUtils.getTotalPage(idList);
            for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
                List<Object> subIdList = LineTypeBussiTypeUpgradePluginUtils.getSubIdList(idList, pageIndex);
                if (subIdList.isEmpty()) continue;
                ArrayList<Object[]> biztypeParms = new ArrayList<Object[]>(500);
                ArrayList<Object[]> linetypeParms = new ArrayList<Object[]>(500);
                HashMap<Long, Long> subIdMap = new HashMap<Long, Long>(500);
                HashMap<Long, Long> subEntryIdMap = new HashMap<Long, Long>(500);
                LineTypeBussiTypeUpgradePluginUtils.setPoEntryIdMapping(dbRoute, subIdList, subIdMap, subEntryIdMap, "T_PUR_INVOICENTRY2_A");
                LineTypeBussiTypeUpgradePluginUtils.buildBizTypeLineTypeByScmc(biztypeParms, linetypeParms, subIdMap, subEntryIdMap, "T_PM_PURORDERBILL", "T_PM_PURORDERBILLENTRY");
                if (linetypeParms.isEmpty()) continue;
                LineTypeBussiTypeUpgradePluginUtils.updateLineTypeData(dbRoute, linetypeParms, "T_PUR_INVOICENTRY2");
            }
        }
        return true;
    }

    public static boolean upgradeOrderData(StringBuilder pProcessInfo, String dbKey) {
        DBRoute dbRoute = new DBRoute(dbKey);
        String sqlAll = "select tp.fentryid from T_PUR_ORDER t,T_PUR_ORDERENTRY tp,T_PUR_ORDERENTRY_A tpa where t.fid =tp.fid and tp.fid =tpa.fid and tp.fentryid =tpa.fentryid and (tp.flinetypeid =0 or tp.flinetypeid is null or t.fbusinesstypeid=0 or t.fbusinesstypeid is null) and tpa.finvoiceqty<fqty order by tp.fentryid desc";
        try (DataSet dataSet1 = DB.queryDataSet((String)"LineTypeBussiTypeUpgradePluginUtils.upgradeOrderData", (DBRoute)dbRoute, (String)sqlAll, null);){
            ArrayList<Object> idList = new ArrayList<Object>();
            dataSet1.forEach(row -> idList.add(row.getLong(FENTRYID)));
            pProcessInfo.append(LineTypeBussiTypeUpgradePluginUtils.getTotalNumTips()).append(idList.size()).append("\n");
            int totalPages = LineTypeBussiTypeUpgradePluginUtils.getTotalPage(idList);
            for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
                List<Object> subIdList = LineTypeBussiTypeUpgradePluginUtils.getSubIdList(idList, pageIndex);
                if (subIdList.isEmpty()) continue;
                ArrayList<Object[]> biztypeParms = new ArrayList<Object[]>(500);
                ArrayList<Object[]> linetypeParms = new ArrayList<Object[]>(500);
                HashMap<Long, Long> subIdMap = new HashMap<Long, Long>(500);
                HashMap<Long, Long> subEntryIdMap = new HashMap<Long, Long>(500);
                LineTypeBussiTypeUpgradePluginUtils.setPoEntryIdMapping(dbRoute, subIdList, subIdMap, subEntryIdMap, "T_PUR_ORDERENTRY_A");
                LineTypeBussiTypeUpgradePluginUtils.buildBizTypeLineTypeByScmc(biztypeParms, linetypeParms, subIdMap, subEntryIdMap, "T_PM_PURORDERBILL", "T_PM_PURORDERBILLENTRY");
                if (!linetypeParms.isEmpty()) {
                    LineTypeBussiTypeUpgradePluginUtils.updateLineTypeData(dbRoute, linetypeParms, "T_PUR_ORDERENTRY");
                }
                if (biztypeParms.isEmpty()) continue;
                LineTypeBussiTypeUpgradePluginUtils.updateBussinessTypeData(dbRoute, biztypeParms, "T_PUR_ORDER");
            }
        }
        return true;
    }

    public static boolean upgradeReceiptData(StringBuilder pProcessInfo, String dbKey) {
        DBRoute dbRoute = new DBRoute(dbKey);
        Calendar calendar = Calendar.getInstance();
        Date date = DateUtil.getPreviousSomeMonth((Date)calendar.getTime(), (int)6);
        Object[] params = new Object[]{date};
        String sqlAll = "select tp.fentryid from T_PUR_RECEIPT t,T_PUR_RECEIPTENTRY tp,T_PUR_RECEIPTENTRY_A tpa where t.fid =tp.fid and tp.fid =tpa.fid and tp.fentryid =tpa.fentryid and (tp.flinetypeid =0 or tp.flinetypeid is null or t.fbusinesstypeid=0 or t.fbusinesstypeid is null) and (tpa.FSumCheckQty=0 or t.fbilldate>=?) order by tp.fentryid  desc";
        try (DataSet dataSet1 = DB.queryDataSet((String)"LineTypeBussiTypeUpgradePluginUtils.upgradeReceiptData", (DBRoute)dbRoute, (String)sqlAll, (Object[])params);){
            ArrayList<Object> idList = new ArrayList<Object>();
            dataSet1.forEach(row -> idList.add(row.getLong("FEntryID")));
            pProcessInfo.append(LineTypeBussiTypeUpgradePluginUtils.getTotalNumTips()).append(idList.size()).append("\n");
            int totalPages = LineTypeBussiTypeUpgradePluginUtils.getTotalPage(idList);
            for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
                List<Object> subIdList = LineTypeBussiTypeUpgradePluginUtils.getSubIdList(idList, pageIndex);
                if (subIdList.isEmpty()) continue;
                ArrayList<Object[]> biztypeParms = new ArrayList<Object[]>(500);
                ArrayList<Object[]> linetypeParms = new ArrayList<Object[]>(500);
                HashMap<Long, Long> subIdMap = new HashMap<Long, Long>(500);
                HashMap<Long, Long> subEntryIdMap = new HashMap<Long, Long>(500);
                LineTypeBussiTypeUpgradePluginUtils.setSrcEntryIdMapping(dbRoute, subIdList, subIdMap, subEntryIdMap, "T_PUR_RECEIPTENTRY_A");
                LineTypeBussiTypeUpgradePluginUtils.buildBizTypeLineTypeByScmc(biztypeParms, linetypeParms, subIdMap, subEntryIdMap, "T_IM_PURRECBILL", "T_IM_PURRECBILLENTRY");
                if (!linetypeParms.isEmpty()) {
                    LineTypeBussiTypeUpgradePluginUtils.updateLineTypeData(dbRoute, linetypeParms, "T_PUR_RECEIPTENTRY");
                }
                if (biztypeParms.isEmpty()) continue;
                LineTypeBussiTypeUpgradePluginUtils.updateBussinessTypeData(dbRoute, biztypeParms, "T_PUR_RECEIPT");
            }
        }
        return true;
    }

    public static boolean upgradeCheckData(StringBuilder pProcessInfo, String dbKey) {
        DBRoute dbRoute = new DBRoute(dbKey);
        String sqlAll = "select tp.fentryid from T_PUR_CHECKENTRY2 tp,T_PUR_CHECKENTRY2_A tpa where tp.fid =tpa.fid and tp.fentryid =tpa.fentryid and (tp.flinetypeid =0 or tp.flinetypeid is null or tp.fbusinesstypeid=0 or tp.fbusinesstypeid is null) and tpa.fsuminvqty<fqty order by tp.fentryid  desc";
        try (DataSet dataSet1 = DB.queryDataSet((String)"LineTypeBussiTypeUpgradePluginUtils.upgradeCheckData", (DBRoute)dbRoute, (String)sqlAll, null);){
            ArrayList<Object> idList = new ArrayList<Object>();
            dataSet1.forEach(row -> idList.add(row.getLong(FENTRYID)));
            pProcessInfo.append(LineTypeBussiTypeUpgradePluginUtils.getTotalNumTips()).append(idList.size()).append("\n");
            int totalPages = LineTypeBussiTypeUpgradePluginUtils.getTotalPage(idList);
            for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
                List<Object> subIdList = LineTypeBussiTypeUpgradePluginUtils.getSubIdList(idList, pageIndex);
                if (subIdList.isEmpty()) continue;
                ArrayList<Object[]> linetypeParms = new ArrayList<Object[]>(500);
                ArrayList<Object[]> biztypeParms = new ArrayList<Object[]>(500);
                HashMap<Long, Long> instockEntryIdMap = new HashMap<Long, Long>(500);
                HashMap<Long, Long> returnEntryIdMap = new HashMap<Long, Long>(500);
                HashMap<Long, Long> receiptEntryIdMap = new HashMap<Long, Long>(500);
                LineTypeBussiTypeUpgradePluginUtils.setCheckMapping(dbRoute, subIdList, instockEntryIdMap, returnEntryIdMap, receiptEntryIdMap);
                LineTypeBussiTypeUpgradePluginUtils.buildCheckBizTypeLineTypeBySrc(dbRoute, linetypeParms, biztypeParms, instockEntryIdMap, returnEntryIdMap, receiptEntryIdMap);
                if (!linetypeParms.isEmpty()) {
                    LineTypeBussiTypeUpgradePluginUtils.updateLineTypeData(dbRoute, linetypeParms, "T_PUR_CHECKENTRY2");
                }
                if (biztypeParms.isEmpty()) continue;
                LineTypeBussiTypeUpgradePluginUtils.updateCheckBussiTypeData(dbRoute, biztypeParms);
            }
        }
        return true;
    }

    private static void setCheckMapping(DBRoute dbRoute, List<Object> subIdList, Map<Long, Long> instockEntryIdMap, Map<Long, Long> returnEntryIdMap, Map<Long, Long> receiptEntryIdMap) {
        StringBuilder placeHolder = LineTypeBussiTypeUpgradePluginUtils.buildParamPlaceHolder(subIdList.size());
        if (placeHolder == null) {
            return;
        }
        StringBuilder sqlSub = new StringBuilder();
        sqlSub.append("select fsrcbilltype,fsrcentryid,fentryid,fid from T_PUR_CHECKENTRY2_A where fentryid in (").append((CharSequence)placeHolder).append(")");
        try (DataSet dataSet = DB.queryDataSet((String)"LineTypeBussiTypeUpgradePluginUtils.setCheckMapping", (DBRoute)dbRoute, (String)sqlSub.toString(), (Object[])subIdList.toArray());){
            if (dataSet != null && !dataSet.isEmpty()) {
                dataSet.forEach(entry -> {
                    Long entryId = entry.getLong(FENTRYID);
                    String srcEntryIdStr = entry.getString("fsrcentryid");
                    String fsrcbilltype = entry.getString("fsrcbilltype");
                    if (StringUtils.isEmpty((CharSequence)srcEntryIdStr) || DEFAULTVALUE.equals(srcEntryIdStr) || !LineTypeBussiTypeUpgradePluginUtils.isValidLong(srcEntryIdStr)) {
                        return;
                    }
                    Long srcEntryId = Long.valueOf(srcEntryIdStr);
                    if ("pur_instock".equals(fsrcbilltype) || "scp_instock".equals(fsrcbilltype)) {
                        instockEntryIdMap.put(srcEntryId, entryId);
                    } else if ("pur_return".equals(fsrcbilltype) || "scp_return".equals(fsrcbilltype)) {
                        returnEntryIdMap.put(srcEntryId, entryId);
                    } else if ("pur_receipt".equals(fsrcbilltype) || "scp_receipt".equals(fsrcbilltype)) {
                        receiptEntryIdMap.put(srcEntryId, entryId);
                    }
                });
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private static void buildCheckBizTypeLineTypeBySrc(DBRoute dbRoute, List<Object[]> linetypeParms, List<Object[]> biztypeParms, Map<Long, Long> instockEntryIdMap, Map<Long, Long> returnEntryIdMap, Map<Long, Long> receiptEntryIdMap) {
        try {
            DataSet dataSet = null;
            dataSet = LineTypeBussiTypeUpgradePluginUtils.buildDataSet(dbRoute, instockEntryIdMap, returnEntryIdMap, receiptEntryIdMap, dataSet);
            if (dataSet != null && !dataSet.isEmpty()) {
                dataSet.forEach(row -> {
                    Long srcentryid = row.getLong(FENTRYID);
                    Long entryId = (Long)instockEntryIdMap.get(srcentryid);
                    Object fbusinesstypeid = row.get("fbusinesstypeid");
                    Object flinetypeid = row.get("flinetypeid");
                    if (fbusinesstypeid != null && !fbusinesstypeid.equals(0L)) {
                        Long biztype = (Long)fbusinesstypeid;
                        Object[] biztypeParam = new Object[]{biztype, entryId};
                        biztypeParms.add(biztypeParam);
                    }
                    if (flinetypeid != null && !flinetypeid.equals(0L)) {
                        Long linetype = (Long)flinetypeid;
                        Object[] linetypeParam = new Object[]{linetype, entryId};
                        linetypeParms.add(linetypeParam);
                    }
                });
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private static DataSet buildDataSet(DBRoute dbRoute, Map<Long, Long> instockEntryIdMap, Map<Long, Long> returnEntryIdMap, Map<Long, Long> receiptEntryIdMap, DataSet dataSet) {
        dataSet = LineTypeBussiTypeUpgradePluginUtils.joinInstockDataSet(dbRoute, instockEntryIdMap, dataSet);
        dataSet = LineTypeBussiTypeUpgradePluginUtils.joinReturnDataSet(dbRoute, returnEntryIdMap, dataSet);
        dataSet = LineTypeBussiTypeUpgradePluginUtils.joinReceiptDataSet(dbRoute, receiptEntryIdMap, dataSet);
        return dataSet;
    }

    private static DataSet joinInstockDataSet(DBRoute dbRoute, Map<Long, Long> instockEntryIdMap, DataSet dataSet) {
        StringBuilder placeHolder;
        if (!instockEntryIdMap.isEmpty() && (placeHolder = LineTypeBussiTypeUpgradePluginUtils.buildParamPlaceHolder(instockEntryIdMap.size())) != null) {
            StringBuilder instockSql = new StringBuilder();
            instockSql.append("select pb.fid,pb.fbusinesstypeid,pe.fentryid,pe.flinetypeid from T_PUR_INSTOCK pb, T_PUR_INSTOCKENTRY pe where pb.fid=pe.fid and pe.fentryid in (").append((CharSequence)placeHolder).append(")");
            DataSet instockSet = DB.queryDataSet((String)"LineTypeBussiTypeUpgradePluginUtils.buildCheckBizTypeLineTypeBySrc", (DBRoute)dbRoute, (String)instockSql.toString(), (Object[])instockEntryIdMap.keySet().toArray());
            if (instockSet != null) {
                dataSet = instockSet.copy();
            }
        }
        return dataSet;
    }

    private static DataSet joinReturnDataSet(DBRoute dbRoute, Map<Long, Long> returnEntryIdMap, DataSet dataSet) {
        StringBuilder placeHolder;
        if (!returnEntryIdMap.isEmpty() && (placeHolder = LineTypeBussiTypeUpgradePluginUtils.buildParamPlaceHolder(returnEntryIdMap.size())) != null) {
            StringBuilder returnSql = new StringBuilder();
            returnSql.append("select pb.fid,pb.fbusinesstypeid,pe.fentryid,pe.flinetypeid from T_PUR_RETURN pb, T_PUR_RETURNENTRY pe where pb.fid=pe.fid and pe.fentryid in (").append((CharSequence)placeHolder).append(")");
            DataSet returnSet = DB.queryDataSet((String)"LineTypeBussiTypeUpgradePluginUtils.buildCheckBizTypeLineTypeBySrc1", (DBRoute)dbRoute, (String)returnSql.toString(), (Object[])returnEntryIdMap.keySet().toArray());
            if (returnSet != null) {
                dataSet = LineTypeBussiTypeUpgradePluginUtils.joinDataSet(returnSet, dataSet);
            }
        }
        return dataSet;
    }

    private static DataSet joinReceiptDataSet(DBRoute dbRoute, Map<Long, Long> receiptEntryIdMap, DataSet dataSet) {
        StringBuilder placeHolder;
        if (!receiptEntryIdMap.isEmpty() && (placeHolder = LineTypeBussiTypeUpgradePluginUtils.buildParamPlaceHolder(receiptEntryIdMap.size())) != null) {
            StringBuilder receiptSql = new StringBuilder();
            receiptSql.append("select pb.fid,pb.fbusinesstypeid,pe.fentryid,pe.flinetypeid from T_PUR_RECEIPT pb, T_PUR_RECEIPTENTRY pe where pb.fid=pe.fid and pe.fentryid in (").append((CharSequence)placeHolder).append(")");
            DataSet receiptSet = DB.queryDataSet((String)"LineTypeBussiTypeUpgradePluginUtils.buildCheckBizTypeLineTypeBySrc2", (DBRoute)dbRoute, (String)receiptSql.toString(), (Object[])receiptEntryIdMap.keySet().toArray());
            if (receiptSet != null) {
                dataSet = LineTypeBussiTypeUpgradePluginUtils.joinDataSet(receiptSet, dataSet);
            }
        }
        return dataSet;
    }

    private static DataSet joinDataSet(DataSet newSet, DataSet dataSet) {
        if (dataSet == null || dataSet.isEmpty()) {
            dataSet = newSet.copy();
        } else {
            dataSet.join(newSet);
        }
        return dataSet;
    }

    private static void buildBizTypeLineTypeByScmc(List<Object[]> biztypeParms, List<Object[]> linetypeParms, Map<Long, Long> subIdMap, Map<Long, Long> subEntryIdMap, String tableName, String entryTableName) {
        if (subEntryIdMap.isEmpty()) {
            return;
        }
        DBRoute dbRoute = new DBRoute("scm");
        StringBuilder placeHolder = LineTypeBussiTypeUpgradePluginUtils.buildParamPlaceHolder(subEntryIdMap.size());
        if (placeHolder == null) {
            return;
        }
        StringBuilder sqlPm = new StringBuilder();
        sqlPm.append("select pb.fid,pb.fbiztypeid,pe.fentryid,pe.flinetypeid from ").append(tableName).append(" pb, ").append(entryTableName).append(" pe where pb.fid=pe.fid and pe.fentryid in (").append((CharSequence)placeHolder).append(")");
        try (DataSet dataSet = DB.queryDataSet((String)"LineTypeBussiTypeUpgradePluginUtils.buildReturnBizTypeLineTypeByScmc", (DBRoute)dbRoute, (String)sqlPm.toString(), (Object[])subEntryIdMap.keySet().toArray());){
            if (dataSet != null && !dataSet.isEmpty()) {
                dataSet.forEach(row -> {
                    Long srcentryid = row.getLong(FENTRYID);
                    Long entryId = (Long)subEntryIdMap.get(srcentryid);
                    Long id = (Long)subIdMap.get(srcentryid);
                    Object fbiztypeid = row.get("fbiztypeid");
                    Object flinetypeid = row.get("flinetypeid");
                    if (fbiztypeid != null && !fbiztypeid.equals(0L)) {
                        Long biztype = (Long)fbiztypeid;
                        Object[] biztypeParam = new Object[]{biztype, id};
                        biztypeParms.add(biztypeParam);
                    }
                    if (flinetypeid != null && !flinetypeid.equals(0L)) {
                        Long linetype = (Long)flinetypeid;
                        Object[] linetypeParam = new Object[]{linetype, entryId};
                        linetypeParms.add(linetypeParam);
                    }
                });
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private static void setSrcEntryIdMapping(DBRoute dbRoute, List<Object> subIdList, Map<Long, Long> subIdMap, Map<Long, Long> subEntryIdMap, String tableName) {
        StringBuilder placeHolder = LineTypeBussiTypeUpgradePluginUtils.buildParamPlaceHolder(subIdList.size());
        if (placeHolder == null) {
            return;
        }
        StringBuilder sqlSub = new StringBuilder();
        sqlSub.append("select fsrcentryid,fentryid,fid from ").append(tableName).append(" where fentryid in (").append((CharSequence)placeHolder).append(")");
        try (DataSet dataSet = DB.queryDataSet((String)"LineTypeBussiTypeUpgradePluginUtils.setReceiptInstockMapping", (DBRoute)dbRoute, (String)sqlSub.toString(), (Object[])subIdList.toArray());){
            if (dataSet != null && !dataSet.isEmpty()) {
                dataSet.forEach(entry -> {
                    Long entryId = entry.getLong(FENTRYID);
                    Long id = entry.getLong("fid");
                    String srcEntryId = entry.getString("fsrcentryid");
                    if (StringUtils.isNotEmpty((CharSequence)srcEntryId) && !DEFAULTVALUE.equals(srcEntryId) && LineTypeBussiTypeUpgradePluginUtils.isValidLong(srcEntryId)) {
                        subEntryIdMap.put(Long.valueOf(srcEntryId), entryId);
                        subIdMap.put(Long.valueOf(srcEntryId), id);
                    }
                });
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static boolean isValidLong(String str) {
        try {
            Long.parseLong(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static void setPoEntryIdMapping(DBRoute dbRoute, List<Object> subIdList, Map<Long, Long> subIdMap, Map<Long, Long> subEntryIdMap, String tableName) {
        StringBuilder placeHolder = LineTypeBussiTypeUpgradePluginUtils.buildParamPlaceHolder(subIdList.size());
        if (placeHolder == null) {
            return;
        }
        StringBuilder sqlSub = new StringBuilder();
        sqlSub.append("select fpoentryid,fentryid,fid from ").append(tableName).append(" where fentryid in (").append((CharSequence)placeHolder).append(")");
        try (DataSet dataSet = DB.queryDataSet((String)"LineTypeBussiTypeUpgradePluginUtils.setPoEntryIdMapping", (DBRoute)dbRoute, (String)sqlSub.toString(), (Object[])subIdList.toArray());){
            if (dataSet != null && !dataSet.isEmpty()) {
                dataSet.forEach(entry -> {
                    Long entryId = entry.getLong(FENTRYID);
                    Long id = entry.getLong("fid");
                    String poEntryId = entry.getString("fpoentryid");
                    if (StringUtils.isNotEmpty((CharSequence)poEntryId) && !DEFAULTVALUE.equals(poEntryId) && LineTypeBussiTypeUpgradePluginUtils.isValidLong(poEntryId)) {
                        subEntryIdMap.put(Long.valueOf(poEntryId), entryId);
                        subIdMap.put(Long.valueOf(poEntryId), id);
                    }
                });
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private static StringBuilder buildParamPlaceHolder(int size) {
        if (size == 0) {
            return null;
        }
        StringBuilder selectFields = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            selectFields.append("?").append(",");
        }
        selectFields.deleteCharAt(selectFields.length() - 1);
        return selectFields;
    }

    private static List<Object> getSubIdList(List<Object> idList, int pageIndex) {
        List<Object> subIdList = (pageIndex + 1) * 500 > idList.size() ? idList.subList(pageIndex * 500, idList.size()) : idList.subList(pageIndex * 500, (pageIndex + 1) * 500);
        return subIdList;
    }

    private static int getTotalPage(List<Object> idList) {
        int count = idList.size();
        int totalPages = count / 500;
        if (count % 500 != 0) {
            ++totalPages;
        }
        return totalPages;
    }

    private static void updateLineTypeData(DBRoute dbRoute, List<Object[]> parms, String tableName) {
        DB.executeBatch((DBRoute)dbRoute, (String)("update " + tableName + " set flinetypeid = ? where (flinetypeid=0 or flinetypeid is null) and fentryid = ?"), parms);
    }

    private static void updateBussinessTypeData(DBRoute dbRoute, List<Object[]> parms, String tableName) {
        DB.executeBatch((DBRoute)dbRoute, (String)("update  " + tableName + " set fbusinesstypeid = ? where (fbusinesstypeid=0 or fbusinesstypeid is null) and fid = ?"), parms);
    }

    private static void updateCheckBussiTypeData(DBRoute dbRoute, List<Object[]> parms) {
        DB.executeBatch((DBRoute)dbRoute, (String)"update T_PUR_CHECKENTRY2 set fbusinesstypeid = ? where (fbusinesstypeid=0 or fbusinesstypeid is null) and fentryid = ?", parms);
    }
}

