/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.service;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.ExchangeHelper;
import kd.scm.pur.business.PurBillHelper;
import kd.scm.pur.business.PurOrderBillHelper;
import kd.scm.pur.service.IPurOrderService;
import kd.scm.pur.service.PurInvoiceService;

public class PurOrderService
implements IPurOrderService {
    private static final Log LOG = LogFactory.getLog(PurOrderService.class);

    public Map<String, Map<String, BigDecimal>> collectDataForReceiptAndReturn(Set<String> poEntryIds) {
        QFilter filter = new QFilter("materialentry.poentryid", "in", poEntryIds);
        return this.getData(poEntryIds, filter, "poentryid");
    }

    public Map<String, Map<String, BigDecimal>> getDataForReceiptAndReturn(Set<String> srcentryIds) {
        QFilter filter = new QFilter("materialentry.srcentryid", "in", srcentryIds);
        return this.getData(srcentryIds, filter, "srcentryid");
    }

    public Map<Long, Boolean> verifyCanSalOutStock(List<ListSelectedRow> selectedRows) {
        Map checkMap = PurBillHelper.assembleBillOfEntry(selectedRows);
        return PurOrderBillHelper.verifyCanSalOutStock((Map)checkMap);
    }

    private Map<String, Map<String, BigDecimal>> getData(Set<String> srcentryIds, QFilter filter, String entryfields) {
        HashMap<String, Map<String, BigDecimal>> res = new HashMap<String, Map<String, BigDecimal>>();
        String selectFields = "id,loccurr.id,curr.id,org.id,materialentry.id,materialentry.pobillid,materialentry.poentryid,materialentry.srcentryid,materialentry.qty,materialentry.amount,materialentry.tax,materialentry.taxamount,materialentry.sumrecretqty,materialentry.suminstockretqty,materialentry.sumreceiptqty,materialentry.suminstockqty,materialentry.locamount,materialentry.loctax,materialentry.loctaxamount,materialentry.sumreceiptbaseqty,materialentry.suminstockbaseqty,materialentry.price,materialentry.taxprice,materialentry.sumrecretbaseqty,materialentry.suminstockretbaseqty";
        HashMap poBillIdExChangeRateMap = new HashMap(srcentryIds.size());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)PurInvoiceService.class.getName(), (String)"pur_order", (String)selectFields, (QFilter[])new QFilter[]{filter}, null);){
            ds.forEach(row -> {
                String poBillId = row.getString("materialentry.pobillid");
                BigDecimal exChangeRate = (BigDecimal)poBillIdExChangeRateMap.get(poBillId);
                if (exChangeRate == null) {
                    exChangeRate = ExchangeHelper.getExChangeRateByOrg((Long)row.getLong("loccurr.id"), (Long)row.getLong("curr.id"), (Long)row.getLong("org.id"));
                    poBillIdExChangeRateMap.put(poBillId, exChangeRate);
                }
                String rowEntryfields = row.getString("materialentry." + entryfields);
                res.putIfAbsent(rowEntryfields, new HashMap());
                Map rowMap = (Map)res.get(rowEntryfields);
                rowMap.put("qty", row.getBigDecimal("materialentry.qty"));
                BigDecimal sumrecretqty = row.getBigDecimal("materialentry.sumrecretqty");
                rowMap.put("sumrecretqty", sumrecretqty);
                rowMap.put("sumrecretbaseqty", row.getBigDecimal("materialentry.sumrecretbaseqty"));
                BigDecimal suminstockretqty = row.getBigDecimal("materialentry.suminstockretqty");
                rowMap.put("suminstockretqty", suminstockretqty);
                rowMap.put("suminstockretbaseqty", row.getBigDecimal("materialentry.suminstockretbaseqty"));
                BigDecimal sumrecrettaxamount = row.getBigDecimal("materialentry.taxprice").multiply(sumrecretqty);
                rowMap.put("sumrecrettaxamount", sumrecrettaxamount);
                BigDecimal sumrecretamount = row.getBigDecimal("materialentry.price").multiply(sumrecretqty);
                rowMap.put("sumrecretamount", sumrecretamount);
                rowMap.put("sumrecrettax", sumrecrettaxamount.subtract(sumrecretamount));
                rowMap.put("sumrecretlocamount", sumrecretamount.multiply(exChangeRate));
                rowMap.put("sumrecretloctax", sumrecrettaxamount.subtract(sumrecretamount).multiply(exChangeRate));
                rowMap.put("sumrecretloctaxamount", sumrecrettaxamount.multiply(exChangeRate));
                BigDecimal suminstockrettaxamount = row.getBigDecimal("materialentry.taxprice").multiply(suminstockretqty);
                rowMap.put("suminstockrettaxamount", suminstockrettaxamount);
                BigDecimal suminstockretamount = row.getBigDecimal("materialentry.price").multiply(suminstockretqty);
                rowMap.put("suminstockretamount", suminstockretamount);
                rowMap.put("suminstockrettax", suminstockrettaxamount.subtract(suminstockretamount));
                rowMap.put("suminstockretlocamount", suminstockretamount.multiply(exChangeRate));
                rowMap.put("suminstockretloctax", suminstockrettaxamount.subtract(suminstockretamount).multiply(exChangeRate));
                rowMap.put("suminstockretloctaxamount", suminstockrettaxamount.multiply(exChangeRate));
            });
        }
        return res;
    }

    public void cancelOrderUpdateStatus(Collection<String> srcEntryIds) {
        DynamicObjectCollection entryCol;
        DynamicObject[] orders = BusinessDataServiceHelper.load((String)"pur_order", (String)"materialentry.rowlogstatus,materialentry.rowcloser,materialentry.rowclosedate,materialentry.srcentryid,materialentry.entrystatus,billstatus,cfmstatus", (QFilter[])new QFilter[]{new QFilter("materialentry.srcentryid", "in", srcEntryIds)});
        Long userId = null;
        try {
            userId = RequestContext.get().getCurrUserId();
        }
        catch (RuntimeException runtimeException) {
            userId = 1L;
            LOG.warn((Throwable)runtimeException);
        }
        Date now = TimeServiceHelper.now();
        for (DynamicObject bill : orders) {
            entryCol = bill.getDynamicObjectCollection("materialentry");
            for (DynamicObject row : entryCol) {
                if (!srcEntryIds.contains(row.getString("srcentryid")) || "B".equals(row.getString("entrystatus"))) continue;
                row.set("entrystatus", (Object)"B");
                row.set("rowcloser", (Object)userId);
                row.set("rowclosedate", (Object)now);
            }
        }
        for (DynamicObject bill : orders) {
            entryCol = bill.getDynamicObjectCollection("materialentry");
            boolean isAllCancel = true;
            for (DynamicObject row : entryCol) {
                if ("B".equals(row.getString("entrystatus"))) continue;
                isAllCancel = false;
                break;
            }
            if (!isAllCancel) continue;
            bill.set("billstatus", (Object)BillStatusEnum.CLOSED.getVal());
            bill.set("cfmstatus", (Object)"");
        }
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])orders);
    }
}

