/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.helper.multisystemjoint.ScMultiDataHandleServiceHelper;
import kd.scm.common.util.OrderUtil;
import kd.scm.pur.business.changemodel.helper.ChangeMicroservicesHelp;
import kd.scm.pur.service.IPurXOrderOmService;
import kd.scm.pur.service.event.AuditPmOmWXPurOrderEventService;

public class PurXOrderOmService
implements IPurXOrderOmService {
    private static final Log log = LogFactory.getLog(AuditPmOmWXPurOrderEventService.class);

    public Map<String, String> updatePurOrderChangeStatusAfterSave(List<String> omIds) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        try {
            DynamicObject[] purOrders = BusinessDataServiceHelper.load((String)"pur_order", (String)"cfmstatus,changestatus", (QFilter[])new QFilter[]{new QFilter("materialentry.pobillid", "in", omIds)});
            if (purOrders == null || purOrders.length == 0) {
                String message = "PurOrder status update failed because the corresponding order is empty.";
                result.put("fail", message);
                log.error(message);
                return result;
            }
            for (DynamicObject purOrder : purOrders) {
                if (purOrder == null || "D".equals(purOrder.getString("cfmstatus"))) continue;
                purOrder.set("cfmstatus", (Object)"D");
                purOrder.set("changestatus", (Object)"B");
            }
            SaveServiceHelper.update((DynamicObject[])purOrders);
            result.put("success", null);
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            String message = "PurOrder status update failed " + e.getMessage();
            result.put("fail", message);
            return result;
        }
    }

    public Map<String, String> updatePurOrderChangeStatusAfterDelete(List<String> omIds) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            ChangeMicroservicesHelp.restorePurOrderConFirmStatus(omIds);
            result.put("success", null);
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            String message = "PurOrder status update failed " + e.getMessage();
            result.put("fail", message);
            return result;
        }
    }

    public Map<String, String> createPurXOrder(Map<Long, List<Map<String, Object>>> omXOrders) {
        HashMap<String, String> res = new HashMap<String, String>();
        if (omXOrders == null || omXOrders.isEmpty()) {
            res.put("fail", "parameter omXOrders is empty.");
            return res;
        }
        try {
            Object[] srcBillIds = omXOrders.keySet().stream().map(Object::toString).toArray();
            QFilter[] filters = new QFilter[]{new QFilter("materialentry.pobillid", "in", (Object)srcBillIds)};
            DynamicObjectCollection purOrders = QueryServiceHelper.query((String)"pur_order", (String)"id,materialentry.pobillid pobillid", (QFilter[])filters);
            if (purOrders == null || purOrders.isEmpty()) {
                res.put("fail", "PurXOrder create failed because the corresponding order is empty.");
                return res;
            }
            HashMap<Long, Long> purIdToOmIdMap = new HashMap<Long, Long>(purOrders.size());
            for (DynamicObject purOrder : purOrders) {
                Long purOrderId = (Long)purOrder.get("id");
                Long srcBillId = Long.parseLong(purOrder.getString("pobillid"));
                purIdToOmIdMap.put(purOrderId, srcBillId);
            }
            ChangeMicroservicesHelp.executeChangeOperate(purIdToOmIdMap, omXOrders);
            res.put("success", null);
            return res;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            res.put("fail", "An error occurred while processing the request." + e.getMessage());
            return res;
        }
    }

    public Map<String, String> activePurOrder(List<String> omIds) {
        HashMap<String, String> res = new HashMap<String, String>();
        if (omIds == null || omIds.isEmpty()) {
            res.put("fail", "parameter omIds is empty.");
            return res;
        }
        try {
            Object[] validIds = ChangeMicroservicesHelp.queryMaxVersionPurXOrder(omIds);
            OperationResult result = OperationServiceHelper.executeOperate((String)"bizvalid", (String)"pur_xorder", (Object[])validIds, (OperateOption)OperateOption.create());
            if (!result.isSuccess()) {
                throw new KDBizException("Failed to execute collaborative purchasing order activation.");
            }
            ChangeMicroservicesHelp.restorePurOrderConFirmStatus(omIds);
            DynamicObject[] purOrderArr = PurXOrderOmService.updatePurOrderStatus(omIds);
            this.synchronousOmOrderStatus(purOrderArr);
            res.put("success", null);
            return res;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            res.put("fail", e.getMessage());
            return res;
        }
    }

    private void synchronousOmOrderStatus(DynamicObject[] purOrderArr) {
        List<DynamicObject> purOrderList = Arrays.asList(purOrderArr);
        Map<String, List<DynamicObject>> groupByLogStatus = PurXOrderOmService.groupByField(purOrderList, "logstatus");
        HashMap param = new HashMap(0);
        for (Map.Entry<String, List<DynamicObject>> entry : groupByLogStatus.entrySet()) {
            List<DynamicObject> purOrders = entry.getValue();
            ScMultiDataHandleServiceHelper.executeManualSceneHandle((String)"purxordertakeeffect", purOrders, param);
        }
        Map<String, List<DynamicObject>> groupByCfmStatus = PurXOrderOmService.groupByField(purOrderList, "cfmstatus");
        for (Map.Entry<String, List<DynamicObject>> entry : groupByCfmStatus.entrySet()) {
            List<DynamicObject> purOrders = entry.getValue();
            ScMultiDataHandleServiceHelper.executeManualSceneHandle((String)"purxordertakeeffectconfirm", purOrders, param);
        }
    }

    private static Map<String, List<DynamicObject>> groupByField(List<DynamicObject> purOrderList, String field) {
        HashMap<String, List<DynamicObject>> groupedObjects = new HashMap<String, List<DynamicObject>>(16);
        for (DynamicObject purOrder : purOrderList) {
            String logStatus = purOrder.getString(field);
            if (!groupedObjects.containsKey(logStatus)) {
                groupedObjects.put(logStatus, new ArrayList());
            }
            ((List)groupedObjects.get(logStatus)).add(purOrder);
        }
        return groupedObjects;
    }

    private static DynamicObject[] updatePurOrderStatus(List<String> omIds) {
        DynamicObjectCollection ids = QueryServiceHelper.query((String)"pur_order", (String)"id", (QFilter[])new QFilter[]{new QFilter("materialentry.pobillid", "in", omIds)});
        Object[] idsObjects = ids.stream().map(id -> id.get("id")).toArray();
        DynamicObjectType purOrderType = BusinessDataServiceHelper.newDynamicObject((String)"pur_order").getDynamicObjectType();
        DynamicObject[] purOrderArr = BusinessDataServiceHelper.load((Object[])idsObjects, (DynamicObjectType)purOrderType);
        OrderUtil.updateOrderCfmStatus((DynamicObject[])purOrderArr, (boolean)false);
        PurXOrderOmService.updateRowStatus(purOrderArr);
        SaveServiceHelper.update((DynamicObject[])purOrderArr);
        return purOrderArr;
    }

    private static void updateRowStatus(DynamicObject[] purOrderArr) {
        boolean isClosed = true;
        for (DynamicObject dynamicObject : purOrderArr) {
            DynamicObjectCollection materialentry = dynamicObject.getDynamicObjectCollection("materialentry");
            for (DynamicObject row : materialentry) {
                BigDecimal suminstockqty = row.getBigDecimal("suminstockqty");
                BigDecimal qty = row.getBigDecimal("qty");
                if (suminstockqty != null && qty != null && suminstockqty.compareTo(qty) >= 0) {
                    row.set("entrystatus", (Object)"B");
                    continue;
                }
                isClosed = false;
            }
            if (!isClosed) continue;
            dynamicObject.set("billstatus", (Object)"D");
        }
    }
}

