/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.service.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;

public class DeletePurOrderChangeEventService
implements IEventServicePlugin {
    private static final Log log = LogFactory.getLog(DeletePurOrderChangeEventService.class);

    public Object handleEvent(KDBizEvent e) {
        if (e instanceof EntityEvent) {
            EntityEvent event = (EntityEvent)e;
            String entityNumber = event.getEntityNumber();
            String operation = event.getOperation();
            List businesskeys = event.getBusinesskeys();
            if (StringUtils.isBlank((CharSequence)entityNumber) || StringUtils.isBlank((CharSequence)operation) || businesskeys == null || businesskeys.size() == 0) {
                log.info("\u4e8b\u4ef6\u8ba2\u9605\u7684\u53c2\u6570\u4e3a\u7a7a");
                return e.getEventId();
            }
            if (("pm_xpurorderbill".equals(entityNumber) || "pm_xspurorderbill".equals(entityNumber)) && "unaudit".equals(operation)) {
                Set<Long> pmOrderIds;
                Set value;
                List<Long> ids = businesskeys.stream().map(Long::parseLong).collect(Collectors.toList());
                if (ids.size() == 0) {
                    log.info("\u4e8b\u4ef6\u8ba2\u9605\u7684\u53c2\u6570\u4e3a\u7a7a");
                    return e.getEventId();
                }
                Map findTargetBills = BFTrackerServiceHelper.findTargetBills((String)"pm_xpurorderbill", (Long[])ids.toArray(new Long[0]));
                Set set = value = findTargetBills == null ? null : (Set)findTargetBills.get("pur_ordchange");
                if (value != null && value.size() > 0) {
                    boolean success;
                    ArrayList list = new ArrayList(value);
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put("ids", list);
                    param.put("entityName", "pur_ordchange");
                    log.info("\u8c03\u7528\u63a5\u53e3 IBillGenericService.unAuditAndDeleteBill \u53c2\u6570 --> " + param);
                    Map result = new HashMap();
                    try {
                        result = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IBillGenericService", (String)"unAuditAndDeleteBill", (Object[])new Object[]{param});
                    }
                    catch (Exception excep) {
                        log.info("\u8c03\u7528\u534f\u540c\u5fae\u670d\u52a1IBillGenericService.unAuditAndDeleteBill\u5f02\u5e38", (Object)excep);
                        return e.getEventId();
                    }
                    log.info("\u8c03\u7528\u63a5\u53e3 IBillGenericService.unAuditAndDeleteBill \u7ed3\u679c --> " + result);
                    if (result != null && !(success = ((Boolean)result.get("success")).booleanValue())) {
                        log.info("\u8c03\u7528\u534f\u540c\u5fae\u670d\u52a1IBillGenericService.unAuditAndDeleteBill\u8fd4\u56de\u7ed3\u679c\u5931\u8d25\uff1a" + result);
                        throw new KDBizException((String)result.get("message"));
                    }
                }
                if ((pmOrderIds = this.getPmOrderIds(ids, entityNumber)).size() > 0) {
                    HashSet hashSet;
                    Map findOrderTargetBills = BFTrackerServiceHelper.findTargetBills((String)"pm_purorderbill", (Long[])pmOrderIds.toArray(new Long[0]));
                    HashSet hashSet2 = hashSet = findOrderTargetBills == null ? null : (HashSet)findOrderTargetBills.get("pur_order");
                    if (hashSet != null && hashSet.size() > 0) {
                        boolean success;
                        ArrayList orderIDs = new ArrayList(hashSet);
                        HashMap<String, Object> param = new HashMap<String, Object>();
                        param.put("ids", orderIDs);
                        param.put("status", "A");
                        log.info("\u8c03\u7528\u63a5\u53e3 IBillGenericService.upPurOrderCfmstatus \u53c2\u6570 --> " + param);
                        Map result = null;
                        try {
                            result = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IBillGenericService", (String)"upPurOrderCfmstatus", (Object[])new Object[]{param});
                        }
                        catch (Exception ex) {
                            log.info("IBillGenericService.upPurOrderCfmstatus", (Object)ex);
                            return e.getEventId();
                        }
                        log.info("\u8c03\u7528\u63a5\u53e3 IBillGenericService.upPurOrderCfmstatus \u7ed3\u679c --> " + result);
                        if (result != null && !(success = ((Boolean)result.get("success")).booleanValue())) {
                            log.info("\u8c03\u7528\u534f\u540c\u5fae\u670d\u52a1IBillGenericService.upPurOrderCfmstatus\u8fd4\u56de\u7ed3\u679c\u5931\u8d25\uff1a" + result);
                            throw new KDBizException((String)result.get("message"));
                        }
                    }
                }
            }
        } else {
            log.info("\u4e8b\u4ef6\u8ba2\u9605\u7ed1\u5b9a\u7684\u4e8b\u4ef6\u5b9a\u4e49\u4e0d\u662f\u64cd\u4f5c\u4e8b\u4ef6");
        }
        return e.getEventId();
    }

    private Set<Long> getPmOrderIds(List<Long> xBillIds, String entityName) {
        String orderIdField = "pm_xspurorderbill".equals(entityName) ? "sourcebillid" : "sourceid";
        QFilter qFilter = new QFilter("id", "in", xBillIds);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)entityName, (String)("id," + orderIdField), (QFilter[])qFilter.toArray());
        HashSet<Long> pmOrderIds = new HashSet<Long>(16);
        for (DynamicObject bill : dynamicObjects) {
            long sourceId = bill.getLong(orderIdField);
            if (0L == sourceId) continue;
            pmOrderIds.add(sourceId);
        }
        return pmOrderIds;
    }
}

