/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.service.kdtx;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.ext.provider.BaseECService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.scm.common.enums.TaxTypeEnum;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.caldynamic.CalDynamicFactory;
import kd.scm.common.util.caldynamic.ICalDynamic;
import kd.scm.pur.business.PurStockAvailableMatchBasicQtyHelper;
import kd.scm.pur.common.util.StoreVerifyServiceDataUtil;

public final class PurStockUnMatchDataUpdateService
extends BaseECService {
    private static final Log log = LogFactory.getLog(StoreVerifyServiceDataUtil.class);

    protected DtxResponse doExecute(Object o, Object o1) throws Exception {
        return null;
    }

    public void executeUnMatchQty(Map<String, Object> paramMap) throws KDException {
        Object verifyRelation = paramMap.get("verifyRelation");
        if (verifyRelation != null) {
            HashSet<Long> verifyBillIds = new HashSet(1024);
            Object verifyBillIdsString = paramMap.get("verifyBillIds");
            if (verifyBillIdsString != null) {
                verifyBillIds = (Collection)SerializationUtils.fromJsonString((String)verifyBillIdsString.toString(), Collection.class);
            }
            Object executeDataString = paramMap.get("executeData");
            Boolean isAdd = Boolean.valueOf(String.valueOf(paramMap.get("isAdd")));
            HashSet<Long> verifyEntryIds = new HashSet();
            if (executeDataString != null && !paramMap.isEmpty()) {
                verifyEntryIds = (Collection)SerializationUtils.fromJsonString((String)executeDataString.toString(), Collection.class);
            }
            switch (String.valueOf(verifyRelation)) {
                case "appurin": {
                    this.storeApVerifyData("im_purinbill", "pur_instock", verifyBillIds, verifyEntryIds, isAdd);
                    break;
                }
                case "appurreced": {
                    this.storeApVerifyData("im_purreceivebill", "pur_receipt", verifyBillIds, verifyEntryIds, isAdd);
                    break;
                }
                case "appurreturn": {
                    this.storeApVerifyData("im_purinbill", "pur_return", verifyBillIds, verifyEntryIds, isAdd);
                    break;
                }
                case "purself": {
                    this.storeApPurSelf(verifyBillIds, verifyEntryIds, isAdd);
                    break;
                }
                case "ominself": {
                    this.storeApPurSelf(verifyBillIds, verifyEntryIds, isAdd);
                    break;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void storeApVerifyData(String verifyEntity, String storeEntity, Collection<Long> verifyBillIds, Collection<Long> verifyEntryIds, Boolean isAdd) {
        Set<Long> verifyScEntry = this.getVerifyScEntryAssmableOm(verifyEntity, "billentry", verifyBillIds, verifyEntryIds);
        DynamicObject[] purInstock = BusinessDataServiceHelper.load((String)storeEntity, (String)"billno,materialentry.id,materialentry.unmatchqty,materialentry.unmatchbaseqty,materialentry.qty,materialentry.basicqty,materialentry.srcbilltype,materialentry.srcentryid,materialentry.jointdatachannelid", (QFilter[])new QFilter[]{new QFilter("materialentry.id", "in", verifyScEntry)});
        if (!isAdd.booleanValue()) {
            this.storeVerifyData(verifyEntity, purInstock);
            return;
        }
        if (purInstock != null && purInstock.length > 0) {
            this.storeVerifyData(verifyEntity, purInstock);
            return;
        }
        String errorMessage = ResManager.loadKDString((String)"\u6570\u636e\u5305\u6682\u4e0d\u6ee1\u8db3\u534f\u540c\u6838\u9500\u6570\u636e\u53cd\u5199\u3002", (String)"PurStockUnMatchDataUpdateService_0", (String)"scm-pur-mservice", (Object[])new Object[0]);
        log.warn("VerifyService#handleVerifyData#errorMessage" + errorMessage);
        throw new KDException(new ErrorCode("VERIFYSERVICE_CODE_003", errorMessage), new Object[0]);
    }

    private void storeApPurSelf(Collection<Long> verifyBillIds, Collection<Long> verifyEntryIds, Boolean isAdd) {
        Long sleepMillis;
        int maxRetry;
        AtomicInteger atomicInteger;
        Set<Long> verifyScEntry = this.getVerifyScEntryAssmableOm("im_purinbill", "billentry", verifyBillIds, verifyEntryIds);
        DynamicObject[] purInstock = BusinessDataServiceHelper.load((String)"pur_instock", (String)"billno,materialentry.id,materialentry.unmatchqty,materialentry.unmatchbaseqty,materialentry.qty,materialentry.basicqty,materialentry.srcbilltype,materialentry.srcentryid,materialentry.jointdatachannelid", (QFilter[])new QFilter[]{new QFilter("materialentry.id", "in", verifyScEntry)});
        DynamicObject[] purReturn = BusinessDataServiceHelper.load((String)"pur_return", (String)"billno,materialentry.id,materialentry.unmatchqty,materialentry.unmatchbaseqty,materialentry.qty,materialentry.basicqty,materialentry.srcbilltype,materialentry.srcentryid,materialentry.jointdatachannelid", (QFilter[])new QFilter[]{new QFilter("materialentry.id", "in", verifyScEntry)});
        if (isAdd.booleanValue() && (purReturn == null || purReturn.length == 0)) {
            atomicInteger = new AtomicInteger(0);
            maxRetry = 3;
            sleepMillis = 100L;
            while (atomicInteger.getAndIncrement() < maxRetry) {
                if (log.isDebugEnabled()) {
                    log.debug("storeApPurSelf\uff0c\u7b2c\u51e0\u6b21\u91cd\u8bd5" + atomicInteger.get());
                }
                try {
                    Thread.sleep(sleepMillis);
                }
                catch (InterruptedException e) {
                    log.error(ExceptionUtil.getStackTrace((Throwable)e));
                }
                verifyScEntry = this.getVerifyScEntryAssmableOm("im_purinbill", "billentry", verifyBillIds, verifyEntryIds);
                purReturn = BusinessDataServiceHelper.load((String)"pur_return", (String)"billno,materialentry.id,materialentry.unmatchqty,materialentry.unmatchbaseqty,materialentry.qty,materialentry.basicqty,materialentry.srcbilltype,materialentry.srcentryid,materialentry.jointdatachannelid", (QFilter[])new QFilter[]{new QFilter("materialentry.id", "in", verifyScEntry)});
            }
        }
        if (isAdd.booleanValue() && (purReturn == null || purReturn.length == 0) && purInstock.length != verifyBillIds.size()) {
            atomicInteger = new AtomicInteger(0);
            maxRetry = 3;
            sleepMillis = 500L;
            while (atomicInteger.getAndIncrement() < maxRetry) {
                if (log.isDebugEnabled()) {
                    log.debug("storeApPurSelf\uff0c\u7b2c\u51e0\u6b21\u91cd\u8bd5" + atomicInteger.get());
                }
                try {
                    Thread.sleep(sleepMillis);
                }
                catch (InterruptedException e) {
                    log.error(ExceptionUtil.getStackTrace((Throwable)e));
                }
                verifyScEntry = this.getVerifyScEntryAssmableOm("im_purinbill", "billentry", verifyBillIds, verifyEntryIds);
                purInstock = BusinessDataServiceHelper.load((String)"pur_instock", (String)"billno,materialentry.id,materialentry.unmatchqty,materialentry.unmatchbaseqty,materialentry.qty,materialentry.basicqty,materialentry.srcbilltype,materialentry.srcentryid,materialentry.jointdatachannelid", (QFilter[])new QFilter[]{new QFilter("materialentry.id", "in", verifyScEntry)});
            }
        }
        if (isAdd.booleanValue()) {
            if (!(purInstock != null && purInstock.length != 0 || purReturn != null && purReturn.length != 0)) {
                String errorMessage = ResManager.loadKDString((String)"\u6570\u636e\u5305\u6682\u4e0d\u6ee1\u8db3\u534f\u540c\u6838\u9500\u6570\u636e\u53cd\u5199\u3002", (String)"StoreVerifyServiceDataUtil_1", (String)"scm-pur-mservice", (Object[])new Object[0]);
                log.warn("VerifyService#handleVerifyData#errorMessage" + errorMessage);
                throw new KDException(new ErrorCode("VERIFYSERVICE_CODE_003", errorMessage), new Object[0]);
            }
            if (purInstock != null && purInstock.length > 0) {
                log.info("Verify blue start , pur_instock count :  " + purInstock.length);
                this.storeVerifyData("im_purinbill", purInstock);
            }
            if (purReturn != null && purReturn.length > 0) {
                log.info("verify blue start , pur_return count :  " + purReturn.length);
                this.storeVerifyData("im_purinbill", purReturn);
            }
        } else {
            this.storeVerifyData("im_purinbill", purInstock);
            this.storeVerifyData("im_purinbill", purReturn);
        }
    }

    private Set<Long> getVerifyScEntryAssmableOm(String billKey, String entryKey, Collection<Long> verifyBillIds, Collection<Long> verifyEntryIds) {
        Set<Long> verifyScEntryByOm;
        HashSet<Long> verifyScEntry = new HashSet<Long>(8);
        Set<Long> verifyScEntryByIn = this.getVerifyScEntry("im_purinbill", "billentry", verifyBillIds, verifyEntryIds);
        if (!CollectionUtils.isEmpty(verifyScEntryByIn)) {
            verifyScEntry.addAll(verifyScEntryByIn);
        }
        if ("im_purinbill".equals(billKey) && !CollectionUtils.isEmpty(verifyScEntryByOm = this.getVerifyScEntry("im_mdc_omcmplinbill", "billentry", verifyBillIds, verifyEntryIds))) {
            verifyScEntry.addAll(verifyScEntryByOm);
        }
        return verifyScEntry;
    }

    private void storeVerifyData(String executeEntity, DynamicObject[] storeData) {
        if (storeData == null || storeData.length == 0) {
            return;
        }
        HashMap<String, String> customParamMap = new HashMap<String, String>(16);
        HashSet allRows = new HashSet(1024);
        String srcbilltype = executeEntity;
        for (DynamicObject bill2 : storeData) {
            String srcbilltypeEntry;
            DynamicObjectCollection materialentry = bill2.getDynamicObjectCollection("materialentry");
            if (!CollectionUtils.isEmpty((Collection)materialentry) && "im_mdc_omcmplinbill".equals(srcbilltypeEntry = ((DynamicObject)materialentry.get(0)).getString("srcbilltype"))) {
                srcbilltype = srcbilltypeEntry;
            }
            allRows.addAll(materialentry);
        }
        List queryStockData = PurStockAvailableMatchBasicQtyHelper.assembleJointBill(allRows);
        customParamMap.put("srcbilltype", srcbilltype);
        Map matchERPAvailableDataMap = PurStockAvailableMatchBasicQtyHelper.getErpMatchBasicQty((List)queryStockData, customParamMap);
        Map stepBasicQty = null;
        DynamicProperty unMatchQtyPro = null;
        DynamicProperty unMatchBaseQtyPro = null;
        HashMap<String, Map> stockEntryUnMatchQtyMap = new HashMap<String, Map>(1024);
        for (DynamicObject dynamicObject : storeData) {
            DynamicObjectCollection materialentry = dynamicObject.getDynamicObjectCollection("materialentry");
            unMatchQtyPro = materialentry.getDynamicObjectType().getProperty("unmatchqty");
            unMatchBaseQtyPro = materialentry.getDynamicObjectType().getProperty("unmatchbaseqty");
            for (DynamicObject row : materialentry) {
                String srcEntryId = row.getString("srcentryid");
                stepBasicQty = (Map)matchERPAvailableDataMap.get(srcEntryId);
                if (stepBasicQty == null) continue;
                unMatchQtyPro.setValue((Object)row, stepBasicQty.get("unverifyqty"));
                unMatchBaseQtyPro.setValue((Object)row, stepBasicQty.get("unverifybaseqty"));
                stockEntryUnMatchQtyMap.put(row.getString("id"), stepBasicQty);
            }
        }
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])storeData);
        HashSet<Long> checkIds = new HashSet<Long>();
        QFilter qFilter = new QFilter("materialentry.srcentryid", "in", stockEntryUnMatchQtyMap.keySet());
        qFilter.and("invstatus", "=", (Object)"A");
        Throwable throwable = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PurStockUnMatchDataUpdateService", (String)"pur_check", (String)"id", (QFilter[])new QFilter[]{qFilter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                checkIds.add(row.getLong("id"));
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        if (!checkIds.isEmpty()) {
            DynamicObject[] checkBills = BusinessDataServiceHelper.load((Object[])checkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pur_check"));
            ICalDynamic iCalDynamic = new CalDynamicFactory().createCal();
            for (DynamicObject bill4 : checkBills) {
                DynamicObjectCollection materialentry = bill4.getDynamicObjectCollection("materialentry");
                unMatchQtyPro = materialentry.getDynamicObjectType().getProperty("unmatchqty");
                for (DynamicObject row : materialentry) {
                    String srcEntryId = row.getString("srcentryid");
                    stepBasicQty = (Map)stockEntryUnMatchQtyMap.get(srcEntryId);
                    if (stepBasicQty == null) continue;
                    unMatchQtyPro.setValue((Object)row, stepBasicQty.get("unverifyqty"));
                }
                iCalDynamic.calEntryUnmatchAmt(bill4, "materialentry");
                iCalDynamic.calEntryUnmatchAmount(bill4, "materialentry");
            }
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])checkBills);
        }
    }

    private boolean isContainTax(DynamicObject bill) {
        String taxType = bill.getString("taxtype");
        return TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType);
    }

    private Set<Long> getVerifyScEntry(String entityKey, String entryKey, Collection<Long> bills, Collection<Long> entryIds) {
        List bfRowList = BFTrackerServiceHelper.loadTargetRowIds((String)entityKey, (String)entryKey, (Long[])bills.toArray(new Long[0]), (Long[])entryIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
        HashSet<Long> verifyScEntry = new HashSet<Long>(bfRowList.size());
        for (BFRow bfRow : bfRowList) {
            BFRowId bfRowSId = bfRow.getSId();
            BFRowId bfRowId = bfRow.getId();
            Long bfRowSIdEntryId = bfRowSId.getEntryId();
            if (!entryIds.contains(bfRowSIdEntryId)) continue;
            verifyScEntry.add(bfRowId.getEntryId());
        }
        log.info("VerifyService#handleVerifyData#verifyScEntry" + verifyScEntry);
        return verifyScEntry;
    }
}

