/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin.mobile;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.JacksonJsonUtil;
import kd.scm.pur.common.ReceiptUtil;
import net.sf.json.JSONArray;

public class PurBatReceiveMobilePlugin
extends AbstractMobFormPlugin
implements BeforeF7SelectListener {
    private static Log log = LogFactory.getLog(PurBatReceiveMobilePlugin.class);
    private static final String RECEIVEQTY = "receiveqty";
    protected final StringBuilder selectProperties = new StringBuilder("id,billno,billdate,curr,supplier,org,logstatus,materialentry.pobillno,materialentry.material,materialentry.unit,materialentry.unit1,materialentry.price,materialentry.sumreceiptqty,materialentry.qty,materialentry.goods,materialentry.pobillid,materialentry.poentryid,materialentry.warehouse,materialentry.lot,materialentry.project,materialentry.trace,materialentry.basicUnit,materialentry.entrystatus");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"mbarreceive", "addimg", "minimg"});
        BasedataEdit warehouse = (BasedataEdit)this.getControl("warehouse");
        warehouse.addBeforeF7SelectListener(this::beforeF7Select);
        BasedataEdit location = (BasedataEdit)this.getControl("location");
        location.addBeforeF7SelectListener(this::beforeF7Select);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        int row = beforeF7SelectEvent.getRow();
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        switch (name) {
            case "warehouse": {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (org != null) {
                    formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("createorg", "=", org.getPkValue()));
                    beforeF7SelectEvent.setFormShowParameter((FormShowParameter)formShowParameter);
                    break;
                }
                beforeF7SelectEvent.setCancel(true);
                this.getView().showMessage(ResManager.loadKDString((String)"\u6536\u8d27\u5355\u65e0\u6536\u8d27\u65b9\u4e0d\u80fd\u6dfb\u52a0\u4ed3\u5e93\u3002", (String)"PurBatReceiveMobilePlugin_0", (String)"scm-pur-mobile", (Object[])new Object[0]));
                break;
            }
            case "location": {
                DynamicObject warehouse = (DynamicObject)this.getModel().getValue("warehouse", row);
                if (warehouse != null) {
                    QFilter destFilter = new QFilter("id", "=", warehouse.getPkValue());
                    DynamicObject[] destArray = BusinessDataServiceHelper.load((String)"bd_warehouse", (String)"id,name,number,entryentity.id,entryentity.location", (QFilter[])new QFilter[]{destFilter});
                    HashSet<Long> idSet = new HashSet<Long>();
                    if (destArray.length > 0) {
                        for (int i = 0; i < destArray.length; ++i) {
                            DynamicObjectCollection entry = destArray[i].getDynamicObjectCollection("entryentity");
                            for (int j = 0; j < entry.size(); ++j) {
                                DynamicObject location = ((DynamicObject)entry.get(j)).getDynamicObject("location");
                                if (null == location) continue;
                                idSet.add(location.getLong("id"));
                            }
                        }
                    }
                    formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", idSet));
                    beforeF7SelectEvent.setFormShowParameter((FormShowParameter)formShowParameter);
                    break;
                }
                beforeF7SelectEvent.setCancel(true);
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u4ed3\u5e93", (String)"PurBatReceiveMobilePlugin_1", (String)"scm-pur-mobile", (Object[])new Object[0]));
                break;
            }
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        Object pkId = formShowParameter.getCustomParam("pkId");
        if (pkId != null) {
            ArrayList pkIds = new ArrayList();
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pur_saloutstock", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)Long.valueOf(pkId.toString())).and(new QFilter("materialentry.entrystatus", "=", (Object)"A"))}, (String)"id");){
                dataSet.forEach(row -> pkIds.add(row.getLong("id")));
            }
            if (pkIds.isEmpty()) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u6240\u6709\u884c\u72b6\u6001\u4e3a\u5df2\u5173\u95ed\uff0c\u65e0\u6cd5\u7ee7\u7eed\u6536\u8d27\u3002", (String)"PurBatReceiveMobilePlugin_11", (String)"scm-pur-mobile", (Object[])new Object[0]));
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        Object pkId;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object fromType = customParams.get("fromType");
        if (fromType != null) {
            if ("list".equals(fromType)) {
                this.getPageCache().put("list", "true");
            }
        } else {
            this.getPageCache().put("qcode", "true");
        }
        if ((pkId = customParams.get("pkId")) != null) {
            this.allotDynamicData(pkId);
        }
    }

    public void allotDynamicData(Object pkId) {
        DynamicObject purSaloutstockBill = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"pur_saloutstock", (String)this.selectProperties.toString());
        this.bindEntityData(purSaloutstockBill, "entryentity", "");
        this.bindBotpListData(purSaloutstockBill.getDynamicObjectCollection("materialentry"));
    }

    protected void bindEntityData(DynamicObject purSaloutstockBill, String entityKey, String suffix) {
        DynamicObject location;
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        Long billId = purSaloutstockBill.getLong("id");
        model.setValue("billno", purSaloutstockBill.get("billno"));
        model.setValue("supplier", purSaloutstockBill.get("supplier_id"));
        model.setValue("curr", purSaloutstockBill.get("curr_id"));
        model.setValue("org", purSaloutstockBill.get("org_id"));
        Long orgId = purSaloutstockBill.getLong("org_id");
        Long warehouseId = null;
        Long locationId = null;
        DynamicObject warehouse = QueryServiceHelper.queryOne((String)"pur_warehouse", (String)"id", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
        if (warehouse != null) {
            warehouseId = warehouse.getLong("id");
        }
        if ((location = QueryServiceHelper.queryOne((String)"pur_location", (String)"id", (QFilter[])new QFilter[]{new QFilter("warehouse", "=", (Object)warehouseId)})) != null) {
            locationId = location.getLong("id");
        }
        model.setValue("billdate", purSaloutstockBill.get("billdate"));
        DynamicObjectCollection materialentry = purSaloutstockBill.getDynamicObjectCollection("materialentry");
        materialentry.getDynamicObjectType().getProperties();
        model.deleteEntryData(entityKey);
        int rowCount = 0;
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (DynamicObject mater : materialentry) {
            String entrystatus = mater.getString("entrystatus");
            if (entrystatus == null || !"A".equals(entrystatus)) continue;
            vs.set("pobillno", mater.get("pobillno"), rowCount);
            vs.set("material", mater.get("material_id"), rowCount);
            vs.set("unit", mater.get("unit_id"), rowCount);
            vs.set("goods", mater.get("goods_id"), rowCount);
            vs.set("unit1", mater.get("unit_id"), rowCount);
            vs.set("basicunit", mater.get("basicunit_id"), rowCount);
            vs.set("location", (Object)locationId, rowCount);
            vs.set("warehouse", (Object)warehouseId, rowCount);
            vs.set("lot", mater.get("lot_id"), rowCount);
            vs.set("project", mater.get("project_id"), rowCount);
            vs.set("trace", mater.get("trace_id"), rowCount);
            vs.set("billid", (Object)billId, rowCount);
            vs.set("entryid", mater.get("id"), rowCount);
            vs.set("poentryid", mater.get("poentryid"), rowCount);
            vs.set("pobillid", mater.get("pobillid"), rowCount);
            vs.set("qty", mater.get("qty"), rowCount);
            vs.set("sumreceiptqty", mater.get("sumreceiptqty"), rowCount);
            vs.set(RECEIVEQTY, (Object)mater.getBigDecimal("qty").subtract(mater.getBigDecimal("sumreceiptqty")), rowCount);
            ++rowCount;
        }
        model.batchCreateNewEntryRow(entityKey, vs);
    }

    protected void bindBotpListData(DynamicObjectCollection materialentry) {
        ArrayList<ComboItem> ruleItems = new ArrayList<ComboItem>();
        ComboEdit ruleCombo = (ComboEdit)this.getView().getControl("botplist");
        if (ApiConfigUtil.hasEASConfig()) {
            ComboItem ruleItem;
            this.getPageCache().put("isEAS", "true");
            ArrayList<DynamicObject> selectDynaObj = new ArrayList<DynamicObject>();
            for (DynamicObject col : materialentry) {
                selectDynaObj.add(col);
            }
            String errorMessage = null;
            String inwareRules = null;
            try {
                inwareRules = ReceiptUtil.getBotpRule(selectDynaObj, (String)"receive");
            }
            catch (KDException e) {
                log.info(ExceptionUtil.getStackTrace((Throwable)e));
                errorMessage = e.getErrorCode().getMessage();
            }
            JSONArray inwareRuleList = null;
            if (inwareRules != null) {
                try {
                    inwareRuleList = JSONArray.fromObject((Object)inwareRules);
                }
                catch (Exception e) {
                    log.info(ExceptionUtil.getStackTrace((Throwable)e));
                    errorMessage = e.getLocalizedMessage();
                }
            }
            if (errorMessage != null) {
                ruleItem = new ComboItem();
                ruleItem.setValue(String.valueOf("500"));
                ruleItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u8f6c\u6362\u89c4\u5219\u3002", (String)"PurBatReceiveMobilePlugin_2", (String)"scm-pur-mobile", (Object[])new Object[0])));
                ruleItems.add(ruleItem);
            }
            if (inwareRuleList != null && inwareRuleList.size() == 0) {
                ruleItem = new ComboItem();
                ruleItem.setValue(String.valueOf("500"));
                ruleItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u8f6c\u6362\u89c4\u5219\u3002", (String)"PurBatReceiveMobilePlugin_2", (String)"scm-pur-mobile", (Object[])new Object[0])));
                ruleItems.add(ruleItem);
            }
            if (inwareRuleList != null) {
                for (Object rule : inwareRuleList) {
                    Map ruleMap = (Map)rule;
                    ComboItem ruleItem2 = new ComboItem();
                    ruleItem2.setValue(String.valueOf(ruleMap.get("number")));
                    ruleItem2.setCaption(new LocaleString(String.valueOf(ruleMap.get("alias"))));
                    ruleItems.add(ruleItem2);
                }
            }
        } else {
            this.getPageCache().put("isEAS", "false");
            List rules = ConvertMetaServiceHelper.loadRules((String)"pm_purorderbill", (String)"im_purreceivebill");
            if (rules != null) {
                for (ConvertRuleElement convertRuleElement : rules) {
                    ComboItem ruleItem = new ComboItem();
                    if (!convertRuleElement.isEnabled()) continue;
                    ruleItem.setValue(String.valueOf(convertRuleElement.getId()));
                    ruleItem.setCaption(new LocaleString(String.valueOf(convertRuleElement.getName())));
                    ruleItems.add(ruleItem);
                }
            } else {
                ComboItem ruleItem = new ComboItem();
                ruleItem.setValue(String.valueOf("500"));
                ruleItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u8f6c\u6362\u89c4\u5219\u3002", (String)"PurBatReceiveMobilePlugin_2", (String)"scm-pur-mobile", (Object[])new Object[0])));
                ruleItems.add(ruleItem);
            }
        }
        ruleCombo.setComboItems(ruleItems);
        if (ruleItems.size() == 0) {
            this.getModel().setValue("botplist", (Object)"");
        } else {
            this.getModel().setValue("botplist", (Object)((ComboItem)ruleItems.get(0)).getValue());
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "addimg": {
                this.calOutStockQty("+");
                break;
            }
            case "minimg": {
                this.calOutStockQty("-");
                break;
            }
            case "mbarreceive": {
                this.getView().setEnable(Boolean.FALSE, new String[]{"mtoolbarap"});
                this.pushReceive();
            }
        }
    }

    public boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        return pattern.matcher(str).matches();
    }

    private void pushReceive() {
        String isEAS = this.getPageCache().get("isEAS");
        DynamicObjectCollection entryCols = this.getModel().getEntryEntity("entryentity");
        ArrayList selectDynaObj = new ArrayList();
        ArrayList selectOrder = new ArrayList();
        HashMap dataMap = new HashMap();
        entryCols.forEach(entry -> {
            BigDecimal qty = entry.getBigDecimal(RECEIVEQTY);
            if (qty.compareTo(BigDecimal.ZERO) > 0) {
                selectDynaObj.add(entry);
                String poBillId = entry.getString("pobillid");
                if (poBillId != null && !"".equals(poBillId) && this.isNumeric(poBillId)) {
                    selectOrder.add(Long.valueOf(poBillId));
                }
                if ("false".equals(isEAS)) {
                    DynamicObject warehouse = entry.getDynamicObject("warehouse");
                    dataMap.put("warehouse", warehouse != null ? warehouse.getString("number") : null);
                    DynamicObject location = entry.getDynamicObject("location");
                    dataMap.put("location", location != null ? location.getString("number") : null);
                }
            }
        });
        StringBuilder errorMessage = new StringBuilder();
        List availableData = ReceiptUtil.getAvailableData(selectDynaObj, (String)"");
        if (availableData.size() == 0) {
            errorMessage.append(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u62e9\u5206\u5f55\u6216\u8005\u6240\u9009\u5206\u5f55\u6536\u8d27\u6570\u91cf\u4e3a0\u3002", (String)"PurBatReceiveMobilePlugin_3", (String)"scm-pur-mobile", (Object[])new Object[0]));
            this.getView().showErrorNotification(errorMessage.toString());
            return;
        }
        Object ruleNumber = this.getModel().getValue("botplist");
        if (ruleNumber == null || "500".equals(ruleNumber) || "null".equals(ruleNumber)) {
            errorMessage.append(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u8f6c\u6362\u89c4\u5219\u65e0\u6cd5\u751f\u6210\u6536\u8d27\u5355\u3002", (String)"PurBatReceiveMobilePlugin_4", (String)"scm-pur-mobile", (Object[])new Object[0]));
            this.getView().showErrorNotification(errorMessage.toString());
            return;
        }
        if ("true".equals(isEAS)) {
            String result = null;
            try {
                result = ReceiptUtil.toRecive(selectDynaObj, (String)String.valueOf(ruleNumber), (String)"");
            }
            catch (KDException e) {
                log.error(ExceptionUtil.getStackTrace((Throwable)e));
                errorMessage.append(e.getLocalizedMessage());
            }
            Map map = null;
            if (result != null) {
                try {
                    map = (Map)JacksonJsonUtil.fromJson((String)result, Map.class);
                }
                catch (Exception e) {
                    log.info(ExceptionUtil.getStackTrace((Throwable)e));
                    errorMessage.append(e.getLocalizedMessage());
                }
            }
            String srcEntryId = null;
            StringBuilder billNumber = new StringBuilder();
            for (DynamicObject col : selectDynaObj) {
                Map msgMap;
                srcEntryId = col.getString("entryid");
                if (map == null || (msgMap = (Map)map.get(srcEntryId)) == null) continue;
                errorMessage.append(msgMap.get("error"));
                Object billno = msgMap.get("billnumber");
                if (billNumber.toString().contains(billno.toString())) continue;
                billNumber.append(msgMap.get("billnumber"));
            }
            if ("".equals(errorMessage.toString())) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6536\u8d27\u6210\u529f", (String)"PurBatReceiveMobilePlugin_5", (String)"scm-pur-mobile", (Object[])new Object[0]), "", MessageTypes.ImageWithText_m, null);
                Object pkId = this.getView().getFormShowParameter().getCustomParams().get("pkId");
                this.allotDynamicData(pkId);
                if ("true".equals(this.getPageCache().get("qcode"))) {
                    MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
                    StringBuilder message = new StringBuilder(ResManager.loadKDString((String)"\u6536\u8d27\u5355\u53f7\uff1a", (String)"PurBatReceiveMobilePlugin_6", (String)"scm-pur-mobile", (Object[])new Object[0]));
                    message.append((CharSequence)billNumber);
                    mobileFormShowParameter.setCaption(ResManager.loadKDString((String)"EAS\u6536\u8d27\u6210\u529f\u53cd\u9988\u3002", (String)"PurBatReceiveMobilePluginEasShsfk", (String)"scm-pur-mobile", (Object[])new Object[0]));
                    mobileFormShowParameter.setCustomParam("title", (Object)ResManager.loadKDString((String)"\u6536\u8d27\u6210\u529f", (String)"PurBatReceiveMobilePlugin_5", (String)"scm-pur-mobile", (Object[])new Object[0]));
                    mobileFormShowParameter.setCustomParam("content", (Object)message.toString());
                    this.openTips(mobileFormShowParameter);
                }
                this.getView().setEnable(Boolean.TRUE, new String[]{"mtoolbarap"});
                if ("true".equals(this.getPageCache().get("list"))) {
                    this.getView().close();
                }
            } else {
                this.getView().showMessage(errorMessage.toString(), errorMessage.toString(), MessageTypes.Business, null);
                this.getView().setEnable(Boolean.TRUE, new String[]{"mtoolbarap"});
            }
        } else {
            DynamicObject[] pmPurorderbills = BusinessDataServiceHelper.load((Object[])selectOrder.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pm_purorderbill"));
            PushArgs pushArgs = new PushArgs();
            pushArgs.setSourceEntityNumber("pm_purorderbill");
            pushArgs.setTargetEntityNumber("im_purreceivebill");
            pushArgs.setBuildConvReport(true);
            pushArgs.setRuleId(ruleNumber.toString());
            ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>();
            for (DynamicObject bill : pmPurorderbills) {
                DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
                for (DynamicObject entry2 : billentry) {
                    ListSelectedRow row2 = new ListSelectedRow();
                    row2.setEntryEntityKey("billentry");
                    row2.setEntryPrimaryKeyValue(entry2.getPkValue());
                    row2.setPrimaryKeyValue(bill.getPkValue());
                    selectedRowList.add(row2);
                }
            }
            pushArgs.setSelectedRows(selectedRowList);
            ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
            if (result.isSuccess()) {
                MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)pushArgs.getTargetEntityNumber());
                List targetData = result.loadTargetDataObjects(new IRefrencedataProvider(){

                    public void fillReferenceData(Object[] objects, IDataEntityType iDataEntityType) {
                        BusinessDataServiceHelper.loadRefence((Object[])objects, (IDataEntityType)iDataEntityType);
                    }
                }, mainType);
                OperateOption option = OperateOption.create();
                option.setVariableValue("isStrict", "false");
                option.setVariableValue("ishasright", String.valueOf(true));
                DynamicObject warehouse = QueryServiceHelper.queryOne((String)"bd_warehouse", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", dataMap.get("warehouse"))});
                DynamicObject location = QueryServiceHelper.queryOne((String)"bd_location", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", dataMap.get("location"))});
                int rowindex = 0;
                for (DynamicObject bill : targetData) {
                    DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
                    for (DynamicObject entry3 : billentry) {
                        entry3.set("warehouse_id", (Object)(warehouse != null ? warehouse.getLong("id") : 0L));
                        entry3.set("location_id", (Object)(location != null ? location.getLong("id") : 0L));
                        ++rowindex;
                    }
                }
                OperateOption operateOption = OperateOption.create();
                OperationResult save = SaveServiceHelper.saveOperate((String)"im_purreceivebill", (DynamicObject[])targetData.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                if (save.isSuccess()) {
                    OperationResult submit = OperationServiceHelper.executeOperate((String)"submit", (String)"im_purreceivebill", (Object[])save.getSuccessPkIds().toArray(), (OperateOption)operateOption);
                    if (submit.isSuccess()) {
                        OperationResult audit = OperationServiceHelper.executeOperate((String)"audit", (String)"im_purreceivebill", (Object[])save.getSuccessPkIds().toArray(), (OperateOption)operateOption);
                        StringBuilder messageError = new StringBuilder();
                        audit.getAllErrorOrValidateInfo().forEach(row -> messageError.append(row.getMessage()));
                        log.info(messageError + audit.getMessage());
                        if ("true".equals(this.getPageCache().get("qcode"))) {
                            MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
                            StringBuilder message = new StringBuilder(ResManager.loadKDString((String)"\u6536\u8d27\u5355\u53f7\uff1a", (String)"PurBatReceiveMobilePlugin_6", (String)"scm-pur-mobile", (Object[])new Object[0]));
                            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_purreceivebill", (String)"billno", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)save.getSuccessPkIds())}, (String)"billno");){
                                dataSet.forEach(row -> message.append(row.getString("billno")));
                            }
                            mobileFormShowParameter.setCaption(ResManager.loadKDString((String)"\u82cd\u7a79\u4f9b\u5e94\u94fe\u6536\u8d27\u6210\u529f\u53cd\u9988\u3002", (String)"PurBatReceiveMobilePluginScmShsfk", (String)"scm-pur-mobile", (Object[])new Object[0]));
                            mobileFormShowParameter.setCustomParam("title", (Object)ResManager.loadKDString((String)"\u6536\u8d27\u6210\u529f", (String)"PurBatReceiveMobilePlugin_5", (String)"scm-pur-mobile", (Object[])new Object[0]));
                            mobileFormShowParameter.setCustomParam("content", (Object)message.toString());
                            this.openTips(mobileFormShowParameter);
                        }
                        this.getView().setEnable(Boolean.TRUE, new String[]{"mbarreceive"});
                        if ("true".equals(this.getPageCache().get("list"))) {
                            this.getView().close();
                        }
                    } else {
                        StringBuilder messageError = new StringBuilder();
                        submit.getAllErrorOrValidateInfo().forEach(row -> messageError.append(row.getMessage()));
                        this.getView().showMessage(ResManager.loadKDString((String)"\u63d0\u4ea4\u6536\u8d27\u5355\u5931\u8d25\u3002", (String)"PurBatReceiveMobilePlugin_7", (String)"scm-pur-mobile", (Object[])new Object[0]), submit.getMessage() + messageError, MessageTypes.ImageWithText_m, null);
                        log.info(messageError + submit.getMessage());
                    }
                } else {
                    this.getView().setEnable(Boolean.TRUE, new String[]{"mbarreceive"});
                    StringBuilder messageError = new StringBuilder();
                    save.getAllErrorOrValidateInfo().forEach(row -> messageError.append(row.getMessage()));
                    this.getView().showMessage(ResManager.loadKDString((String)"\u4fdd\u5b58\u6536\u8d27\u5355\u5931\u8d25\u3002", (String)"PurBatReceiveMobilePlugin_8", (String)"scm-pur-mobile", (Object[])new Object[0]), save.getMessage() + messageError, MessageTypes.ImageWithText_m, null);
                    log.info(messageError + save.getMessage());
                }
            } else {
                StringBuilder messageError = new StringBuilder();
                result.getReports().forEach(row -> messageError.append(row.getFailMessage()));
                this.getView().showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u6536\u8d27\u5355\u5931\u8d25{0}{1}{2}\u3002", (String)"PurBatReceiveMobilePlugin_9", (String)"scm-pur-mobile", (Object[])new Object[0]), " : ", result.getMessage(), messageError));
                log.info(messageError + result.getMessage());
            }
        }
    }

    private void openTips(MobileFormShowParameter mobileFormShowParameter) {
        mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        mobileFormShowParameter.setAppId("181/2AWNX/C6");
        mobileFormShowParameter.setFormId("pbd_succeedtips");
        this.getView().showForm((FormShowParameter)mobileFormShowParameter);
    }

    private void calOutStockQty(String ob) {
        int rowindex = this.getModel().getEntryCurrentRowIndex("entryentity");
        BigDecimal sumreceiptqty = (BigDecimal)this.getModel().getValue("sumreceiptqty", rowindex);
        BigDecimal receiptqty = (BigDecimal)this.getModel().getValue(RECEIVEQTY, rowindex);
        BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", rowindex);
        BigDecimal maxqty = qty.subtract(sumreceiptqty);
        switch (ob) {
            case "+": {
                if (maxqty.compareTo(receiptqty) <= 0) break;
                this.getModel().setValue(RECEIVEQTY, (Object)receiptqty.add(BigDecimal.ONE), rowindex);
                break;
            }
            case "-": {
                if (receiptqty.compareTo(BigDecimal.ONE) < 0) break;
                this.getModel().setValue(RECEIVEQTY, (Object)receiptqty.subtract(BigDecimal.ONE), rowindex);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        switch (name) {
            case "receiveqty": {
                BigDecimal qty = (BigDecimal)this.getModel().getValue("qty");
                BigDecimal sumReceiptQty = (BigDecimal)this.getModel().getValue("sumreceiptqty");
                if (qty.subtract(sumReceiptQty).compareTo((BigDecimal)newValue) >= 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6536\u8d27\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u53d1\u8d27\u6570\u91cf\u3002", (String)"PurBatReceiveMobilePlugin_10", (String)"scm-pur-mobile", (Object[])new Object[0]));
                this.getModel().setValue(RECEIVEQTY, oldValue, rowIndex);
            }
        }
    }
}

