/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin.mobile.inquiry;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pur.common.enums.BizStatusEnum;
import kd.scm.pur.common.helper.PurCompareHelper;
import kd.scm.pur.common.helper.PurInquiryOpHelper;
import kd.scm.pur.common.pojo.CompareConfirmInfo;
import kd.scm.pur.common.utils.ListUtils;
import kd.scm.pur.common.utils.MobileControlUtils;

public class PurInquiryMobEdit
extends AbstractMobBillPlugIn {
    private static final String[] turnsArray = new String[]{"", "", ResManager.loadKDString((String)"\u4e8c", (String)"PurInquiryMobEdit_Two", (String)"scm-pur-mobile", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e09", (String)"PurInquiryMobEdit_Three", (String)"scm-pur-mobile", (Object[])new Object[0]), ResManager.loadKDString((String)"\u56db", (String)"PurInquiryMobEdit_Four", (String)"scm-pur-mobile", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e94", (String)"PurInquiryMobEdit_Five", (String)"scm-pur-mobile", (Object[])new Object[0]), ResManager.loadKDString((String)"\u516d", (String)"PurInquiryMobEdit_Six", (String)"scm-pur-mobile", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e03", (String)"PurInquiryMobEdit_Seven", (String)"scm-pur-mobile", (Object[])new Object[0]), ResManager.loadKDString((String)"\u516b", (String)"PurInquiryMobEdit_Eight", (String)"scm-pur-mobile", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e5d", (String)"PurInquiryMobEdit_Nine", (String)"scm-pur-mobile", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341", (String)"PurInquiryMobEdit_Ten", (String)"scm-pur-mobile", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341\u4e00", (String)"PurInquiryMobEdit_Eleven", (String)"scm-pur-mobile", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341\u4e8c", (String)"PurInquiryMobEdit_Twelve", (String)"scm-pur-mobile", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341\u4e09", (String)"PurInquiryMobEdit_Thirteen", (String)"scm-pur-mobile", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341\u56db", (String)"PurInquiryMobEdit_Fourteen", (String)"scm-pur-mobile", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341\u4e94", (String)"PurInquiryMobEdit_Fifteen", (String)"scm-pur-mobile", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341\u516d", (String)"PurInquiryMobEdit_Sixteen", (String)"scm-pur-mobile", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341\u4e03", (String)"PurInquiryMobEdit_Seventeen", (String)"scm-pur-mobile", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341\u516b", (String)"PurInquiryMobEdit_Eighteen", (String)"scm-pur-mobile", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341\u4e5d", (String)"PurInquiryMobEdit_Nineteen", (String)"scm-pur-mobile", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e8c\u5341", (String)"PurInquiryMobEdit_Twenty", (String)"scm-pur-mobile", (Object[])new Object[0])};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"queryquotedetails", "down", "up", "terminate", "alertdate", "compare", "tocompare", "comparelabel", "uncomparelabel"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initVisible();
        this.setBizStatusBcAndFc();
        this.setTurns();
        this.handleAssignItemRows();
    }

    private void setBizStatusBcAndFc() {
        Control bizStatus = this.getControl("bizstatus");
        String bizStatusVal = (String)this.getModel().getValue("bizstatus");
        if (BizStatusEnum.QUOTING.getVal().equals(bizStatusVal)) {
            MobileControlUtils.controlSetFrontAndBackColor(bizStatus, "#FFFFFF", "#55A0F5");
        } else if (BizStatusEnum.OPENED.getVal().equals(bizStatusVal) || BizStatusEnum.CALIBRATED.getVal().equals(bizStatusVal) || BizStatusEnum.EXECUTED.getVal().equals(bizStatusVal)) {
            MobileControlUtils.controlSetFrontAndBackColor(bizStatus, "#FFFFFF", "#26B175");
        } else {
            MobileControlUtils.controlSetFrontAndBackColor(bizStatus, "#FFFFFF", "#666666");
        }
    }

    private void initVisible() {
        IFormView view = this.getView();
        view.setVisible(Boolean.valueOf(false), new String[]{"defaulthideflex", "up"});
        view.setVisible(Boolean.valueOf(true), new String[]{"down"});
        this.initCompareBtn();
    }

    private void initCompareBtn() {
        DynamicObject[] itemDetails;
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String inquiryNo = (String)model.getValue("billno");
        DynamicObject[] compareBills = PurInquiryOpHelper.getCompareData(inquiryNo);
        view.setVisible(Boolean.valueOf(compareBills == null || compareBills.length < 1), new String[]{"compare"});
        view.setVisible(Boolean.valueOf(false), new String[]{"tocompare"});
        CardEntry cardEntry = (CardEntry)this.getControl("materialentry");
        for (DynamicObject item : itemDetails = cardEntry.getEntryData().getDataEntitys()) {
            int index = item.getInt("seq") - 1;
            cardEntry.setChildVisible(false, index, new String[]{"comparelabel", "uncomparelabel", "unquotelabel"});
        }
    }

    private void handleAssignItemRows() {
        int i;
        IDataModel model = this.getModel();
        IPageCache pageCache = this.getPageCache();
        CardEntry cardEntry = (CardEntry)this.getControl("materialentry");
        DynamicObject[] itemDetails = cardEntry.getEntryData().getDataEntitys();
        ArrayList<String> entryIds = new ArrayList<String>(10);
        for (int i2 = 0; i2 < itemDetails.length && i2 < 500; ++i2) {
            DynamicObject item = itemDetails[i2];
            String id = String.valueOf(item.getLong("id"));
            entryIds.add(id);
        }
        String billNo = (String)model.getValue("billno");
        String turns = (String)model.getValue("turns");
        QFilter filter = new QFilter("inquiryno", "=", (Object)billNo);
        filter.and("turns", "=", (Object)turns);
        filter.and("billstatus", "=", (Object)"C");
        filter.and("materialentry.entrystatus", "=", (Object)"A");
        filter.and("materialentry.srcentryid", "in", entryIds);
        DynamicObjectCollection quotes = QueryServiceHelper.query((String)"sou_quote", (String)"materialentry.srcentryid", (QFilter[])filter.toArray(), null);
        ArrayList<Long> hasQuoteEntryIds = new ArrayList<Long>();
        int quoteCount = quotes.size();
        for (i = 0; i < quoteCount; ++i) {
            Long entryId;
            DynamicObject quote = (DynamicObject)quotes.get(i);
            String srcEntryId = quote.getString("materialentry.srcentryid");
            if (StringUtils.isEmpty((CharSequence)srcEntryId) || hasQuoteEntryIds.contains(entryId = Long.valueOf(srcEntryId))) continue;
            hasQuoteEntryIds.add(entryId);
        }
        for (i = 0; i < itemDetails.length && i < 500; ++i) {
            DynamicObject item = itemDetails[i];
            Long entryId = item.getLong("id");
            int index = item.getInt("seq") - 1;
            boolean hasQuote = hasQuoteEntryIds.contains(entryId);
            cardEntry.setChildVisible(hasQuote, index, new String[]{"queryquotedetails"});
        }
        pageCache.put("assignEntryIds", ListUtils.listToString(entryIds, "_"));
    }

    private void setTurns() {
        String turnsT;
        Label turnsLabel = (Label)this.getControl("turnslabel");
        String turnsKey = (String)this.getModel().getValue("turns");
        if (turnsKey == null || turnsKey.equals("")) {
            return;
        }
        if ("1".equals(turnsKey)) {
            turnsT = ResManager.loadKDString((String)"\u9996\u8f6e", (String)"PurInquiryMobEdit_2", (String)"scm-pur-mobile", (Object[])new Object[0]);
        } else {
            int turnNum = Integer.parseInt(turnsKey);
            if (turnNum > 20) {
                return;
            }
            turnsT = ResManager.loadKDString((String)"\u7b2c{0}\u8f6e", (String)"PurInquiryMobEdit_3", (String)"scm-pur-mobile", (Object[])new Object[]{turnsArray[turnNum]});
        }
        turnsLabel.setText(turnsT);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        OperationResult result = args.getOperationResult();
        switch (key) {
            case "terminate": {
                this.terminateOP(result);
                break;
            }
            case "alertdate": {
                PurInquiryOpHelper.alertdate((IFormPlugin)this, model, view, "pur_mobalertdate");
                break;
            }
            case "compare": {
                PurInquiryOpHelper.openCompareToolPage(this, model, view, "pur_mobcomparetool", 0);
                break;
            }
        }
    }

    private void terminateOP(OperationResult result) {
        if (result.isSuccess()) {
            IDataModel model = this.getModel();
            IFormView view = this.getView();
            PurInquiryOpHelper.terminate((IFormPlugin)this, model, view, "pur_mobinquiryend");
        }
    }

    public void click(EventObject e) {
        String opKey;
        super.click(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Control source = (Control)e.getSource();
        switch (opKey = source.getKey()) {
            case "queryquotedetails": {
                this.openQuoteAsitQueryPage();
                break;
            }
            case "down": {
                this.doDownOp();
                break;
            }
            case "up": {
                this.doUpOp();
                break;
            }
            case "comparelabel": 
            case "uncomparelabel": {
                int currEntryIndex = model.getEntryCurrentRowIndex("materialentry");
                PurInquiryOpHelper.openCompareToolPage(this, model, view, "pur_mobcomparetool", currEntryIndex);
                break;
            }
            case "tocompare": {
                PurCompareHelper compareHelper = new PurCompareHelper();
                compareHelper.compareConfirm(view);
                break;
            }
        }
    }

    private void doUpOp() {
        IFormView view = this.getView();
        view.setVisible(Boolean.valueOf(false), new String[]{"defaulthideflex", "up"});
        view.setVisible(Boolean.valueOf(true), new String[]{"down"});
    }

    private void doDownOp() {
        IFormView view = this.getView();
        view.setVisible(Boolean.valueOf(true), new String[]{"defaulthideflex", "up"});
        view.setVisible(Boolean.valueOf(false), new String[]{"down"});
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        IFormView view = this.getView();
        switch (callBackId) {
            case "compareConfirmCB": {
                if (e.getResult().compareTo((Enum)MessageBoxResult.Yes) != 0) break;
                PurCompareHelper compareHelper = new PurCompareHelper();
                CompareConfirmInfo compareCfmInfo = compareHelper.getCompareCfmInfo(view);
                compareHelper.createAndAuditCompBill(view, compareCfmInfo.getCompareBill());
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        BillModel model = (BillModel)this.getModel();
        switch (actionId) {
            case "inquiryTerminateAtionId": 
            case "alertDateAction": {
                PurInquiryOpHelper.refresh(view);
                break;
            }
            case "compareToolAtionId": {
                this.compareToolClosedCB(e, view, pageCache);
                break;
            }
        }
        model.setDataChanged(false);
    }

    private void compareToolClosedCB(ClosedCallBackEvent e, IFormView view, IPageCache pageCache) {
        DynamicObject[] itemDetails;
        Map returnData = (Map)e.getReturnData();
        Map idxToIsComparePrice = (Map)returnData.get("idxToIsComparePrice");
        Map idxToQuoInfo = (Map)returnData.get("idxToQuoInfo");
        pageCache.put("quotecustomparams", SerializationUtils.toJsonString((Object)idxToQuoInfo));
        view.setVisible(Boolean.valueOf(true), new String[]{"tocompare"});
        view.setVisible(Boolean.valueOf(false), new String[]{"compare"});
        CardEntry cardEntry = (CardEntry)this.getControl("materialentry");
        for (DynamicObject item : itemDetails = cardEntry.getEntryData().getDataEntitys()) {
            boolean isQuote;
            int index = item.getInt("seq") - 1;
            cardEntry.setChildVisible(false, index, new String[]{"queryquotedetails"});
            String isComparePrice = (String)idxToIsComparePrice.get(String.valueOf(index));
            boolean bl = isQuote = !StringUtils.isEmpty((CharSequence)isComparePrice);
            if (!isQuote) {
                cardEntry.setChildVisible(true, index, new String[]{"unquotelabel"});
                cardEntry.setChildVisible(false, index, new String[]{"comparelabel", "uncomparelabel"});
                continue;
            }
            boolean isCompared = "1".equals(isComparePrice);
            cardEntry.setChildVisible(false, index, new String[]{"unquotelabel"});
            cardEntry.setChildVisible(isCompared, index, new String[]{"comparelabel"});
            cardEntry.setChildVisible(!isCompared, index, new String[]{"uncomparelabel"});
        }
    }

    private void openQuoteAsitQueryPage() {
        boolean isShowTips;
        int currEntryIndex;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        String openType = (String)model.getValue("opentype");
        if (!"1".equals(openType)) {
            return;
        }
        DynamicObjectCollection materialEntry = model.getEntryEntity("materialentry");
        DynamicObject currEntry = (DynamicObject)materialEntry.get(currEntryIndex = model.getEntryCurrentRowIndex("materialentry"));
        Long entryPkValue = currEntry.getLong("id");
        String entryId = entryPkValue == null ? "" : String.valueOf(entryPkValue);
        List<Map<String, Object>> quoteBillParams = PurInquiryOpHelper.buildQuoCustomParams(model, entryId);
        String assignEntryIds = pageCache.get("assignEntryIds");
        boolean isOpenQuoPage = quoteBillParams != null;
        boolean bl = isShowTips = !isOpenQuoPage && !assignEntryIds.contains(entryId + "_");
        if (isShowTips) {
            view.showTipNotification(ResManager.loadKDString((String)"\u65e0\u5339\u914d\u7684\u62a5\u4ef7\u5355\u6570\u636e\u3002", (String)"PurInquiryMobEdit_1", (String)"scm-pur-mobile", (Object[])new Object[0]));
        }
        if (!isOpenQuoPage) {
            return;
        }
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        Map<String, Object> inquiryCustParams = PurInquiryOpHelper.getInquiryCustParams(model);
        customParams.put("inquirycustomparams", inquiryCustParams);
        customParams.put("quotecustomparams", quoteBillParams);
        showParameter.setCustomParams(customParams);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setFormId("pur_mobquoteassitquery");
        view.showForm((FormShowParameter)showParameter);
    }
}

