/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.util.EmalParamsUtil;
import kd.scm.common.util.DateUtil;

public class PurGetCheckDataPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button bt = (Button)this.getControl("btnok");
        bt.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("startdate", (Object)DateUtil.addDays((Date)TimeServiceHelper.today(), (int)(-this.getLastSomeDay())));
        List openedMalNos = EmalParamsUtil.getOpenedEmalNumberList();
        if (openedMalNos == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u5df2\u5f00\u901a\u7684\u7535\u5546\uff0c\u8bf7\u5230\u7535\u5546\u6388\u6743\u91cc\u914d\u7f6e\u5bf9\u5e94\u7684\u7535\u5546\u3002", (String)"PurGetCheckDataPlugin_0", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            this.getView().close();
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"jd", "jdpro", "sn", "dl", "xy", "cg", "zkh", "unkonw"});
            ArrayList viKeyList = new ArrayList();
            boolean hasSetDefault = false;
            if (openedMalNos.contains(EcPlatformEnum.ECPLATFORM_JD.getVal())) {
                this.getModel().setValue("source", (Object)"2");
                hasSetDefault = true;
            }
            if (openedMalNos.contains(EcPlatformEnum.ECPLATFORM_DL.getVal()) && !hasSetDefault) {
                this.getModel().setValue("source", (Object)"4");
                hasSetDefault = true;
            }
            if (openedMalNos.contains(EcPlatformEnum.ECPLATFORM_CG.getVal()) && !hasSetDefault) {
                this.getModel().setValue("source", (Object)"6");
                hasSetDefault = true;
            }
            if (openedMalNos.contains(EcPlatformEnum.ECPLATFORM_XY.getVal()) && !hasSetDefault) {
                this.getModel().setValue("source", (Object)"5");
                hasSetDefault = true;
            }
            if (openedMalNos.contains(EcPlatformEnum.ECPLATFORM_SUNING.getVal()) && !hasSetDefault) {
                this.getModel().setValue("source", (Object)"3");
            }
            if (openedMalNos.contains(EcPlatformEnum.ECPLATFORM_ZKH.getVal()) && !hasSetDefault) {
                this.getModel().setValue("source", (Object)"9");
            }
            openedMalNos.forEach(mallNo -> this.getViKeyList((String)mallNo, viKeyList));
            this.getView().setVisible(Boolean.valueOf(true), viKeyList.toArray(new String[0]));
        }
    }

    protected void getViKeyList(String mallNo, List<String> viKeyList) {
        if (EcPlatformEnum.ECPLATFORM_JD.getVal().equals(mallNo)) {
            viKeyList.add("jd");
        }
        if (EcPlatformEnum.ECPLATFORM_JDPRO.getVal().equals(mallNo)) {
            viKeyList.add("jdpro");
            this.getModel().setValue("source", (Object)"7");
        }
        if (EcPlatformEnum.ECPLATFORM_SUNING.getVal().equals(mallNo)) {
            viKeyList.add("sn");
        }
        if (EcPlatformEnum.ECPLATFORM_DL.getVal().equals(mallNo)) {
            viKeyList.add("dl");
        }
        if (EcPlatformEnum.ECPLATFORM_XY.getVal().equals(mallNo)) {
            viKeyList.add("xy");
        }
        if (EcPlatformEnum.ECPLATFORM_CG.getVal().equals(mallNo)) {
            viKeyList.add("cg");
        }
        if (EcPlatformEnum.ECPLATFORM_ZKH.getVal().equals(mallNo)) {
            viKeyList.add("zkh");
        }
    }

    public int getLastSomeDay() {
        return 7;
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control c = (Control)evt.getSource();
        if ("btnok".equals(c.getKey())) {
            Date startDate = (Date)this.getModel().getValue("startdate");
            Date endDate = (Date)this.getModel().getValue("enddate");
            if (startDate == null || endDate == null) {
                evt.setCancel(true);
                return;
            }
            if (endDate.getTime() < startDate.getTime()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"PurGetCheckDataPlugin_1", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            if (this.getModel().getValue("source").equals("9")) {
                Calendar startCld = Calendar.getInstance();
                startCld.setTime(startDate);
                Calendar endCld = Calendar.getInstance();
                endCld.setTime(endDate);
                int yearDiff = endCld.get(1) - startCld.get(1);
                int monthDiff = endCld.get(2) - startCld.get(2);
                int dayDiff = endCld.get(5) - startCld.get(5);
                if (yearDiff > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9707\u5764\u884c\u5bf9\u8d26\u65f6\u95f4\u8de8\u5ea6\u4e0d\u80fd\u8d85\u8fc7\u516d\u4e2a\u6708\u3002", (String)"PurGetCheckDataPlugin_2", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                if (yearDiff == 1) {
                    monthDiff += 12;
                }
                if (monthDiff > 6) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9707\u5764\u884c\u5bf9\u8d26\u65f6\u95f4\u8de8\u5ea6\u4e0d\u80fd\u8d85\u8fc7\u516d\u4e2a\u6708\u3002", (String)"PurGetCheckDataPlugin_2", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                if (monthDiff == 6 && dayDiff >= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9707\u5764\u884c\u5bf9\u8d26\u65f6\u95f4\u8de8\u5ea6\u4e0d\u80fd\u8d85\u8fc7\u516d\u4e2a\u6708\u3002", (String)"PurGetCheckDataPlugin_2", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if ("btnok".equals(c.getKey())) {
            this.getView().updateView();
            Map<String, String> returnData = this.packageReturnData();
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    public Map<String, String> packageReturnData() {
        HashMap<String, String> returnData = new HashMap<String, String>();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        returnData.put("source", (String)this.getModel().getValue("source"));
        returnData.put("startDate", formatter.format(this.getModel().getValue("startdate")));
        returnData.put("endDate", formatter.format(this.getModel().getValue("enddate")));
        returnData.put("pageNo", (String)this.getModel().getValue("pageno"));
        returnData.put("pageSize", (String)this.getModel().getValue("pagesize"));
        return returnData;
    }
}

