/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.invcloud.enums.InvoiceTypeEnum;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.MutexUtil;
import kd.scm.common.util.mal.MalNewOrderUtils;
import kd.scm.pur.business.CreateAPBillSupportHelper;
import kd.scm.pur.business.PurInvoiceHelper;
import kd.scm.pur.business.PurJointChannelHelper;
import kd.scm.pur.common.PurInvoiceUtil;
import kd.scm.pur.common.ecinvoice.EcInvoiceFactory;
import kd.scm.pur.common.ecinvoice.service.impl.GenericEcInvoiceService;
import kd.scm.pur.formplugin.PurCoreBillEditPlugin;
import kd.scm.pur.service.IPurInvoiceService;
import kd.scm.pur.servicehelper.ServiceFactory;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class PurInvoiceEditPlugin
extends PurCoreBillEditPlugin
implements HyperLinkClickListener {
    private static final Log log = LogFactory.getLog(PurInvoiceEditPlugin.class);
    private static final String JDSUPPLER = "486095512240421888";
    private static final String OP_GENERATE_REIMBURSE = "generatereimburse";
    private static final String ER_PUBLICREIMBURSEBILL = "er_publicreimbursebill";
    private static final String HAS_PUSHED = "1";
    private static final String NOT_PUSH = "2";
    private static final String ISENTRYPAY = "isentrypay";
    private static final String OP_CONFIRM = "confirm";
    private static final String OP_CQ_SUBMITBID = "cq_submitbid";
    private static final String ACTION_BOTPLIST = "botpList";
    public static final String PLATFORM = "platform";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid headGrid = (EntryGrid)this.getView().getControl("entryentity1");
        headGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject dy = this.getModel().getDataEntity(true);
        boolean xhConfig = PurJointChannelHelper.hasDefaultJointChannel((DynamicObject[])new DynamicObject[]{dy}, (String)"self");
        if (!xhConfig) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_itemap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_confirm"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_itemap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_confirm"});
        }
        this.initEcView();
    }

    private boolean isOverseasOrDigitalInvoices(DynamicObject invoiceTypeDy) {
        if (invoiceTypeDy == null) {
            return false;
        }
        String invoiceType = invoiceTypeDy.getString("number");
        return InvoiceTypeEnum.INVOICETYPE30.getVal().equals(invoiceType) || InvoiceTypeEnum.INVOICETYPE26.getVal().equals(invoiceType) || InvoiceTypeEnum.INVOICETYPE27.getVal().equals(invoiceType);
    }

    protected void initEcView() {
        String source;
        DynamicObjectCollection entryentity1 = this.getModel().getEntryEntity("entryentity1");
        if (entryentity1.isEmpty()) {
            return;
        }
        String ecorderPk = ((DynamicObject)entryentity1.get(0)).getString("ecorder");
        if (StringUtils.isEmpty((CharSequence)ecorderPk) || "0".equals(ecorderPk)) {
            ecorderPk = ((DynamicObject)entryentity1.get(0)).getString("entryjdorder.id");
            if (StringUtils.isEmpty((CharSequence)ecorderPk) || "0".equals(ecorderPk)) {
                return;
            }
            source = EcPlatformEnum.ECPLATFORM_JD.getVal();
        } else {
            source = MalNewOrderUtils.getPlatformByEcOrderPk((Long)Long.valueOf(ecorderPk));
        }
        GenericEcInvoiceService ecInvoiceService = EcInvoiceFactory.getEcInvoiceServiceBySource((String)source);
        if (ecInvoiceService != null) {
            DynamicObject ecOrderDyn = ecInvoiceService.queryEcOrderByPk(ecorderPk);
            if (!EcPlatformEnum.ECPLATFORM_JD.getVal().equals(source)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"entrychildorderid"});
            }
            if (ecOrderDyn != null) {
                this.getModel().setValue("ecinvoicestate", (Object)ecOrderDyn.getString("invoicestate"));
                this.getModel().setValue("ecinvoiceresult", (Object)ecOrderDyn.getString("invoiceresult"));
                this.getModel().setDataChanged(false);
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"ecinvoicestate", "ecinvoiceresult", "entrychildorderid"});
        }
    }

    private void openBotpListPage(String pkStr, Map<String, List<Object>> ruleListMap, String toBillType) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("rules", ruleListMap.get("instock"));
        param.put("tobilltype", toBillType);
        param.put("pkstr", pkStr);
        param.put("rules1", ruleListMap.get("receipt"));
        param.put("tobilltype1", toBillType);
        param.put("pkstr1", pkStr);
        param.put("rule11", ruleListMap.get("instockreturn"));
        param.put("tobilltype11", toBillType);
        param.put("pkstr11", pkStr);
        param.put("rulereceive", ruleListMap.get("appurreced"));
        param.put("tobilltypereceive", toBillType);
        param.put("pkstrreceive", pkStr);
        param.put("rulepropertyconvert", ruleListMap.get("propertyconvert"));
        param.put("tobilltypepropertyconvert", toBillType);
        param.put("pkstrpropertyconvert", pkStr);
        FormShowParameter formParam = BillFormUtil.assembleShowDynamicFormParam((String)"check_botp_list", param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, ACTION_BOTPLIST), (ShowType)ShowType.Modal);
        this.getView().showForm(formParam);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        switch (closedCallBackEvent.getActionId()) {
            case "botpList": {
                Object botpList_condition = closedCallBackEvent.getReturnData();
                if (botpList_condition == null) {
                    return;
                }
                IFormView view = this.getView();
                BillModel model = (BillModel)this.getModel();
                model.load(model.getPKValue());
                DynamicObject obj = model.getDataEntity(true);
                Map result = (Map)botpList_condition;
                Object ruleNumber = result.get("rule");
                Object ruleNumber1 = result.get("rule1");
                HashMap<String, String> rulesMap = new HashMap<String, String>();
                if (ruleNumber != null) {
                    rulesMap.put("instock", String.valueOf(ruleNumber));
                }
                if (ruleNumber1 != null) {
                    rulesMap.put("receipt", String.valueOf(ruleNumber1));
                }
                if (ApiConfigUtil.hasXKScmConfig()) {
                    Object rulePropertyConvert;
                    Object ruleReceive;
                    Object ruleNumber11 = result.get("rule11");
                    if (ruleNumber11 != null) {
                        rulesMap.put("instockreturn", String.valueOf(ruleNumber11));
                    }
                    if ((ruleReceive = result.get("rulereceive")) != null) {
                        rulesMap.put("appurreced", String.valueOf(ruleReceive));
                    }
                    if ((rulePropertyConvert = result.get("rulepropertyconvert")) != null) {
                        rulesMap.put("propertyconvert", String.valueOf(rulePropertyConvert));
                    }
                }
                this.toInvoice(obj, rulesMap);
                view.updateView("cfmstatus");
                break;
            }
            case "generatereimburse": {
                this.releaseGenErMutex();
            }
        }
    }

    private boolean checkStatus() {
        boolean verifyFlag = true;
        boolean isAllPushed = true;
        this.getView().invokeOperation("refresh");
        DynamicObjectCollection entryCol1 = this.getModel().getEntryEntity("entryentity1");
        for (DynamicObject entry : entryCol1) {
            if (!StringUtils.isEmpty((CharSequence)entry.getString(ISENTRYPAY)) && !NOT_PUSH.equals(entry.getString(ISENTRYPAY))) continue;
            isAllPushed = false;
        }
        if (isAllPushed) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u751f\u6210\u4e0b\u6e38\u5355\u636e\u3002", (String)"PurInvoiceEditPlugin_0", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            verifyFlag = false;
        }
        if (!"B".equals(this.getModel().getDataEntity().getString("cfmstatus"))) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u7b7e\u6536\u72b6\u6001\u4e3a\u5df2\u7b7e\u6536\u624d\u80fd\u751f\u6210\u4e0b\u6e38\u5355\u636e\u3002", (String)"PurInvoiceEditPlugin_1", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            verifyFlag = false;
        }
        return verifyFlag;
    }

    @Override
    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        DynamicObject supplier = (DynamicObject)this.getModel().getValue("supplier");
        if (null != supplier && StringUtils.equals((CharSequence)String.valueOf(supplier.getPkValue()), (CharSequence)JDSUPPLER)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"checkbillno"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"reqperson"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"revname"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"jdchildorderid"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"jdinvoicestate"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"jdinvoiceresult"});
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String clickKey;
        switch (clickKey = evt.getItemKey()) {
            case "bar_viewinvoice": {
                String invAddress = this.getModel().getDataEntity().getString("invaddress");
                this.getView().openUrl(invAddress);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if (OP_GENERATE_REIMBURSE.equals(operateKey)) {
            if (!MalNewOrderUtils.checkIsGoodsBizTypeId((Long)PurInvoiceUtil.getBizTypeId((DynamicObject)this.getModel().getDataEntity(true)))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u5546\u54c1\u7c7b\u91c7\u8d2d\u624d\u80fd\u751f\u6210\u5bf9\u516c\u62a5\u9500\u5355\u3002", (String)"PurInvoiceEditPlugin_7", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (!this.checkStatus()) {
                args.setCancel(true);
                return;
            }
        }
        if ((OP_CQ_SUBMITBID.equals(operateKey) || OP_CONFIRM.equals(operateKey)) && MalNewOrderUtils.checkIsGoodsBizTypeId((Long)PurInvoiceUtil.getBizTypeId((DynamicObject)this.getModel().getDataEntity(true)))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u975e\u5546\u54c1\u7c7b\u91c7\u8d2d\u624d\u80fd\u751f\u6210\u5e94\u4ed8\u3002", (String)"PurInvoiceEditPlugin_8", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        if ("generateap".equals(operateKey)) {
            FormOperate formOperate = (FormOperate)args.getSource();
            formOperate.getOption().setVariableValue("batchop_batchsize", String.valueOf(1));
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (null != afterDoOperationEventArgs.getOperationResult() && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "logquery": {
                    IFormView viewLogquery = this.getView();
                    IDataModel dataModel = this.getModel();
                    FormShowParameter param = null;
                    DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity1");
                    DynamicObject supplier = (DynamicObject)this.getModel().getDataEntity(true).get("supplier");
                    Long supplierId = Long.valueOf(supplier.get("id").toString());
                    String source = GenericEcInvoiceService.getSource((Long)supplierId);
                    DynamicObject jdOrderDyn = null;
                    HashSet<String> dsChildOrderIds = new HashSet<String>();
                    for (DynamicObject entry : entrys) {
                        String childOrderId;
                        jdOrderDyn = entry.getDynamicObject("entryjdorder");
                        String dsChildOrderId = entry.getString("ecorder");
                        if (kd.bos.util.StringUtils.isNotEmpty((String)dsChildOrderId) && null == jdOrderDyn && null != (childOrderId = MalNewOrderUtils.getSubOrderId((String)source, (String)dsChildOrderId))) {
                            dsChildOrderIds.add(childOrderId);
                        }
                        if (jdOrderDyn == null) continue;
                        dsChildOrderIds.add(jdOrderDyn.getString("number"));
                    }
                    if (dsChildOrderIds.size() > 0) {
                        FormShowParameter showParameter = new FormShowParameter();
                        showParameter.setFormId("pbd_logistics");
                        showParameter.getOpenStyle().setShowType(ShowType.Modal);
                        HashMap<String, Object> paramMap = new HashMap<String, Object>();
                        paramMap.put("ecChildOrderids", dsChildOrderIds);
                        paramMap.put("LOGISTICS_TYPE", "invoice");
                        paramMap.put(PLATFORM, source);
                        showParameter.setCustomParams(paramMap);
                        viewLogquery.showForm(showParameter);
                        break;
                    }
                    HashMap<String, Object> customFilter = new HashMap<String, Object>();
                    customFilter.put("pkidcoll", new Object[]{dataModel.getDataEntity().getPkValue()});
                    customFilter.put("ENTRY_KEY", dataModel.getDataEntity().getDataEntityType().getName());
                    param = BillFormUtil.assembleShowDynamicFormParam((String)"pur_invlogquery", customFilter, null, (ShowType)ShowType.MainNewTabPage);
                    this.getView().showForm(param);
                    break;
                }
                case "cq_submitbid": {
                    if (!this.checkStatus()) {
                        return;
                    }
                    DynamicObject dynamicObject = this.getModel().getDataEntity(true);
                    Map extParamMap = CreateAPBillSupportHelper.getAllExtendCQFields((DynamicObject[])new DynamicObject[]{dynamicObject});
                    String message = "";
                    try {
                        message = PurInvoiceHelper.singleToApBill((DynamicObject)dynamicObject, (Map)extParamMap);
                    }
                    catch (KDException exception) {
                        message = exception.getMessage();
                    }
                    if (message.length() <= 1) break;
                    this.getView().showMessage(message);
                    BillModel billModel = (BillModel)this.getModel();
                    billModel.load(billModel.getPKValue());
                    this.getView().updateView();
                    break;
                }
                case "confirm": {
                    IFormView view = this.getView();
                    if (!this.checkStatus()) {
                        return;
                    }
                    DynamicObject obj = this.getModel().getDataEntity(true);
                    boolean enableWriteOffFlag = QueryServiceHelper.exists((String)"pur_updateparamconfig", (QFilter[])new QFilter[]{new QFilter("paramkey", "=", (Object)"writeoffkey").and(new QFilter("paramvalue", "=", (Object)"Y"))});
                    if (ApiConfigUtil.hasEASScmConfig() && !ApiConfigUtil.hasXKScmConfig() && enableWriteOffFlag) {
                        this.toInvoice(obj, new HashMap<String, String>(1024));
                        break;
                    }
                    Map rulesMap = PurInvoiceUtil.getBotpRule((DynamicObject[])new DynamicObject[]{obj}, (String)"otherbill");
                    if (rulesMap.size() == 0 || StringUtils.isEmpty((CharSequence)((CharSequence)rulesMap.get("receipt"))) && StringUtils.isEmpty((CharSequence)((CharSequence)rulesMap.get("instock"))) && StringUtils.isEmpty((CharSequence)((CharSequence)rulesMap.get("instockreturn"))) && StringUtils.isEmpty((CharSequence)((CharSequence)rulesMap.get("appurreced"))) && StringUtils.isEmpty((CharSequence)((CharSequence)rulesMap.get("propertyconvert")))) {
                        view.showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u53ef\u7528\u7684\u8f6c\u6362\u89c4\u5219\u3002", (String)"PurInvoiceEditPlugin_3", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.toConfirm(view, obj, rulesMap);
                    break;
                }
                case "generatereimburse": {
                    this.checkGenErMutex(this.getModel().getDataEntity().getString("id"));
                    ArrayList<Long> purInvoiceIds = new ArrayList<Long>();
                    purInvoiceIds.add((Long)this.getModel().getDataEntity().getPkValue());
                    IPurInvoiceService purInvoiceService = (IPurInvoiceService)ServiceFactory.getService(IPurInvoiceService.class);
                    try {
                        ConvertOperationResult convertOperationResult = purInvoiceService.generatePublicReimburseBill(purInvoiceIds);
                        long targetId = 0L;
                        for (Object successId : convertOperationResult.getTargetBillIds()) {
                            targetId = (Long)successId;
                        }
                        this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)ER_PUBLICREIMBURSEBILL, (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.EDIT, (long)targetId, null, (CloseCallBack)new CloseCallBack((IFormPlugin)this, OP_GENERATE_REIMBURSE)));
                        break;
                    }
                    catch (Exception e) {
                        log.warn(ExceptionUtil.getStackTrace((Throwable)e));
                        throw new KDBizException((Throwable)e, new ErrorCode("generatePublicReimburseBill", e.getMessage()), new Object[0]);
                    }
                    finally {
                        this.releaseGenErMutex();
                    }
                }
            }
        }
    }

    private void toConfirm(IFormView view, DynamicObject obj, Map<String, String> rulesMap) {
        StringBuilder errorMessage = new StringBuilder();
        HashMap<String, List<Object>> ruleListMap = new HashMap<String, List<Object>>((int)((double)rulesMap.size() / 0.75));
        for (Map.Entry<String, String> entry : rulesMap.entrySet()) {
            try {
                JSONArray inwareRuleList = JSONArray.fromObject((Object)entry.getValue());
                ruleListMap.put(entry.getKey(), (List<Object>)inwareRuleList);
            }
            catch (Exception e) {
                errorMessage.append(ResManager.loadKDString((String)"\u6570\u636e\u9519\u8bef", (String)"PurInvoiceEditPlugin_6", (String)"scm-pur-formplugin", (Object[])new Object[0])).append(e.getLocalizedMessage());
            }
        }
        if (errorMessage.length() > 0) {
            view.showMessage(errorMessage.toString());
            return;
        }
        if (ruleListMap.size() > 0) {
            if (ruleListMap.size() == 1 && (null != ruleListMap.get("receipt") || null != ruleListMap.get("instock") || null != ruleListMap.get("instockreturn") || null != ruleListMap.get("appurreced"))) {
                if (null != ruleListMap.get("receipt")) {
                    this.toConfirm(view, obj, "receipt", ruleListMap);
                } else if (null != ruleListMap.get("instock")) {
                    this.toConfirm(view, obj, "instock", ruleListMap);
                } else if (null != ruleListMap.get("instockreturn")) {
                    this.toConfirm(view, obj, "instockreturn", ruleListMap);
                } else if (null != ruleListMap.get("appurreced")) {
                    this.toConfirm(view, obj, "appurreced", ruleListMap);
                }
            } else {
                this.openBotpListPage(String.valueOf(obj.getPkValue()), ruleListMap, "otherbill");
            }
        }
    }

    private void toConfirm(IFormView view, DynamicObject obj, String ruleKey, Map<String, List<Object>> ruleListMap) {
        JSONObject json = JSONObject.fromObject((Object)ruleListMap.get(ruleKey).get(0));
        if (!json.getString("error").isEmpty()) {
            this.getView().showMessage(ResManager.loadKDString((String)json.getString("error"), (String)"PurInvoiceEditPlugin_4", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> ruleMap = new HashMap<String, String>();
        ruleMap.put(ruleKey, json.getString("number"));
        if ("instockreturn".equals(ruleKey) || "appurreced".equals(ruleKey)) {
            if (ApiConfigUtil.hasXKScmConfig()) {
                this.toInvoice(obj, ruleMap);
            }
        } else {
            this.toInvoice(obj, ruleMap);
        }
    }

    private void toInvoice(DynamicObject obj, Map<String, String> ruleMap2) {
        OperateOption operateOption = OperateOption.create();
        String str = SerializationUtils.toJsonString(ruleMap2);
        log.info("\u751f\u6210\u5e94\u4ed8\u524dbotp\u89c4\u5219\u4e3a\uff1a{}", (Object)str);
        operateOption.setVariableValue("ruleMap", str);
        this.getView().invokeOperation("generateap", operateOption);
        this.getView().invokeOperation("refresh");
    }

    private void checkGenErMutex(String id) {
        boolean request = MutexUtil.request((String)id, (String)"pur_invoice", (String)OP_GENERATE_REIMBURSE);
        if (!request) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u6b63\u5728\u751f\u6210\u5bf9\u516c\u62a5\u9500\u5355\uff0c\u8bf7\u7a0d\u540e\u6267\u884c\u3002", (String)"PurInvoiceEditPlugin_9", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        }
        this.getPageCache().put("successMutex", id);
    }

    private void releaseGenErMutex() {
        String successMutex = this.getPageCache().get("successMutex");
        if (StringUtils.isNotEmpty((CharSequence)successMutex)) {
            MutexUtil.release((String)successMutex, (String)"pur_invoice", (String)OP_GENERATE_REIMBURSE);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String clickKey;
        super.beforeItemClick(evt);
        switch (clickKey = evt.getItemKey()) {
            case "bar_viewinvoice": {
                String invAddress = this.getModel().getDataEntity().getString("invaddress");
                if (invAddress != null && !invAddress.isEmpty() && (invAddress.startsWith("https://") || invAddress.startsWith("http://"))) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u4e0b\u8f7d\u5730\u5740\u4e3a\u7a7a\u6216\u65e0\u6548\uff0c\u4e0d\u80fd\u4e0b\u8f7d\u6d4f\u89c8\u3002", (String)"PurInvoiceEditPlugin_5", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
        }
    }

    public void pageRelease(EventObject e) {
        this.releaseGenErMutex();
    }

    public void hyperLinkClick(HyperLinkClickEvent heperLinkEvent) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        EntryGrid grid = (EntryGrid)heperLinkEvent.getSource();
        String gridKey = grid.getKey();
        String property = heperLinkEvent.getFieldName();
        if (gridKey.equals("entryentity1")) {
            int rowIndex = heperLinkEvent.getRowIndex();
            if ("deductamount".equals(property)) {
                DynamicObject curr;
                EntryData entryData = grid.getEntryData();
                DynamicObject dy = entryData.getDataEntitys()[rowIndex];
                HashMap<String, Object> customParams = new HashMap<String, Object>(8);
                DynamicObject material = dy.getDynamicObject("material1");
                if (material != null) {
                    customParams.put("material", material.getPkValue());
                }
                if ((curr = dataEntity.getDynamicObject("curr")) != null) {
                    customParams.put("curr", curr.getPkValue());
                }
                customParams.put("afterdeductdiscounttype", dy.getString("afterdeductdiscounttype"));
                customParams.put("deductamount", dy.getBigDecimal("deductamount"));
                customParams.put("afterdeductdctrate", dy.getBigDecimal("afterdeductdctrate"));
                customParams.put("afterdeductdctamount", dy.getBigDecimal("afterdeductdctamount"));
                customParams.put("afterdeducttax", dy.getBigDecimal("afterdeducttax"));
                customParams.put("afterdeductamount", dy.getBigDecimal("afterdeductamount"));
                customParams.put("afterdeducttaxamount", dy.getBigDecimal("afterdeducttaxamount"));
                this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"pur_invoice_deduct", customParams, null, (ShowType)ShowType.Modal));
            }
        }
    }
}

