/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.OrgUtil;

public class PurReturnQueryPlugin
extends AbstractFormPlugin {
    private static final String SOURCE_ENTITY_KEY = "source";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit revOrg = (BasedataEdit)this.getControl("rcvorg");
        revOrg.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                List orglist = OrgUtil.getAllInvViewPermissionOrgs((String)"pur_instock");
                QFilter filter = new QFilter("id", "in", (Object)orglist);
                ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                formShowParameter.getListFilterParameter().getQFilters().add(filter);
            }
        });
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "barquery": {
                IDataModel model = this.getModel();
                DynamicObject revOrg = (DynamicObject)model.getValue("rcvorg");
                DynamicObject supplier = (DynamicObject)model.getValue("supplier");
                String source = (String)model.getValue(SOURCE_ENTITY_KEY);
                String pobillno = String.valueOf(model.getValue("pobillno"));
                DynamicObject materiel = (DynamicObject)model.getValue("material");
                Date billdate = (Date)model.getValue("delidate");
                Date datefrom = (Date)model.getValue("delidatefrom");
                if (null != billdate && null != datefrom && billdate.before(datefrom)) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u65e5\u671f\u4ece\u201d\u4e0d\u80fd\u665a\u4e8e\u201c\u4e1a\u52a1\u65e5\u671f\u4ece\u81f3\u201d\u3002", (String)"PurReturnQueryPlugin_0", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashMap<String, Object> returnData = new HashMap<String, Object>();
                returnData.put("rcvorg", revOrg != null ? revOrg.getPkValue() : null);
                returnData.put("supplier", supplier != null ? supplier.getPkValue() : null);
                returnData.put("pobillno", pobillno);
                returnData.put(SOURCE_ENTITY_KEY, source);
                returnData.put("material", materiel != null ? materiel.getPkValue() : null);
                returnData.put("billdatefrom", datefrom != null ? DateUtil.getFormatStartDate((Date)datefrom) : null);
                returnData.put("billdate", billdate != null ? DateUtil.getFormatEndDate((Date)billdate) : null);
                this.getView().returnDataToParent(returnData);
                this.getView().close();
            }
        }
    }

    public void initialize() {
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        Map customerParam = this.getView().getFormShowParameter().getShowParameter().getCustomParams();
        if (customerParam != null) {
            String pobillno;
            Object purorgid;
            Object showParameterMap = customerParam.get("customfilter");
            if (null != showParameterMap && (purorgid = ((Map)showParameterMap).get("purorgid")) != null) {
                Long pkId = Long.valueOf(purorgid.toString());
                model.setValue("rcvorg", (Object)pkId);
            }
            if ((pobillno = (String)customerParam.get("pobillno")) != null) {
                model.setValue("pobillno", (Object)pobillno);
            }
            Date currDate = new Date();
            Object startDate = customerParam.get("delidatefrom");
            if (null != startDate) {
                model.setValue("delidatefrom", (Object)DateUtil.string2date((String)startDate.toString(), null));
            } else {
                model.setValue("delidatefrom", (Object)DateUtil.addMonth((Date)currDate, (int)-1));
            }
        }
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        this.getModel().setDataChanged(false);
    }
}

