/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.systemjoint.SystemJointChannelHelper;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.OrgUtil;
import kd.scm.pur.business.PurJointChannelHelper;

public final class PurSendQueryPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("rcvorg");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setJointChannelDataVisibleAndEnable();
    }

    private void setJointChannelDataVisibleAndEnable() {
        ArrayList<String> verifyEntityNumbers = new ArrayList<String>(16);
        verifyEntityNumbers.add("pur_order");
        verifyEntityNumbers.add("pur_saloutstock");
        boolean isEnable = PurJointChannelHelper.checkMultiJointSystem(verifyEntityNumbers);
        this.getView().setEnable(Boolean.valueOf(isEnable), new String[]{"jointchanneldata"});
        this.getView().setVisible(Boolean.valueOf(isEnable), new String[]{"jointchanneldata"});
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name;
        switch (name = beforeF7SelectEvent.getProperty().getName()) {
            case "rcvorg": {
                List permissionOrgs = OrgUtil.getAllInvViewPermissionOrgs((String)"pur_saloutstock");
                ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)permissionOrgs));
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if (key.isEmpty()) {
            return;
        }
        switch (key) {
            case "query": {
                IDataModel model = this.getModel();
                DynamicObject revOrg = (DynamicObject)model.getValue("rcvorg");
                DynamicObject supplier = (DynamicObject)model.getValue("supplier");
                String pobillno = String.valueOf(model.getValue("pobillno"));
                DynamicObject materiel = (DynamicObject)model.getValue("material");
                Date delidate = (Date)model.getValue("delidate");
                Date datefrom = (Date)model.getValue("delidatefrom");
                if (null != delidate && null != datefrom && delidate.before(datefrom)) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u201c\u9884\u8ba1\u5230\u8d27\u65e5\u671f\u4ece\u201d\u4e0d\u80fd\u665a\u4e8e\u201c\u9884\u8ba1\u5230\u8d27\u65e5\u671f\u81f3\u201d\u3002", (String)"PurSendQueryPlugin_0", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                boolean onlylookme = Boolean.parseBoolean(String.valueOf(model.getValue("onlylookme")));
                String jointChannelId = null;
                DynamicObject jointchanneldata = model.getDataEntity().getDynamicObject("jointchanneldata");
                jointChannelId = jointchanneldata != null ? jointchanneldata.getString("id") : SystemJointChannelHelper.getDefaultJointChannelId();
                HashMap<String, Object> returnData = new HashMap<String, Object>();
                returnData.put("rcvorg", revOrg != null ? revOrg.getPkValue() : null);
                returnData.put("supplier", supplier != null ? supplier.getPkValue() : null);
                returnData.put("pobillno", pobillno);
                returnData.put("material", materiel != null ? materiel.getPkValue() : null);
                returnData.put("delidatefrom", datefrom != null ? DateUtil.getFormatStartDate((Date)datefrom) : null);
                returnData.put("delidate", delidate != null ? DateUtil.getFormatEndDate((Date)delidate) : null);
                returnData.put("onlylookme", onlylookme);
                returnData.put("jointchanneldata", jointChannelId);
                this.getView().returnDataToParent(returnData);
                this.getView().close();
                break;
            }
        }
        super.beforeDoOperation(args);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object showParameterMap = this.getView().getFormShowParameter().getShowParameter().getCustomParams().get("customfilter");
        Long pkId = null;
        String jointChannelId = null;
        if (showParameterMap instanceof Map) {
            Object paramJoint;
            Object purorgid = ((Map)showParameterMap).get("purorgid");
            if (purorgid != null) {
                pkId = Long.valueOf(purorgid.toString());
                this.getModel().setValue("rcvorg", (Object)pkId);
            }
            if ((paramJoint = ((Map)showParameterMap).get("jointchanneldata")) != null) {
                jointChannelId = paramJoint.toString();
            }
        }
        if (jointChannelId == null) {
            jointChannelId = SystemJointChannelHelper.getDefaultJointChannelId();
        }
        if (jointChannelId != null) {
            this.getModel().setValue("jointchanneldata", (Object)jointChannelId);
        }
        Date now = TimeServiceHelper.now();
        this.getModel().setValue("delidatefrom", (Object)DateUtil.getFormatStartDate((Date)DateUtil.addMonth((Date)now, (int)-2)));
        this.getModel().setValue("delidate", (Object)DateUtil.getFormatEndDate((Date)DateUtil.addMonth((Date)now, (int)1)));
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        this.getModel().setDataChanged(false);
    }
}

