/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin.batchreceive;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.BillEntryStatusEnum;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.systemjoint.SystemJointChannelHelper;
import kd.scm.common.util.BillAssistUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.OrgUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.pur.common.enums.LogstatusEnum;
import kd.scm.pur.formplugin.batchreceive.IBatchReceiveGetFilter;
import kd.scm.pur.formplugin.batchreceive.PurBatchReceiveContext;
import net.sf.json.JSONArray;

public class BatchReceiveGetFilter
implements IBatchReceiveGetFilter {
    private static Log log = LogFactory.getLog(BatchReceiveGetFilter.class);
    private static final long serialVersionUID = -2335103845654536832L;

    @Override
    public void process(PurBatchReceiveContext context) {
        String jointchanneldata;
        String pobillno;
        String material;
        String rcvOrg;
        String cacheKey;
        String poped;
        Map<String, String> cacheParams = context.getCacheParams();
        log.info("###\u5f00\u59cb\u6784\u9020\u67e5\u8be2\u6761\u4ef6");
        List orglist = OrgUtil.getUserHasPermissionOrgs((String)"pur_saloutstock");
        QFilter filter = new QFilter("org", "in", (Object)orglist);
        filter.and(new QFilter("logstatus", "!=", (Object)LogstatusEnum.REFUSED.getValue()));
        filter.and(new QFilter("isinitial", "=", (Object)"0"));
        filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal()));
        filter.and(new QFilter("materialentry.entrystatus", "=", (Object)BillEntryStatusEnum.COMMON.getVal()));
        StringBuilder receiveQtySB = new StringBuilder();
        receiveQtySB.append("materialentry").append('.').append("qty").append('>').append('(').append("materialentry").append('.').append("sumreceiptqty").append('+').append("materialentry").append('.').append("rejectqty").append(')');
        filter.and(QFilter.of((String)receiveQtySB.toString(), (Object[])new Object[0]));
        StringBuilder instockQtySB = new StringBuilder();
        instockQtySB.append("materialentry").append('.').append("qty").append('>').append('(').append("materialentry").append('.').append("suminstockqty").append('+').append("materialentry").append('.').append("rejectqty").append(')');
        filter.and(QFilter.of((String)instockQtySB.toString(), (Object[])new Object[0]));
        String supplier = cacheParams.get("supplier");
        if (null != supplier && !supplier.isEmpty()) {
            filter.and(new QFilter("supplier", "=", (Object)Long.parseLong(supplier)));
        }
        Date now = TimeServiceHelper.now();
        String delidateForm = cacheParams.get("delidatefrom");
        if (null != delidateForm && !delidateForm.isEmpty()) {
            filter.and(new QFilter("delidate", ">=", (Object)DateUtil.string2date((String)delidateForm, null)));
        } else {
            Date startDate = DateUtil.string2date((String)DateUtil.getFormatStartDate((Date)DateUtil.addMonth((Date)now, (int)-2)), null);
            filter.and(new QFilter("delidate", ">=", (Object)startDate));
        }
        String delidate = cacheParams.get("delidate");
        if (null != delidate && !delidate.isEmpty()) {
            filter.and(new QFilter("delidate", "<=", (Object)DateUtil.string2date((String)delidate, null)));
        }
        if (!"1".equals(poped = cacheParams.get(cacheKey = cacheParams.get("cacheKey"))) || null == delidate) {
            Date endDate = DateUtil.string2date((String)DateUtil.getFormatEndDate((Date)DateUtil.addMonth((Date)now, (int)1)), null);
            filter.and(new QFilter("delidate", "<=", (Object)endDate));
        }
        if (null != (rcvOrg = cacheParams.get("rcvorg")) && !rcvOrg.trim().isEmpty()) {
            filter.and(new QFilter(BillAssistUtil.getReceiveOrgKey((String)context.getEnttityKey()), "=", (Object)Long.valueOf(rcvOrg)));
        }
        if (null != (material = cacheParams.get("material")) && !material.isEmpty()) {
            filter.and(new QFilter("materialentry.material", "=", (Object)Long.valueOf(material)));
        }
        if (null != (pobillno = cacheParams.get("pobillno")) && !pobillno.trim().isEmpty()) {
            filter.and(new QFilter("materialentry.pobillno", "=", (Object)pobillno));
        }
        if (ParamUtil.getBooleanParam((String)"isautoreceive").booleanValue()) {
            filter.and(new QFilter("materialentry.autorecbillno", "=", (Object)"").or(new QFilter("materialentry.autorecbillno", "=", (Object)" ")));
        }
        if ((jointchanneldata = cacheParams.get("jointchanneldata")) == null) {
            jointchanneldata = SystemJointChannelHelper.getDefaultJointChannelId();
        }
        if (jointchanneldata != null) {
            filter.and(new QFilter("materialentry.jointdatachannelid", "=", (Object)"").or(new QFilter("materialentry.jointdatachannelid", "=", (Object)" ")).or(new QFilter("materialentry.jointdatachannelid", "=", (Object)jointchanneldata)));
        }
        String isFirst = context.getIsFirst();
        Object customParamsObj = context.getCustomfilter();
        if ((isFirst == null || "0".equals(isFirst)) && customParamsObj != null) {
            JSONArray pobillIds = JSONArray.fromObject((Object)URLDecoder.decode(customParamsObj.toString()));
            ArrayList<String> ids = new ArrayList<String>();
            for (Object o : pobillIds) {
                ids.add(o.toString());
            }
            filter.and(new QFilter("materialentry.pobillid", "in", ids));
        }
        context.setFilter(filter);
        log.info("###\u8fc7\u6ee4\u6761\u4ef6" + filter.toString());
    }
}

