/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin.edit;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.MaterialUtil;
import kd.scm.common.util.PurBizPersonUtil;
import kd.scm.pur.formplugin.util.PurSupplierContacterUtil;

public final class PurClaimEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit person;
        super.registerListener(e);
        BasedataEdit contacter = (BasedataEdit)this.getControl("contacter");
        if (contacter != null) {
            contacter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((person = (BasedataEdit)this.getControl("person")) != null) {
            person.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String proName = beforeF7SelectEvent.getProperty().getName();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        switch (proName) {
            case "contacter": {
                DynamicObject supplier = dataEntity.getDynamicObject("supplier");
                DynamicObject bizpartner = dataEntity.getDynamicObject("bizpartner");
                Long bizpartnerId = null;
                if (bizpartner != null) {
                    bizpartnerId = bizpartner.getLong("id");
                }
                if (bizpartnerId == null && supplier != null) {
                    bizpartnerId = supplier.getLong("bizpartner_id");
                }
                if (bizpartnerId != null && !Objects.equals(bizpartnerId, 0L)) {
                    beforeF7SelectEvent.getCustomQFilters().add(new QFilter("bizpartner", "=", (Object)bizpartnerId));
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4f9b\u5e94\u5546\u6570\u636e\u3002", (String)"PurClaimEdit_0", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                break;
            }
            case "person": {
                DynamicObject org = dataEntity.getDynamicObject("org");
                if (org == null) break;
                beforeF7SelectEvent.getCustomQFilters().add(new QFilter("createorg", "=", (Object)org.getLong("id")));
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject person = dataEntity.getDynamicObject("person");
        if (person == null) {
            this.getModel().setValue("person", (Object)PurBizPersonUtil.getBizPerson());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null != customParams.get("claim")) {
            this.init(true);
        } else {
            this.init(false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        int rowIndex = 0;
        Object modelValue = null;
        switch (propertyName) {
            case "supplier": {
                rowIndex = e.getChangeSet()[0].getRowIndex();
                modelValue = model.getValue(propertyName, rowIndex);
                if (!(modelValue instanceof DynamicObject)) break;
                PurSupplierContacterUtil.supplierChange(model, (DynamicObject)modelValue);
                break;
            }
            case "materialid": {
                rowIndex = e.getChangeSet()[0].getRowIndex();
                modelValue = model.getValue(propertyName, rowIndex);
                if (!(modelValue instanceof DynamicObject)) break;
                MaterialUtil.materialChanged((IDataModel)model, (String)propertyName, (DynamicObject)((DynamicObject)modelValue), (String)"materialentry", (int)rowIndex);
                break;
            }
            case "claimtaxamount": {
                BigDecimal sumtaxamount = BigDecimal.ZERO;
                DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("materialentry");
                for (DynamicObject dy : dynamicObjectCollection) {
                    BigDecimal claimtaxamount = dy.getBigDecimal("claimtaxamount");
                    sumtaxamount = sumtaxamount.add(claimtaxamount);
                }
                model.setValue("sumtaxamount", (Object)sumtaxamount);
                this.getView().updateView("sumtaxamount");
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (null != afterDoOperationEventArgs.getOperationResult() && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "comfirmexe": {
                    AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanel");
                    List data = attachmentPanel.getAttachmentData();
                    if (data != null && !data.isEmpty()) {
                        this.getView().invokeOperation("save");
                    }
                    this.init(false);
                    break;
                }
                case "returnclaimexe": {
                    this.init(false);
                    break;
                }
                case "claimexe": {
                    this.init(true);
                    break;
                }
                case "historyversion": {
                    HashMap<String, String> params = new HashMap<String, String>(8);
                    String billno = dataEntity.getString("billno");
                    params.put("billno", billno);
                    ListShowParameter listParam = BillFormUtil.assembleShowListFormParam((String)"pur_claim", params, null);
                    this.getView().showForm((FormShowParameter)listParam);
                    break;
                }
            }
            if ("returnclaimexe".equals(operateKey) || "comfirmexe".equals(operateKey)) {
                this.getView().invokeOperation("refresh");
            }
        }
    }

    private void init(Boolean status) {
        if (status.booleanValue()) {
            this.getView().getFormShowParameter().getCustomParams().put("claim", "claim");
        } else {
            this.getView().getFormShowParameter().getCustomParams().remove("claim");
        }
        this.setVisiable(status);
        this.doFeedEnableBtn(status);
    }

    private void doFeedEnableBtn(Boolean status) {
        this.getView().setVisible(status, new String[]{"bar_comfirmexe", "bar_returnclaimexe"});
        this.getView().setVisible(Boolean.valueOf(status == false), new String[]{"bar_new", "bar_draw", "bar_del", "bar_save", "bar_modify", "bar_submit", "bar_audit", "bar_claimexe", "bar_cancel", "bar_historyversion", "bar_print", "bar_more", "bar_refresh", "bar_close"});
    }

    private void setVisiable(boolean status) {
        this.getView().setVisible(Boolean.valueOf(status), new String[]{"fs_claiminfo"});
        ComboEdit disposaltype1 = (ComboEdit)this.getControl("disposaltype1");
        disposaltype1.setMustInput(status);
        TextEdit disposalnote1 = (TextEdit)this.getControl("disposalnote1");
        disposalnote1.setMustInput(status);
    }
}

