/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin.list;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.OrgUtil;

public class PurOrderCheckListPlugin
extends AbstractListPlugin {
    private static final String LISTCONTROL = "billlistap";
    private static final String BEGINCHECK = "begincheck";
    private static final String TOCHECKBILL = "tocheckbill";
    private static final String CHECKBILL = "checkbill";
    private static final String CHECKSTATUS = "checkstatus";
    private static final String BEGINCALLBACK = "begincallback";
    private static final String PUSHCALLBACK = "pushcallback";
    private static Log log = LogFactory.getLog(PurOrderCheckListPlugin.class);

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilterList = e.getQFilters();
        qFilterList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal()).or(new QFilter("billstatus", "=", (Object)BillStatusEnum.CLOSED.getVal())).or(new QFilter("billstatus", "=", (Object)BillStatusEnum.CHANGED.getVal())));
        qFilterList.add(new QFilter("entryentity.rcvno", "is not null", (Object)" "));
        qFilterList.add(new QFilter("entryentity.rcvno", "!=", (Object)" "));
        ArrayList<String> srcTypeList = new ArrayList<String>();
        srcTypeList.add("1");
        srcTypeList.add("3");
        qFilterList.add(new QFilter("srctype", "in", srcTypeList));
        qFilterList.addAll(this.getQFilterByParam());
    }

    public void itemClick(ItemClickEvent evt) {
        String clickKey;
        super.itemClick(evt);
        switch (clickKey = evt.getItemKey()) {
            case "begincheck": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u91cd\u65b0\u5bf9\u8d26\u4f1a\u5173\u95ed\u5f53\u524d\u9875\u9762\uff0c\u662f\u5426\u91cd\u65b0\u5bf9\u8d26\uff1f", (String)"PurOrderCheckListPlugin_0", (String)"scm-pur-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("recheck"));
                break;
            }
            case "tocheckbill": {
                Map<String, Object> paraMap = this.getOrderInfo();
                if (paraMap == null) {
                    return;
                }
                CloseCallBack pushCallBack = new CloseCallBack((IFormPlugin)this, PUSHCALLBACK);
                OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)"pur_ordercheckpush", (ShowType)ShowType.Modal, paraMap, (CloseCallBack)pushCallBack);
                break;
            }
            case "checkbill": {
                OpenFormUtil.openListPage((IFormView)this.getView(), (String)"pur_check", (ShowType)ShowType.MainNewTabPage, null, null, null);
            }
        }
    }

    private Map<String, Object> getOrderInfo() {
        ArrayList<Long> idLists = new ArrayList<Long>();
        BillList billList = (BillList)this.getView().getControl(LISTCONTROL);
        ListSelectedRowCollection rows = billList.getSelectedRows();
        for (ListSelectedRow row : rows) {
            idLists.add(Long.parseLong(row.getPrimaryKeyValue().toString()));
        }
        Integer supNum = 0;
        HashSet<String> supSet = new HashSet<String>();
        Integer orgNum = 0;
        HashSet<String> orgSet = new HashSet<String>();
        Integer sup_currNum = 0;
        HashSet<String> sup_currSet = new HashSet<String>();
        Integer sup_orgNum = 0;
        HashSet<String> sup_orgSet = new HashSet<String>();
        BigDecimal orderAmt = BigDecimal.ZERO;
        BigDecimal settleAmt = BigDecimal.ZERO;
        BigDecimal diffAmt = BigDecimal.ZERO;
        ArrayList<Long> billLists = new ArrayList<Long>();
        QFilter filter = new QFilter("billstatus", "in", (Object)new String[]{BillStatusEnum.AUDIT.getVal(), BillStatusEnum.CLOSED.getVal()}).and(new QFilter(CHECKSTATUS, "=", (Object)"C")).and(new QFilter("id", "in", idLists));
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"pur_ordercheck", (String)"id,supplier,settleorg,curr,sumtaxamount,sumsettleamount,sumdiffamount", (QFilter[])filters);
        if (objs == null || objs.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\uff08\u65e0\u5dee\u5f02\u6216\u672a\u5bf9\u8d26\uff09\u7684\u8ba2\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PurOrderCheckListPlugin_1", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            return null;
        }
        for (Object obj : objs) {
            supSet.add(obj.getString("supplier"));
            sup_currSet.add(obj.getString("supplier") + obj.getString("curr"));
            orderAmt = orderAmt.add(obj.getBigDecimal("sumtaxamount"));
            settleAmt = settleAmt.add(obj.getBigDecimal("sumsettleamount"));
            diffAmt = diffAmt.add(obj.getBigDecimal("sumdiffamount"));
            billLists.add(obj.getLong("id"));
        }
        DynamicObjectCollection entryObjs = QueryServiceHelper.query((String)"pur_ordercheck", (String)"supplier,curr,entryentity.entrysettleorg", (QFilter[])filters);
        if (entryObjs != null && entryObjs.size() > 0) {
            for (DynamicObject obj : entryObjs) {
                orgSet.add(obj.getString("entryentity.entrysettleorg"));
                sup_orgSet.add(obj.getString("supplier") + obj.getString("entryentity.entrysettleorg") + obj.getString("curr"));
            }
        }
        supNum = supSet.size();
        orgNum = orgSet.size();
        sup_currNum = sup_currSet.size();
        sup_orgNum = sup_orgSet.size();
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("supnum", supNum);
        paraMap.put("orgnum", orgNum);
        paraMap.put("ordernum", objs.size());
        paraMap.put("orderamt", orderAmt);
        paraMap.put("settleamt", settleAmt);
        paraMap.put("diffamt", diffAmt);
        paraMap.put("sup_currnum", sup_currNum);
        paraMap.put("sup_orgnum", sup_orgNum);
        paraMap.put("billlist", billLists);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            String startdateStr = null;
            if (null != params.get("startdate")) {
                Date startdate = format.parse(String.valueOf(params.get("startdate")));
                startdateStr = format.format(startdate);
            }
            paraMap.put("datefrom", params.get("startdate") == null ? "" : startdateStr);
            Date date = TimeServiceHelper.now();
            String dateTo = format.format(date);
            Date enddate = format.parse(String.valueOf(params.get("enddate")));
            String enddateStr = format.format(enddate);
            paraMap.put("dateto", params.get("enddate") == null ? dateTo : enddateStr);
        }
        catch (Exception e) {
            log.error("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        return paraMap;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals(PUSHCALLBACK)) {
            this.getView().invokeOperation("refresh");
        }
    }

    protected List<QFilter> getQFilterByParam() {
        String settleorgscope;
        String supplierscope;
        Object datefrom;
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object dateto = params.get("enddate");
        String pattern = "yyyy-MM-dd HH:mm:ss";
        if (null != dateto) {
            qFilterList.add(new QFilter("billdate", "<=", (Object)DateUtil.string2date((String)dateto.toString(), (String)pattern)));
        }
        if (null != (datefrom = params.get("startdate"))) {
            qFilterList.add(new QFilter("billdate", ">=", (Object)DateUtil.string2date((String)datefrom.toString(), (String)pattern)));
        }
        if (null != (supplierscope = (String)params.get("supplier")) && !supplierscope.isEmpty()) {
            qFilterList.add(new QFilter("supplier", "in", (Object)Arrays.stream(supplierscope.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toSet()).toArray()));
        }
        if (null != (settleorgscope = (String)params.get("settleorg")) && !settleorgscope.isEmpty()) {
            qFilterList.add(new QFilter("entryentity.entrysettleorg", "in", (Object)Arrays.stream(settleorgscope.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toSet()).toArray()));
        } else {
            HashSet orgSet = new HashSet(1024);
            List orgList = OrgUtil.getAllInvViewPermissionOrgs((String)"pur_instock");
            List orgRcvList = OrgUtil.getAllInvViewPermissionOrgs((String)"pur_receipt");
            orgSet.addAll(orgList);
            orgSet.addAll(orgRcvList);
            qFilterList.add(new QFilter("entryentity.entrysettleorg", "in", orgSet));
        }
        return qFilterList;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("recheck".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.openCheckCenter();
            this.getView().close();
        }
    }

    private void openCheckCenter() {
        FormShowParameter formParamter = this.getView().getFormShowParameter();
        Map customerParam = formParamter.getCustomParams();
        customerParam.putIfAbsent("checktype", "2");
        FormShowParameter param = BillFormUtil.assembleShowDynamicFormParam((String)"pur_checkcenter", (Map)customerParam, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "comfirmaction"), (ShowType)ShowType.MainNewTabPage);
        this.getView().showForm(param);
    }
}

