/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin.list;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.ecapi.entity.CheckOrder;
import kd.scm.common.ecapi.entity.CheckOrderGroupParam;
import kd.scm.common.ecapi.entity.CheckOrderGroupResult;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.enums.ReturnStatusEnum;
import kd.scm.common.helper.apiconnector.api.util.EcGroupApiUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.mal.MalNewOrderUtils;

public class PurThirdDataListPlugin
extends AbstractListPlugin {
    private static final String GETCHECKDATA = "getcheckdata";
    private Log log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if ("mal".equals(this.getView().getFormShowParameter().getAppId()) && MalOrderUtil.getDefaultMalVersion()) {
            this.getView().executeClientCommand("setCaption", new Object[]{ResManager.loadKDString((String)"\u7535\u5546\u5bf9\u8d26\u6570\u636e\u5bfc\u5165\u3002", (String)"PurThirdDataListPlugin_3", (String)"scm-pur-formplugin", (Object[])new Object[0])});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opkey = afterDoOperationEventArgs.getOperateKey();
        if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess() && GETCHECKDATA.equals(opkey)) {
            this.showThirdDataFilterView();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        if (null != fsp.getCustomParam("status")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"close"});
        }
    }

    public void showThirdDataFilterView() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("pur_getcheckdata");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack cb = new CloseCallBack((IFormPlugin)this, GETCHECKDATA);
        fsp.setCloseCallBack(cb);
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData;
        super.closedCallBack(closedCallBackEvent);
        if (GETCHECKDATA.equals(closedCallBackEvent.getActionId()) && (returnData = (Map)closedCallBackEvent.getReturnData()) != null) {
            ArrayList<CheckOrder> checkOrders = new ArrayList<CheckOrder>();
            this.queryCheckDataFromApi(returnData, checkOrders);
            this.createCheckData(returnData, checkOrders);
            this.getView().invokeOperation("refresh");
        }
    }

    public void createCheckData(Map<String, String> returnData, List<CheckOrder> checkOrders) {
        DynamicObject checkDataDyn = BusinessDataServiceHelper.newDynamicObject((String)"pur_thirddata");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        try {
            checkDataDyn.set("startdate", (Object)formatter.parse(returnData.get("startDate")));
            checkDataDyn.set("enddate", (Object)formatter.parse(returnData.get("endDate")));
        }
        catch (ParseException e) {
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u9519\u8bef:{0}\u3002", (String)"PurThirdDataListPlugin_0", (String)"scm-pur-formplugin", (Object[])new Object[0]), returnData));
        }
        String source = returnData.get("source");
        checkDataDyn.set("source", (Object)source);
        HashMap<String, BigDecimal> returnAmountMap = new HashMap<String, BigDecimal>(16);
        Map<String, DynamicObject> orderIdMalRetReqDynMap = this.queryMalReturnReq(checkOrders, returnAmountMap);
        Map<String, BigDecimal> ecorderIdOrderAmountMap = this.getQueryOrderAmountMap(checkOrders, source);
        Map<String, DynamicObject> ecorderIdEcOrderMap = this.getEcorderIdEcOrderMap(ecorderIdOrderAmountMap.keySet(), source);
        DynamicObjectCollection checkDataEntryCol = checkDataDyn.getDynamicObjectCollection("entryentity");
        checkOrders.forEach(checkOrder -> {
            DynamicObject malRetReqDyn;
            DynamicObject checkDataEntry = new DynamicObject(checkDataEntryCol.getDynamicObjectType());
            checkDataEntry.set("childorder", (Object)checkOrder.getOrderId());
            try {
                checkDataEntry.set("billdate", (Object)formatter.parse(checkOrder.getTime()));
            }
            catch (ParseException e) {
                this.log.error("\u65e5\u671f\u8f6c\u6362\u9519\u8bef:" + checkOrder);
            }
            BigDecimal orderAmount = (BigDecimal)ecorderIdOrderAmountMap.get(checkOrder.getOrderId());
            checkDataEntry.set("orderamount", (Object)(orderAmount == null ? BigDecimal.ZERO : orderAmount));
            DynamicObject ecOrderDyn = (DynamicObject)ecorderIdEcOrderMap.get(checkOrder.getOrderId());
            if (ecOrderDyn != null) {
                checkDataEntry.set("parentorder", (Object)ecOrderDyn.getString("porderid"));
            }
            if ((malRetReqDyn = (DynamicObject)orderIdMalRetReqDynMap.get(checkOrder.getOrderId())) != null) {
                checkDataEntry.set("returnstatus", (Object)malRetReqDyn.getString("cfmstatus"));
                BigDecimal returnamount = (BigDecimal)returnAmountMap.get(checkOrder.getOrderId());
                checkDataEntry.set("returnamount", (Object)returnamount);
            }
            checkDataEntry.set("unpayamount", (Object)checkOrder.getOrderPrice());
            checkDataEntry.set("checkstatus", (Object)"0");
            checkDataEntryCol.add((Object)checkDataEntry);
        });
        if (!checkDataEntryCol.isEmpty()) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", String.valueOf(true));
            option.setVariableValue("isStrict", String.valueOf(false));
            OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"pur_thirddata", (DynamicObject[])new DynamicObject[]{checkDataDyn}, (OperateOption)option);
            if (!saveResult.isSuccess()) {
                throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u521b\u5efa\u7535\u5546\u5bf9\u8d26\u6570\u636e\u5931\u8d25\uff0c\u539f\u56e0\uff1a{0}\u3002", (String)"PurThirdDataListPlugin_1", (String)"scm-pur-formplugin", (Object[])new Object[0]), ExceptionUtil.getErrorInfoDetails((List)saveResult.getAllErrorOrValidateInfo())));
            }
        }
    }

    protected Map<String, BigDecimal> getReturnAmountMap(List<CheckOrder> checkOrders) {
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        ArrayList childBillNoList = new ArrayList();
        checkOrders.forEach(checkOrder -> childBillNoList.add(checkOrder.getOrderId()));
        if (!childBillNoList.isEmpty()) {
            DynamicObjectCollection afDynCol = QueryServiceHelper.query((String)"pbd_eafservicebill", (String)"orderid,returnamount", (QFilter[])new QFilter[]{new QFilter("orderid", "in", childBillNoList)});
            for (DynamicObject afDyn : afDynCol) {
                String orderId = afDyn.getString("orderid");
                if (!StringUtils.isNotEmpty((CharSequence)orderId)) continue;
                BigDecimal returnAmount = (BigDecimal)result.get(orderId);
                returnAmount = returnAmount == null ? afDyn.getBigDecimal("returnamount") : returnAmount.add(afDyn.getBigDecimal("returnamount"));
                result.put(orderId, returnAmount);
            }
        }
        return result;
    }

    public Map<String, DynamicObject> getEcorderIdEcOrderMap(Set<String> ecOrderIds, String source) {
        HashMap<String, DynamicObject> res = new HashMap<String, DynamicObject>();
        if (ecOrderIds == null || ecOrderIds.isEmpty()) {
            return res;
        }
        DynamicObjectCollection ecOrderCol = null;
        String ecsource = "";
        if (EcPlatformEnum.ECPLATFORM_JD.getVal().equals(source) || EcPlatformEnum.ECPLATFORM_JDPRO.getVal().equals(source)) {
            QFilter ecOrderPkfilter = new QFilter("number", "in", ecOrderIds);
            QFilter[] filters = new QFilter[]{ecOrderPkfilter};
            ecOrderCol = QueryServiceHelper.query((String)"pbd_jdorder", (String)"id,number orderid,jdorderid porderid", (QFilter[])filters, null);
        } else {
            if (EcPlatformEnum.ECPLATFORM_SUNING.getVal().equals(source)) {
                ecsource = "pbd_order_sn";
            } else if (EcPlatformEnum.ECPLATFORM_XY.getVal().equals(source)) {
                ecsource = "pbd_order_xy";
            } else if (EcPlatformEnum.ECPLATFORM_ZKH.getVal().equals(source)) {
                ecsource = "pbd_order_zkh";
            }
            if (StringUtils.isNotEmpty((CharSequence)ecsource)) {
                ecOrderCol = QueryServiceHelper.query((String)ecsource, (String)"id,porderid,orderid", (QFilter[])new QFilter[]{new QFilter("orderid", "in", ecOrderIds)}, null);
            }
        }
        if (ecOrderCol != null) {
            ecOrderCol.forEach(ecOrder -> res.put(ecOrder.getString("orderid"), (DynamicObject)ecOrder));
        }
        return res;
    }

    public Map<String, BigDecimal> getQueryOrderAmountMap(List<CheckOrder> checkOrders, String source) {
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        ArrayList childBillNoList = new ArrayList();
        checkOrders.forEach(checkOrder -> childBillNoList.add(checkOrder.getOrderId()));
        if (childBillNoList.isEmpty()) {
            return new HashMap<String, BigDecimal>();
        }
        String ecsource = "";
        if (EcPlatformEnum.ECPLATFORM_JD.getVal().equals(source) || EcPlatformEnum.ECPLATFORM_JDPRO.getVal().equals(source)) {
            QFilter ecOrderPkfilter = new QFilter("number", "in", childBillNoList);
            QFilter[] filters = new QFilter[]{ecOrderPkfilter};
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"ThirdOrderCheckUtil", (String)"pbd_jdorder", (String)"number,taxamount", (QFilter[])filters, null);){
                ds.forEach(row -> result.put(row.getString("number"), row.getBigDecimal("taxamount")));
            }
        }
        ecsource = MalNewOrderUtils.getPlatformId((String)source);
        if (StringUtils.isEmpty((CharSequence)ecsource)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7535\u5546\u5e73\u53f0\u4e3a\u7a7a\u3002", (String)"PurThirdDataListPlugin_2", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        }
        try (DataSet ecds = QueryServiceHelper.queryDataSet((String)"ThirdOrderCheckUtil", (String)ecsource, (String)"orderid,orderamount", (QFilter[])new QFilter[]{new QFilter("orderid", "in", childBillNoList)}, null);){
            ecds.forEach(row -> result.put(row.getString("orderid"), row.getBigDecimal("orderamount")));
        }
        return result;
    }

    private Map<String, DynamicObject> queryMalReturnReq(List<CheckOrder> checkOrders, Map<String, BigDecimal> returnAmountMap) {
        HashMap<String, DynamicObject> orderIdMalReturnReqMap = new HashMap<String, DynamicObject>();
        if (checkOrders.isEmpty()) {
            return orderIdMalReturnReqMap;
        }
        String selectField = "platform,cfmstatus,aftersaleentry.afservicebill.porderid,aftersaleentry.afservicebill.orderid,aftersaleentry.afservicebill.returnamount";
        HashSet orderIdSet = new HashSet();
        checkOrders.forEach(checkOrder -> orderIdSet.add(checkOrder.getOrderId()));
        QFilter ecorderFilter = new QFilter("aftersaleentry.afservicebill.orderid", "in", orderIdSet);
        HashSet<String> cfmStatusSet = new HashSet<String>();
        cfmStatusSet.add(ReturnStatusEnum.CONFIRMED.getVal());
        cfmStatusSet.add(ReturnStatusEnum.FINISH.getVal());
        QFilter cfmStatusFilter = new QFilter("cfmstatus", "in", cfmStatusSet);
        QFilter[] filters = new QFilter[]{ecorderFilter, cfmStatusFilter};
        DynamicObjectCollection malreturnreqDynCol = QueryServiceHelper.query((String)"mal_returnreq", (String)selectField, (QFilter[])filters);
        malreturnreqDynCol.forEach(malreturnreqDyn -> {
            orderIdMalReturnReqMap.put(malreturnreqDyn.getString("aftersaleentry.afservicebill.orderid"), (DynamicObject)malreturnreqDyn);
            BigDecimal returnAmount = (BigDecimal)returnAmountMap.get(malreturnreqDyn.getString("aftersaleentry.afservicebill.orderid"));
            returnAmount = returnAmount == null ? malreturnreqDyn.getBigDecimal("aftersaleentry.afservicebill.returnamount") : returnAmount.add(malreturnreqDyn.getBigDecimal("aftersaleentry.afservicebill.returnamount"));
            returnAmountMap.put(malreturnreqDyn.getString("aftersaleentry.afservicebill.orderid"), returnAmount);
        });
        return orderIdMalReturnReqMap;
    }

    public CheckOrderGroupResult queryCheckDataFromApi(Map<String, String> returnData, List<CheckOrder> checkOrders) {
        CheckOrderGroupParam checkOrderGroupParam = returnData.get("source").equals("9") ? new CheckOrderGroupParam(returnData.get("source"), returnData.get("startDate"), returnData.get("endDate"), returnData.get("pageNo"), returnData.get("pageSize"), "", "1", "0", "") : new CheckOrderGroupParam(returnData.get("source"), returnData.get("startDate"), returnData.get("endDate"), returnData.get("pageNo"), returnData.get("pageSize"), "", "4", "0", "");
        if (EcPlatformEnum.ECPLATFORM_DL.getVal().equals(checkOrderGroupParam.getPlatform())) {
            checkOrderGroupParam.setOrderItemStatus("1,2");
        }
        HashMap<String, CheckOrderGroupParam> checkOrderGroupParamMap = new HashMap<String, CheckOrderGroupParam>();
        checkOrderGroupParamMap.put(checkOrderGroupParam.getPlatform(), checkOrderGroupParam);
        Map result = EcGroupApiUtil.queryEcCheckOrder(checkOrderGroupParamMap);
        Object invokeResult = result.get(checkOrderGroupParam.getPlatform());
        if (invokeResult instanceof CheckOrderGroupResult) {
            CheckOrderGroupResult checkOrderGroupResult = (CheckOrderGroupResult)result.get(checkOrderGroupParam.getPlatform());
            checkOrders.addAll(checkOrderGroupResult.getOrders());
            int pageNo = Integer.parseInt(returnData.get("pageNo"));
            if (Integer.parseInt(checkOrderGroupResult.getTotalPage()) > pageNo) {
                returnData.put("pageNo", String.valueOf(++pageNo));
                this.queryCheckDataFromApi(returnData, checkOrders);
            }
            return (CheckOrderGroupResult)result.get(checkOrderGroupParam.getPlatform());
        }
        if (invokeResult instanceof Throwable) {
            throw new KDBizException(((Throwable)invokeResult).getMessage());
        }
        return new CheckOrderGroupResult();
    }
}

