/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterGridView;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.jd.util.JDAccessTokenUtil;
import kd.scm.common.jd.util.JDHttpsUtil;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.BizTypeHelper;
import kd.scm.common.util.MalOrderParamUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.pur.common.ecinvoice.EcInvoiceFactory;
import kd.scm.pur.common.ecinvoice.beans.EcInvSubmitResult;
import kd.scm.pur.common.ecinvoice.service.impl.GenericEcInvoiceService;
import net.sf.json.JSONObject;

public class PurNewEcInvoiceRequestFormPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener,
RowClickEventListener {
    private static final String REPORTLIST = "reportlistap";
    private static final String CURRENT_PLATFORM = "currentplatform";
    private static final String CURRENCY = "currency";
    private static final String INVOICEREQ = "invoicereq";
    private static final String INVOICEALL = "invoiceall";
    private static final String REPAIRDATA = "repairdata";
    private static final String PUSHINVOICE = "pushinvoice";
    private static final String VIEWINVOICE = "viewinvoice";
    private static final String CONFIRMRECEIVE = "confirmreceive";
    private static final String UPDATEINVOICE = "updateinvoice";
    private static final String REVADDRESS = "revaddress";
    private static final String REVADDRESSDETAIL = "revaddressdetail";
    private static final String WHOLEADDRESS = "wholeaddress";
    private static final String JDADDRESSNUM = "jdaddressnum";
    private static final String SELECTALL = "selectall";
    private static final String CLEARALL = "clearall";
    private static final String LOGQUERY = "logquery";
    public static final String REVNAME = "revname";
    public static final String REVPHONE = "revphone";
    public static final String EMAIL = "email";
    public static final String BD_ADMINDIVISION = "bd_admindivision";
    public static final long MALORDER_BILLTYPE_ID = 1317361223599179776L;

    public void setPlatform(String platform) {
        this.getModel().setValue(CURRENT_PLATFORM, (Object)platform);
    }

    public String getPlatform() {
        return this.getModel().getValue(CURRENT_PLATFORM).toString();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        if (null != fsp.getCustomParam("status")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"close"});
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        this.setPlatform(args.getFilterValue("platform_query").toString());
    }

    protected void filterContainerInit(FilterContainerInitEvent event, ReportQueryParam reParam) {
        List bizTypeIds;
        List filterColumnList = event.getCommonFilterColumns();
        if (reParam.getFilter() != null) {
            String platformQuery;
            String string = platformQuery = reParam.getFilter().getValue("platform_query") == null ? "" : (String)reParam.getFilter().getValue("platform_query");
            if (StringUtils.isNotEmpty((CharSequence)platformQuery)) {
                ((FilterColumn)filterColumnList.get(0)).setDefaultValue(platformQuery);
                this.setPlatform(platformQuery);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(bizTypeIds = BizTypeHelper.getAllBizTypes((String)"mal_order", (Long)1317361223599179776L)))) {
            for (FilterColumn filterColumn : filterColumnList) {
                if (!"businesstype_query".equals(filterColumn.getFieldName())) continue;
                if (!filterColumn.getDefaultValues().isEmpty()) {
                    String defaultOrg = filterColumn.getDefaultValues().get(0).toString();
                    filterColumn.setDefaultValue(defaultOrg);
                }
                Map bizTypeDynMap = BusinessDataServiceHelper.loadFromCache((Object[])bizTypeIds.toArray(), (String)"bd_biztype");
                ArrayList<ComboItem> combosNew = new ArrayList<ComboItem>(16);
                for (Map.Entry entry : bizTypeDynMap.entrySet()) {
                    combosNew.add(new ComboItem(new LocaleString(((DynamicObject)entry.getValue()).getString("name")), String.valueOf(entry.getKey())));
                }
                if (!combosNew.isEmpty()) {
                    ((CommonFilterColumn)filterColumn).setComboItems(combosNew);
                }
                return;
            }
        }
    }

    public void registerListener(EventObject e) {
        ReportList list = (ReportList)this.getView().getControl(REPORTLIST);
        list.addHyperClickListener((HyperLinkClickListener)this);
        list.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if ("mal".equals(this.getView().getFormShowParameter().getAppId()) && MalOrderParamUtil.getDefaultMalVersion()) {
            this.getView().executeClientCommand("setCaption", new Object[]{ResManager.loadKDString((String)"\u7535\u5546\u5f00\u7968", (String)"PurNewEcInvoiceRequestFormPlugin_31", (String)"scm-pur-formplugin", (Object[])new Object[0])});
        }
        List fastFilterColumns = ((FilterGridView)this.getControl("filtergridviewap")).getFilterColumns();
        for (FilterColumn filterColumn : fastFilterColumns) {
            if (!"platform_query".equals(filterColumn.getFieldName())) continue;
            this.setPlatform(((CommonFilterColumn)filterColumn).getDefValue());
        }
        if (StringUtils.isNotBlank((CharSequence)MalOrderParamUtil.getDefaultCurrency())) {
            this.getModel().setValue(CURRENCY, (Object)MalOrderParamUtil.getDefaultCurrency());
        }
        this.setDeaultHistoryAddress(this.getModel());
    }

    public void setDeaultHistoryAddress(IDataModel model) {
        String userId = RequestContext.get().getUserId();
        QFilter filter = new QFilter("creator", "=", (Object)Long.valueOf(userId)).and(REVADDRESS, "!=", (Object)"");
        String selectFields = "revname,revphone,revaddress";
        DynamicObjectCollection dyoCol = QueryServiceHelper.query((String)"pur_invoice", (String)selectFields, (QFilter[])new QFilter[]{filter}, (String)"billdate desc");
        DynamicObject receiptDyn = QueryServiceHelper.queryOne((String)"mal_address", (String)"id,name,phone,address,email,mapaddress,wholeaddress", (QFilter[])new QFilter[]{new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId()).and("default", "=", (Object)"1")});
        if (null != dyoCol && dyoCol.size() > 0) {
            String[] complexAddr = ((DynamicObject)dyoCol.get(0)).getString(REVADDRESS).split("&");
            model.setValue(REVNAME, (Object)((DynamicObject)dyoCol.get(0)).getString(REVNAME));
            model.setValue(REVPHONE, (Object)((DynamicObject)dyoCol.get(0)).getString(REVPHONE));
            if (complexAddr.length >= 2) {
                model.setValue(REVADDRESS, (Object)complexAddr[1]);
                model.setValue(WHOLEADDRESS, (Object)complexAddr[0]);
                if (complexAddr.length >= 3) {
                    model.setValue(JDADDRESSNUM, (Object)complexAddr[2]);
                }
                if (complexAddr[0].split("_").length > 1) {
                    model.setValue(REVADDRESSDETAIL, (Object)complexAddr[0].split("_")[1]);
                }
            }
        } else if (receiptDyn != null) {
            this.getModel().setValue(REVNAME, (Object)receiptDyn.getString("name"));
            this.getModel().setValue(REVPHONE, (Object)receiptDyn.getString("phone"));
            this.getModel().setValue(REVADDRESS, (Object)receiptDyn.getString("address"));
            String[] strings = receiptDyn.getString(WHOLEADDRESS).split("_");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < strings.length - 1; ++i) {
                sb.append(strings[i]);
            }
            sb.append("_").append(strings[strings.length - 1]);
            this.getModel().setValue(WHOLEADDRESS, (Object)sb);
            this.getModel().setValue(REVADDRESSDETAIL, (Object)receiptDyn.getString("mapaddress"));
        }
        if (receiptDyn != null) {
            this.getModel().setValue(EMAIL, (Object)receiptDyn.getString(EMAIL));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        String malOrderId;
        BillShowParameter billShowParameter;
        String purInvoicePk;
        QFilter filter;
        DynamicObject orderDyo;
        if (StringUtils.equals((CharSequence)"purno", (CharSequence)args.getFieldName()) && null != (orderDyo = QueryServiceHelper.queryOne((String)"pur_order", (String)"billno,id", (QFilter[])new QFilter[]{filter = new QFilter("billno", "=", (Object)args.getRowData().getString("purno"))}))) {
            Long malOrderBillPk = orderDyo.getLong("id");
            BillShowParameter billShowParameter2 = BillFormUtil.assembleShowBillFormParam((String)"pur_order", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.VIEW, (long)malOrderBillPk, null, null);
            this.getView().showForm((FormShowParameter)billShowParameter2);
        }
        if (StringUtils.equals((CharSequence)"invoiceno", (CharSequence)args.getFieldName()) && StringUtils.isNotEmpty((CharSequence)(purInvoicePk = args.getRowData().getString("invoiceid")))) {
            billShowParameter = BillFormUtil.assembleShowBillFormParam((String)"pur_invoice", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.EDIT, (long)Long.parseLong(purInvoicePk), null, null);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
        if (StringUtils.equals((CharSequence)"malno", (CharSequence)args.getFieldName()) && StringUtils.isNotEmpty((CharSequence)(malOrderId = args.getRowData().getString("malorderid")))) {
            billShowParameter = BillFormUtil.assembleShowBillFormParam((String)"mal_order", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.VIEW, (long)Long.parseLong(malOrderId), null, null);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String address;
        String addressNumber;
        super.propertyChanged(e);
        String property = e.getProperty().getName();
        IDataModel model = this.getModel();
        if (StringUtils.equalsIgnoreCase((CharSequence)property, (CharSequence)REVADDRESS)) {
            boolean isCity;
            addressNumber = (String)model.getValue(REVADDRESS);
            address = this.getAreaFullName(addressNumber);
            boolean bl = isCity = StringUtils.contains((CharSequence)address, (CharSequence)ResManager.loadKDString((String)"\u5317\u4eac", (String)"PurNewEcInvoiceRequestFormPlugin_14", (String)"scm-pur-formplugin", (Object[])new Object[0])) || StringUtils.contains((CharSequence)address, (CharSequence)ResManager.loadKDString((String)"\u4e0a\u6d77", (String)"PurNewEcInvoiceRequestFormPlugin_15", (String)"scm-pur-formplugin", (Object[])new Object[0])) || StringUtils.contains((CharSequence)address, (CharSequence)ResManager.loadKDString((String)"\u5929\u6d25", (String)"PurNewEcInvoiceRequestFormPlugin_16", (String)"scm-pur-formplugin", (Object[])new Object[0])) || StringUtils.contains((CharSequence)address, (CharSequence)ResManager.loadKDString((String)"\u91cd\u5e86", (String)"PurNewEcInvoiceRequestFormPlugin_17", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            if (StringUtils.isNotBlank((CharSequence)address) && (address.split("_").length >= 3 && !isCity || address.split("_").length >= 2 && isCity)) {
                this.setWholeAddress(address);
                this.getView().setEnable(Boolean.TRUE, new String[]{REVADDRESSDETAIL});
                this.setAddressLongNumber(address);
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{REVADDRESSDETAIL});
            }
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)property, (CharSequence)REVADDRESSDETAIL)) {
            if (null != model.getValue(REVADDRESS)) {
                addressNumber = (String)model.getValue(REVADDRESS);
                address = this.getAreaFullName(addressNumber);
                if (StringUtils.isNotBlank((CharSequence)address) && address.split("_").length >= 3) {
                    this.setWholeAddress(address);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5c06\u7701\u5e02\u533a\u586b\u5199\u5b8c\u6574\u3002", (String)"PurNewEcInvoiceRequestFormPlugin_13", (String)"scm-pur-formplugin", (Object[])new Object[0]));
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5c06\u7701\u5e02\u533a\u586b\u5199\u5b8c\u6574\u3002", (String)"PurNewEcInvoiceRequestFormPlugin_13", (String)"scm-pur-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public String getAreaFullName(String city) {
        if (StringUtils.isEmpty((CharSequence)city)) {
            return "";
        }
        QFilter idfilter = new QFilter("id", "=", (Object)Long.valueOf(city));
        DynamicObject address = QueryServiceHelper.queryOne((String)BD_ADMINDIVISION, (String)"id,fullname,name", (QFilter[])new QFilter[]{idfilter});
        if (address == null) {
            return "";
        }
        return address.getString("fullname");
    }

    private void setWholeAddress(String address) {
        StringBuilder sb = new StringBuilder();
        String[] addrstr = address.split("_");
        String detailAddr = (String)this.getModel().getValue(REVADDRESSDETAIL);
        int startIndex = 0;
        if (StringUtils.contains((CharSequence)address, (CharSequence)ResManager.loadKDString((String)"\u5317\u4eac", (String)"PurNewEcInvoiceRequestFormPlugin_14", (String)"scm-pur-formplugin", (Object[])new Object[0])) || StringUtils.contains((CharSequence)address, (CharSequence)ResManager.loadKDString((String)"\u4e0a\u6d77", (String)"PurNewEcInvoiceRequestFormPlugin_15", (String)"scm-pur-formplugin", (Object[])new Object[0])) || StringUtils.contains((CharSequence)address, (CharSequence)ResManager.loadKDString((String)"\u5929\u6d25", (String)"PurNewEcInvoiceRequestFormPlugin_16", (String)"scm-pur-formplugin", (Object[])new Object[0])) || StringUtils.contains((CharSequence)address, (CharSequence)ResManager.loadKDString((String)"\u91cd\u5e86", (String)"PurNewEcInvoiceRequestFormPlugin_17", (String)"scm-pur-formplugin", (Object[])new Object[0]))) {
            startIndex = 1;
        }
        for (int i = startIndex; i < addrstr.length; ++i) {
            sb.append(addrstr[i]);
        }
        sb.append('_').append(null != detailAddr ? detailAddr : "");
        this.getModel().setValue(WHOLEADDRESS, (Object)sb.toString());
    }

    public void setAddressLongNumber(String address) {
        if (!MalOrderUtil.getDefaultMalVersion()) {
            String platform = this.getPlatform();
            if (EcPlatformEnum.ECPLATFORM_JD.getVal().equals(platform)) {
                this.setJdAddress(address);
            }
        }
    }

    private void setJdAddress(String address) {
        StringBuilder sb = new StringBuilder();
        try {
            List<String> addressList = this.getJDAddrNumberByAddr(RequestContext.get().getTenantId(), address);
            if (null != addressList && addressList.size() > 0) {
                addressList.forEach(str -> sb.append((String)str).append('_'));
                this.getModel().setValue(JDADDRESSNUM, (Object)sb.substring(0, sb.length() - 1));
            }
        }
        catch (Exception exception) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u4eac\u4e1c\u5730\u5740\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"PurEcInvoiceRequestFormPlugin_17", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        }
    }

    private List<String> getJDAddrNumberByAddr(String enterpriseID, String address) {
        if (address.isEmpty()) {
            return null;
        }
        String rsJson = this.getAddressJonString(enterpriseID, address);
        JSONObject jsonObject = JSONObject.fromObject((Object)rsJson);
        ArrayList<String> addrList = null;
        if (jsonObject.getBoolean("success")) {
            addrList = new ArrayList<String>();
            JSONObject result = jsonObject.getJSONObject("result");
            if (!result.getString("provinceId").isEmpty()) {
                addrList.add(result.getString("provinceId"));
            }
            if (!result.getString("cityId").isEmpty()) {
                addrList.add(result.getString("cityId"));
            }
            if (!result.getString("countyId").isEmpty()) {
                addrList.add(result.getString("countyId"));
            }
        }
        return addrList;
    }

    private String getAddressJonString(String enterpriseID, String adress) {
        if (adress.isEmpty()) {
            return null;
        }
        String data = "&address=" + adress;
        String token = JDAccessTokenUtil.getAccessTokenByKD((String)enterpriseID);
        return JDHttpsUtil.httpsJDPost((String)"https://bizapi.jd.com/api/area/getJDAddressFromAddress", (String)("token=" + token + data));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        super.beforeDoOperation(event);
        String operateKey = ((AbstractOperate)event.getSource()).getOperateKey();
        String source = (String)this.getModel().getValue(CURRENT_PLATFORM);
        GenericEcInvoiceService ecInvoiceService = EcInvoiceFactory.getEcInvoiceServiceBySource((String)source);
        switch (operateKey) {
            case "viewinvoice": {
                ecInvoiceService.viewInvoice((IFormView)this.getView());
                break;
            }
            case "invoicereq": {
                List ecInvSubmitResults = ecInvoiceService.invoiceBatchSplitSubmit(this.getModel(), (IFormView)this.getView());
                String errorInfo = this.getErrorInfo(ecInvSubmitResults);
                if (!StringUtils.isNotBlank((CharSequence)errorInfo)) break;
                this.getView().showErrorNotification(errorInfo);
                break;
            }
            case "invoiceall": {
                this.invoiceAll();
                break;
            }
            case "repairdata": {
                ecInvoiceService.repaireData((IFormView)this.getView());
                break;
            }
            case "pushinvoice": {
                DynamicObjectCollection dyoCol = ecInvoiceService.getSelectedDyObject((IFormView)this.getView());
                ecInvoiceService.pushPurInvoice(this.getModel(), dyoCol, "919591508682895360");
                break;
            }
            case "confirmreceive": {
                ecInvoiceService.confirmReceive((IFormView)this.getView());
                break;
            }
            case "updateinvoice": {
                ecInvoiceService.updateInvoice((IFormView)this.getView());
                break;
            }
            case "selectall": {
                ReportList list = (ReportList)this.getView().getControl(REPORTLIST);
                list.getEntryState().setSelectAllRows(true);
                list.selectRows(ecInvoiceService.getAllRowIndex((IFormView)this.getView()), 1);
                break;
            }
            case "clearall": {
                ReportList list = (ReportList)this.getView().getControl(REPORTLIST);
                list.clearEntryState();
                break;
            }
            case "logquery": {
                ecInvoiceService.showInvoiceLogistics((IFormView)this.getView());
                break;
            }
        }
    }

    protected String getErrorInfo(List<EcInvSubmitResult> ecInvSubmitResults) {
        StringBuilder sb = new StringBuilder();
        for (EcInvSubmitResult ecInvSubmitResult : ecInvSubmitResults) {
            if (ecInvSubmitResult.isSuccess()) continue;
            for (String errStr : ecInvSubmitResult.getErrorInfo()) {
                sb.append(errStr).append("\r\n");
            }
        }
        return sb.toString();
    }

    protected void invoiceAll() {
        GenericEcInvoiceService ecInvoiceService = EcInvoiceFactory.getEcInvoiceServiceBySource((String)((String)this.getModel().getValue(CURRENT_PLATFORM)));
        int[] selectIndexs = ecInvoiceService.getSelectIndex((IFormView)this.getView());
        if (selectIndexs.length > 0) {
            DynamicObjectCollection dyoCol = ecInvoiceService.getSelectedDyObject((IFormView)this.getView());
            HashMap<String, Number> paraMap = new HashMap<String, Number>(1);
            int ordernum = dyoCol.size();
            HashSet<String> orgSet = new HashSet<String>();
            BigDecimal settleamt = new BigDecimal("0.0");
            DynamicObject org = null;
            for (DynamicObject bill : dyoCol) {
                org = bill.getDynamicObject("invoiceorg");
                if (org != null) {
                    orgSet.add(org.getPkValue().toString());
                }
                settleamt = settleamt.add(bill.getBigDecimal("invoiceamount"));
            }
            paraMap.put("ordernum", ordernum);
            paraMap.put("orgnum", orgSet.size());
            paraMap.put("settleamt", settleamt);
            CloseCallBack pushCallBack = new CloseCallBack((IFormPlugin)this, INVOICEALL);
            OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)"pur_invoicepush", (ShowType)ShowType.Modal, paraMap, (CloseCallBack)pushCallBack);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PurEcInvoiceRequestFormPlugin_11", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        List ecInvSubmitResults;
        String errorInfo;
        super.closedCallBack(e);
        String callBackId = e.getActionId();
        GenericEcInvoiceService ecInvoiceService = EcInvoiceFactory.getEcInvoiceServiceBySource((String)((String)this.getModel().getValue(CURRENT_PLATFORM)));
        if (INVOICEALL.equals(callBackId) && e.getReturnData() != null && StringUtils.isNotBlank((CharSequence)(errorInfo = this.getErrorInfo(ecInvSubmitResults = ecInvoiceService.invoiceMergeSubmit(this.getModel(), (IFormView)this.getView()))))) {
            this.getView().showErrorNotification(errorInfo);
        }
    }
}

