/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pur.formplugin.suppliercollenable;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.report.ReportShowParameter;
import kd.scm.pur.business.suppliercoll.PurSupplierCollInitiateHelper;
import kd.scm.pur.common.constant.SupplierAssignConstants;

public final class PurInactiveCollPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"confirminactive", "selectdataclose"});
    }

    public void afterCreateNewData(EventObject e) {
        Label warning;
        super.afterCreateNewData(e);
        Object assignsupllierid = this.getView().getFormShowParameter().getCustomParam(SupplierAssignConstants.SUPPLIERIDS);
        if (assignsupllierid != null) {
            Object contentString = this.getView().getFormShowParameter().getCustomParam("content");
            if (contentString != null && !contentString.toString().isEmpty()) {
                Label content = (Label)this.getView().getControl("content");
                content.setText(contentString.toString());
            }
            Collection supplierIds = (Collection)SerializationUtils.fromJsonString((String)assignsupllierid.toString(), Collection.class);
            TableValueSetter supplierData = new TableValueSetter(new String[0]);
            AbstractFormDataModel formDataModel = (AbstractFormDataModel)this.getModel();
            int rowIndex = 0;
            for (Long supplier : supplierIds) {
                supplierData.set("verifyresult", (Object)"fail", rowIndex);
                supplierData.set("supplier", (Object)supplier, rowIndex);
                ++rowIndex;
            }
            formDataModel.deleteEntryData("entryentity");
            formDataModel.beginInit();
            formDataModel.batchCreateNewEntryRow("entryentity", supplierData);
            formDataModel.beginInit();
            this.getView().updateView();
        }
        if ((warning = (Label)this.getView().getControl("warning")) != null) {
            warning.setText(ResManager.loadKDString((String)"\u6ce8\u610f\uff1a\u4ee5\u4e0b\u4f9b\u5e94\u5546\u5b58\u5728\u672a\u7ed3\u9879\uff0c\u5efa\u8bae\u5904\u7406\u540e\u518d\u5173\u95ed\u91c7\u8d2d\u534f\u540c\u3002\u5982\u679c\u7acb\u5373\u5173\u95ed\uff0c\u540e\u7eed\u542f\u7528\u534f\u540c\u9700\u8981\u8c03\u6574\u5904\u7406\u3002", (String)"PurInactiveCollPlugin_0", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Object source = evt.getSource();
        if (source instanceof Button && "confirminactive".equals(((Button)source).getKey())) {
            HashMap<Long, Boolean> supplierUpdateInfoMap = new HashMap<Long, Boolean>(1024);
            HashMap customParamMap = new HashMap(1);
            DynamicObjectCollection dynamicObjects = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            for (DynamicObject row : dynamicObjects) {
                Long supplierId = row.getLong("supplier.id");
                supplierUpdateInfoMap.put(supplierId, Boolean.FALSE);
            }
            if (!supplierUpdateInfoMap.isEmpty()) {
                String taskId = PurSupplierCollInitiateHelper.dispatchUpdateSupplierCollTask(supplierUpdateInfoMap, customParamMap);
                this.showProcessTask(taskId);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("processTaskAction".equals(actionId)) {
            this.getView().close();
        }
    }

    private void showProcessTask(String taskId) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("pur_taskprogress");
        param.setCustomParam("taskId", (Object)taskId);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.getOpenStyle().setTargetKey("taskId");
        param.setStatus(OperationStatus.VIEW);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "processTaskAction"));
        this.getView().showForm(param);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("viewdetail".equals(operateKey)) {
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity("entryentity", currentRowIndex);
            if (dynamicObject != null) {
                this.showInactiveForm(dynamicObject.getLong("supplier.id"));
            }
        }
    }

    private void showInactiveForm(Long supplierId) {
        ReportShowParameter formShowParameter = new ReportShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
        formShowParameter.setFormId("pur_inactiveresult");
        formShowParameter.setCustomParam(SupplierAssignConstants.SUPPLIERCOLLIDS, (Object)supplierId);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960px");
        styleCss.setHeight("780px");
        formShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }
}

